/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Particle {
    private static final AxisAlignedBB field_187121_a = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    protected World field_187122_b;
    protected double field_187123_c;
    protected double field_187124_d;
    protected double field_187125_e;
    protected double field_187126_f;
    protected double field_187127_g;
    protected double field_187128_h;
    protected double field_187129_i;
    protected double field_187130_j;
    protected double field_187131_k;
    private AxisAlignedBB field_187120_G = field_187121_a;
    protected boolean field_187132_l;
    protected boolean field_190017_n;
    protected boolean field_187133_m;
    protected float field_187134_n = 0.6f;
    protected float field_187135_o = 1.8f;
    protected Random field_187136_p = new Random();
    protected int field_94054_b;
    protected int field_94055_c;
    protected float field_70548_b;
    protected float field_70549_c;
    protected int field_70546_d;
    protected int field_70547_e;
    protected float field_70544_f;
    protected float field_70545_g;
    protected float field_70552_h;
    protected float field_70553_i;
    protected float field_70551_j;
    protected float field_82339_as = 1.0f;
    protected TextureAtlasSprite field_187119_C;
    protected float field_190014_F;
    protected float field_190015_G;
    public static double field_70556_an;
    public static double field_70554_ao;
    public static double field_70555_ap;
    public static Vec3d field_190016_K;

    protected Particle(World worldIn, double posXIn, double posYIn, double posZIn) {
        this.field_187122_b = worldIn;
        this.func_187115_a(0.2f, 0.2f);
        this.func_187109_b(posXIn, posYIn, posZIn);
        this.field_187123_c = posXIn;
        this.field_187124_d = posYIn;
        this.field_187125_e = posZIn;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70548_b = this.field_187136_p.nextFloat() * 3.0f;
        this.field_70549_c = this.field_187136_p.nextFloat() * 3.0f;
        this.field_70544_f = (this.field_187136_p.nextFloat() * 0.5f + 0.5f) * 2.0f;
        this.field_70547_e = (int)(4.0f / (this.field_187136_p.nextFloat() * 0.9f + 0.1f));
        this.field_70546_d = 0;
        this.field_190017_n = true;
    }

    public Particle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn) {
        this(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.field_187129_i = xSpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.field_187130_j = ySpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        this.field_187131_k = zSpeedIn + (Math.random() * 2.0 - 1.0) * (double)0.4f;
        float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
        float f1 = MathHelper.func_76133_a((double)(this.field_187129_i * this.field_187129_i + this.field_187130_j * this.field_187130_j + this.field_187131_k * this.field_187131_k));
        this.field_187129_i = this.field_187129_i / (double)f1 * (double)f * (double)0.4f;
        this.field_187130_j = this.field_187130_j / (double)f1 * (double)f * (double)0.4f + (double)0.1f;
        this.field_187131_k = this.field_187131_k / (double)f1 * (double)f * (double)0.4f;
    }

    public Particle func_70543_e(float multiplier) {
        this.field_187129_i *= (double)multiplier;
        this.field_187130_j = (this.field_187130_j - (double)0.1f) * (double)multiplier + (double)0.1f;
        this.field_187131_k *= (double)multiplier;
        return this;
    }

    public Particle func_70541_f(float scale) {
        this.func_187115_a(0.2f * scale, 0.2f * scale);
        this.field_70544_f *= scale;
        return this;
    }

    public void func_70538_b(float particleRedIn, float particleGreenIn, float particleBlueIn) {
        this.field_70552_h = particleRedIn;
        this.field_70553_i = particleGreenIn;
        this.field_70551_j = particleBlueIn;
    }

    public void func_82338_g(float alpha) {
        this.field_82339_as = alpha;
    }

    public boolean func_187111_c() {
        return false;
    }

    public float func_70534_d() {
        return this.field_70552_h;
    }

    public float func_70542_f() {
        return this.field_70553_i;
    }

    public float func_70535_g() {
        return this.field_70551_j;
    }

    public void func_187114_a(int particleLifeTime) {
        this.field_70547_e = particleLifeTime;
    }

    public int func_206254_h() {
        return this.field_70547_e;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.04 * (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= (double)0.98f;
        this.field_187130_j *= (double)0.98f;
        this.field_187131_k *= (double)0.98f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float f = (float)this.field_94054_b / 32.0f;
        float f1 = f + 0.03121875f;
        float f2 = (float)this.field_94055_c / 32.0f;
        float f3 = f2 + 0.03121875f;
        float f4 = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            f = this.field_187119_C.func_94209_e();
            f1 = this.field_187119_C.func_94212_f();
            f2 = this.field_187119_C.func_94206_g();
            f3 = this.field_187119_C.func_94210_h();
        }
        float f5 = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float f6 = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float f7 = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int i = this.func_189214_a(partialTicks);
        int j = i >> 16 & 0xFFFF;
        int k = i & 0xFFFF;
        Vec3d[] avec3d = new Vec3d[]{new Vec3d(-rotationX * f4 - rotationXY * f4, -rotationZ * f4, -rotationYZ * f4 - rotationXZ * f4), new Vec3d(-rotationX * f4 + rotationXY * f4, rotationZ * f4, -rotationYZ * f4 + rotationXZ * f4), new Vec3d(rotationX * f4 + rotationXY * f4, rotationZ * f4, rotationYZ * f4 + rotationXZ * f4), new Vec3d(rotationX * f4 - rotationXY * f4, -rotationZ * f4, rotationYZ * f4 - rotationXZ * f4)};
        if (this.field_190014_F != 0.0f) {
            float f8 = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float f9 = MathHelper.func_76134_b((float)(f8 * 0.5f));
            float f10 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)Particle.field_190016_K.field_72450_a;
            float f11 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)Particle.field_190016_K.field_72448_b;
            float f12 = MathHelper.func_76126_a((float)(f8 * 0.5f)) * (float)Particle.field_190016_K.field_72449_c;
            Vec3d vec3d = new Vec3d(f10, f11, f12);
            for (int l = 0; l < 4; ++l) {
                avec3d[l] = vec3d.func_186678_a(2.0 * avec3d[l].func_72430_b(vec3d)).func_178787_e(avec3d[l].func_186678_a((double)(f9 * f9) - vec3d.func_72430_b(vec3d))).func_178787_e(vec3d.func_72431_c(avec3d[l]).func_186678_a(2.0f * f9));
            }
        }
        buffer.func_181662_b((double)f5 + avec3d[0].field_72450_a, (double)f6 + avec3d[0].field_72448_b, (double)f7 + avec3d[0].field_72449_c).func_187315_a(f1, f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[1].field_72450_a, (double)f6 + avec3d[1].field_72448_b, (double)f7 + avec3d[1].field_72449_c).func_187315_a(f1, f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[2].field_72450_a, (double)f6 + avec3d[2].field_72448_b, (double)f7 + avec3d[2].field_72449_c).func_187315_a(f, f2).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        buffer.func_181662_b((double)f5 + avec3d[3].field_72450_a, (double)f6 + avec3d[3].field_72448_b, (double)f7 + avec3d[3].field_72449_c).func_187315_a(f, f3).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }

    public int func_70537_b() {
        return 0;
    }

    public void func_187117_a(TextureAtlasSprite texture) {
        int i = this.func_70537_b();
        if (i != 1) {
            throw new RuntimeException("Invalid call to Particle.setTex, use coordinate methods");
        }
        this.field_187119_C = texture;
    }

    public void func_70536_a(int particleTextureIndex) {
        if (this.func_70537_b() != 0) {
            throw new RuntimeException("Invalid call to Particle.setMiscTex");
        }
        this.field_94054_b = particleTextureIndex % 16;
        this.field_94055_c = particleTextureIndex / 16;
    }

    public void func_94053_h() {
        ++this.field_94054_b;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", Pos (" + this.field_187126_f + "," + this.field_187127_g + "," + this.field_187128_h + "), RGBA (" + this.field_70552_h + "," + this.field_70553_i + "," + this.field_70551_j + "," + this.field_82339_as + "), Age " + this.field_70546_d;
    }

    public void func_187112_i() {
        this.field_187133_m = true;
    }

    protected void func_187115_a(float particleWidth, float particleHeight) {
        if (particleWidth != this.field_187134_n || particleHeight != this.field_187135_o) {
            this.field_187134_n = particleWidth;
            this.field_187135_o = particleHeight;
            AxisAlignedBB axisalignedbb = this.func_187116_l();
            double d0 = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d - (double)particleWidth) / 2.0;
            double d1 = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f - (double)particleWidth) / 2.0;
            this.func_187108_a(new AxisAlignedBB(d0, axisalignedbb.field_72338_b, d1, d0 + (double)this.field_187134_n, axisalignedbb.field_72338_b + (double)this.field_187135_o, d1 + (double)this.field_187134_n));
        }
    }

    public void func_187109_b(double x, double y, double z) {
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        float f = this.field_187134_n / 2.0f;
        float f1 = this.field_187135_o;
        this.func_187108_a(new AxisAlignedBB(x - (double)f, y, z - (double)f, x + (double)f, y + (double)f1, z + (double)f));
    }

    public void func_187110_a(double x, double y, double z) {
        double d0 = y;
        double origX = x;
        double origZ = z;
        if (this.field_190017_n && (x != 0.0 || y != 0.0 || z != 0.0)) {
            ReuseableStream reuseablestream = new ReuseableStream(this.field_187122_b.func_199406_a(null, this.func_187116_l(), x, y, z));
            y = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Y, (AxisAlignedBB)this.func_187116_l(), (Stream)reuseablestream.func_212761_a(), (double)y);
            this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
            x = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.X, (AxisAlignedBB)this.func_187116_l(), (Stream)reuseablestream.func_212761_a(), (double)x);
            if (x != 0.0) {
                this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
            }
            if ((z = VoxelShapes.func_212437_a((EnumFacing.Axis)EnumFacing.Axis.Z, (AxisAlignedBB)this.func_187116_l(), (Stream)reuseablestream.func_212761_a(), (double)z)) != 0.0) {
                this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
            }
        } else {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        }
        this.func_187118_j();
        boolean bl = this.field_187132_l = d0 != y && d0 < 0.0;
        if (origX != x) {
            this.field_187129_i = 0.0;
        }
        if (origZ != z) {
            this.field_187131_k = 0.0;
        }
    }

    protected void func_187118_j() {
        AxisAlignedBB axisalignedbb = this.func_187116_l();
        this.field_187126_f = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_187127_g = axisalignedbb.field_72338_b;
        this.field_187128_h = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
    }

    public int func_189214_a(float partialTick) {
        BlockPos blockpos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        return this.field_187122_b.func_175667_e(blockpos) ? this.field_187122_b.func_175626_b(blockpos, 0) : 0;
    }

    public boolean func_187113_k() {
        return !this.field_187133_m;
    }

    public AxisAlignedBB func_187116_l() {
        return this.field_187120_G;
    }

    public void func_187108_a(AxisAlignedBB bb) {
        this.field_187120_G = bb;
    }
}

