/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelRenderer {
    private final BlockColors field_187499_a;
    private static final ThreadLocal<Object2IntLinkedOpenHashMap<BlockPos>> field_210267_b = ThreadLocal.withInitial(() -> {
        Object2IntLinkedOpenHashMap<BlockPos> object2intlinkedopenhashmap = new Object2IntLinkedOpenHashMap<BlockPos>(50){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
        return object2intlinkedopenhashmap;
    });
    private static final ThreadLocal<Boolean> field_211848_c = ThreadLocal.withInitial(() -> false);

    public BlockModelRenderer(BlockColors blockColorsIn) {
        this.field_187499_a = blockColorsIn;
    }

    @Deprecated
    public boolean func_199324_a(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        return this.renderModel(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModel(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand, IModelData modelData) {
        boolean flag = Minecraft.func_71379_u() && stateIn.getLightValue(worldIn, posIn) == 0 && modelIn.isAmbientOcclusion(stateIn);
        modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        try {
            return flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, modelData);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block model being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, posIn, stateIn);
            crashreportcategory.func_71507_a("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    public boolean func_199326_b(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand, IModelData modelData) {
        boolean flag = false;
        float[] afloat = new float[EnumFacing.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace blockmodelrenderer$ambientocclusionface = new AmbientOcclusionFace();
        for (EnumFacing enumfacing : EnumFacing.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, enumfacing, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, enumfacing)) continue;
            this.func_187492_a(worldIn, stateIn, posIn, buffer, list, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_187492_a(worldIn, stateIn, posIn, buffer, list1, afloat, bitset, blockmodelrenderer$ambientocclusionface);
            flag = true;
        }
        return flag;
    }

    @Deprecated
    public boolean func_199325_c(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand) {
        return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, checkSides, randomIn, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(IWorldReader worldIn, IBakedModel modelIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, boolean checkSides, Random randomIn, long rand, IModelData modelData) {
        boolean flag = false;
        BitSet bitset = new BitSet(3);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            randomIn.setSeed(rand);
            List list = modelIn.getQuads(stateIn, enumfacing, randomIn, modelData);
            if (list.isEmpty() || checkSides && !Block.func_176225_a(stateIn, (IBlockReader)worldIn, posIn, enumfacing)) continue;
            int i = stateIn.func_185889_a(worldIn, posIn.func_177972_a(enumfacing));
            this.func_187496_a(worldIn, stateIn, posIn, i, false, buffer, list, bitset);
            flag = true;
        }
        randomIn.setSeed(rand);
        List list1 = modelIn.getQuads(stateIn, null, randomIn, modelData);
        if (!list1.isEmpty()) {
            this.func_187496_a(worldIn, stateIn, posIn, -1, true, buffer, list1, bitset);
            flag = true;
        }
        return flag;
    }

    private void func_187492_a(IWorldReader blockAccessIn, IBlockState stateIn, BlockPos posIn, BufferBuilder buffer, List<BakedQuad> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace) {
        Vec3d vec3d = stateIn.func_191059_e((IBlockReader)blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            this.func_187494_a(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), quadBounds, bitSet);
            aoFace.func_187491_a(blockAccessIn, stateIn, posIn, bakedquad.func_178210_d(), quadBounds, bitSet);
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(aoFace.field_178207_c[0], aoFace.field_178207_c[1], aoFace.field_178207_c[2], aoFace.field_178207_c[3]);
            if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                float[] fArray = aoFace.field_178206_b;
                fArray[0] = fArray[0] * diffuse;
                float[] fArray2 = aoFace.field_178206_b;
                fArray2[1] = fArray2[1] * diffuse;
                float[] fArray3 = aoFace.field_178206_b;
                fArray3[2] = fArray3[2] * diffuse;
                float[] fArray4 = aoFace.field_178206_b;
                fArray4[3] = fArray4[3] * diffuse;
            }
            if (bakedquad.func_178212_b()) {
                int k = this.field_187499_a.func_186724_a(stateIn, (IWorldReaderBase)blockAccessIn, posIn, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.func_178978_a(aoFace.field_178206_b[0] * f, aoFace.field_178206_b[0] * f1, aoFace.field_178206_b[0] * f2, 4);
                buffer.func_178978_a(aoFace.field_178206_b[1] * f, aoFace.field_178206_b[1] * f1, aoFace.field_178206_b[1] * f2, 3);
                buffer.func_178978_a(aoFace.field_178206_b[2] * f, aoFace.field_178206_b[2] * f1, aoFace.field_178206_b[2] * f2, 2);
                buffer.func_178978_a(aoFace.field_178206_b[3] * f, aoFace.field_178206_b[3] * f1, aoFace.field_178206_b[3] * f2, 1);
            } else {
                buffer.func_178978_a(aoFace.field_178206_b[0], aoFace.field_178206_b[0], aoFace.field_178206_b[0], 4);
                buffer.func_178978_a(aoFace.field_178206_b[1], aoFace.field_178206_b[1], aoFace.field_178206_b[1], 3);
                buffer.func_178978_a(aoFace.field_178206_b[2], aoFace.field_178206_b[2], aoFace.field_178206_b[2], 2);
                buffer.func_178978_a(aoFace.field_178206_b[3], aoFace.field_178206_b[3], aoFace.field_178206_b[3], 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    private void func_187494_a(IBlockState stateIn, int[] vertexData, EnumFacing face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[EnumFacing.WEST.func_176745_a()] = f;
            quadBounds[EnumFacing.EAST.func_176745_a()] = f3;
            quadBounds[EnumFacing.DOWN.func_176745_a()] = f1;
            quadBounds[EnumFacing.UP.func_176745_a()] = f4;
            quadBounds[EnumFacing.NORTH.func_176745_a()] = f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a()] = f5;
            int j = EnumFacing.values().length;
            quadBounds[EnumFacing.WEST.func_176745_a() + j] = 1.0f - f;
            quadBounds[EnumFacing.EAST.func_176745_a() + j] = 1.0f - f3;
            quadBounds[EnumFacing.DOWN.func_176745_a() + j] = 1.0f - f1;
            quadBounds[EnumFacing.UP.func_176745_a() + j] = 1.0f - f4;
            quadBounds[EnumFacing.NORTH.func_176745_a() + j] = 1.0f - f2;
            quadBounds[EnumFacing.SOUTH.func_176745_a() + j] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (face) {
            case DOWN: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case UP: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || stateIn.func_185917_h()) && f1 == f4);
                break;
            }
            case NORTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case SOUTH: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || stateIn.func_185917_h()) && f2 == f5);
                break;
            }
            case WEST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || stateIn.func_185917_h()) && f == f3);
                break;
            }
            case EAST: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || stateIn.func_185917_h()) && f == f3);
            }
        }
    }

    private void func_187496_a(IWorldReader blockAccessIn, IBlockState stateIn, BlockPos posIn, int brightnessIn, boolean ownBrightness, BufferBuilder buffer, List<BakedQuad> list, BitSet bitSet) {
        Vec3d vec3d = stateIn.func_191059_e((IBlockReader)blockAccessIn, posIn);
        double d0 = (double)posIn.func_177958_n() + vec3d.field_72450_a;
        double d1 = (double)posIn.func_177956_o() + vec3d.field_72448_b;
        double d2 = (double)posIn.func_177952_p() + vec3d.field_72449_c;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = list.get(i);
            if (ownBrightness) {
                this.func_187494_a(stateIn, bakedquad.func_178209_a(), bakedquad.func_178210_d(), null, bitSet);
                BlockPos blockpos = bitSet.get(0) ? posIn.func_177972_a(bakedquad.func_178210_d()) : posIn;
                brightnessIn = stateIn.func_185889_a(blockAccessIn, blockpos);
            }
            buffer.func_178981_a(bakedquad.func_178209_a());
            buffer.func_178962_a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.func_178212_b()) {
                int k = this.field_187499_a.func_186724_a(stateIn, (IWorldReaderBase)blockAccessIn, posIn, bakedquad.func_178211_c());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                if (bakedquad.shouldApplyDiffuseLighting()) {
                    float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                    f *= diffuse;
                    f1 *= diffuse;
                    f2 *= diffuse;
                }
                buffer.func_178978_a(f, f1, f2, 4);
                buffer.func_178978_a(f, f1, f2, 3);
                buffer.func_178978_a(f, f1, f2, 2);
                buffer.func_178978_a(f, f1, f2, 1);
            } else if (bakedquad.shouldApplyDiffuseLighting()) {
                float diffuse = LightUtil.diffuseLight((EnumFacing)bakedquad.func_178210_d());
                buffer.func_178978_a(diffuse, diffuse, diffuse, 4);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 3);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 2);
                buffer.func_178978_a(diffuse, diffuse, diffuse, 1);
            }
            buffer.func_178987_a(d0, d1, d2);
        }
    }

    public void func_178262_a(IBakedModel bakedModel, float brightness, float red, float green, float blue) {
        this.func_187495_a(null, bakedModel, brightness, red, green, blue);
    }

    public void func_187495_a(@Nullable IBlockState state, IBakedModel modelIn, float brightness, float red, float green, float blue) {
        Random random = new Random();
        long i = 42L;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            random.setSeed(42L);
            this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, enumfacing, random));
        }
        random.setSeed(42L);
        this.func_178264_a(brightness, red, green, blue, modelIn.func_200117_a(state, null, random));
    }

    public void func_178266_a(IBakedModel model, IBlockState state, float brightness, boolean glDisabled) {
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        int i = this.field_187499_a.func_186724_a(state, null, null, 0);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        if (!glDisabled) {
            GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        }
        this.func_187495_a(state, model, brightness, f, f1, f2);
    }

    private void func_178264_a(float brightness, float red, float green, float blue, List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            bufferbuilder.func_178981_a(bakedquad.func_178209_a());
            if (bakedquad.func_178212_b()) {
                bufferbuilder.func_178990_f(red * brightness, green * brightness, blue * brightness);
            } else {
                bufferbuilder.func_178990_f(brightness, brightness, brightness);
            }
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            bufferbuilder.func_178975_e(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void func_211847_a() {
        field_211848_c.set(true);
    }

    public static void func_210266_a() {
        field_210267_b.get().clear();
        field_211848_c.set(false);
    }

    private static int func_210264_b(IBlockState blockStateIn, IWorldReader worldIn, BlockPos posIn) {
        int i;
        Boolean obool = field_211848_c.get();
        Object2IntLinkedOpenHashMap<BlockPos> object2intlinkedopenhashmap = null;
        if (obool.booleanValue() && (i = (object2intlinkedopenhashmap = field_210267_b.get()).getInt((Object)posIn)) != Integer.MAX_VALUE) {
            return i;
        }
        int j = blockStateIn.func_185889_a(worldIn, posIn);
        if (object2intlinkedopenhashmap != null) {
            if (object2intlinkedopenhashmap.size() == 50) {
                object2intlinkedopenhashmap.removeFirstInt();
            }
            object2intlinkedopenhashmap.put((Object)posIn.func_185334_h(), j);
        }
        return j;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int field_178191_g;
        private final int field_178200_h;
        private final int field_178201_i;
        private final int field_178198_j;
        private static final VertexTranslations[] field_178199_k;

        private VertexTranslations(int vert0In, int vert1In, int vert2In, int vert3In) {
            this.field_178191_g = vert0In;
            this.field_178200_h = vert1In;
            this.field_178201_i = vert2In;
            this.field_178198_j = vert3In;
        }

        public static VertexTranslations func_178184_a(EnumFacing facingIn) {
            return field_178199_k[facingIn.func_176745_a()];
        }

        static {
            field_178199_k = (VertexTranslations[])Util.func_200696_a((Object)new VertexTranslations[6], p_209261_0_ -> {
                p_209261_0_[EnumFacing.DOWN.func_176745_a()] = DOWN;
                p_209261_0_[EnumFacing.UP.func_176745_a()] = UP;
                p_209261_0_[EnumFacing.NORTH.func_176745_a()] = NORTH;
                p_209261_0_[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
                p_209261_0_[EnumFacing.WEST.func_176745_a()] = WEST;
                p_209261_0_[EnumFacing.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum Orientation {
        DOWN(EnumFacing.DOWN, false),
        UP(EnumFacing.UP, false),
        NORTH(EnumFacing.NORTH, false),
        SOUTH(EnumFacing.SOUTH, false),
        WEST(EnumFacing.WEST, false),
        EAST(EnumFacing.EAST, false),
        FLIP_DOWN(EnumFacing.DOWN, true),
        FLIP_UP(EnumFacing.UP, true),
        FLIP_NORTH(EnumFacing.NORTH, true),
        FLIP_SOUTH(EnumFacing.SOUTH, true),
        FLIP_WEST(EnumFacing.WEST, true),
        FLIP_EAST(EnumFacing.EAST, true);

        private final int field_178229_m;

        private Orientation(EnumFacing facingIn, boolean flip) {
            this.field_178229_m = facingIn.func_176745_a() + (flip ? EnumFacing.values().length : 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum EnumNeighborInfo {
        DOWN(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final EnumFacing[] field_178276_g;
        private final boolean field_178289_i;
        private final Orientation[] field_178286_j;
        private final Orientation[] field_178287_k;
        private final Orientation[] field_178284_l;
        private final Orientation[] field_178285_m;
        private static final EnumNeighborInfo[] field_178282_n;

        private EnumNeighborInfo(EnumFacing[] cornersIn, float brightness, boolean doNonCubicWeightIn, Orientation[] vert0WeightsIn, Orientation[] vert1WeightsIn, Orientation[] vert2WeightsIn, Orientation[] vert3WeightsIn) {
            this.field_178276_g = cornersIn;
            this.field_178289_i = doNonCubicWeightIn;
            this.field_178286_j = vert0WeightsIn;
            this.field_178287_k = vert1WeightsIn;
            this.field_178284_l = vert2WeightsIn;
            this.field_178285_m = vert3WeightsIn;
        }

        public static EnumNeighborInfo func_178273_a(EnumFacing facing) {
            return field_178282_n[facing.func_176745_a()];
        }

        static {
            field_178282_n = (EnumNeighborInfo[])Util.func_200696_a((Object)new EnumNeighborInfo[6], p_209260_0_ -> {
                p_209260_0_[EnumFacing.DOWN.func_176745_a()] = DOWN;
                p_209260_0_[EnumFacing.UP.func_176745_a()] = UP;
                p_209260_0_[EnumFacing.NORTH.func_176745_a()] = NORTH;
                p_209260_0_[EnumFacing.SOUTH.func_176745_a()] = SOUTH;
                p_209260_0_[EnumFacing.WEST.func_176745_a()] = WEST;
                p_209260_0_[EnumFacing.EAST.func_176745_a()] = EAST;
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class AmbientOcclusionFace {
        private final float[] field_178206_b = new float[4];
        private final int[] field_178207_c = new int[4];

        AmbientOcclusionFace() {
        }

        public void func_187491_a(IWorldReader worldIn, IBlockState state, BlockPos centerPos, EnumFacing direction, float[] faceShape, BitSet shapeState) {
            int l1;
            float f7;
            int k1;
            float f6;
            int j1;
            float f5;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = shapeState.get(0) ? centerPos.func_177972_a(direction) : centerPos;
            EnumNeighborInfo blockmodelrenderer$enumneighborinfo = EnumNeighborInfo.func_178273_a(direction);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[0]);
            int i = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            float f = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[1]);
            int j = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            float f1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
            int k = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            float f2 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
            int l = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            float f3 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[0]).func_189536_c(direction);
            boolean flag = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[1]).func_189536_c(direction);
            boolean flag1 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]).func_189536_c(direction);
            boolean flag2 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]).func_189536_c(direction);
            boolean bl = flag3 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200016_a((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) == 0;
            if (!flag2 && !flag) {
                f4 = f;
                i1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f4 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
                i1 = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag) {
                f5 = f;
                j1 = i;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[0]).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f5 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
                j1 = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag2 && !flag1) {
                f6 = f1;
                k1 = j;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[2]);
                f6 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
                k1 = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            if (!flag3 && !flag1) {
                f7 = f1;
                l1 = j;
            } else {
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[1]).func_189536_c(blockmodelrenderer$enumneighborinfo.field_178276_g[3]);
                f7 = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185892_j();
                l1 = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            int i2 = BlockModelRenderer.func_210264_b(state, worldIn, centerPos);
            blockpos$mutableblockpos.func_189533_g((Vec3i)centerPos).func_189536_c(direction);
            if (shapeState.get(0) || !worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_200015_d((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos)) {
                i2 = BlockModelRenderer.func_210264_b(state, worldIn, (BlockPos)blockpos$mutableblockpos);
            }
            float f8 = shapeState.get(0) ? worldIn.func_180495_p(blockpos).func_185892_j() : worldIn.func_180495_p(centerPos).func_185892_j();
            VertexTranslations blockmodelrenderer$vertextranslations = VertexTranslations.func_178184_a(direction);
            if (shapeState.get(1) && blockmodelrenderer$enumneighborinfo.field_178289_i) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[0].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[1].field_178229_m];
                float f14 = faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[2].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[3].field_178229_m];
                float f15 = faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[4].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[5].field_178229_m];
                float f16 = faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[6].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178286_j[7].field_178229_m];
                float f17 = faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[0].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[1].field_178229_m];
                float f18 = faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[2].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[3].field_178229_m];
                float f19 = faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[4].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[5].field_178229_m];
                float f20 = faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[6].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178287_k[7].field_178229_m];
                float f21 = faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[0].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[1].field_178229_m];
                float f22 = faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[2].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[3].field_178229_m];
                float f23 = faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[4].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[5].field_178229_m];
                float f24 = faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[6].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178284_l[7].field_178229_m];
                float f25 = faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[0].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[1].field_178229_m];
                float f26 = faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[2].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[3].field_178229_m];
                float f27 = faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[4].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[5].field_178229_m];
                float f28 = faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[6].field_178229_m] * faceShape[blockmodelrenderer$enumneighborinfo.field_178285_m[7].field_178229_m];
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int j2 = this.func_147778_a(l, i, j1, i2);
                int k2 = this.func_147778_a(k, i, i1, i2);
                int l2 = this.func_147778_a(k, j, k1, i2);
                int i3 = this.func_147778_a(l, j, l1, i2);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_178203_a(j2, k2, l2, i3, f13, f14, f15, f16);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_178203_a(j2, k2, l2, i3, f17, f18, f19, f20);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_178203_a(j2, k2, l2, i3, f21, f22, f23, f24);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_178203_a(j2, k2, l2, i3, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = this.func_147778_a(l, i, j1, i2);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = this.func_147778_a(k, i, i1, i2);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = this.func_147778_a(k, j, k1, i2);
                this.field_178207_c[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = this.func_147778_a(l, j, l1, i2);
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178191_g] = f9;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178200_h] = f10;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178201_i] = f11;
                this.field_178206_b[((VertexTranslations)blockmodelrenderer$vertextranslations).field_178198_j] = f12;
            }
        }

        private int func_147778_a(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int func_178203_a(int b1, int b2, int b3, int b4, float w1, float w2, float w3, float w4) {
            int i = (int)((float)(b1 >> 16 & 0xFF) * w1 + (float)(b2 >> 16 & 0xFF) * w2 + (float)(b3 >> 16 & 0xFF) * w3 + (float)(b4 >> 16 & 0xFF) * w4) & 0xFF;
            int j = (int)((float)(b1 & 0xFF) * w1 + (float)(b2 & 0xFF) * w2 + (float)(b3 & 0xFF) * w3 + (float)(b4 & 0xFF) * w4) & 0xFF;
            return i << 16 | j;
        }
    }
}

