/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.Processor;

@OnlyIn(value=Dist.CLIENT)
public class OpenGlHelper {
    public static boolean field_153197_d;
    public static boolean field_181063_b;
    public static int field_153198_e;
    public static int field_153199_f;
    public static int field_153200_g;
    public static int field_153201_h;
    public static int field_153202_i;
    public static int field_153203_j;
    public static int field_153204_k;
    public static int field_153205_l;
    public static int field_153206_m;
    private static FboMode field_153212_w;
    public static boolean field_148823_f;
    private static boolean field_153213_x;
    private static boolean field_153214_y;
    public static int field_153207_o;
    public static int field_153208_p;
    public static int field_153209_q;
    public static int field_153210_r;
    private static boolean field_153215_z;
    public static int field_77478_a;
    public static int field_77476_b;
    public static int field_176096_r;
    private static boolean field_176088_V;
    public static int field_176095_s;
    public static int field_176094_t;
    public static int field_176093_u;
    public static int field_176092_v;
    public static int field_176091_w;
    public static int field_176099_x;
    public static int field_176098_y;
    public static int field_176097_z;
    public static int field_176080_A;
    public static int field_176081_B;
    public static int field_176082_C;
    public static int field_176076_D;
    public static int field_176077_E;
    public static int field_176078_F;
    public static int field_176079_G;
    public static int field_176084_H;
    public static int field_176085_I;
    public static int field_176086_J;
    public static int field_176087_K;
    private static boolean field_148828_i;
    public static boolean field_153211_u;
    public static boolean field_148827_a;
    public static boolean field_148824_g;
    private static String field_153196_B;
    private static String field_183030_aa;
    public static boolean field_176083_O;
    public static boolean field_181062_Q;
    private static boolean field_176090_Y;
    public static int field_176089_P;
    public static int field_148826_e;
    private static final Map<Integer, String> field_195919_ac;
    public static float lastBrightnessX;
    public static float lastBrightnessY;

    public static void func_77474_a() {
        GLCapabilities glcapabilities = GL.getCapabilities();
        field_153215_z = glcapabilities.GL_ARB_multitexture && !glcapabilities.OpenGL13;
        boolean bl = field_176088_V = glcapabilities.GL_ARB_texture_env_combine && !glcapabilities.OpenGL13;
        if (field_153215_z) {
            field_153196_B = field_153196_B + "Using ARB_multitexture.\n";
            field_77478_a = 33984;
            field_77476_b = 33985;
            field_176096_r = 33986;
        } else {
            field_153196_B = field_153196_B + "Using GL 1.3 multitexturing.\n";
            field_77478_a = 33984;
            field_77476_b = 33985;
            field_176096_r = 33986;
        }
        if (field_176088_V) {
            field_153196_B = field_153196_B + "Using ARB_texture_env_combine.\n";
            field_176095_s = 34160;
            field_176094_t = 34165;
            field_176093_u = 34167;
            field_176092_v = 34166;
            field_176091_w = 34168;
            field_176099_x = 34161;
            field_176098_y = 34176;
            field_176097_z = 34177;
            field_176080_A = 34178;
            field_176081_B = 34192;
            field_176082_C = 34193;
            field_176076_D = 34194;
            field_176077_E = 34162;
            field_176078_F = 34184;
            field_176079_G = 34185;
            field_176084_H = 34186;
            field_176085_I = 34200;
            field_176086_J = 34201;
            field_176087_K = 34202;
        } else {
            field_153196_B = field_153196_B + "Using GL 1.3 texture combiners.\n";
            field_176095_s = 34160;
            field_176094_t = 34165;
            field_176093_u = 34167;
            field_176092_v = 34166;
            field_176091_w = 34168;
            field_176099_x = 34161;
            field_176098_y = 34176;
            field_176097_z = 34177;
            field_176080_A = 34178;
            field_176081_B = 34192;
            field_176082_C = 34193;
            field_176076_D = 34194;
            field_176077_E = 34162;
            field_176078_F = 34184;
            field_176079_G = 34185;
            field_176084_H = 34186;
            field_176085_I = 34200;
            field_176086_J = 34201;
            field_176087_K = 34202;
        }
        field_153211_u = glcapabilities.GL_EXT_blend_func_separate && !glcapabilities.OpenGL14;
        field_148828_i = glcapabilities.OpenGL14 || glcapabilities.GL_EXT_blend_func_separate;
        boolean bl2 = field_148823_f = field_148828_i && (glcapabilities.GL_ARB_framebuffer_object || glcapabilities.GL_EXT_framebuffer_object || glcapabilities.OpenGL30);
        if (field_148823_f) {
            field_153196_B = field_153196_B + "Using framebuffer objects because ";
            if (glcapabilities.OpenGL30) {
                field_153196_B = field_153196_B + "OpenGL 3.0 is supported and separate blending is supported.\n";
                field_153212_w = FboMode.BASE;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153203_j = 36054;
                field_153204_k = 36055;
                field_153205_l = 36059;
                field_153206_m = 36060;
            } else if (glcapabilities.GL_ARB_framebuffer_object) {
                field_153196_B = field_153196_B + "ARB_framebuffer_object is supported and separate blending is supported.\n";
                field_153212_w = FboMode.ARB;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153204_k = 36055;
                field_153203_j = 36054;
                field_153205_l = 36059;
                field_153206_m = 36060;
            } else if (glcapabilities.GL_EXT_framebuffer_object) {
                field_153196_B = field_153196_B + "EXT_framebuffer_object is supported.\n";
                field_153212_w = FboMode.EXT;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153204_k = 36055;
                field_153203_j = 36054;
                field_153205_l = 36059;
                field_153206_m = 36060;
            }
        } else {
            field_153196_B = field_153196_B + "Not using framebuffer objects because ";
            field_153196_B = field_153196_B + "OpenGL 1.4 is " + (glcapabilities.OpenGL14 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "EXT_blend_func_separate is " + (glcapabilities.GL_EXT_blend_func_separate ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "OpenGL 3.0 is " + (glcapabilities.OpenGL30 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_framebuffer_object is " + (glcapabilities.GL_ARB_framebuffer_object ? "" : "not ") + "supported, and ";
            field_153196_B = field_153196_B + "EXT_framebuffer_object is " + (glcapabilities.GL_EXT_framebuffer_object ? "" : "not ") + "supported.\n";
        }
        field_148827_a = glcapabilities.OpenGL21;
        field_153213_x = field_148827_a || glcapabilities.GL_ARB_vertex_shader && glcapabilities.GL_ARB_fragment_shader && glcapabilities.GL_ARB_shader_objects;
        field_153196_B = field_153196_B + "Shaders are " + (field_153213_x ? "" : "not ") + "available because ";
        if (field_153213_x) {
            if (glcapabilities.OpenGL21) {
                field_153196_B = field_153196_B + "OpenGL 2.1 is supported.\n";
                field_153214_y = false;
                field_153207_o = 35714;
                field_153208_p = 35713;
                field_153209_q = 35633;
                field_153210_r = 35632;
            } else {
                field_153196_B = field_153196_B + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported.\n";
                field_153214_y = true;
                field_153207_o = 35714;
                field_153208_p = 35713;
                field_153209_q = 35633;
                field_153210_r = 35632;
            }
        } else {
            field_153196_B = field_153196_B + "OpenGL 2.1 is " + (glcapabilities.OpenGL21 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_shader_objects is " + (glcapabilities.GL_ARB_shader_objects ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_vertex_shader is " + (glcapabilities.GL_ARB_vertex_shader ? "" : "not ") + "supported, and ";
            field_153196_B = field_153196_B + "ARB_fragment_shader is " + (glcapabilities.GL_ARB_fragment_shader ? "" : "not ") + "supported.\n";
        }
        field_148824_g = field_148823_f && field_153213_x;
        String s = GL11.glGetString((int)7936).toLowerCase(Locale.ROOT);
        field_153197_d = s.contains("nvidia");
        field_176090_Y = !glcapabilities.OpenGL15 && glcapabilities.GL_ARB_vertex_buffer_object;
        field_176083_O = glcapabilities.OpenGL15 || field_176090_Y;
        field_153196_B = field_153196_B + "VBOs are " + (field_176083_O ? "" : "not ") + "available because ";
        if (field_176083_O) {
            if (field_176090_Y) {
                field_153196_B = field_153196_B + "ARB_vertex_buffer_object is supported.\n";
                field_148826_e = 35044;
                field_176089_P = 34962;
            } else {
                field_153196_B = field_153196_B + "OpenGL 1.5 is supported.\n";
                field_148826_e = 35044;
                field_176089_P = 34962;
            }
        }
        if (field_181063_b = s.contains("ati")) {
            if (field_176083_O) {
                field_181062_Q = true;
            } else {
                GameSettings.Options.RENDER_DISTANCE.func_148263_a(16.0f);
            }
        }
        try {
            Processor[] aprocessor = new SystemInfo().getHardware().getProcessors();
            field_183030_aa = String.format("%dx %s", aprocessor.length, aprocessor[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean func_153193_b() {
        return field_148824_g;
    }

    public static String func_153172_c() {
        return field_153196_B;
    }

    public static int func_153175_a(int program, int pname) {
        return field_153214_y ? ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)pname) : GL20.glGetProgrami((int)program, (int)pname);
    }

    public static void func_153178_b(int program, int shaderIn) {
        if (field_153214_y) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shaderIn);
        } else {
            GL20.glAttachShader((int)program, (int)shaderIn);
        }
    }

    public static void func_153180_a(int shaderIn) {
        if (field_153214_y) {
            ARBShaderObjects.glDeleteObjectARB((int)shaderIn);
        } else {
            GL20.glDeleteShader((int)shaderIn);
        }
    }

    public static int func_153195_b(int type) {
        return field_153214_y ? ARBShaderObjects.glCreateShaderObjectARB((int)type) : GL20.glCreateShader((int)type);
    }

    public static void func_195918_a(int shaderIn, CharSequence string) {
        if (field_153214_y) {
            ARBShaderObjects.glShaderSourceARB((int)shaderIn, (CharSequence)string);
        } else {
            GL20.glShaderSource((int)shaderIn, (CharSequence)string);
        }
    }

    public static void func_153170_c(int shaderIn) {
        if (field_153214_y) {
            ARBShaderObjects.glCompileShaderARB((int)shaderIn);
        } else {
            GL20.glCompileShader((int)shaderIn);
        }
    }

    public static int func_153157_c(int shaderIn, int pname) {
        return field_153214_y ? ARBShaderObjects.glGetObjectParameteriARB((int)shaderIn, (int)pname) : GL20.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String func_153158_d(int shaderIn, int maxLength) {
        return field_153214_y ? ARBShaderObjects.glGetInfoLogARB((int)shaderIn, (int)maxLength) : GL20.glGetShaderInfoLog((int)shaderIn, (int)maxLength);
    }

    public static String func_153166_e(int program, int maxLength) {
        return field_153214_y ? ARBShaderObjects.glGetInfoLogARB((int)program, (int)maxLength) : GL20.glGetProgramInfoLog((int)program, (int)maxLength);
    }

    public static void func_153161_d(int program) {
        if (field_153214_y) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        } else {
            GL20.glUseProgram((int)program);
        }
    }

    public static int func_153183_d() {
        return field_153214_y ? ARBShaderObjects.glCreateProgramObjectARB() : GL20.glCreateProgram();
    }

    public static void func_153187_e(int program) {
        if (field_153214_y) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
        } else {
            GL20.glDeleteProgram((int)program);
        }
    }

    public static void func_153179_f(int program) {
        if (field_153214_y) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        } else {
            GL20.glLinkProgram((int)program);
        }
    }

    public static int func_153194_a(int programObj, CharSequence name) {
        return field_153214_y ? ARBShaderObjects.glGetUniformLocationARB((int)programObj, (CharSequence)name) : GL20.glGetUniformLocation((int)programObj, (CharSequence)name);
    }

    public static void func_153181_a(int location, IntBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1ivARB((int)location, (IntBuffer)values);
        } else {
            GL20.glUniform1iv((int)location, (IntBuffer)values);
        }
    }

    public static void func_153163_f(int location, int v0) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1iARB((int)location, (int)v0);
        } else {
            GL20.glUniform1i((int)location, (int)v0);
        }
    }

    public static void func_153168_a(int location, FloatBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1fvARB((int)location, (FloatBuffer)values);
        } else {
            GL20.glUniform1fv((int)location, (FloatBuffer)values);
        }
    }

    public static void func_153182_b(int location, IntBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform2ivARB((int)location, (IntBuffer)values);
        } else {
            GL20.glUniform2iv((int)location, (IntBuffer)values);
        }
    }

    public static void func_153177_b(int location, FloatBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform2fvARB((int)location, (FloatBuffer)values);
        } else {
            GL20.glUniform2fv((int)location, (FloatBuffer)values);
        }
    }

    public static void func_153192_c(int location, IntBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform3ivARB((int)location, (IntBuffer)values);
        } else {
            GL20.glUniform3iv((int)location, (IntBuffer)values);
        }
    }

    public static void func_153191_c(int location, FloatBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform3fvARB((int)location, (FloatBuffer)values);
        } else {
            GL20.glUniform3fv((int)location, (FloatBuffer)values);
        }
    }

    public static void func_153162_d(int location, IntBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform4ivARB((int)location, (IntBuffer)values);
        } else {
            GL20.glUniform4iv((int)location, (IntBuffer)values);
        }
    }

    public static void func_153159_d(int location, FloatBuffer values) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform4fvARB((int)location, (FloatBuffer)values);
        } else {
            GL20.glUniform4fv((int)location, (FloatBuffer)values);
        }
    }

    public static void func_153173_a(int location, boolean transpose, FloatBuffer matrices) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix2fvARB((int)location, (boolean)transpose, (FloatBuffer)matrices);
        } else {
            GL20.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)matrices);
        }
    }

    public static void func_153189_b(int location, boolean transpose, FloatBuffer matrices) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix3fvARB((int)location, (boolean)transpose, (FloatBuffer)matrices);
        } else {
            GL20.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)matrices);
        }
    }

    public static void func_153160_c(int location, boolean transpose, FloatBuffer matrices) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix4fvARB((int)location, (boolean)transpose, (FloatBuffer)matrices);
        } else {
            GL20.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)matrices);
        }
    }

    public static int func_153164_b(int program, CharSequence name) {
        return field_153214_y ? ARBVertexShader.glGetAttribLocationARB((int)program, (CharSequence)name) : GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public static int func_176073_e() {
        return field_176090_Y ? ARBVertexBufferObject.glGenBuffersARB() : GL15.glGenBuffers();
    }

    public static void func_176072_g(int target, int buffer) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glBindBufferARB((int)target, (int)buffer);
        } else {
            GL15.glBindBuffer((int)target, (int)buffer);
        }
    }

    public static void func_176071_a(int target, ByteBuffer data, int usage) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        }
    }

    public static void func_176074_g(int buffer) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glDeleteBuffersARB((int)buffer);
        } else {
            GL15.glDeleteBuffers((int)buffer);
        }
    }

    public static boolean func_176075_f() {
        return field_176083_O && Minecraft.func_71410_x().field_71474_y.field_178881_t;
    }

    public static void func_153171_g(int target, int framebufferIn) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glBindFramebuffer((int)target, (int)framebufferIn);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebufferIn);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebufferIn);
                }
            }
        }
    }

    public static void func_153176_h(int target, int renderbuffer) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
                }
            }
        }
    }

    public static void func_153184_g(int renderbuffer) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glDeleteRenderbuffers((int)renderbuffer);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
                }
            }
        }
    }

    public static void func_153174_h(int framebufferIn) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glDeleteFramebuffers((int)framebufferIn);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glDeleteFramebuffers((int)framebufferIn);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebufferIn);
                }
            }
        }
    }

    public static int func_153165_e() {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glGenFramebuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static int func_153185_f() {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glGenRenderbuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return -1;
    }

    public static void func_153186_a(int target, int internalFormat, int width, int height) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalFormat, (int)width, (int)height);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalFormat, (int)width, (int)height);
                }
            }
        }
    }

    public static void func_153190_b(int target, int attachment, int renderBufferTarget, int renderBuffer) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderBufferTarget, (int)renderBuffer);
                }
            }
        }
    }

    public static int func_153167_i(int target) {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glCheckFramebufferStatus((int)target);
            }
            case ARB: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)target);
            }
            case EXT: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
            }
        }
        return -1;
    }

    public static void func_153188_a(int target, int attachment, int textarget, int texture, int level) {
        if (field_148823_f) {
            switch (field_153212_w) {
                case BASE: {
                    GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                    break;
                }
                case ARB: {
                    ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                    break;
                }
                case EXT: {
                    EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                }
            }
        }
    }

    public static void func_77473_a(int texture) {
        if (field_153215_z) {
            ARBMultitexture.glActiveTextureARB((int)texture);
        } else {
            GL13.glActiveTexture((int)texture);
        }
    }

    public static void func_77472_b(int texture) {
        if (field_153215_z) {
            ARBMultitexture.glClientActiveTextureARB((int)texture);
        } else {
            GL13.glClientActiveTexture((int)texture);
        }
    }

    public static void func_77475_a(int target, float x, float y) {
        if (field_153215_z) {
            ARBMultitexture.glMultiTexCoord2fARB((int)target, (float)x, (float)y);
        } else {
            GL13.glMultiTexCoord2f((int)target, (float)x, (float)y);
        }
        if (target == field_77476_b) {
            lastBrightnessX = x;
            lastBrightnessY = y;
        }
    }

    public static void func_148821_a(int sFactorRGB, int dFactorRGB, int sfactorAlpha, int dfactorAlpha) {
        if (field_148828_i) {
            if (field_153211_u) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)sFactorRGB, (int)dFactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
            } else {
                GL14.glBlendFuncSeparate((int)sFactorRGB, (int)dFactorRGB, (int)sfactorAlpha, (int)dfactorAlpha);
            }
        } else {
            GL11.glBlendFunc((int)sFactorRGB, (int)dFactorRGB);
        }
    }

    public static boolean func_148822_b() {
        return field_148823_f && Minecraft.func_71410_x().field_71474_y.field_151448_g;
    }

    public static String func_183029_j() {
        return field_183030_aa == null ? "<unknown>" : field_183030_aa;
    }

    public static void func_188785_m(int size) {
        OpenGlHelper.func_203094_a(size, true, true, true);
    }

    public static void func_203094_a(int size, boolean renderX, boolean renderY, boolean renderZ) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glLineWidth((float)4.0f);
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (renderX) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(size, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (renderY) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, size, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (renderZ) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, size).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)2.0f);
        bufferbuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (renderX) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(size, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        }
        if (renderY) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, size, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        }
        if (renderZ) {
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(127, 127, 255, 255).func_181675_d();
            bufferbuilder.func_181662_b(0.0, 0.0, size).func_181669_b(127, 127, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
    }

    public static String func_195917_n(int error) {
        return field_195919_ac.get(error);
    }

    static {
        field_153196_B = "";
        field_195919_ac = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_203093_0_ -> {
            p_203093_0_.put(0, "No error");
            p_203093_0_.put(1280, "Enum parameter is invalid for this function");
            p_203093_0_.put(1281, "Parameter is invalid for this function");
            p_203093_0_.put(1282, "Current state is invalid for this function");
            p_203093_0_.put(1283, "Stack overflow");
            p_203093_0_.put(1284, "Stack underflow");
            p_203093_0_.put(1285, "Out of memory");
            p_203093_0_.put(1286, "Operation on incomplete framebuffer");
            p_203093_0_.put(1286, "Operation on incomplete framebuffer");
        });
        lastBrightnessX = 0.0f;
        lastBrightnessY = 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum FboMode {
        BASE,
        ARB,
        EXT;

    }
}

