/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBlock;
import net.minecraft.client.renderer.model.ModelBlockDefinition;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelBakery {
    public static final ResourceLocation field_207763_a = new ResourceLocation("block/fire_0");
    public static final ResourceLocation field_207764_b = new ResourceLocation("block/fire_1");
    public static final ResourceLocation field_207766_d = new ResourceLocation("block/lava_flow");
    public static final ResourceLocation field_207768_f = new ResourceLocation("block/water_flow");
    public static final ResourceLocation field_207769_g = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation field_207770_h = new ResourceLocation("block/destroy_stage_0");
    public static final ResourceLocation field_207771_i = new ResourceLocation("block/destroy_stage_1");
    public static final ResourceLocation field_207772_j = new ResourceLocation("block/destroy_stage_2");
    public static final ResourceLocation field_207773_k = new ResourceLocation("block/destroy_stage_3");
    public static final ResourceLocation field_207774_l = new ResourceLocation("block/destroy_stage_4");
    public static final ResourceLocation field_207775_m = new ResourceLocation("block/destroy_stage_5");
    public static final ResourceLocation field_207776_n = new ResourceLocation("block/destroy_stage_6");
    public static final ResourceLocation field_207777_o = new ResourceLocation("block/destroy_stage_7");
    public static final ResourceLocation field_207778_p = new ResourceLocation("block/destroy_stage_8");
    public static final ResourceLocation field_207779_q = new ResourceLocation("block/destroy_stage_9");
    protected static final Set<ResourceLocation> field_177602_b = Sets.newHashSet((Object[])new ResourceLocation[]{field_207768_f, field_207766_d, field_207769_g, field_207763_a, field_207764_b, field_207770_h, field_207771_i, field_207772_j, field_207773_k, field_207774_l, field_207775_m, field_207776_n, field_207777_o, field_207778_p, field_207779_q, new ResourceLocation("item/empty_armor_slot_helmet"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_boots"), new ResourceLocation("item/empty_armor_slot_shield")});
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195677_a().func_195668_m().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195677_a().func_195668_m().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    protected static final ModelBlock field_177606_o = (ModelBlock)Util.func_200696_a((Object)ModelBlock.func_178294_a("{}"), p_209273_0_ -> {
        p_209273_0_.field_178317_b = "generation marker";
    });
    protected static final ModelBlock field_177616_r = (ModelBlock)Util.func_200696_a((Object)ModelBlock.func_178294_a("{}"), p_209274_0_ -> {
        p_209274_0_.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, IBlockState> field_209613_y = new StateContainer.Builder((Object)Blocks.field_150350_a).func_206894_a(new IProperty[]{BooleanProperty.func_177716_a((String)"map")}).func_206893_a(BlockState::new);
    protected final IResourceManager field_177598_f;
    protected final TextureMap field_177609_j;
    protected final Map<ModelResourceLocation, IBakedModel> field_177605_n = Maps.newHashMap();
    private static final Map<ResourceLocation, StateContainer<Block, IBlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), field_209613_y);
    private final Map<ResourceLocation, IUnbakedModel> field_209608_D = Maps.newHashMap();
    private final Set<ResourceLocation> field_209609_E = Sets.newHashSet();
    private final ModelBlockDefinition.ContainerHolder field_209610_F = new ModelBlockDefinition.ContainerHolder();

    public ModelBakery(IResourceManager resourceManagerIn, TextureMap textureMapIn) {
        this.field_177598_f = resourceManagerIn;
        this.field_177609_j = textureMapIn;
    }

    private static Predicate<IBlockState> func_209605_a(StateContainer<Block, IBlockState> containerIn, String variantIn) {
        HashMap map = Maps.newHashMap();
        for (String s : field_209611_w.split((CharSequence)variantIn)) {
            Iterator iterator = field_209612_x.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String s1 = (String)iterator.next();
            IProperty iproperty = containerIn.func_185920_a(s1);
            if (iproperty != null && iterator.hasNext()) {
                String s2 = (String)iterator.next();
                Object comparable = ModelBakery.func_209592_a(iproperty, s2);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + s2 + "' for blockstate property: '" + s1 + "' " + iproperty.func_177700_c());
                }
                map.put(iproperty, comparable);
                continue;
            }
            if (s1.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + s1 + "'");
        }
        Block block = (Block)((Object)containerIn.func_177622_c());
        return p_209606_2_ -> {
            if (p_209606_2_ != null && block == p_209606_2_.func_177230_c()) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(p_209606_2_.func_177229_b((IProperty)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(IProperty<T> property, String value) {
        return (T)property.func_185929_b(value).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation modelLocation) {
        if (this.field_209608_D.containsKey(modelLocation)) {
            return this.field_209608_D.get(modelLocation);
        }
        if (this.field_209609_E.contains(modelLocation)) {
            throw new IllegalStateException("Circular reference while loading " + modelLocation);
        }
        this.field_209609_E.add(modelLocation);
        IUnbakedModel iunbakedmodel = this.field_209608_D.get((Object)field_177604_a);
        while (!this.field_209609_E.isEmpty()) {
            ResourceLocation resourcelocation = this.field_209609_E.iterator().next();
            try {
                if (this.field_209608_D.containsKey(resourcelocation)) continue;
                this.func_209598_b(resourcelocation);
            }
            catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                field_177603_c.warn(modelbakery$blockstatedefinitionexception.getMessage());
                this.field_209608_D.put(resourcelocation, iunbakedmodel);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourcelocation, (Object)modelLocation, (Object)exception);
                this.field_209608_D.put(resourcelocation, iunbakedmodel);
            }
            finally {
                this.field_209609_E.remove(resourcelocation);
            }
        }
        return this.field_209608_D.getOrDefault(modelLocation, iunbakedmodel);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void func_209598_b(ResourceLocation p_209598_1_) throws Exception {
        HashMap map1;
        HashMap map;
        block19: {
            boolean flag;
            block18: {
                if (!(p_209598_1_ instanceof ModelResourceLocation)) {
                    this.func_209593_a(p_209598_1_, this.func_177594_c(p_209598_1_));
                    return;
                }
                ModelResourceLocation modelresourcelocation = (ModelResourceLocation)p_209598_1_;
                if (Objects.equals(modelresourcelocation.func_177518_c(), "inventory")) {
                    ResourceLocation resourcelocation2 = new ResourceLocation(p_209598_1_.func_110624_b(), "item/" + p_209598_1_.func_110623_a());
                    ModelBlock modelblock = this.func_177594_c(resourcelocation2);
                    this.func_209593_a(modelresourcelocation, modelblock);
                    this.field_209608_D.put(resourcelocation2, modelblock);
                    return;
                }
                ResourceLocation resourcelocation = new ResourceLocation(p_209598_1_.func_110624_b(), p_209598_1_.func_110623_a());
                StateContainer statecontainer = Optional.ofNullable(field_209607_C.get(resourcelocation)).orElseGet(() -> IRegistry.field_212618_g.func_82594_a(resourcelocation).func_176194_O());
                this.field_209610_F.func_209573_a((StateContainer<Block, IBlockState>)statecontainer);
                ImmutableList immutablelist = statecontainer.func_177619_a();
                map = Maps.newHashMap();
                immutablelist.forEach(p_209587_2_ -> {
                    IBlockState iblockstate = map.put(BlockModelShapes.func_209553_a((ResourceLocation)resourcelocation, (IBlockState)p_209587_2_), p_209587_2_);
                });
                map1 = Maps.newHashMap();
                ResourceLocation resourcelocation1 = new ResourceLocation(p_209598_1_.func_110624_b(), "blockstates/" + p_209598_1_.func_110623_a() + ".json");
                flag = false;
                try {
                    List lvt_9_4_;
                    try {
                        flag = true;
                        lvt_9_4_ = this.field_177598_f.func_199004_b(resourcelocation1).stream().map(p_209591_1_ -> {
                            try (InputStream inputstream = p_209591_1_.func_199027_b();){
                                Pair pair = Pair.of((Object)p_209591_1_.func_199026_d(), (Object)ModelBlockDefinition.fromJson(this.field_209610_F, new InputStreamReader(inputstream, StandardCharsets.UTF_8), p_209598_1_));
                                return pair;
                            }
                            catch (Exception exception1) {
                                throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", p_209591_1_.func_199029_a(), p_209591_1_.func_199026_d(), exception1.getMessage()));
                            }
                        }).collect(Collectors.toList());
                    }
                    catch (IOException ioexception) {
                        field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)resourcelocation1, (Object)ioexception);
                        flag = false;
                        break block18;
                    }
                    for (Pair pair : lvt_9_4_) {
                        Multipart iunbakedmodel;
                        ModelBlockDefinition modelblockdefinition = (ModelBlockDefinition)pair.getSecond();
                        IdentityHashMap map2 = Maps.newIdentityHashMap();
                        if (modelblockdefinition.func_188002_b()) {
                            iunbakedmodel = modelblockdefinition.func_188001_c();
                            immutablelist.forEach(p_209603_2_ -> {
                                IUnbakedModel iunbakedmodel1 = map2.put(p_209603_2_, iunbakedmodel);
                            });
                        } else {
                            iunbakedmodel = null;
                        }
                        modelblockdefinition.func_209578_a().forEach((p_209589_8_, p_209589_9_) -> {
                            try {
                                immutablelist.stream().filter(ModelBakery.func_209605_a((StateContainer<Block, IBlockState>)statecontainer, p_209589_8_)).forEach(p_209590_5_ -> {
                                    IUnbakedModel iunbakedmodel1 = map2.put(p_209590_5_, p_209589_9_);
                                    if (iunbakedmodel1 != null && iunbakedmodel1 != iunbakedmodel) {
                                        map2.put(p_209590_5_, this.field_209608_D.get((Object)field_177604_a));
                                        throw new RuntimeException("Overlapping definition with: " + (String)modelblockdefinition.func_209578_a().entrySet().stream().filter(p_209604_1_ -> p_209604_1_.getValue() == iunbakedmodel1).findFirst().get().getKey());
                                    }
                                });
                            }
                            catch (Exception exception1) {
                                field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)resourcelocation1, pair.getFirst(), p_209589_8_, (Object)exception1.getMessage());
                            }
                        });
                        map1.putAll(map2);
                    }
                    flag = false;
                    if (!flag) break block19;
                }
                catch (BlockStateDefinitionException modelbakery$blockstatedefinitionexception) {
                    try {
                        throw modelbakery$blockstatedefinitionexception;
                        catch (Exception exception) {
                            throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", resourcelocation1, exception));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!flag) throw throwable;
                        Iterator iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            this.func_209593_a((ResourceLocation)entry.getKey(), map1.getOrDefault(entry.getValue(), this.field_209608_D.get((Object)field_177604_a)));
                        }
                        throw throwable;
                    }
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.func_209593_a((ResourceLocation)entry.getKey(), map1.getOrDefault(entry.getValue(), this.field_209608_D.get((Object)field_177604_a)));
                }
                break block19;
            }
            if (flag) {
                for (Map.Entry entry : map.entrySet()) {
                    this.func_209593_a((ResourceLocation)entry.getKey(), map1.getOrDefault(entry.getValue(), this.field_209608_D.get((Object)field_177604_a)));
                }
            }
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                this.func_209593_a((ResourceLocation)entry2.getKey(), map1.getOrDefault(entry2.getValue(), this.field_209608_D.get((Object)field_177604_a)));
            }
            return;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry1 = iterator.next();
            this.func_209593_a((ResourceLocation)entry1.getKey(), map1.getOrDefault(entry1.getValue(), this.field_209608_D.get((Object)field_177604_a)));
        }
    }

    private void func_209593_a(ResourceLocation p_209593_1_, IUnbakedModel p_209593_2_) {
        this.field_209608_D.put(p_209593_1_, p_209593_2_);
        this.field_209609_E.addAll(p_209593_2_.func_187965_e());
    }

    private void func_209594_a(Map<ModelResourceLocation, IUnbakedModel> p_209594_1_, ModelResourceLocation p_209594_2_) {
        p_209594_1_.put(p_209594_2_, this.func_209597_a(p_209594_2_));
    }

    public Map<ModelResourceLocation, IBakedModel> func_177570_a() {
        HashMap map = Maps.newHashMap();
        try {
            this.field_209608_D.put(field_177604_a, this.func_177594_c(field_177604_a));
            this.func_209594_a(map, field_177604_a);
        }
        catch (IOException ioexception) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)ioexception);
            throw new RuntimeException(ioexception);
        }
        field_209607_C.forEach((p_209602_2_, p_209602_3_) -> p_209602_3_.func_177619_a().forEach(p_209601_3_ -> this.func_209594_a(map, BlockModelShapes.func_209553_a((ResourceLocation)p_209602_2_, (IBlockState)p_209601_3_))));
        Iterator<Block> ioexception = IRegistry.field_212618_g.iterator();
        while (ioexception.hasNext()) {
            Block block = ioexception.next();
            block.func_176194_O().func_177619_a().forEach(p_209600_2_ -> this.func_209594_a(map, BlockModelShapes.func_209554_c((IBlockState)p_209600_2_)));
        }
        for (ResourceLocation resourcelocation : IRegistry.field_212630_s.func_148742_b()) {
            this.func_209594_a(map, new ModelResourceLocation(resourcelocation, "inventory"));
        }
        this.func_209594_a(map, new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        LinkedHashSet set = Sets.newLinkedHashSet();
        Set<ResourceLocation> set1 = map.values().stream().flatMap(p_209595_2_ -> p_209595_2_.func_209559_a(this::func_209597_a, set).stream()).collect(Collectors.toSet());
        set1.addAll(field_177602_b);
        set.forEach(p_209588_0_ -> field_177603_c.warn("Unable to resolve texture reference: {}", p_209588_0_));
        this.field_177609_j.func_195426_a(this.field_177598_f, set1);
        map.forEach((p_209599_1_, p_209599_2_) -> {
            IBakedModel ibakedmodel = null;
            try {
                ibakedmodel = p_209599_2_.func_209558_a(this::func_209597_a, this.field_177609_j::func_195424_a, ModelRotation.X0_Y0, false);
            }
            catch (Exception exception) {
                field_177603_c.warn("Unable to bake model: '{}': {}", (Object)p_209599_1_, (Object)exception);
            }
            if (ibakedmodel != null) {
                this.field_177605_n.put((ModelResourceLocation)((Object)p_209599_1_), ibakedmodel);
            }
        });
        return this.field_177605_n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelBlock func_177594_c(ResourceLocation location) throws IOException {
        ModelBlock lvt_5_2_;
        IResource iresource;
        Reader reader;
        block8: {
            ModelBlock modelblock1;
            String s;
            block9: {
                ModelBlock lvt_5_2_2;
                reader = null;
                iresource = null;
                s = location.func_110623_a();
                if ("builtin/generated".equals(s)) break block8;
                if (!"builtin/entity".equals(s)) break block9;
                ModelBlock modelBlock = lvt_5_2_2 = field_177616_r;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(iresource);
                return modelBlock;
            }
            if (s.startsWith("builtin/")) {
                String s2 = s.substring("builtin/".length());
                String s1 = field_177600_d.get(s2);
                if (s1 == null) {
                    throw new FileNotFoundException(location.toString());
                }
                reader = new StringReader(s1);
            } else {
                iresource = this.field_177598_f.func_199002_a(new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json"));
                reader = new InputStreamReader(iresource.func_199027_b(), StandardCharsets.UTF_8);
            }
            ModelBlock lvt_5_2_3 = ModelBlock.func_178307_a(reader);
            lvt_5_2_3.field_178317_b = location.toString();
            ModelBlock modelBlock = modelblock1 = lvt_5_2_3;
            IOUtils.closeQuietly((Reader)reader);
            IOUtils.closeQuietly((Closeable)iresource);
            return modelBlock;
        }
        try {
            lvt_5_2_ = field_177606_o;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
        }
        return lvt_5_2_;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String message) {
            super(message);
        }
    }
}

