/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public abstract class EntityHanging
extends Entity {
    protected static final Predicate<Entity> field_184524_c = p_210144_0_ -> p_210144_0_ instanceof EntityHanging;
    private int field_70520_f;
    protected BlockPos field_174861_a;
    @Nullable
    public EnumFacing field_174860_b;

    protected EntityHanging(EntityType<?> type, World p_i48561_2_) {
        super(type, p_i48561_2_);
        this.func_70105_a(0.5f, 0.5f);
    }

    protected EntityHanging(EntityType<?> type, World p_i48562_2_, BlockPos p_i48562_3_) {
        this(type, p_i48562_2_);
        this.field_174861_a = p_i48562_3_;
    }

    @Override
    protected void func_70088_a() {
    }

    protected void func_174859_a(EnumFacing facingDirectionIn) {
        Validate.notNull((Object)((Object)facingDirectionIn));
        Validate.isTrue((boolean)facingDirectionIn.func_176740_k().func_176722_c());
        this.field_174860_b = facingDirectionIn;
        this.field_70126_B = this.field_70177_z = (float)(this.field_174860_b.func_176736_b() * 90);
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double d0 = (double)this.field_174861_a.func_177958_n() + 0.5;
            double d1 = (double)this.field_174861_a.func_177956_o() + 0.5;
            double d2 = (double)this.field_174861_a.func_177952_p() + 0.5;
            double d3 = 0.46875;
            double d4 = this.func_190202_a(this.func_82329_d());
            double d5 = this.func_190202_a(this.func_82330_g());
            d0 -= (double)this.field_174860_b.func_82601_c() * 0.46875;
            d2 -= (double)this.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing enumfacing = this.field_174860_b.func_176735_f();
            this.field_70165_t = d0 += d4 * (double)enumfacing.func_82601_c();
            this.field_70163_u = d1 += d5;
            this.field_70161_v = d2 += d4 * (double)enumfacing.func_82599_e();
            double d6 = this.func_82329_d();
            double d7 = this.func_82330_g();
            double d8 = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                d8 = 1.0;
            } else {
                d6 = 1.0;
            }
            this.func_174826_a(new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8));
        }
    }

    private double func_190202_a(int p_190202_1_) {
        return p_190202_1_ % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70520_f++ == 100 && !this.field_70170_p.field_72995_K) {
            this.field_70520_f = 0;
            if (!this.field_70128_L && !this.func_70518_d()) {
                this.func_70106_y();
                this.func_110128_b(null);
            }
        }
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_195586_b(this, this.func_174813_aQ())) {
            return false;
        }
        int i = Math.max(1, this.func_82329_d() / 16);
        int j = Math.max(1, this.func_82330_g() / 16);
        BlockPos blockpos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        EnumFacing enumfacing = this.field_174860_b.func_176735_f();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k = 0; k < i; ++k) {
            for (int l = 0; l < j; ++l) {
                int i1 = (i - 1) / -2;
                int j1 = (j - 1) / -2;
                blockpos$mutableblockpos.func_189533_g((Vec3i)blockpos).func_189534_c(enumfacing, k + i1).func_189534_c(EnumFacing.UP, l + j1);
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (iblockstate.func_193401_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutableblockpos, this.field_174860_b) == BlockFaceShape.SOLID || iblockstate.func_185904_a().func_76220_a() || BlockRedstoneDiode.func_185546_B(iblockstate)) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof EntityPlayer ? this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entityIn)), 0.0f) : false;
    }

    @Override
    public EnumFacing func_174811_aO() {
        return this.field_174860_b;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.func_110128_b(source.func_76346_g());
        }
        return true;
    }

    @Override
    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.func_110128_b(null);
        }
    }

    @Override
    public void func_70024_g(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.func_110128_b(null);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74774_a("Facing", (byte)this.field_174860_b.func_176736_b());
        BlockPos blockpos = this.func_174857_n();
        compound.func_74768_a("TileX", blockpos.func_177958_n());
        compound.func_74768_a("TileY", blockpos.func_177956_o());
        compound.func_74768_a("TileZ", blockpos.func_177952_p());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_174861_a = new BlockPos(compound.func_74762_e("TileX"), compound.func_74762_e("TileY"), compound.func_74762_e("TileZ"));
        this.func_174859_a(EnumFacing.func_176731_b(compound.func_74771_c("Facing")));
    }

    public abstract int func_82329_d();

    public abstract int func_82330_g();

    public abstract void func_110128_b(@Nullable Entity var1);

    public abstract void func_184523_o();

    @Override
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)((float)this.field_174860_b.func_82601_c() * 0.15f), this.field_70163_u + (double)offsetY, this.field_70161_v + (double)((float)this.field_174860_b.func_82599_e() * 0.15f), stack);
        entityitem.func_174869_p();
        this.field_70170_p.func_72838_d(entityitem);
        return entityitem;
    }

    @Override
    protected boolean func_142008_O() {
        return false;
    }

    @Override
    public void func_70107_b(double x, double y, double z) {
        this.field_174861_a = new BlockPos(x, y, z);
        this.func_174856_o();
        this.field_70160_al = true;
    }

    public BlockPos func_174857_n() {
        return this.field_174861_a;
    }

    @Override
    public float func_184229_a(Rotation transformRotation) {
        if (this.field_174860_b != null && this.field_174860_b.func_176740_k() != EnumFacing.Axis.Y) {
            switch (transformRotation) {
                case CLOCKWISE_180: {
                    this.field_174860_b = this.field_174860_b.func_176734_d();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176735_f();
                    break;
                }
                case CLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176746_e();
                }
            }
        }
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (transformRotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    @Override
    public float func_184217_a(Mirror transformMirror) {
        return this.func_184229_a(transformMirror.func_185800_a(this.field_174860_b));
    }

    @Override
    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }
}

