/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityArmorStand
extends EntityLivingBase {
    private static final Rotations field_175435_a = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175433_b = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175434_c = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations field_175431_d = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations field_175432_e = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations field_175429_f = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Byte> field_184801_a = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187191_a);
    public static final DataParameter<Rotations> field_184802_b = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184803_c = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184804_d = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184805_e = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184806_f = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184807_g = EntityDataManager.func_187226_a(EntityArmorStand.class, DataSerializers.field_187199_i);
    private static final Predicate<Entity> field_184798_bv = p_200617_0_ -> p_200617_0_ instanceof EntityMinecart && ((EntityMinecart)((Object)p_200617_0_)).canBeRidden();
    private final NonNullList<ItemStack> field_184799_bw = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    private final NonNullList<ItemStack> field_184800_bx = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    private boolean field_175436_h;
    public long field_175437_i;
    private int field_175442_bg;
    private boolean field_181028_bj;
    private Rotations field_175443_bh = field_175435_a;
    private Rotations field_175444_bi = field_175433_b;
    private Rotations field_175438_bj = field_175434_c;
    private Rotations field_175439_bk = field_175431_d;
    private Rotations field_175440_bl = field_175432_e;
    private Rotations field_175441_bm = field_175429_f;

    public EntityArmorStand(World worldIn) {
        super(EntityType.field_200789_c, worldIn);
        this.field_70145_X = this.func_189652_ae();
        this.func_70105_a(0.5f, 1.975f);
        this.field_70138_W = 0.0f;
    }

    public EntityArmorStand(World worldIn, double posX, double posY, double posZ) {
        this(worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    @Override
    protected final void func_70105_a(float width, float height) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        float f = this.func_181026_s() ? 0.0f : (this.func_70631_g_() ? 0.5f : 1.0f);
        super.func_70105_a(width * f, height * f);
        this.func_70107_b(d0, d1, d2);
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && !this.func_189652_ae();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184801_a, (byte)0);
        this.field_70180_af.func_187214_a(field_184802_b, field_175435_a);
        this.field_70180_af.func_187214_a(field_184803_c, field_175433_b);
        this.field_70180_af.func_187214_a(field_184804_d, field_175434_c);
        this.field_70180_af.func_187214_a(field_184805_e, field_175431_d);
        this.field_70180_af.func_187214_a(field_184806_f, field_175432_e);
        this.field_70180_af.func_187214_a(field_184807_g, field_175429_f);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184799_bw;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184800_bx;
    }

    @Override
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)((Object)this.field_184799_bw.get(slotIn.func_188454_b()));
            }
            case ARMOR: {
                return (ItemStack)((Object)this.field_184800_bx.get(slotIn.func_188454_b()));
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.field_184799_bw.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.field_184800_bx.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        EntityEquipmentSlot entityequipmentslot;
        if (inventorySlot == 98) {
            entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        } else if (inventorySlot == 99) {
            entityequipmentslot = EntityEquipmentSlot.OFFHAND;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.HEAD.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.CHEST.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (inventorySlot == 100 + EntityEquipmentSlot.LEGS.func_188454_b()) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else {
            if (inventorySlot != 100 + EntityEquipmentSlot.FEET.func_188454_b()) {
                return false;
            }
            entityequipmentslot = EntityEquipmentSlot.FEET;
        }
        if (!itemStackIn.func_190926_b() && !EntityLiving.func_184648_b(entityequipmentslot, itemStackIn) && entityequipmentslot != EntityEquipmentSlot.HEAD) {
            return false;
        }
        this.func_184201_a(entityequipmentslot, itemStackIn);
        return true;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (ItemStack itemstack : this.field_184800_bx) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(nbttagcompound);
            }
            nbttaglist.add((INBTBase)nbttagcompound);
        }
        compound.func_74782_a("ArmorItems", (INBTBase)nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (ItemStack itemstack1 : this.field_184799_bw) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_77955_b(nbttagcompound1);
            }
            nbttaglist1.add((INBTBase)nbttagcompound1);
        }
        compound.func_74782_a("HandItems", (INBTBase)nbttaglist1);
        compound.func_74757_a("Invisible", this.func_82150_aj());
        compound.func_74757_a("Small", this.func_175410_n());
        compound.func_74757_a("ShowArms", this.func_175402_q());
        compound.func_74768_a("DisabledSlots", this.field_175442_bg);
        compound.func_74757_a("NoBasePlate", this.func_175414_r());
        if (this.func_181026_s()) {
            compound.func_74757_a("Marker", this.func_181026_s());
        }
        compound.func_74782_a("Pose", this.func_175419_y());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItems", 9)) {
            NBTTagList nbttaglist = compound.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.field_184800_bx.size(); ++i) {
                this.field_184800_bx.set(i, (Object)ItemStack.func_199557_a(nbttaglist.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            NBTTagList nbttaglist1 = compound.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.field_184799_bw.size(); ++j) {
                this.field_184799_bw.set(j, (Object)ItemStack.func_199557_a(nbttaglist1.func_150305_b(j)));
            }
        }
        this.func_82142_c(compound.func_74767_n("Invisible"));
        this.func_175420_a(compound.func_74767_n("Small"));
        this.func_175413_k(compound.func_74767_n("ShowArms"));
        this.field_175442_bg = compound.func_74762_e("DisabledSlots");
        this.func_175426_l(compound.func_74767_n("NoBasePlate"));
        this.func_181027_m(compound.func_74767_n("Marker"));
        this.field_181028_bj = !this.func_181026_s();
        this.field_70145_X = this.func_189652_ae();
        NBTTagCompound nbttagcompound = compound.func_74775_l("Pose");
        this.func_175416_h(nbttagcompound);
    }

    private void func_175416_h(NBTTagCompound tagCompound) {
        NBTTagList nbttaglist = tagCompound.func_150295_c("Head", 5);
        this.func_175415_a(nbttaglist.isEmpty() ? field_175435_a : new Rotations(nbttaglist));
        NBTTagList nbttaglist1 = tagCompound.func_150295_c("Body", 5);
        this.func_175424_b(nbttaglist1.isEmpty() ? field_175433_b : new Rotations(nbttaglist1));
        NBTTagList nbttaglist2 = tagCompound.func_150295_c("LeftArm", 5);
        this.func_175405_c(nbttaglist2.isEmpty() ? field_175434_c : new Rotations(nbttaglist2));
        NBTTagList nbttaglist3 = tagCompound.func_150295_c("RightArm", 5);
        this.func_175428_d(nbttaglist3.isEmpty() ? field_175431_d : new Rotations(nbttaglist3));
        NBTTagList nbttaglist4 = tagCompound.func_150295_c("LeftLeg", 5);
        this.func_175417_e(nbttaglist4.isEmpty() ? field_175432_e : new Rotations(nbttaglist4));
        NBTTagList nbttaglist5 = tagCompound.func_150295_c("RightLeg", 5);
        this.func_175427_f(nbttaglist5.isEmpty() ? field_175429_f : new Rotations(nbttaglist5));
    }

    private NBTTagCompound func_175419_y() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!field_175435_a.equals((Object)this.field_175443_bh)) {
            nbttagcompound.func_74782_a("Head", (INBTBase)this.field_175443_bh.func_179414_a());
        }
        if (!field_175433_b.equals((Object)this.field_175444_bi)) {
            nbttagcompound.func_74782_a("Body", (INBTBase)this.field_175444_bi.func_179414_a());
        }
        if (!field_175434_c.equals((Object)this.field_175438_bj)) {
            nbttagcompound.func_74782_a("LeftArm", (INBTBase)this.field_175438_bj.func_179414_a());
        }
        if (!field_175431_d.equals((Object)this.field_175439_bk)) {
            nbttagcompound.func_74782_a("RightArm", (INBTBase)this.field_175439_bk.func_179414_a());
        }
        if (!field_175432_e.equals((Object)this.field_175440_bl)) {
            nbttagcompound.func_74782_a("LeftLeg", (INBTBase)this.field_175440_bl.func_179414_a());
        }
        if (!field_175429_f.equals((Object)this.field_175441_bm)) {
            nbttagcompound.func_74782_a("RightLeg", (INBTBase)this.field_175441_bm.func_179414_a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity entityIn) {
    }

    @Override
    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184798_bv);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f(this);
        }
    }

    @Override
    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_181026_s() && itemstack.func_77973_b() != Items.field_151057_cb) {
            if (!this.field_70170_p.field_72995_K && !player.func_175149_v()) {
                EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d(itemstack);
                if (itemstack.func_190926_b()) {
                    EntityEquipmentSlot entityequipmentslot2;
                    EntityEquipmentSlot entityequipmentslot1 = this.func_190772_a(vec);
                    EntityEquipmentSlot entityEquipmentSlot = entityequipmentslot2 = this.func_184796_b(entityequipmentslot1) ? entityequipmentslot : entityequipmentslot1;
                    if (this.func_190630_a(entityequipmentslot2)) {
                        this.func_184795_a(player, entityequipmentslot2, itemstack, hand);
                    }
                } else {
                    if (this.func_184796_b(entityequipmentslot)) {
                        return EnumActionResult.FAIL;
                    }
                    if (entityequipmentslot.func_188453_a() == EntityEquipmentSlot.Type.HAND && !this.func_175402_q()) {
                        return EnumActionResult.FAIL;
                    }
                    this.func_184795_a(player, entityequipmentslot, itemstack, hand);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EntityEquipmentSlot func_190772_a(Vec3d p_190772_1_) {
        EntityEquipmentSlot entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        boolean flag = this.func_175410_n();
        double d0 = flag ? p_190772_1_.field_72448_b * 2.0 : p_190772_1_.field_72448_b;
        EntityEquipmentSlot entityequipmentslot1 = EntityEquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.func_190630_a(entityequipmentslot1)) {
                return EntityEquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.func_190630_a(EntityEquipmentSlot.CHEST)) {
                return EntityEquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.func_190630_a(EntityEquipmentSlot.LEGS)) {
                return EntityEquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.func_190630_a(EntityEquipmentSlot.HEAD)) {
            return EntityEquipmentSlot.HEAD;
        }
        if (this.func_190630_a(EntityEquipmentSlot.MAINHAND)) return entityequipmentslot;
        if (!this.func_190630_a(EntityEquipmentSlot.OFFHAND)) return entityequipmentslot;
        return EntityEquipmentSlot.OFFHAND;
    }

    public boolean func_184796_b(EntityEquipmentSlot slotIn) {
        return (this.field_175442_bg & 1 << slotIn.func_188452_c()) != 0 || slotIn.func_188453_a() == EntityEquipmentSlot.Type.HAND && !this.func_175402_q();
    }

    private void func_184795_a(EntityPlayer player, EntityEquipmentSlot p_184795_2_, ItemStack p_184795_3_, EnumHand hand) {
        ItemStack itemstack = this.func_184582_a(p_184795_2_);
        if (!(!itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_184795_2_.func_188452_c() + 8) != 0 || itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_184795_2_.func_188452_c() + 16) != 0)) {
            if (player.field_71075_bZ.field_75098_d && itemstack.func_190926_b() && !p_184795_3_.func_190926_b()) {
                ItemStack itemstack2 = p_184795_3_.func_77946_l();
                itemstack2.func_190920_e(1);
                this.func_184201_a(p_184795_2_, itemstack2);
            } else if (!p_184795_3_.func_190926_b() && p_184795_3_.func_190916_E() > 1) {
                if (itemstack.func_190926_b()) {
                    ItemStack itemstack1 = p_184795_3_.func_77946_l();
                    itemstack1.func_190920_e(1);
                    this.func_184201_a(p_184795_2_, itemstack1);
                    p_184795_3_.func_190918_g(1);
                }
            } else {
                this.func_184201_a(p_184795_2_, p_184795_3_);
                player.func_184611_a(hand, itemstack);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(source)) {
                this.func_70106_y();
                return false;
            }
            if (!(this.func_180431_b(source) || this.field_175436_h || this.func_181026_s())) {
                if (source.func_94541_c()) {
                    this.func_175409_C();
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(source)) {
                    if (this.func_70027_ad()) {
                        this.func_175406_a(0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
                    this.func_175406_a(4.0f);
                    return false;
                }
                boolean flag = source.func_76364_f() instanceof EntityArrow;
                boolean flag1 = "player".equals(source.func_76355_l());
                if (!flag1 && !flag) {
                    return false;
                }
                if (source.func_76346_g() instanceof EntityPlayer && !((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (source.func_180136_u()) {
                    this.func_190773_I();
                    this.func_175412_z();
                    this.func_70106_y();
                    return false;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.field_175437_i > 5L && !flag) {
                    this.field_70170_p.func_72960_a(this, (byte)32);
                    this.field_175437_i = i;
                } else {
                    this.func_175421_A();
                    this.func_175412_z();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.field_175437_i = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void func_175412_z() {
        if (this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_195598_a(new BlockParticleData(Particles.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 1.5, this.field_70161_v, 10, this.field_70130_N / 4.0f, this.field_70131_O / 4.0f, this.field_70130_N / 4.0f, 0.05);
        }
    }

    private void func_175406_a(float damage) {
        float f = this.func_110143_aJ();
        if ((f -= damage) <= 0.5f) {
            this.func_175409_C();
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void func_175421_A() {
        Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this), new ItemStack(Items.field_179565_cj));
        this.func_175409_C();
    }

    private void func_175409_C() {
        this.func_190773_I();
        for (int i = 0; i < this.field_184799_bw.size(); ++i) {
            ItemStack itemstack = (ItemStack)((Object)this.field_184799_bw.get(i));
            if (itemstack.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this).func_177984_a(), itemstack);
            this.field_184799_bw.set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.field_184800_bx.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)((Object)this.field_184800_bx.get(j));
            if (itemstack1.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this).func_177984_a(), itemstack1);
            this.field_184800_bx.set(j, (Object)ItemStack.field_190927_a);
        }
    }

    private void func_190773_I() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    @Override
    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    @Override
    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O * 0.5f : this.field_70131_O * 0.9f;
    }

    @Override
    public double func_70033_W() {
        return this.func_181026_s() ? 0.0 : (double)0.1f;
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.func_189652_ae()) {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public void func_181013_g(float offset) {
        this.field_70760_ar = this.field_70126_B = offset;
        this.field_70758_at = this.field_70759_as = offset;
    }

    @Override
    public void func_70034_d(float rotation) {
        this.field_70760_ar = this.field_70126_B = rotation;
        this.field_70758_at = this.field_70759_as = rotation;
    }

    @Override
    public void func_70071_h_() {
        boolean flag;
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.func_70071_h_();
        Rotations rotations = this.field_70180_af.func_187225_a(field_184802_b);
        if (!this.field_175443_bh.equals((Object)rotations)) {
            this.func_175415_a(rotations);
        }
        if (!this.field_175444_bi.equals((Object)(rotations1 = this.field_70180_af.func_187225_a(field_184803_c)))) {
            this.func_175424_b(rotations1);
        }
        if (!this.field_175438_bj.equals((Object)(rotations2 = this.field_70180_af.func_187225_a(field_184804_d)))) {
            this.func_175405_c(rotations2);
        }
        if (!this.field_175439_bk.equals((Object)(rotations3 = this.field_70180_af.func_187225_a(field_184805_e)))) {
            this.func_175428_d(rotations3);
        }
        if (!this.field_175440_bl.equals((Object)(rotations4 = this.field_70180_af.func_187225_a(field_184806_f)))) {
            this.func_175417_e(rotations4);
        }
        if (!this.field_175441_bm.equals((Object)(rotations5 = this.field_70180_af.func_187225_a(field_184807_g)))) {
            this.func_175427_f(rotations5);
        }
        if (this.field_181028_bj != (flag = this.func_181026_s())) {
            this.func_181550_a(flag);
            this.field_70156_m = !flag;
            this.field_181028_bj = flag;
        }
    }

    private void func_181550_a(boolean p_181550_1_) {
        if (p_181550_1_) {
            this.func_70105_a(0.0f, 0.0f);
        } else {
            this.func_70105_a(0.5f, 1.975f);
        }
    }

    @Override
    protected void func_175135_B() {
        this.func_82142_c(this.field_175436_h);
    }

    @Override
    public void func_82142_c(boolean invisible) {
        this.field_175436_h = invisible;
        super.func_82142_c(invisible);
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_175410_n();
    }

    @Override
    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    @Override
    public EnumPushReaction func_184192_z() {
        return this.func_181026_s() ? EnumPushReaction.IGNORE : super.func_184192_z();
    }

    private void func_175420_a(boolean small) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 1, small));
        this.func_70105_a(0.5f, 1.975f);
    }

    public boolean func_175410_n() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 1) != 0;
    }

    private void func_175413_k(boolean showArms) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 4, showArms));
    }

    public boolean func_175402_q() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 4) != 0;
    }

    private void func_175426_l(boolean noBasePlate) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 8, noBasePlate));
    }

    public boolean func_175414_r() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 8) != 0;
    }

    private void func_181027_m(boolean marker) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 16, marker));
        this.func_70105_a(0.5f, 1.975f);
    }

    public boolean func_181026_s() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 0x10) != 0;
    }

    private byte func_184797_a(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void func_175415_a(Rotations vec) {
        this.field_175443_bh = vec;
        this.field_70180_af.func_187227_b(field_184802_b, vec);
    }

    public void func_175424_b(Rotations vec) {
        this.field_175444_bi = vec;
        this.field_70180_af.func_187227_b(field_184803_c, vec);
    }

    public void func_175405_c(Rotations vec) {
        this.field_175438_bj = vec;
        this.field_70180_af.func_187227_b(field_184804_d, vec);
    }

    public void func_175428_d(Rotations vec) {
        this.field_175439_bk = vec;
        this.field_70180_af.func_187227_b(field_184805_e, vec);
    }

    public void func_175417_e(Rotations vec) {
        this.field_175440_bl = vec;
        this.field_70180_af.func_187227_b(field_184806_f, vec);
    }

    public void func_175427_f(Rotations vec) {
        this.field_175441_bm = vec;
        this.field_70180_af.func_187227_b(field_184807_g, vec);
    }

    public Rotations func_175418_s() {
        return this.field_175443_bh;
    }

    public Rotations func_175408_t() {
        return this.field_175444_bi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175404_u() {
        return this.field_175438_bj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175411_v() {
        return this.field_175439_bk;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175403_w() {
        return this.field_175440_bl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175407_x() {
        return this.field_175441_bm;
    }

    @Override
    public boolean func_70067_L() {
        return super.func_70067_L() && !this.func_181026_s();
    }

    @Override
    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    @Override
    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187704_k;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187707_l;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    @Override
    public void func_70077_a(EntityLightningBolt lightningBolt) {
    }

    @Override
    public boolean func_184603_cC() {
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184801_a.equals(key)) {
            this.func_70105_a(0.5f, 1.975f);
        }
        super.func_184206_a(key);
    }

    @Override
    public boolean func_190631_cK() {
        return false;
    }
}

