/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityFallingBlock
extends Entity {
    private IBlockState field_175132_d = Blocks.field_150354_m.func_176223_P();
    public int field_145812_b;
    public boolean field_145813_c = true;
    private boolean field_145808_f;
    private boolean field_145809_g;
    private int field_145815_h = 40;
    private float field_145816_i = 2.0f;
    public NBTTagCompound field_145810_d;
    protected static final DataParameter<BlockPos> field_184532_d = EntityDataManager.func_187226_a(EntityFallingBlock.class, DataSerializers.field_187200_j);

    public EntityFallingBlock(World worldIn) {
        super(EntityType.field_200809_w, worldIn);
    }

    public EntityFallingBlock(World worldIn, double x, double y, double z, IBlockState fallingBlockState) {
        this(worldIn);
        this.field_175132_d = fallingBlockState;
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(x, y + (double)((1.0f - this.field_70131_O) / 2.0f), z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
        this.func_184530_a(new BlockPos((Entity)this));
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    public void func_184530_a(BlockPos p_184530_1_) {
        this.field_70180_af.func_187227_b(field_184532_d, p_184530_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockPos func_184531_j() {
        return this.field_70180_af.func_187225_a(field_184532_d);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184532_d, BlockPos.field_177992_a);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_175132_d.func_196958_f()) {
            this.func_70106_y();
        } else {
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            Block block = this.field_175132_d.func_177230_c();
            if (this.field_145812_b++ == 0) {
                BlockPos blockpos = new BlockPos((Entity)this);
                if (this.field_70170_p.func_180495_p(blockpos).func_177230_c() == block) {
                    this.field_70170_p.func_175698_g(blockpos);
                } else if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                    return;
                }
            }
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.04f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (!this.field_70170_p.field_72995_K) {
                RayTraceResult raytraceresult;
                BlockPos blockpos1 = new BlockPos((Entity)this);
                boolean flag = this.field_175132_d.func_177230_c() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.field_70170_p.func_204610_c(blockpos1).func_206884_a(FluidTags.field_206959_a);
                double d0 = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
                if (flag && d0 > 1.0 && (raytraceresult = this.field_70170_p.func_200260_a(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), RayTraceFluidMode.SOURCE_ONLY)) != null && this.field_70170_p.func_204610_c(raytraceresult.func_178782_a()).func_206884_a(FluidTags.field_206959_a)) {
                    blockpos1 = raytraceresult.func_178782_a();
                    flag1 = true;
                }
                if (!this.field_70122_E && !flag1) {
                    if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockpos1.func_177956_o() < 1 || blockpos1.func_177956_o() > 256) || this.field_145812_b > 600) {
                        if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.func_199703_a(block);
                        }
                        this.func_70106_y();
                    }
                } else {
                    IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                    if (this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)) && !flag1 && BlockFalling.func_185759_i(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                        this.field_70122_E = false;
                        return;
                    }
                    this.field_70159_w *= (double)0.7f;
                    this.field_70179_y *= (double)0.7f;
                    this.field_70181_x *= -0.5;
                    if (iblockstate.func_177230_c() != Blocks.field_196603_bb) {
                        this.func_70106_y();
                        if (!this.field_145808_f) {
                            if (iblockstate.func_185904_a().func_76222_j() && (flag1 || !BlockFalling.func_185759_i(this.field_70170_p.func_180495_p(blockpos1.func_177977_b()))) && !ForgeEventFactory.onBlockPlace((Entity)this, (BlockSnapshot)new BlockSnapshot(this.func_130014_f_(), this.func_180425_c(), iblockstate), (EnumFacing)EnumFacing.UP) && this.field_70170_p.func_180501_a(blockpos1, this.field_175132_d, 3)) {
                                TileEntity tileentity;
                                if (block instanceof BlockFalling) {
                                    ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockpos1, this.field_175132_d, iblockstate);
                                }
                                if (this.field_145810_d != null && this.field_175132_d.hasTileEntity() && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                                    for (String s : this.field_145810_d.func_150296_c()) {
                                        INBTBase inbtbase = this.field_145810_d.func_74781_a(s);
                                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                                        nbttagcompound.func_74782_a(s, inbtbase.func_74737_b());
                                    }
                                    tileentity.func_145839_a(nbttagcompound);
                                    tileentity.func_70296_d();
                                }
                            } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                                this.func_199703_a(block);
                            }
                        } else if (block instanceof BlockFalling) {
                            ((BlockFalling)block).func_190974_b(this.field_70170_p, blockpos1);
                        }
                    }
                }
            }
            this.field_70159_w *= (double)0.98f;
            this.field_70181_x *= (double)0.98f;
            this.field_70179_y *= (double)0.98f;
        }
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        if (this.field_145809_g && (i = MathHelper.func_76123_f((float)(distance - 1.0f))) > 0) {
            ArrayList list = Lists.newArrayList((Iterable)this.field_70170_p.func_72839_b(this, this.func_174813_aQ()));
            boolean flag = this.field_175132_d.func_203425_a(BlockTags.field_200572_k);
            DamageSource damagesource = flag ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : list) {
                entity.func_70097_a(damagesource, Math.min(MathHelper.func_76141_d((float)((float)i * this.field_145816_i)), this.field_145815_h));
            }
            if (flag && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)i * 0.05) {
                IBlockState iblockstate = BlockAnvil.func_196433_f((IBlockState)this.field_175132_d);
                if (iblockstate == null) {
                    this.field_145808_f = true;
                } else {
                    this.field_175132_d = iblockstate;
                }
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("BlockState", NBTUtil.func_190009_a((IBlockState)this.field_175132_d));
        compound.func_74768_a("Time", this.field_145812_b);
        compound.func_74757_a("DropItem", this.field_145813_c);
        compound.func_74757_a("HurtEntities", this.field_145809_g);
        compound.func_74776_a("FallHurtAmount", this.field_145816_i);
        compound.func_74768_a("FallHurtMax", this.field_145815_h);
        if (this.field_145810_d != null) {
            compound.func_74782_a("TileEntityData", this.field_145810_d);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        this.field_175132_d = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("BlockState"));
        this.field_145812_b = compound.func_74762_e("Time");
        if (compound.func_150297_b("HurtEntities", 99)) {
            this.field_145809_g = compound.func_74767_n("HurtEntities");
            this.field_145816_i = compound.func_74760_g("FallHurtAmount");
            this.field_145815_h = compound.func_74762_e("FallHurtMax");
        } else if (this.field_175132_d.func_203425_a(BlockTags.field_200572_k)) {
            this.field_145809_g = true;
        }
        if (compound.func_150297_b("DropItem", 99)) {
            this.field_145813_c = compound.func_74767_n("DropItem");
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.field_145810_d = compound.func_74775_l("TileEntityData");
        }
        if (this.field_175132_d.func_196958_f()) {
            this.field_175132_d = Blocks.field_150354_m.func_176223_P();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public World func_145807_e() {
        return this.field_70170_p;
    }

    public void func_145806_a(boolean hurtEntitiesIn) {
        this.field_145809_g = hurtEntitiesIn;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void func_85029_a(CrashReportCategory category) {
        super.func_85029_a(category);
        category.func_71507_a("Immitating BlockState", this.field_175132_d.toString());
    }

    public IBlockState func_195054_l() {
        return this.field_175132_d;
    }

    @Override
    public boolean func_184213_bq() {
        return true;
    }
}

