/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIDefendVillage;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookAtVillager;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Fluids;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityIronGolem
extends EntityGolem {
    protected static final DataParameter<Byte> field_184750_a = EntityDataManager.func_187226_a(EntityIronGolem.class, DataSerializers.field_187191_a);
    private int field_70858_e;
    @Nullable
    private Village field_70857_d;
    private int field_70855_f;
    private int field_70856_g;

    public EntityIronGolem(World worldIn) {
        super(EntityType.field_200757_aw, worldIn);
        this.func_70105_a(1.4f, 2.7f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.9, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 0.6, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookAtVillager(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDefendVillage(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, p_210132_0_ -> p_210132_0_ != null && IMob.field_175450_e.test(p_210132_0_) && !(p_210132_0_ instanceof EntityCreeper)));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184750_a, (byte)0);
    }

    protected void func_70619_bc() {
        if (--this.field_70858_e <= 0) {
            this.field_70858_e = 70 + this.field_70146_Z.nextInt(50);
            this.field_70857_d = this.field_70170_p.func_175714_ae().func_176056_a(new BlockPos((Entity)((Object)this)), 32);
            if (this.field_70857_d == null) {
                this.func_110177_bN();
            } else {
                BlockPos blockpos = this.field_70857_d.func_180608_a();
                this.func_175449_a(blockpos, (int)((float)this.field_70857_d.func_75568_b() * 0.6f));
            }
        }
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    protected void func_82167_n(Entity entityIn) {
        if (entityIn instanceof IMob && !(entityIn instanceof EntityCreeper) && this.func_70681_au().nextInt(20) == 0) {
            this.func_70624_b((EntityLivingBase)entityIn);
        }
        super.func_82167_n(entityIn);
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        super.func_70636_d();
        if (this.field_70855_f > 0) {
            --this.field_70855_f;
        }
        if (this.field_70856_g > 0) {
            --this.field_70856_g;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_196958_f()) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(Particles.field_197611_d, iblockstate), this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (this.func_70850_q() && EntityPlayer.class.isAssignableFrom(cls)) {
            return false;
        }
        return cls == EntityCreeper.class ? false : super.func_70686_a(cls);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("PlayerCreated", this.func_70850_q());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70849_f(compound.func_74767_n("PlayerCreated"));
    }

    public boolean func_70652_k(Entity entityIn) {
        this.field_70855_f = 10;
        this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((Object)this)), 7 + this.field_70146_Z.nextInt(15));
        if (flag) {
            entityIn.field_70181_x += (double)0.4f;
            this.func_174815_a((EntityLivingBase)((Object)this), entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.field_70855_f = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (id == 11) {
            this.field_70856_g = 400;
        } else if (id == 34) {
            this.field_70856_g = 0;
        } else {
            super.func_70103_a(id);
        }
    }

    public Village func_70852_n() {
        return this.field_70857_d;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70854_o() {
        return this.field_70855_f;
    }

    public void func_70851_e(boolean p_70851_1_) {
        if (p_70851_1_) {
            this.field_70856_g = 400;
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)11);
        } else {
            this.field_70856_g = 0;
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)34);
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186443_y;
    }

    public int func_70853_p() {
        return this.field_70856_g;
    }

    public boolean func_70850_q() {
        return (this.field_70180_af.func_187225_a(field_184750_a) & 1) != 0;
    }

    public void func_70849_f(boolean playerCreated) {
        byte b0 = this.field_70180_af.func_187225_a(field_184750_a);
        if (playerCreated) {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(b0 | 1));
        } else {
            this.field_70180_af.func_187227_b(field_184750_a, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.func_70850_q() && this.field_70717_bb != null && this.field_70857_d != null) {
            this.field_70857_d.modifyPlayerReputation(this.field_70717_bb.func_146103_bH().getId(), -5);
        }
        super.func_70645_a(cause);
    }

    public boolean func_205019_a(IWorldReaderBase worldIn) {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        IBlockState iblockstate1 = worldIn.func_180495_p(blockpos.func_177977_b());
        IBlockState iblockstate2 = worldIn.func_180495_p(blockpos.func_177984_a());
        return iblockstate1.func_185896_q() && WorldEntitySpawner.func_206851_a(iblockstate2, iblockstate2.func_204520_s()) && WorldEntitySpawner.func_206851_a(iblockstate, Fluids.field_204541_a.func_207188_f()) && worldIn.func_195586_b((Entity)((Object)this), this.func_174813_aQ()) && worldIn.func_195587_c((Entity)((Object)this), this.func_174813_aQ());
    }
}

