/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBreakBlock;
import net.minecraft.entity.ai.EntityAIBreakDoor;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityDrowned;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;

public class EntityZombie
extends EntityMob {
    protected static final IAttribute field_110186_bp = new RangedAttribute((IAttribute)null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    private static final UUID field_110187_bq = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier field_110188_br = new AttributeModifier(field_110187_bq, "Baby speed boost", 0.5, 1);
    private static final DataParameter<Boolean> field_184737_bv = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184738_bw = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_184740_by = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_204709_bA = EntityDataManager.func_187226_a(EntityZombie.class, DataSerializers.field_187198_h);
    private final EntityAIBreakDoor field_146075_bs = new EntityAIBreakDoor((EntityLiving)((Object)this));
    private boolean field_146076_bu;
    private int field_204707_bD;
    private int field_204708_bE;
    private float field_146074_bv = -1.0f;
    private float field_146073_bw;

    public EntityZombie(EntityType<?> type, World p_i48549_2_) {
        super(type, p_i48549_2_);
        this.func_70105_a(0.6f, 1.95f);
    }

    public EntityZombie(World worldIn) {
        this(EntityType.field_200725_aD, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttackTurtleEgg(Blocks.field_203213_jA, (EntityCreature)this, 1.0, 3));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIZombieAttack(this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPigZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityTurtle.class, 10, true, false, EntityTurtle.field_203029_bx));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(field_110186_bp).func_111128_a(this.field_70146_Z.nextDouble() * (Double)ForgeConfig.SERVER.zombieBaseSummonChance.get());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184737_bv, false);
        this.func_184212_Q().func_187214_a(field_184738_bw, 0);
        this.func_184212_Q().func_187214_a(field_184740_by, false);
        this.func_184212_Q().func_187214_a(field_204709_bA, false);
    }

    public boolean func_204706_dD() {
        return this.func_184212_Q().func_187225_a(field_204709_bA);
    }

    public void func_184724_a(boolean swingingArms) {
        this.func_184212_Q().func_187227_b(field_184740_by, swingingArms);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_184734_db() {
        return this.func_184212_Q().func_187225_a(field_184740_by);
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean enabled) {
        if (this.func_204900_dz()) {
            if (this.field_146076_bu != enabled) {
                this.field_146076_bu = enabled;
                ((PathNavigateGround)this.func_70661_as()).func_179688_b(enabled);
                if (enabled) {
                    this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_146075_bs);
                } else {
                    this.field_70714_bg.func_85156_a((EntityAIBase)this.field_146075_bs);
                }
            }
        } else if (this.field_146076_bu) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.field_146075_bs);
            this.field_146076_bu = false;
        }
    }

    protected boolean func_204900_dz() {
        return true;
    }

    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_184737_bv);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(player);
    }

    public void func_82227_f(boolean childZombie) {
        this.func_184212_Q().func_187227_b(field_184737_bv, childZombie);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(field_110188_br);
            if (childZombie) {
                iattributeinstance.func_111121_a(field_110188_br);
            }
        }
        this.func_146071_k(childZombie);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (field_184737_bv.equals(key)) {
            this.func_146071_k(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    protected boolean func_204703_dA() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_204706_dD()) {
                --this.field_204708_bE;
                if (this.field_204708_bE < 0) {
                    this.func_207302_dI();
                }
            } else if (this.func_204703_dA()) {
                if (this.func_208600_a(FluidTags.field_206959_a)) {
                    ++this.field_204707_bD;
                    if (this.field_204707_bD >= 600) {
                        this.func_204704_a(300);
                    }
                } else {
                    this.field_204707_bD = -1;
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        boolean flag;
        boolean bl = flag = this.func_190730_o() && this.func_204609_dp();
        if (flag) {
            ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!itemstack.func_190926_b()) {
                if (itemstack.func_77984_f()) {
                    itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                    if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                        this.func_70669_a(itemstack);
                        this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.func_70015_d(8);
            }
        }
        super.func_70636_d();
    }

    private void func_204704_a(int p_204704_1_) {
        this.field_204708_bE = p_204704_1_;
        this.func_184212_Q().func_187227_b(field_204709_bA, true);
    }

    protected void func_207302_dI() {
        this.func_207305_a((EntityZombie)new EntityDrowned(this.field_70170_p));
        this.field_70170_p.func_180498_a(null, 1040, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
    }

    protected void func_207305_a(EntityZombie p_207305_1_) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            p_207305_1_.func_82149_j((Entity)((Object)this));
            p_207305_1_.func_207301_a(this.func_98052_bS(), this.func_146072_bX(), this.func_70631_g_(), this.func_175446_cd());
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (itemstack.func_190926_b()) continue;
                p_207305_1_.func_184201_a(entityequipmentslot, itemstack);
                p_207305_1_.func_184642_a(entityequipmentslot, this.func_205712_c(entityequipmentslot));
            }
            if (this.func_145818_k_()) {
                p_207305_1_.func_200203_b(this.func_200201_e());
                p_207305_1_.func_174805_g(this.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)((Object)p_207305_1_));
            this.func_70106_y();
        }
    }

    protected boolean func_190730_o() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            int k;
            int j;
            int i;
            ZombieEvent.SummonAidEvent event;
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
            if ((event = ForgeEventFactory.fireZombieSummonAid((EntityZombie)this, (World)this.field_70170_p, (int)(i = MathHelper.func_76128_c((double)this.field_70165_t)), (int)(j = MathHelper.func_76128_c((double)this.field_70163_u)), (int)(k = MathHelper.func_76128_c((double)this.field_70161_v)), (EntityLivingBase)entitylivingbase, (double)this.func_110148_a(field_110186_bp).func_111126_e())).getResult() == Event.Result.DENY) {
                return true;
            }
            if (event.getResult() == Event.Result.ALLOW || entitylivingbase != null && this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(field_110186_bp).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                EntityZombie entityzombie = event.getCustomSummonedAid() != null && event.getResult() == Event.Result.ALLOW ? event.getCustomSummonedAid() : new EntityZombie(this.field_70170_p);
                for (int l = 0; l < 50; ++l) {
                    int k1;
                    int j1;
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    if (!this.field_70170_p.func_195595_w(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1))) || this.field_70170_p.func_201696_r(new BlockPos(i1, j1, k1)) >= 10) continue;
                    entityzombie.func_70107_b(i1, j1, k1);
                    if (this.field_70170_p.func_175636_b(i1, j1, k1, 7.0) || !this.field_70170_p.func_195587_c((Entity)((Object)entityzombie), entityzombie.func_174813_aQ()) || !this.field_70170_p.func_195586_b((Entity)((Object)entityzombie), entityzombie.func_174813_aQ()) || this.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)((Object)entityzombie));
                    if (entitylivingbase != null) {
                        entityzombie.func_70624_b(entitylivingbase);
                    }
                    entityzombie.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)entityzombie))), null, null);
                    this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement caller charge", (double)-0.05f, 0));
                    entityzombie.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", (double)-0.05f, 0));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)this))).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                entityIn.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(this.func_190731_di(), 0.15f, 1.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186383_ah;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151037_a));
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        compound.func_74757_a("CanBreakDoors", this.func_146072_bX());
        compound.func_74768_a("InWaterTime", this.func_70090_H() ? this.field_204707_bD : -1);
        compound.func_74768_a("DrownedConversionTime", this.func_204706_dD() ? this.field_204708_bE : -1);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74767_n("IsBaby")) {
            this.func_82227_f(true);
        }
        this.func_146070_a(compound.func_74767_n("CanBreakDoors"));
        this.field_204707_bD = compound.func_74762_e("InWaterTime");
        if (compound.func_150297_b("DrownedConversionTime", 99) && compound.func_74762_e("DrownedConversionTime") > -1) {
            this.func_204704_a(compound.func_74762_e("DrownedConversionTime"));
        }
    }

    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
        if ((this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) && entityLivingIn instanceof EntityVillager) {
            if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            EntityVillager entityvillager = (EntityVillager)((Object)entityLivingIn);
            EntityZombieVillager entityzombievillager = new EntityZombieVillager(this.field_70170_p);
            entityzombievillager.func_82149_j((Entity)((Object)entityvillager));
            this.field_70170_p.func_72900_e((Entity)((Object)entityvillager));
            entityzombievillager.func_204210_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)entityzombievillager))), new GroupData(false), null);
            entityzombievillager.setProfession(entityvillager.getProfessionForge());
            entityzombievillager.func_82227_f(entityvillager.func_70631_g_());
            entityzombievillager.func_94061_f(entityvillager.func_175446_cd());
            if (entityvillager.func_145818_k_()) {
                entityzombievillager.func_200203_b(entityvillager.func_200201_e());
                entityzombievillager.func_174805_g(entityvillager.func_174833_aM());
            }
            this.field_70170_p.func_72838_d((Entity)((Object)entityzombievillager));
            this.field_70170_p.func_180498_a(null, 1026, new BlockPos((Entity)((Object)this)), 0);
        }
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    protected boolean func_175448_a(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(stack);
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        entityLivingData = super.func_204210_a(difficulty, entityLivingData, itemNbt);
        float f = difficulty.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        if (entityLivingData == null) {
            entityLivingData = new GroupData((double)this.field_70170_p.field_73012_v.nextFloat() < (Double)ForgeConfig.SERVER.zombieBabyChance.get());
        }
        if (entityLivingData instanceof GroupData) {
            GroupData entityzombie$groupdata = (GroupData)entityLivingData;
            if (entityzombie$groupdata.field_142048_a) {
                this.func_82227_f(true);
                if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    List<EntityChicken> list = this.field_70170_p.func_175647_a(EntityChicken.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntitySelectors.field_152785_b);
                    if (!list.isEmpty()) {
                        EntityChicken entitychicken = list.get(0);
                        entitychicken.func_152117_i(true);
                        this.func_184220_m((Entity)entitychicken);
                    }
                } else if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.05) {
                    EntityChicken entitychicken1 = new EntityChicken(this.field_70170_p);
                    entitychicken1.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
                    entitychicken1.func_204210_a(difficulty, (IEntityLivingData)null, (NBTTagCompound)null);
                    entitychicken1.func_152117_i(true);
                    this.field_70170_p.func_72838_d((Entity)entitychicken1);
                    this.func_184220_m((Entity)entitychicken1);
                }
            }
            this.func_146070_a(this.func_204900_dz() && this.field_70146_Z.nextFloat() < f * 0.1f);
            this.func_180481_a(difficulty);
            this.func_180483_b(difficulty);
        }
        if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS));
                this.field_184655_bs[EntityEquipmentSlot.HEAD.func_188454_b()] = 0.0f;
            }
        }
        this.func_207304_a(f);
        return entityLivingData;
    }

    protected void func_207301_a(boolean p_207301_1_, boolean p_207301_2_, boolean p_207301_3_, boolean p_207301_4_) {
        this.func_98053_h(p_207301_1_);
        this.func_146070_a(this.func_204900_dz() && p_207301_2_);
        this.func_207304_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)((Object)this))).func_180170_c());
        this.func_82227_f(p_207301_3_);
        this.func_94061_f(p_207301_4_);
    }

    protected void func_207304_a(float difficulty) {
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, 0));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)difficulty;
        if (d0 > 1.0) {
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(new AttributeModifier("Random zombie-spawn bonus", d0, 2));
        }
        if (this.field_70146_Z.nextFloat() < difficulty * 0.05f) {
            this.func_110148_a(field_110186_bp).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, 0));
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, 2));
            this.func_146070_a(this.func_204900_dz());
        }
    }

    public void func_146071_k(boolean isChild) {
        this.func_146069_a(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.field_146074_bv > 0.0f && this.field_146073_bw > 0.0f;
        this.field_146074_bv = width;
        this.field_146073_bw = height;
        if (!flag) {
            this.func_146069_a(1.0f);
        }
    }

    protected final void func_146069_a(float size) {
        super.func_70105_a(this.field_146074_bv * size, this.field_146073_bw * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    public void func_70645_a(DamageSource cause) {
        EntityCreeper entitycreeper;
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper && (entitycreeper = (EntityCreeper)((Object)cause.func_76346_g())).func_70830_n() && entitycreeper.func_70650_aV()) {
            entitycreeper.func_175493_co();
            ItemStack itemstack = this.func_190732_dj();
            if (!itemstack.func_190926_b()) {
                this.func_199701_a_(itemstack);
            }
        }
    }

    protected ItemStack func_190732_dj() {
        return new ItemStack(Items.field_196186_dz);
    }

    public class GroupData
    implements IEntityLivingData {
        public boolean field_142048_a;

        private GroupData(boolean p_i47328_2_) {
            this.field_142048_a = p_i47328_2_;
        }
    }

    class AIAttackTurtleEgg
    extends EntityAIBreakBlock {
        AIAttackTurtleEgg(Block p_i48792_2_, EntityCreature p_i48792_3_, double p_i48792_4_, int p_i48792_6_) {
            super(p_i48792_2_, p_i48792_3_, p_i48792_4_, p_i48792_6_);
        }

        @Override
        public void func_203114_b(IWorld p_203114_1_, BlockPos p_203114_2_) {
            p_203114_1_.func_184133_a(null, p_203114_2_, SoundEvents.field_203276_jU, SoundCategory.HOSTILE, 0.5f, 0.9f + EntityZombie.this.field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public void func_203116_c(World p_203116_1_, BlockPos p_203116_2_) {
            p_203116_1_.func_184133_a(null, p_203116_2_, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + p_203116_1_.field_73012_v.nextFloat() * 0.2f);
        }

        public double func_203110_f() {
            return 1.3;
        }
    }
}

