/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAILandOnOwnersShoulder;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityShoulderRiding;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityParrot
extends EntityShoulderRiding
implements IFlyingAnimal {
    private static final DataParameter<Integer> field_192013_bG = EntityDataManager.func_187226_a(EntityParrot.class, DataSerializers.field_187192_b);
    private static final Predicate<EntityLiving> field_192014_bH = new Predicate<EntityLiving>(){

        @Override
        public boolean test(@Nullable EntityLiving p_test_1_) {
            return p_test_1_ != null && field_192017_bK.containsKey(p_test_1_.func_200600_R());
        }
    };
    private static final Item field_192015_bI = Items.field_151106_aX;
    private static final Set<Item> field_192016_bJ = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final Map<EntityType<?>, SoundEvent> field_192017_bK = (Map)Util.func_200696_a((Object)Maps.newHashMap(), p_200609_0_ -> {
        p_200609_0_.put(EntityType.field_200792_f, SoundEvents.field_193791_eM);
        p_200609_0_.put(EntityType.field_200794_h, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200797_k, SoundEvents.field_193792_eN);
        p_200609_0_.put(EntityType.field_204724_o, SoundEvents.field_206942_fI);
        p_200609_0_.put(EntityType.field_200800_n, SoundEvents.field_193793_eO);
        p_200609_0_.put(EntityType.field_200802_p, SoundEvents.field_193794_eP);
        p_200609_0_.put(EntityType.field_200803_q, SoundEvents.field_193795_eQ);
        p_200609_0_.put(EntityType.field_200804_r, SoundEvents.field_193796_eR);
        p_200609_0_.put(EntityType.field_200806_t, SoundEvents.field_193797_eS);
        p_200609_0_.put(EntityType.field_200811_y, SoundEvents.field_193798_eT);
        p_200609_0_.put(EntityType.field_200763_C, SoundEvents.field_193799_eU);
        p_200609_0_.put(EntityType.field_200764_D, SoundEvents.field_193800_eV);
        p_200609_0_.put(EntityType.field_200771_K, SoundEvents.field_193801_eW);
        p_200609_0_.put(EntityType.field_200785_Y, SoundEvents.field_193822_fl);
        p_200609_0_.put(EntityType.field_203097_aH, SoundEvents.field_206943_fS);
        p_200609_0_.put(EntityType.field_200786_Z, SoundEvents.field_193802_eX);
        p_200609_0_.put(EntityType.field_200738_ad, SoundEvents.field_193803_eY);
        p_200609_0_.put(EntityType.field_200740_af, SoundEvents.field_193804_eZ);
        p_200609_0_.put(EntityType.field_200741_ag, SoundEvents.field_193811_fa);
        p_200609_0_.put(EntityType.field_200743_ai, SoundEvents.field_193812_fb);
        p_200609_0_.put(EntityType.field_200748_an, SoundEvents.field_193813_fc);
        p_200609_0_.put(EntityType.field_200750_ap, SoundEvents.field_193814_fd);
        p_200609_0_.put(EntityType.field_200755_au, SoundEvents.field_193815_fe);
        p_200609_0_.put(EntityType.field_200758_ax, SoundEvents.field_193816_ff);
        p_200609_0_.put(EntityType.field_200759_ay, SoundEvents.field_193817_fg);
        p_200609_0_.put(EntityType.field_200760_az, SoundEvents.field_193818_fh);
        p_200609_0_.put(EntityType.field_200722_aA, SoundEvents.field_193819_fi);
        p_200609_0_.put(EntityType.field_200724_aC, SoundEvents.field_193820_fj);
        p_200609_0_.put(EntityType.field_200725_aD, SoundEvents.field_193821_fk);
        p_200609_0_.put(EntityType.field_200727_aF, SoundEvents.field_193823_fm);
    });
    public float field_192008_bB;
    public float field_192009_bC;
    public float field_192010_bD;
    public float field_192011_bE;
    public float field_192012_bF = 1.0f;
    private boolean field_192018_bL;
    private BlockPos field_192019_bM;

    public EntityParrot(World worldIn) {
        super(EntityType.field_200783_W, worldIn);
        this.func_70105_a(0.5f, 0.9f);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)((Object)this));
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        this.func_191997_m(this.field_70146_Z.nextInt(5));
        return super.func_204210_a(difficulty, entityLivingData, itemNbt);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILandOnOwnersShoulder((EntityShoulderRiding)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollow((EntityLiving)((Object)this), 1.0, 3.0f, 7.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a((double)0.4f);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying pathnavigateflying = new PathNavigateFlying((EntityLiving)((Object)this), worldIn);
        pathnavigateflying.func_192879_a(false);
        pathnavigateflying.func_212239_d(true);
        pathnavigateflying.func_192878_b(true);
        return pathnavigateflying;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    public void func_70636_d() {
        EntityParrot.func_192006_b(this.field_70170_p, (Entity)((Object)this));
        if (this.field_192019_bM == null || this.field_192019_bM.func_177954_c(this.field_70165_t, this.field_70163_u, this.field_70161_v) > 12.0 || this.field_70170_p.func_180495_p(this.field_192019_bM).func_177230_c() != Blocks.field_150421_aI) {
            this.field_192018_bL = false;
            this.field_192019_bM = null;
        }
        super.func_70636_d();
        this.func_192001_dv();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        this.field_192019_bM = pos;
        this.field_192018_bL = isPartying;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_192004_dr() {
        return this.field_192018_bL;
    }

    private void func_192001_dv() {
        this.field_192011_bE = this.field_192008_bB;
        this.field_192010_bD = this.field_192009_bC;
        this.field_192009_bC = (float)((double)this.field_192009_bC + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.field_192009_bC = MathHelper.func_76131_a((float)this.field_192009_bC, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.field_192012_bF < 1.0f) {
            this.field_192012_bF = 1.0f;
        }
        this.field_192012_bF = (float)((double)this.field_192012_bF * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.field_192008_bB += this.field_192012_bF * 2.0f;
    }

    private static boolean func_192006_b(World worldIn, Entity parrotIn) {
        if (!parrotIn.func_174814_R() && worldIn.field_73012_v.nextInt(50) == 0) {
            EntityLiving entityliving;
            List<EntityLiving> list = worldIn.func_175647_a(EntityLiving.class, parrotIn.func_174813_aQ().func_186662_g(20.0), field_192014_bH);
            if (!list.isEmpty() && !(entityliving = list.get(worldIn.field_73012_v.nextInt(list.size()))).func_174814_R()) {
                SoundEvent soundevent = EntityParrot.func_200610_a(entityliving.func_200600_R());
                worldIn.func_184148_a(null, parrotIn.field_70165_t, parrotIn.field_70163_u, parrotIn.field_70161_v, soundevent, parrotIn.func_184176_by(), 0.7f, EntityParrot.func_192000_b(worldIn.field_73012_v));
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_70909_n() && field_192016_bJ.contains((Object)itemstack.func_77973_b())) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)6);
                }
            }
            return true;
        }
        if (itemstack.func_77973_b() == field_192015_bI) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_195064_c(new PotionEffect(MobEffects.field_76436_u, 900));
            if (player.func_184812_l_() || !this.func_190530_aW()) {
                this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), Float.MAX_VALUE);
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_192002_a() && this.func_70909_n() && this.func_152114_e(player)) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return false;
    }

    public boolean func_205020_a(IWorld worldIn, boolean p_205020_2_) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)this.field_70161_v));
        Block block = worldIn.func_180495_p(blockpos.func_177977_b()).func_177230_c();
        return block instanceof BlockLeaves || block == Blocks.field_196658_i || block instanceof BlockLog || block == Blocks.field_150350_a && super.func_205020_a(worldIn, p_205020_2_);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public static void func_192005_a(World worldIn, Entity parrotIn) {
        if (!parrotIn.func_174814_R() && !EntityParrot.func_192006_b(worldIn, parrotIn) && worldIn.field_73012_v.nextInt(200) == 0) {
            worldIn.func_184148_a(null, parrotIn.field_70165_t, parrotIn.field_70163_u, parrotIn.field_70161_v, EntityParrot.func_192003_a(worldIn.field_73012_v), parrotIn.func_184176_by(), 1.0f, EntityParrot.func_192000_b(worldIn.field_73012_v));
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((Object)this)), 3.0f);
    }

    @Nullable
    public SoundEvent func_184639_G() {
        return EntityParrot.func_192003_a(this.field_70146_Z);
    }

    private static SoundEvent func_192003_a(Random random) {
        if (random.nextInt(1000) == 0) {
            ArrayList list = Lists.newArrayList(field_192017_bK.keySet());
            return EntityParrot.func_200610_a((EntityType)((Object)list.get(random.nextInt(list.size()))));
        }
        return SoundEvents.field_192792_ep;
    }

    public static SoundEvent func_200610_a(EntityType<?> p_200610_0_) {
        return field_192017_bK.getOrDefault(p_200610_0_, SoundEvents.field_192792_ep);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_192794_er;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_192793_eq;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float volume) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return volume + this.field_192009_bC / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    protected float func_70647_i() {
        return EntityParrot.func_192000_b(this.field_70146_Z);
    }

    private static float func_192000_b(Random random) {
        return (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(entityIn instanceof EntityPlayer)) {
            super.func_82167_n(entityIn);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    public int func_191998_ds() {
        return MathHelper.func_76125_a((int)this.field_70180_af.func_187225_a(field_192013_bG), (int)0, (int)4);
    }

    public void func_191997_m(int variantIn) {
        this.field_70180_af.func_187227_b(field_192013_bG, variantIn);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_192013_bG, 0);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.func_191998_ds());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_191997_m(compound.func_74762_e("Variant"));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_192561_ax;
    }

    public boolean func_192002_a() {
        return !this.field_70122_E;
    }
}

