/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final DataParameter<Byte> field_184774_bv = EntityDataManager.func_187226_a(EntitySheep.class, DataSerializers.field_187191_a);
    private final InventoryCrafting field_90016_e = new InventoryCrafting(new Container(){

        @Override
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }, 2, 1);
    private static final Map<EnumDyeColor, IItemProvider> field_200206_bz = (Map)Util.func_200696_a((Object)Maps.newEnumMap(EnumDyeColor.class), p_203402_0_ -> {
        p_203402_0_.put(EnumDyeColor.WHITE, Blocks.field_196556_aL);
        p_203402_0_.put(EnumDyeColor.ORANGE, Blocks.field_196557_aM);
        p_203402_0_.put(EnumDyeColor.MAGENTA, Blocks.field_196558_aN);
        p_203402_0_.put(EnumDyeColor.LIGHT_BLUE, Blocks.field_196559_aO);
        p_203402_0_.put(EnumDyeColor.YELLOW, Blocks.field_196560_aP);
        p_203402_0_.put(EnumDyeColor.LIME, Blocks.field_196561_aQ);
        p_203402_0_.put(EnumDyeColor.PINK, Blocks.field_196562_aR);
        p_203402_0_.put(EnumDyeColor.GRAY, Blocks.field_196563_aS);
        p_203402_0_.put(EnumDyeColor.LIGHT_GRAY, Blocks.field_196564_aT);
        p_203402_0_.put(EnumDyeColor.CYAN, Blocks.field_196565_aU);
        p_203402_0_.put(EnumDyeColor.PURPLE, Blocks.field_196566_aV);
        p_203402_0_.put(EnumDyeColor.BLUE, Blocks.field_196567_aW);
        p_203402_0_.put(EnumDyeColor.BROWN, Blocks.field_196568_aX);
        p_203402_0_.put(EnumDyeColor.GREEN, Blocks.field_196569_aY);
        p_203402_0_.put(EnumDyeColor.RED, Blocks.field_196570_aZ);
        p_203402_0_.put(EnumDyeColor.BLACK, Blocks.field_196602_ba);
    });
    private static final Map<EnumDyeColor, float[]> field_175514_bm = Maps.newEnumMap(Arrays.stream(EnumDyeColor.values()).collect(Collectors.toMap(p_200204_0_ -> p_200204_0_, EntitySheep::func_192020_c)));
    private int field_70899_e;
    private EntityAIEatGrass field_146087_bs;

    private static float[] func_192020_c(EnumDyeColor p_192020_0_) {
        if (p_192020_0_ == EnumDyeColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] afloat = p_192020_0_.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float[] func_175513_a(EnumDyeColor dyeColor) {
        return field_175514_bm.get((Object)dyeColor);
    }

    public EntitySheep(World worldIn) {
        super(EntityType.field_200737_ac, worldIn);
        this.func_70105_a(0.9f, 1.3f);
    }

    protected void func_184651_r() {
        this.field_146087_bs = new EntityAIEatGrass((EntityLiving)((Object)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, Ingredient.func_199804_a(Items.field_151015_O), false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.field_146087_bs);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)((Object)this), EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)((Object)this)));
    }

    protected void func_70619_bc() {
        this.field_70899_e = this.field_146087_bs.func_151499_f();
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.field_70899_e = Math.max(0, this.field_70899_e - 1);
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184774_bv, (byte)0);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.func_70892_o()) {
            return LootTableList.field_186403_K;
        }
        switch (this.func_175509_cj()) {
            default: {
                return LootTableList.field_186404_L;
            }
            case ORANGE: {
                return LootTableList.field_186405_M;
            }
            case MAGENTA: {
                return LootTableList.field_186406_N;
            }
            case LIGHT_BLUE: {
                return LootTableList.field_186407_O;
            }
            case YELLOW: {
                return LootTableList.field_186408_P;
            }
            case LIME: {
                return LootTableList.field_186409_Q;
            }
            case PINK: {
                return LootTableList.field_186410_R;
            }
            case GRAY: {
                return LootTableList.field_186411_S;
            }
            case LIGHT_GRAY: {
                return LootTableList.field_197738_Y;
            }
            case CYAN: {
                return LootTableList.field_186413_U;
            }
            case PURPLE: {
                return LootTableList.field_186414_V;
            }
            case BLUE: {
                return LootTableList.field_186415_W;
            }
            case BROWN: {
                return LootTableList.field_186416_X;
            }
            case GREEN: {
                return LootTableList.field_186417_Y;
            }
            case RED: {
                return LootTableList.field_186418_Z;
            }
            case BLACK: 
        }
        return LootTableList.field_186376_aa;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.field_70899_e = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70894_j(float p_70894_1_) {
        if (this.field_70899_e <= 0) {
            return 0.0f;
        }
        if (this.field_70899_e >= 4 && this.field_70899_e <= 36) {
            return 1.0f;
        }
        return this.field_70899_e < 4 ? ((float)this.field_70899_e - p_70894_1_) / 4.0f : -((float)(this.field_70899_e - 40) - p_70894_1_) / 4.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70890_k(float p_70890_1_) {
        if (this.field_70899_e > 4 && this.field_70899_e <= 36) {
            float f = ((float)(this.field_70899_e - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.field_70899_e > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        return super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74774_a("Color", (byte)this.func_175509_cj().func_196059_a());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.func_175512_b(EnumDyeColor.func_196056_a(compound.func_74771_c("Color")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, IBlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public EnumDyeColor func_175509_cj() {
        return EnumDyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184774_bv) & 0xF);
    }

    public void func_175512_b(EnumDyeColor color) {
        byte b0 = this.field_70180_af.func_187225_a(field_184774_bv);
        this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 & 0xF0 | color.func_196059_a() & 0xF));
    }

    public boolean func_70892_o() {
        return (this.field_70180_af.func_187225_a(field_184774_bv) & 0x10) != 0;
    }

    public void func_70893_e(boolean sheared) {
        byte b0 = this.field_70180_af.func_187225_a(field_184774_bv);
        if (sheared) {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 | 0x10));
        } else {
            this.field_70180_af.func_187227_b(field_184774_bv, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    public static EnumDyeColor func_175510_a(Random random) {
        int i = random.nextInt(100);
        if (i < 5) {
            return EnumDyeColor.BLACK;
        }
        if (i < 10) {
            return EnumDyeColor.GRAY;
        }
        if (i < 15) {
            return EnumDyeColor.LIGHT_GRAY;
        }
        if (i < 18) {
            return EnumDyeColor.BROWN;
        }
        return random.nextInt(500) == 0 ? EnumDyeColor.PINK : EnumDyeColor.WHITE;
    }

    public EntitySheep func_90011_a(EntityAgeable ageable) {
        EntitySheep entitysheep = (EntitySheep)ageable;
        EntitySheep entitysheep1 = new EntitySheep(this.field_70170_p);
        entitysheep1.func_175512_b(this.func_175511_a(this, entitysheep));
        return entitysheep1;
    }

    public void func_70615_aA() {
        this.func_70893_e(false);
        if (this.func_70631_g_()) {
            this.func_110195_a(60);
        }
    }

    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficulty, @Nullable IEntityLivingData entityLivingData, @Nullable NBTTagCompound itemNbt) {
        entityLivingData = super.func_204210_a(difficulty, entityLivingData, itemNbt);
        this.func_175512_b(EntitySheep.func_175510_a(this.field_70170_p.field_73012_v));
        return entityLivingData;
    }

    private EnumDyeColor func_175511_a(EntityAnimal father, EntityAnimal mother) {
        EnumDyeColor enumdyecolor = ((EntitySheep)father).func_175509_cj();
        EnumDyeColor enumdyecolor1 = ((EntitySheep)mother).func_175509_cj();
        this.field_90016_e.func_70299_a(0, new ItemStack((IItemProvider)ItemDye.func_195961_a((EnumDyeColor)enumdyecolor)));
        this.field_90016_e.func_70299_a(1, new ItemStack((IItemProvider)ItemDye.func_195961_a((EnumDyeColor)enumdyecolor1)));
        ItemStack itemstack = father.field_70170_p.func_199532_z().getResult((IInventory)this.field_90016_e, ((EntitySheep)father).field_70170_p, VanillaRecipeTypes.CRAFTING);
        Item item = itemstack.func_77973_b();
        EnumDyeColor enumdyecolor2 = item instanceof ItemDye ? ((ItemDye)item).func_195962_g() : (this.field_70170_p.field_73012_v.nextBoolean() ? enumdyecolor : enumdyecolor1);
        return enumdyecolor2;
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.func_70892_o() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.func_70893_e(true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                ret.add(new ItemStack(field_200206_bz.get((Object)this.func_175509_cj())));
            }
        }
        return ret;
    }
}

