/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.init.Particles;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityFireball
extends Entity {
    public EntityLivingBase field_70235_a;
    private int field_70236_j;
    private int field_70234_an;
    public double field_70232_b;
    public double field_70233_c;
    public double field_70230_d;

    protected EntityFireball(EntityType<?> type, World p_i48543_2_, float p_i48543_3_, float p_i48543_4_) {
        super(type, p_i48543_2_);
        this.func_70105_a(p_i48543_3_, p_i48543_4_);
    }

    public EntityFireball(EntityType<?> type, double p_i48544_2_, double p_i48544_4_, double p_i48544_6_, double p_i48544_8_, double p_i48544_10_, double p_i48544_12_, World p_i48544_14_, float p_i48544_15_, float p_i48544_16_) {
        this(type, p_i48544_14_, p_i48544_15_, p_i48544_16_);
        this.func_70012_b(p_i48544_2_, p_i48544_4_, p_i48544_6_, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(p_i48544_2_, p_i48544_4_, p_i48544_6_);
        double d0 = MathHelper.func_76133_a((double)(p_i48544_8_ * p_i48544_8_ + p_i48544_10_ * p_i48544_10_ + p_i48544_12_ * p_i48544_12_));
        this.field_70232_b = p_i48544_8_ / d0 * 0.1;
        this.field_70233_c = p_i48544_10_ / d0 * 0.1;
        this.field_70230_d = p_i48544_12_ / d0 * 0.1;
    }

    public EntityFireball(EntityType<?> type, EntityLivingBase p_i48545_2_, double p_i48545_3_, double p_i48545_5_, double p_i48545_7_, World p_i48545_9_, float p_i48545_10_, float p_i48545_11_) {
        this(type, p_i48545_9_, p_i48545_10_, p_i48545_11_);
        this.field_70235_a = p_i48545_2_;
        this.func_70012_b(p_i48545_2_.field_70165_t, p_i48545_2_.field_70163_u, p_i48545_2_.field_70161_v, p_i48545_2_.field_70177_z, p_i48545_2_.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        double d0 = MathHelper.func_76133_a((double)((p_i48545_3_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i48545_3_ + (p_i48545_5_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i48545_5_ + (p_i48545_7_ += this.field_70146_Z.nextGaussian() * 0.4) * p_i48545_7_));
        this.field_70232_b = p_i48545_3_ / d0 * 0.1;
        this.field_70233_c = p_i48545_5_ / d0 * 0.1;
        this.field_70230_d = p_i48545_7_ / d0 * 0.1;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.field_70235_a == null || !this.field_70235_a.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            if (this.func_184564_k()) {
                this.func_70015_d(1);
            }
            ++this.field_70234_an;
            RayTraceResult raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (this.field_70234_an >= 25 ? 1 : 0) != 0, (Entity)this.field_70235_a);
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((EntityFireball)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.func_82341_c();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                f = 0.8f;
            }
            this.field_70159_w += this.field_70232_b;
            this.field_70181_x += this.field_70233_c;
            this.field_70179_y += this.field_70230_d;
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
            this.field_70170_p.func_195594_a(this.func_195057_f(), this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    protected boolean func_184564_k() {
        return true;
    }

    protected IParticleData func_195057_f() {
        return Particles.field_197601_L;
    }

    protected float func_82341_c() {
        return 0.95f;
    }

    protected abstract void func_70227_a(RayTraceResult var1);

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("direction", (INBTBase)this.func_70087_a(this.field_70159_w, this.field_70181_x, this.field_70179_y));
        compound.func_74782_a("power", (INBTBase)this.func_70087_a(this.field_70232_b, this.field_70233_c, this.field_70230_d));
        compound.func_74768_a("life", this.field_70236_j);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList nbttaglist;
        if (compound.func_150297_b("power", 9) && (nbttaglist = compound.func_150295_c("power", 6)).size() == 3) {
            this.field_70232_b = nbttaglist.func_150309_d(0);
            this.field_70233_c = nbttaglist.func_150309_d(1);
            this.field_70230_d = nbttaglist.func_150309_d(2);
        }
        this.field_70236_j = compound.func_74762_e("life");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).size() == 3) {
            NBTTagList nbttaglist1 = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist1.func_150309_d(0);
            this.field_70181_x = nbttaglist1.func_150309_d(1);
            this.field_70179_y = nbttaglist1.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public float func_70111_Y() {
        return 1.0f;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                this.field_70159_w = vec3d.field_72450_a;
                this.field_70181_x = vec3d.field_72448_b;
                this.field_70179_y = vec3d.field_72449_c;
                this.field_70232_b = this.field_70159_w * 0.1;
                this.field_70233_c = this.field_70181_x * 0.1;
                this.field_70230_d = this.field_70179_y * 0.1;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.field_70235_a = (EntityLivingBase)source.func_76346_g();
            }
            return true;
        }
        return false;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }
}

