/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityThrowable
extends Entity
implements IProjectile {
    private int field_145788_c = -1;
    private int field_145786_d = -1;
    private int field_145787_e = -1;
    protected boolean field_174854_a;
    public int field_70191_b;
    protected EntityLivingBase field_70192_c;
    private UUID field_200218_h;
    public Entity field_184539_c;
    private int field_184540_av;

    protected EntityThrowable(EntityType<?> type, World p_i48540_2_) {
        super(type, p_i48540_2_);
        this.func_70105_a(0.25f, 0.25f);
    }

    protected EntityThrowable(EntityType<?> type, double p_i48541_2_, double p_i48541_4_, double p_i48541_6_, World p_i48541_8_) {
        this(type, p_i48541_8_);
        this.func_70107_b(p_i48541_2_, p_i48541_4_, p_i48541_6_);
    }

    protected EntityThrowable(EntityType<?> type, EntityLivingBase p_i48542_2_, World p_i48542_3_) {
        this(type, p_i48542_2_.field_70165_t, p_i48542_2_.field_70163_u + (double)p_i48542_2_.func_70047_e() - (double)0.1f, p_i48542_2_.field_70161_v, p_i48542_3_);
        this.field_70192_c = p_i48542_2_;
        this.field_200218_h = p_i48542_2_.func_110124_au();
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void func_184538_a(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += entityThrower.field_70159_w;
        this.field_70179_y += entityThrower.field_70179_y;
        if (!entityThrower.field_70122_E) {
            this.field_70181_x += entityThrower.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @Override
    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.field_174854_a) {
            this.field_174854_a = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b(this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)((Object)list.get(i));
            if (!entity1.func_70067_L()) continue;
            if (entity1 == this.field_184539_c) {
                flag = true;
                continue;
            }
            if (this.field_70192_c != null && this.field_70173_aa < 2 && this.field_184539_c == null) {
                this.field_184539_c = entity1;
                flag = true;
                continue;
            }
            flag = false;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
            if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (this.field_184539_c != null) {
            if (flag) {
                this.field_184540_av = 2;
            } else if (this.field_184540_av-- <= 0) {
                this.field_184539_c = null;
            }
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytraceresult.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(raytraceresult.func_178782_a());
            } else if (!ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)raytraceresult)) {
                this.func_70184_a(raytraceresult);
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = this.func_70185_h();
        if (this.func_70090_H()) {
            for (int j = 0; j < 4; ++j) {
                float f3 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)Particles.field_197612_e, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            f1 = 0.8f;
        }
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)f2;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    protected abstract void func_70184_a(RayTraceResult var1);

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("xTile", this.field_145788_c);
        compound.func_74768_a("yTile", this.field_145786_d);
        compound.func_74768_a("zTile", this.field_145787_e);
        compound.func_74774_a("shake", (byte)this.field_70191_b);
        compound.func_74774_a("inGround", (byte)(this.field_174854_a ? 1 : 0));
        if (this.field_200218_h != null) {
            compound.func_74782_a("owner", NBTUtil.func_186862_a((UUID)this.field_200218_h));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        this.field_145788_c = compound.func_74762_e("xTile");
        this.field_145786_d = compound.func_74762_e("yTile");
        this.field_145787_e = compound.func_74762_e("zTile");
        this.field_70191_b = compound.func_74771_c("shake") & 0xFF;
        this.field_174854_a = compound.func_74771_c("inGround") == 1;
        this.field_70192_c = null;
        if (compound.func_150297_b("owner", 10)) {
            this.field_200218_h = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("owner"));
        }
    }

    @Nullable
    public EntityLivingBase func_85052_h() {
        if (this.field_70192_c == null && this.field_200218_h != null && this.field_70170_p instanceof WorldServer) {
            Entity entity = ((WorldServer)this.field_70170_p).func_175733_a(this.field_200218_h);
            if (entity instanceof EntityLivingBase) {
                this.field_70192_c = (EntityLivingBase)entity;
            } else {
                this.field_200218_h = null;
            }
        }
        return this.field_70192_c;
    }
}

