/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.fluid.WaterFluid;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.Tag;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeFluid;

public abstract class Fluid
implements IForgeFluid {
    public static final ObjectIntIdentityMap<IFluidState> field_207201_d = new ObjectIntIdentityMap();
    protected final StateContainer<Fluid, IFluidState> field_207202_e;
    private IFluidState field_207200_b;

    protected Fluid() {
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.func_207184_a((StateContainer.Builder<Fluid, IFluidState>)builder);
        this.field_207202_e = builder.func_206893_a(FluidState::new);
        this.func_207183_f((IFluidState)this.field_207202_e.func_177621_b());
    }

    protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
    }

    public StateContainer<Fluid, IFluidState> func_207182_e() {
        return this.field_207202_e;
    }

    protected final void func_207183_f(IFluidState state) {
        this.field_207200_b = state;
    }

    public final IFluidState func_207188_f() {
        return this.field_207200_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract BlockRenderLayer func_180664_k();

    public abstract Item func_204524_b();

    @OnlyIn(value=Dist.CLIENT)
    protected void func_204522_a(World worldIn, BlockPos pos, IFluidState state, Random random) {
    }

    protected void func_207191_a(World worldIn, BlockPos pos, IFluidState state) {
    }

    protected void func_207186_b(World p_207186_1_, BlockPos pos, IFluidState state, Random random) {
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected IParticleData func_204521_c() {
        return null;
    }

    protected abstract boolean func_211757_a(IFluidState var1, Fluid var2, EnumFacing var3);

    protected abstract Vec3d func_205564_a(IWorldReaderBase var1, BlockPos var2, IFluidState var3);

    public abstract int func_205569_a(IWorldReaderBase var1);

    protected boolean func_207196_h() {
        return false;
    }

    protected boolean func_204538_c() {
        return false;
    }

    protected abstract float func_210195_d();

    public abstract float func_207181_a(IFluidState var1);

    protected abstract IBlockState func_204527_a(IFluidState var1);

    public abstract boolean func_207193_c(IFluidState var1);

    public abstract int func_207192_d(IFluidState var1);

    public boolean func_207187_a(Fluid fluidIn) {
        return fluidIn == this;
    }

    public boolean func_207185_a(Tag<Fluid> tagIn) {
        return tagIn.func_199685_a_(this);
    }

    public static void func_207195_i() {
        Fluid.func_207194_a(IRegistry.field_212619_h.func_212609_b(), (Fluid)new EmptyFluid());
        Fluid.func_207198_a("flowing_water", (Fluid)new WaterFluid.Flowing());
        Fluid.func_207198_a("water", (Fluid)new WaterFluid.Source());
        Fluid.func_207198_a("flowing_lava", (Fluid)new LavaFluid.Flowing());
        Fluid.func_207198_a("lava", (Fluid)new LavaFluid.Source());
        Iterator<Fluid> iterator = IRegistry.field_212619_h.iterator();
        while (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            for (IFluidState ifluidstate : fluid.func_207182_e().func_177619_a()) {
                field_207201_d.func_195867_b((Object)ifluidstate);
            }
        }
    }

    private static void func_207198_a(String resourceName, Fluid fluidIn) {
        Fluid.func_207194_a(new ResourceLocation(resourceName), fluidIn);
    }

    private static void func_207194_a(ResourceLocation resourceLocationIn, Fluid fluidIn) {
        IRegistry.field_212619_h.func_82595_a(resourceLocationIn, fluidIn);
    }
}

