/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlock
extends Item {
    @Deprecated
    private final Block field_150939_a;

    public ItemBlock(Block blockIn, Item.Properties builder) {
        super(builder);
        this.field_150939_a = blockIn;
    }

    @Override
    public EnumActionResult func_195939_a(ItemUseContext p_195939_1_) {
        return this.func_195942_a(new BlockItemUseContext(p_195939_1_));
    }

    public EnumActionResult func_195942_a(BlockItemUseContext p_195942_1_) {
        if (!p_195942_1_.func_196011_b()) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = this.func_195945_b(p_195942_1_);
        if (iblockstate == null) {
            return EnumActionResult.FAIL;
        }
        if (!this.func_195941_b(p_195942_1_, iblockstate)) {
            return EnumActionResult.FAIL;
        }
        BlockPos blockpos = p_195942_1_.func_195995_a();
        World world = p_195942_1_.func_195991_k();
        EntityPlayer entityplayer = p_195942_1_.func_195999_j();
        ItemStack itemstack = p_195942_1_.func_195996_i();
        IBlockState iblockstate1 = world.func_180495_p(blockpos);
        Block block = iblockstate1.func_177230_c();
        if (block == iblockstate.func_177230_c()) {
            this.func_195943_a(blockpos, world, entityplayer, itemstack, iblockstate1);
            block.func_180633_a(world, blockpos, iblockstate1, entityplayer, itemstack);
            if (entityplayer instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)entityplayer, blockpos, itemstack);
            }
        }
        SoundType soundtype = iblockstate1.getSoundType(world, blockpos, p_195942_1_.func_195999_j());
        world.func_184133_a(entityplayer, blockpos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        itemstack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    protected boolean func_195943_a(BlockPos p_195943_1_, World p_195943_2_, @Nullable EntityPlayer p_195943_3_, ItemStack p_195943_4_, IBlockState p_195943_5_) {
        return ItemBlock.func_179224_a(p_195943_2_, p_195943_3_, p_195943_1_, p_195943_4_);
    }

    @Nullable
    protected IBlockState func_195945_b(BlockItemUseContext p_195945_1_) {
        IBlockState iblockstate = this.func_179223_d().func_196258_a(p_195945_1_);
        return iblockstate != null && this.func_195944_a(p_195945_1_, iblockstate) ? iblockstate : null;
    }

    protected boolean func_195944_a(BlockItemUseContext p_195944_1_, IBlockState p_195944_2_) {
        return p_195944_2_.func_196955_c(p_195944_1_.func_195991_k(), p_195944_1_.func_195995_a()) && p_195944_1_.func_195991_k().func_195584_a(p_195944_2_, p_195944_1_.func_195995_a());
    }

    protected boolean func_195941_b(BlockItemUseContext p_195941_1_, IBlockState p_195941_2_) {
        return p_195941_1_.func_195991_k().func_180501_a(p_195941_1_.func_195995_a(), p_195941_2_, 11);
    }

    public static boolean func_179224_a(World worldIn, @Nullable EntityPlayer player, BlockPos pos, ItemStack stackIn) {
        TileEntity tileentity;
        MinecraftServer minecraftserver = worldIn.func_73046_m();
        if (minecraftserver == null) {
            return false;
        }
        NBTTagCompound nbttagcompound = stackIn.func_179543_a("BlockEntityTag");
        if (nbttagcompound != null && (tileentity = worldIn.func_175625_s(pos)) != null) {
            if (!(worldIn.field_72995_K || !tileentity.func_183000_F() || player != null && player.func_195070_dx())) {
                return false;
            }
            NBTTagCompound nbttagcompound1 = tileentity.func_189515_b(new NBTTagCompound());
            NBTTagCompound nbttagcompound2 = nbttagcompound1.func_74737_b();
            nbttagcompound1.func_197643_a(nbttagcompound);
            nbttagcompound1.func_74768_a("x", pos.func_177958_n());
            nbttagcompound1.func_74768_a("y", pos.func_177956_o());
            nbttagcompound1.func_74768_a("z", pos.func_177952_p());
            if (!nbttagcompound1.equals(nbttagcompound2)) {
                tileentity.func_145839_a(nbttagcompound1);
                tileentity.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public String func_77658_a() {
        return this.func_179223_d().func_149739_a();
    }

    @Override
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            this.func_179223_d().func_149666_a(group, items);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.func_179223_d().func_190948_a(stack, (IBlockReader)worldIn, tooltip, flagIn);
    }

    public Block func_179223_d() {
        return this.getBlockRaw() == null ? null : (Block)((Object)this.getBlockRaw().delegate.get());
    }

    private Block getBlockRaw() {
        return this.field_150939_a;
    }

    public void func_195946_a(Map<Block, Item> blockToItemMap, Item itemIn) {
        blockToItemMap.put(this.func_179223_d(), itemIn);
    }
}

