/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTiered;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemHoe
extends ItemTiered {
    private final float field_185072_b;
    protected static final Map<Block, IBlockState> field_195973_b = Maps.newHashMap((Map)ImmutableMap.of((Object)((Object)Blocks.field_196658_i), (Object)Blocks.field_150458_ak.func_176223_P(), (Object)((Object)Blocks.field_185774_da), (Object)Blocks.field_150458_ak.func_176223_P(), (Object)((Object)Blocks.field_150346_d), (Object)Blocks.field_150458_ak.func_176223_P(), (Object)((Object)Blocks.field_196660_k), (Object)Blocks.field_150346_d.func_176223_P()));

    public ItemHoe(IItemTier tier, float p_i48488_2_, Item.Properties builder) {
        super(tier, builder);
        this.field_185072_b = p_i48488_2_;
    }

    public EnumActionResult func_195939_a(ItemUseContext p_195939_1_) {
        IBlockState iblockstate;
        World world = p_195939_1_.func_195991_k();
        BlockPos blockpos = p_195939_1_.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)p_195939_1_);
        if (hook != 0) {
            return hook > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (p_195939_1_.func_196000_l() != EnumFacing.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (iblockstate = field_195973_b.get((Object)world.func_180495_p(blockpos).func_177230_c())) != null) {
            EntityPlayer entityplayer = p_195939_1_.func_195999_j();
            world.func_184133_a(entityplayer, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, iblockstate, 11);
                if (entityplayer != null) {
                    p_195939_1_.func_195996_i().func_77972_a(1, entityplayer);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.field_185072_b, 0));
        }
        return multimap;
    }
}

