/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.datasync;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;

public class DataSerializers {
    private static final IntIdentityHashBiMap<DataSerializer<?>> field_187204_n = new IntIdentityHashBiMap(16);
    public static final DataSerializer<Byte> field_187191_a = new DataSerializer<Byte>(){

        public void func_187160_a(PacketBuffer buf, Byte value) {
            buf.writeByte(value.byteValue());
        }

        public Byte func_187159_a(PacketBuffer buf) {
            return buf.readByte();
        }

        public DataParameter<Byte> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Byte func_192717_a(Byte value) {
            return value;
        }
    };
    public static final DataSerializer<Integer> field_187192_b = new DataSerializer<Integer>(){

        public void func_187160_a(PacketBuffer buf, Integer value) {
            buf.func_150787_b(value);
        }

        public Integer func_187159_a(PacketBuffer buf) {
            return buf.func_150792_a();
        }

        public DataParameter<Integer> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Integer func_192717_a(Integer value) {
            return value;
        }
    };
    public static final DataSerializer<Float> field_187193_c = new DataSerializer<Float>(){

        public void func_187160_a(PacketBuffer buf, Float value) {
            buf.writeFloat(value.floatValue());
        }

        public Float func_187159_a(PacketBuffer buf) {
            return Float.valueOf(buf.readFloat());
        }

        public DataParameter<Float> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Float func_192717_a(Float value) {
            return value;
        }
    };
    public static final DataSerializer<String> field_187194_d = new DataSerializer<String>(){

        public void func_187160_a(PacketBuffer buf, String value) {
            buf.func_180714_a(value);
        }

        public String func_187159_a(PacketBuffer buf) {
            return buf.func_150789_c(Short.MAX_VALUE);
        }

        public DataParameter<String> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public String func_192717_a(String value) {
            return value;
        }
    };
    public static final DataSerializer<ITextComponent> field_187195_e = new DataSerializer<ITextComponent>(){

        public void func_187160_a(PacketBuffer buf, ITextComponent value) {
            buf.func_179256_a(value);
        }

        public ITextComponent func_187159_a(PacketBuffer buf) {
            return buf.func_179258_d();
        }

        public DataParameter<ITextComponent> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public ITextComponent func_192717_a(ITextComponent value) {
            return value.func_212638_h();
        }
    };
    public static final DataSerializer<Optional<ITextComponent>> field_200544_f = new DataSerializer<Optional<ITextComponent>>(){

        public void func_187160_a(PacketBuffer buf, Optional<ITextComponent> value) {
            if (value.isPresent()) {
                buf.writeBoolean(true);
                buf.func_179256_a(value.get());
            } else {
                buf.writeBoolean(false);
            }
        }

        public Optional<ITextComponent> func_187159_a(PacketBuffer buf) {
            return buf.readBoolean() ? Optional.of(buf.func_179258_d()) : Optional.empty();
        }

        public DataParameter<Optional<ITextComponent>> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Optional<ITextComponent> func_192717_a(Optional<ITextComponent> value) {
            return value.isPresent() ? Optional.of(value.get().func_212638_h()) : Optional.empty();
        }
    };
    public static final DataSerializer<ItemStack> field_187196_f = new DataSerializer<ItemStack>(){

        public void func_187160_a(PacketBuffer buf, ItemStack value) {
            buf.func_150788_a(value);
        }

        public ItemStack func_187159_a(PacketBuffer buf) {
            return buf.func_150791_c();
        }

        public DataParameter<ItemStack> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public ItemStack func_192717_a(ItemStack value) {
            return value.func_77946_l();
        }
    };
    public static final DataSerializer<Optional<IBlockState>> field_187197_g = new DataSerializer<Optional<IBlockState>>(){

        public void func_187160_a(PacketBuffer buf, Optional<IBlockState> value) {
            if (value.isPresent()) {
                buf.func_150787_b(Block.func_196246_j(value.get()));
            } else {
                buf.func_150787_b(0);
            }
        }

        public Optional<IBlockState> func_187159_a(PacketBuffer buf) {
            int i = buf.func_150792_a();
            return i == 0 ? Optional.empty() : Optional.of(Block.func_196257_b(i));
        }

        public DataParameter<Optional<IBlockState>> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Optional<IBlockState> func_192717_a(Optional<IBlockState> value) {
            return value;
        }
    };
    public static final DataSerializer<Boolean> field_187198_h = new DataSerializer<Boolean>(){

        public void func_187160_a(PacketBuffer buf, Boolean value) {
            buf.writeBoolean(value);
        }

        public Boolean func_187159_a(PacketBuffer buf) {
            return buf.readBoolean();
        }

        public DataParameter<Boolean> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Boolean func_192717_a(Boolean value) {
            return value;
        }
    };
    public static final DataSerializer<IParticleData> field_198166_i = new DataSerializer<IParticleData>(){

        public void func_187160_a(PacketBuffer buf, IParticleData value) {
            buf.func_150787_b(IRegistry.field_212632_u.func_148757_b((ParticleType<? extends IParticleData>)value.func_197554_b()));
            value.func_197553_a(buf);
        }

        public IParticleData func_187159_a(PacketBuffer buf) {
            return this.func_200543_a(buf, IRegistry.field_212632_u.func_148754_a(buf.func_150792_a()));
        }

        private <T extends IParticleData> T func_200543_a(PacketBuffer p_200543_1_, ParticleType<T> p_200543_2_) {
            return (T)p_200543_2_.func_197571_g().func_197543_b(p_200543_2_, p_200543_1_);
        }

        public DataParameter<IParticleData> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public IParticleData func_192717_a(IParticleData value) {
            return value;
        }
    };
    public static final DataSerializer<Rotations> field_187199_i = new DataSerializer<Rotations>(){

        public void func_187160_a(PacketBuffer buf, Rotations value) {
            buf.writeFloat(value.func_179415_b());
            buf.writeFloat(value.func_179416_c());
            buf.writeFloat(value.func_179413_d());
        }

        public Rotations func_187159_a(PacketBuffer buf) {
            return new Rotations(buf.readFloat(), buf.readFloat(), buf.readFloat());
        }

        public DataParameter<Rotations> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Rotations func_192717_a(Rotations value) {
            return value;
        }
    };
    public static final DataSerializer<BlockPos> field_187200_j = new DataSerializer<BlockPos>(){

        public void func_187160_a(PacketBuffer buf, BlockPos value) {
            buf.func_179255_a(value);
        }

        public BlockPos func_187159_a(PacketBuffer buf) {
            return buf.func_179259_c();
        }

        public DataParameter<BlockPos> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public BlockPos func_192717_a(BlockPos value) {
            return value;
        }
    };
    public static final DataSerializer<Optional<BlockPos>> field_187201_k = new DataSerializer<Optional<BlockPos>>(){

        public void func_187160_a(PacketBuffer buf, Optional<BlockPos> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.func_179255_a(value.get());
            }
        }

        public Optional<BlockPos> func_187159_a(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(buf.func_179259_c());
        }

        public DataParameter<Optional<BlockPos>> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Optional<BlockPos> func_192717_a(Optional<BlockPos> value) {
            return value;
        }
    };
    public static final DataSerializer<EnumFacing> field_187202_l = new DataSerializer<EnumFacing>(){

        public void func_187160_a(PacketBuffer buf, EnumFacing value) {
            buf.func_179249_a(value);
        }

        public EnumFacing func_187159_a(PacketBuffer buf) {
            return buf.func_179257_a(EnumFacing.class);
        }

        public DataParameter<EnumFacing> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public EnumFacing func_192717_a(EnumFacing value) {
            return value;
        }
    };
    public static final DataSerializer<Optional<UUID>> field_187203_m = new DataSerializer<Optional<UUID>>(){

        public void func_187160_a(PacketBuffer buf, Optional<UUID> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                buf.func_179252_a(value.get());
            }
        }

        public Optional<UUID> func_187159_a(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(buf.func_179253_g());
        }

        public DataParameter<Optional<UUID>> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Optional<UUID> func_192717_a(Optional<UUID> value) {
            return value;
        }
    };
    public static final DataSerializer<NBTTagCompound> field_192734_n = new DataSerializer<NBTTagCompound>(){

        public void func_187160_a(PacketBuffer buf, NBTTagCompound value) {
            buf.func_150786_a(value);
        }

        public NBTTagCompound func_187159_a(PacketBuffer buf) {
            return buf.func_150793_b();
        }

        public DataParameter<NBTTagCompound> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public NBTTagCompound func_192717_a(NBTTagCompound value) {
            return value.func_74737_b();
        }
    };

    public static void func_187189_a(DataSerializer<?> serializer) {
        if (field_187204_n.func_186808_c(serializer) >= 256) {
            throw new RuntimeException("Vanilla DataSerializer ID limit exceeded");
        }
    }

    @Nullable
    public static DataSerializer<?> func_187190_a(int id) {
        return ForgeHooks.getSerializer((int)id, field_187204_n);
    }

    public static int func_187188_b(DataSerializer<?> serializer) {
        return ForgeHooks.getSerializerId(serializer, field_187204_n);
    }

    static {
        DataSerializers.func_187189_a(field_187191_a);
        DataSerializers.func_187189_a(field_187192_b);
        DataSerializers.func_187189_a(field_187193_c);
        DataSerializers.func_187189_a(field_187194_d);
        DataSerializers.func_187189_a(field_187195_e);
        DataSerializers.func_187189_a(field_200544_f);
        DataSerializers.func_187189_a(field_187196_f);
        DataSerializers.func_187189_a(field_187198_h);
        DataSerializers.func_187189_a(field_187199_i);
        DataSerializers.func_187189_a(field_187200_j);
        DataSerializers.func_187189_a(field_187201_k);
        DataSerializers.func_187189_a(field_187202_l);
        DataSerializers.func_187189_a(field_187203_m);
        DataSerializers.func_187189_a(field_187197_g);
        DataSerializers.func_187189_a(field_192734_n);
        DataSerializers.func_187189_a(field_198166_i);
    }
}

