/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;
import net.minecraftforge.resource.SelectiveReloadStateHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimpleReloadableResourceManager
implements IReloadableResourceManager {
    private static final Logger field_199012_a = LogManager.getLogger();
    private final Map<String, FallbackResourceManager> field_199014_c = Maps.newHashMap();
    private final List<IResourceManagerReloadListener> field_199015_d = Lists.newArrayList();
    private final Set<String> field_199016_e = Sets.newLinkedHashSet();
    private final ResourcePackType field_199017_f;

    public SimpleReloadableResourceManager(ResourcePackType typeIn) {
        this.field_199017_f = typeIn;
    }

    public void func_199009_a(IResourcePack resourcePack) {
        for (String s : resourcePack.func_195759_a(this.field_199017_f)) {
            this.field_199016_e.add(s);
            FallbackResourceManager fallbackresourcemanager = this.field_199014_c.get(s);
            if (fallbackresourcemanager == null) {
                fallbackresourcemanager = new FallbackResourceManager(this.field_199017_f);
                this.field_199014_c.put(s, fallbackresourcemanager);
            }
            fallbackresourcemanager.func_199021_a(resourcePack);
        }
    }

    public Set<String> func_199001_a() {
        return this.field_199016_e;
    }

    public IResource func_199002_a(ResourceLocation resourceLocationIn) throws IOException {
        IResourceManager iresourcemanager = (IResourceManager)this.field_199014_c.get(resourceLocationIn.func_110624_b());
        if (iresourcemanager != null) {
            return iresourcemanager.func_199002_a(resourceLocationIn);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    public List<IResource> func_199004_b(ResourceLocation resourceLocationIn) throws IOException {
        IResourceManager iresourcemanager = (IResourceManager)this.field_199014_c.get(resourceLocationIn.func_110624_b());
        if (iresourcemanager != null) {
            return iresourcemanager.func_199004_b(resourceLocationIn);
        }
        throw new FileNotFoundException(resourceLocationIn.toString());
    }

    public Collection<ResourceLocation> func_199003_a(String pathIn, Predicate<String> filter) {
        HashSet set = Sets.newHashSet();
        for (FallbackResourceManager fallbackresourcemanager : this.field_199014_c.values()) {
            set.addAll(fallbackresourcemanager.func_199003_a(pathIn, filter));
        }
        ArrayList list = Lists.newArrayList((Iterable)set);
        Collections.sort(list);
        return list;
    }

    private void func_199008_b() {
        this.field_199014_c.clear();
        this.field_199016_e.clear();
    }

    public void func_199005_a(List<IResourcePack> resourcePacks) {
        try (ProgressBar resReload = StartupProgressManager.start((String)"Loading Resources", (int)(resourcePacks.size() + 1), (boolean)true);){
            this.func_199008_b();
            field_199012_a.info("Reloading ResourceManager: {}", (Object)resourcePacks.stream().map(IResourcePack::func_195762_a).collect(Collectors.joining(", ")));
            for (IResourcePack iresourcepack : resourcePacks) {
                resReload.step(iresourcepack.func_195762_a());
                this.func_199009_a(iresourcepack);
            }
            resReload.step("Reloading listeners");
            if (field_199012_a.isDebugEnabled()) {
                this.func_199011_d();
            } else {
                this.func_199010_c();
            }
        }
    }

    public void func_199006_a(IResourceManagerReloadListener reloadListener) {
        try (ProgressBar resReload = StartupProgressManager.start((String)"Loading Resource", (int)1);){
            resReload.step(reloadListener.getClass(), new String[0]);
            this.field_199015_d.add(reloadListener);
            if (field_199012_a.isDebugEnabled()) {
                field_199012_a.info(this.func_199007_b(reloadListener));
            } else {
                reloadListener.func_195410_a((IResourceManager)((Object)this));
            }
        }
    }

    private void func_199010_c() {
        try (ProgressBar resReload = StartupProgressManager.start((String)"Reloading", (int)this.field_199015_d.size());){
            for (IResourceManagerReloadListener iresourcemanagerreloadlistener : this.field_199015_d) {
                resReload.step(iresourcemanagerreloadlistener.getClass(), new String[0]);
                if (!SelectiveReloadStateHandler.INSTANCE.test(iresourcemanagerreloadlistener)) continue;
                iresourcemanagerreloadlistener.func_195410_a((IResourceManager)((Object)this));
            }
        }
    }

    private void func_199011_d() {
        field_199012_a.info("Reloading all resources! {} listeners to update.", (Object)this.field_199015_d.size());
        ArrayList list = Lists.newArrayList();
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (IResourceManagerReloadListener iresourcemanagerreloadlistener : this.field_199015_d) {
            list.add(this.func_199007_b(iresourcemanagerreloadlistener));
        }
        stopwatch.stop();
        field_199012_a.info("----");
        field_199012_a.info("Complete resource reload took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        for (String s : list) {
            field_199012_a.info(s);
        }
        field_199012_a.info("----");
    }

    private String func_199007_b(IResourceManagerReloadListener reloadListener) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        reloadListener.func_195410_a((IResourceManager)((Object)this));
        stopwatch.stop();
        return "Resource reload for " + reloadListener.getClass().getSimpleName() + " took " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms";
    }
}

