/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.regex.Pattern;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConConsoleSource;
import net.minecraft.network.rcon.RConThreadMain;
import net.minecraft.network.rcon.RConThreadQuery;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerEula;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraft.server.dedicated.PropertyManager;
import net.minecraft.server.dedicated.ServerHangWatchdog;
import net.minecraft.server.gui.MinecraftServerGui;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.CryptManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.DefaultUncaughtExceptionHandlerWithName;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.fml.server.ServerModLoader;
import net.minecraftforge.server.console.TerminalHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DedicatedServer
extends MinecraftServer
implements IServer {
    private static final Logger field_155771_h = LogManager.getLogger();
    private static final Pattern field_189647_l = Pattern.compile("^[a-fA-F0-9]{40}$");
    public final List<PendingCommand> field_71341_l = Collections.synchronizedList(Lists.newArrayList());
    private RConThreadQuery field_71342_m;
    private final RConConsoleSource field_184115_n = new RConConsoleSource((MinecraftServer)this);
    private RConThreadMain field_71339_n;
    private PropertyManager field_71340_o;
    private ServerEula field_154332_n;
    private boolean field_71338_p;
    private GameType field_71337_q;
    private boolean field_71335_s;

    public DedicatedServer(File p_i49693_1_, DataFixer p_i49693_2_, YggdrasilAuthenticationService p_i49693_3_, MinecraftSessionService p_i49693_4_, GameProfileRepository p_i49693_5_, PlayerProfileCache p_i49693_6_) {
        super(p_i49693_1_, Proxy.NO_PROXY, p_i49693_2_, new Commands(true), p_i49693_3_, p_i49693_4_, p_i49693_5_, p_i49693_6_);
        Thread thread = new Thread("Server Infinisleeper"){
            {
                this.setDaemon(true);
                this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_155771_h));
                this.start();
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Integer.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
    }

    @Override
    public boolean func_71197_b() throws IOException {
        WorldType worldtype;
        Thread thread = new Thread("Server console handler"){

            @Override
            public void run() {
                if (TerminalHandler.handleCommands((DedicatedServer)DedicatedServer.this)) {
                    return;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
                try {
                    String s4;
                    while (!DedicatedServer.this.func_71241_aa() && DedicatedServer.this.func_71278_l() && (s4 = bufferedreader.readLine()) != null) {
                        DedicatedServer.this.func_195581_a(s4, DedicatedServer.this.func_195573_aM());
                    }
                }
                catch (IOException ioexception1) {
                    field_155771_h.error("Exception handling console input", (Throwable)ioexception1);
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_155771_h));
        thread.start();
        field_155771_h.info("Starting minecraft server version 1.13.2");
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            field_155771_h.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        ServerModLoader.begin((DedicatedServer)this);
        field_155771_h.info("Loading properties");
        this.field_71340_o = new PropertyManager(new File("server.properties"));
        this.field_154332_n = new ServerEula(new File("eula.txt"));
        if (!this.field_154332_n.func_154346_a()) {
            field_155771_h.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
            this.field_154332_n.func_154348_b();
            return false;
        }
        if (this.func_71264_H()) {
            this.func_71189_e("127.0.0.1");
        } else {
            this.func_71229_d(this.field_71340_o.func_73670_a("online-mode", true));
            this.func_190517_e(this.field_71340_o.func_73670_a("prevent-proxy-connections", false));
            this.func_71189_e(this.field_71340_o.func_73671_a("server-ip", ""));
        }
        this.func_71251_e(this.field_71340_o.func_73670_a("spawn-animals", true));
        this.func_71257_f(this.field_71340_o.func_73670_a("spawn-npcs", true));
        this.func_71188_g(this.field_71340_o.func_73670_a("pvp", true));
        this.func_71245_h(this.field_71340_o.func_73670_a("allow-flight", false));
        this.func_180507_a_(this.field_71340_o.func_73671_a("resource-pack", ""), this.func_184113_aK());
        this.func_71205_p(this.field_71340_o.func_73671_a("motd", "A Minecraft Server"));
        this.func_104055_i(this.field_71340_o.func_73670_a("force-gamemode", false));
        this.func_143006_e(this.field_71340_o.func_73669_a("player-idle-timeout", 0));
        this.func_205741_k(this.field_71340_o.func_73670_a("enforce-whitelist", false));
        if (this.field_71340_o.func_73669_a("difficulty", 1) < 0) {
            this.field_71340_o.func_73667_a("difficulty", (Object)0);
        } else if (this.field_71340_o.func_73669_a("difficulty", 1) > 3) {
            this.field_71340_o.func_73667_a("difficulty", (Object)3);
        }
        this.field_71338_p = this.field_71340_o.func_73670_a("generate-structures", true);
        int i = this.field_71340_o.func_73669_a("gamemode", GameType.SURVIVAL.func_77148_a());
        this.field_71337_q = WorldSettings.func_77161_a((int)i);
        field_155771_h.info("Default game type: {}", (Object)this.field_71337_q);
        InetAddress inetaddress = null;
        if (!this.func_71211_k().isEmpty()) {
            inetaddress = InetAddress.getByName(this.func_71211_k());
        }
        if (this.func_71215_F() < 0) {
            this.func_71208_b(this.field_71340_o.func_73669_a("server-port", 25565));
        }
        field_155771_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        field_155771_h.info("Starting Minecraft server on {}:{}", (Object)(this.func_71211_k().isEmpty() ? "*" : this.func_71211_k()), (Object)this.func_71215_F());
        try {
            this.func_147137_ag().func_151265_a(inetaddress, this.func_71215_F());
        }
        catch (IOException ioexception) {
            field_155771_h.warn("**** FAILED TO BIND TO PORT!");
            field_155771_h.warn("The exception was: {}", (Object)ioexception.toString());
            field_155771_h.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.func_71266_T()) {
            field_155771_h.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            field_155771_h.warn("The server will make no attempt to authenticate usernames. Beware.");
            field_155771_h.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            field_155771_h.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        if (this.func_152368_aE()) {
            this.func_152358_ax().func_152658_c();
        }
        if (!PreYggdrasilConverter.func_152714_a((PropertyManager)this.field_71340_o)) {
            return false;
        }
        ServerModLoader.end();
        this.func_184105_a((PlayerList)new DedicatedPlayerList(this));
        long j = Util.func_211178_c();
        if (this.func_71270_I() == null) {
            this.func_71261_m(this.field_71340_o.func_73671_a("level-name", "world"));
        }
        String s = this.field_71340_o.func_73671_a("level-seed", "");
        String s1 = this.field_71340_o.func_73671_a("level-type", "DEFAULT");
        String s2 = this.field_71340_o.func_73671_a("generator-settings", "");
        long k = new Random().nextLong();
        if (!s.isEmpty()) {
            try {
                long l = Long.parseLong(s);
                if (l != 0L) {
                    k = l;
                }
            }
            catch (NumberFormatException var17) {
                k = s.hashCode();
            }
        }
        if ((worldtype = WorldType.func_77130_a(s1)) == null) {
            worldtype = WorldType.field_77137_b;
        }
        this.func_82356_Z();
        this.func_110455_j();
        this.func_70002_Q();
        this.func_175577_aI();
        this.func_71191_d(this.field_71340_o.func_73669_a("max-build-height", 256));
        this.func_71191_d((this.func_71207_Z() + 8) / 16 * 16);
        this.func_71191_d(MathHelper.func_76125_a((int)this.func_71207_Z(), (int)64, (int)256));
        this.field_71340_o.func_73667_a("max-build-height", (Object)this.func_71207_Z());
        TileEntitySkull.func_184293_a((PlayerProfileCache)this.func_152358_ax());
        TileEntitySkull.func_184294_a((MinecraftSessionService)this.func_147130_as());
        PlayerProfileCache.func_187320_a((boolean)this.func_71266_T());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        field_155771_h.info("Preparing level \"{}\"", (Object)this.func_71270_I());
        JsonObject jsonobject = new JsonObject();
        if (worldtype == WorldType.field_77138_c) {
            jsonobject.addProperty("flat_world_options", s2);
        } else if (!s2.isEmpty()) {
            jsonobject = JsonUtils.func_212745_a((String)s2);
        }
        this.func_71247_a(this.func_71270_I(), this.func_71270_I(), k, worldtype, (JsonElement)jsonobject);
        long i1 = Util.func_211178_c() - j;
        String s3 = String.format(Locale.ROOT, "%.3fs", (double)i1 / 1.0E9);
        field_155771_h.info("Done ({})! For help, type \"help\"", (Object)s3);
        this.field_211151_aa = Util.func_211177_b();
        if (this.field_71340_o.func_187239_a("announce-player-achievements")) {
            this.func_200252_aR().func_82764_b("announceAdvancements", this.field_71340_o.func_73670_a("announce-player-achievements", true) ? "true" : "false", (MinecraftServer)this);
            this.field_71340_o.func_187238_b("announce-player-achievements");
            this.field_71340_o.func_73668_b();
        }
        if (this.field_71340_o.func_73670_a("enable-query", false)) {
            field_155771_h.info("Starting GS4 status listener");
            this.field_71342_m = new RConThreadQuery((IServer)this);
            this.field_71342_m.func_72602_a();
        }
        if (this.field_71340_o.func_73670_a("enable-rcon", false)) {
            field_155771_h.info("Starting remote control listener");
            this.field_71339_n = new RConThreadMain((IServer)this);
            this.field_71339_n.func_72602_a();
        }
        if (this.func_175593_aQ() > 0L) {
            Thread thread1 = new Thread(new ServerHangWatchdog(this));
            thread1.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandlerWithName(field_155771_h));
            thread1.setName("Server Watchdog");
            thread1.setDaemon(true);
            thread1.start();
        }
        Items.field_190931_a.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)NonNullList.func_191196_a());
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    public String func_184113_aK() {
        String s;
        if (this.field_71340_o.func_187239_a("resource-pack-hash")) {
            if (this.field_71340_o.func_187239_a("resource-pack-sha1")) {
                field_155771_h.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            } else {
                field_155771_h.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
                this.field_71340_o.func_73671_a("resource-pack-sha1", this.field_71340_o.func_73671_a("resource-pack-hash", ""));
                this.field_71340_o.func_187238_b("resource-pack-hash");
            }
        }
        if (!(s = this.field_71340_o.func_73671_a("resource-pack-sha1", "")).isEmpty() && !field_189647_l.matcher(s).matches()) {
            field_155771_h.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!this.field_71340_o.func_73671_a("resource-pack", "").isEmpty() && s.isEmpty()) {
            field_155771_h.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return s;
    }

    @Override
    public void func_71235_a(GameType gameMode) {
        super.func_71235_a(gameMode);
        this.field_71337_q = gameMode;
    }

    @Override
    public boolean func_71225_e() {
        return this.field_71338_p;
    }

    @Override
    public GameType func_71265_f() {
        return this.field_71337_q;
    }

    @Override
    public EnumDifficulty func_147135_j() {
        return EnumDifficulty.func_151523_a((int)this.field_71340_o.func_73669_a("difficulty", EnumDifficulty.NORMAL.func_151525_a()));
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71340_o.func_73670_a("hardcore", false);
    }

    @Override
    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = this.getServerModName();
            return !"vanilla".equals(s) ? "Definitely; Server brand changed to '" + s + "'" : "Unknown (can't tell)";
        }));
        report.func_85056_g().func_189529_a("Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> "Dedicated Server (map_server.txt)"));
        return report;
    }

    @Override
    public void func_71240_o() {
        System.exit(0);
    }

    @Override
    public void func_71190_q(BooleanSupplier p_71190_1_) {
        super.func_71190_q(p_71190_1_);
        this.func_71333_ah();
    }

    @Override
    public boolean func_71255_r() {
        return this.field_71340_o.func_73670_a("allow-nether", true);
    }

    @Override
    public boolean func_71193_K() {
        return this.field_71340_o.func_73670_a("spawn-monsters", true);
    }

    @Override
    public void func_70000_a(Snooper playerSnooper) {
        playerSnooper.func_152768_a("whitelist_enabled", (Object)this.func_184103_al().func_72383_n());
        playerSnooper.func_152768_a("whitelist_count", (Object)this.func_184103_al().func_152598_l().length);
        super.func_70000_a(playerSnooper);
    }

    @Override
    public boolean func_70002_Q() {
        if (this.field_71340_o.func_73670_a("snooper-enabled", true)) {
            // empty if block
        }
        return false;
    }

    public void func_195581_a(String p_195581_1_, CommandSource p_195581_2_) {
        this.field_71341_l.add(new PendingCommand(p_195581_1_, p_195581_2_));
    }

    public void func_71333_ah() {
        while (!this.field_71341_l.isEmpty()) {
            PendingCommand pendingcommand = this.field_71341_l.remove(0);
            this.func_195571_aL().func_197059_a(pendingcommand.field_73701_b, pendingcommand.field_73702_a);
        }
    }

    @Override
    public boolean func_71262_S() {
        return true;
    }

    @Override
    public boolean func_181035_ah() {
        return this.field_71340_o.func_73670_a("use-native-transport", true);
    }

    public DedicatedPlayerList func_184103_al() {
        return (DedicatedPlayerList)super.func_184103_al();
    }

    @Override
    public boolean func_71344_c() {
        return true;
    }

    public int func_71327_a(String key, int defaultValue) {
        return this.field_71340_o.func_73669_a(key, defaultValue);
    }

    public String func_71330_a(String key, String defaultValue) {
        return this.field_71340_o.func_73671_a(key, defaultValue);
    }

    public boolean func_71332_a(String key, boolean defaultValue) {
        return this.field_71340_o.func_73670_a(key, defaultValue);
    }

    public void func_71328_a(String key, Object value) {
        this.field_71340_o.func_73667_a(key, value);
    }

    public void func_71326_a() {
        this.field_71340_o.func_73668_b();
    }

    public String func_71329_c() {
        File file1 = this.field_71340_o.func_73665_c();
        return file1 != null ? file1.getAbsolutePath() : "No settings file";
    }

    public String func_71277_t() {
        return this.func_71211_k();
    }

    public int func_71234_u() {
        return this.func_71215_F();
    }

    public String func_71274_v() {
        return this.func_71273_Y();
    }

    public void func_120011_ar() {
        MinecraftServerGui.func_120016_a(this);
        this.field_71335_s = true;
    }

    @Override
    public boolean func_71279_ae() {
        return this.field_71335_s;
    }

    @Override
    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        return false;
    }

    @Override
    public boolean func_82356_Z() {
        return this.field_71340_o.func_73670_a("enable-command-block", false);
    }

    @Override
    public int func_82357_ak() {
        return this.field_71340_o.func_73669_a("spawn-protection", super.func_82357_ak());
    }

    @Override
    public boolean func_175579_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        int j;
        if (worldIn.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return false;
        }
        if (this.func_184103_al().func_152603_m().func_152690_d()) {
            return false;
        }
        if (this.func_184103_al().func_152596_g(playerIn.func_146103_bH())) {
            return false;
        }
        if (this.func_82357_ak() <= 0) {
            return false;
        }
        BlockPos blockpos = worldIn.func_175694_M();
        int i = MathHelper.func_76130_a((int)(pos.func_177958_n() - blockpos.func_177958_n()));
        int k = Math.max(i, j = MathHelper.func_76130_a((int)(pos.func_177952_p() - blockpos.func_177952_p())));
        return k <= this.func_82357_ak();
    }

    @Override
    public int func_110455_j() {
        return this.field_71340_o.func_73669_a("op-permission-level", 4);
    }

    @Override
    public void func_143006_e(int idleTimeout) {
        super.func_143006_e(idleTimeout);
        this.field_71340_o.func_73667_a("player-idle-timeout", (Object)idleTimeout);
        this.func_71326_a();
    }

    @Override
    public boolean func_195569_l() {
        return this.field_71340_o.func_73670_a("broadcast-rcon-to-ops", true);
    }

    public boolean func_195041_r_() {
        return this.field_71340_o.func_73670_a("broadcast-console-to-ops", true);
    }

    @Override
    public int func_175580_aG() {
        int i = this.field_71340_o.func_73669_a("max-world-size", super.func_175580_aG());
        if (i < 1) {
            i = 1;
        } else if (i > super.func_175580_aG()) {
            i = super.func_175580_aG();
        }
        return i;
    }

    @Override
    public int func_175577_aI() {
        return this.field_71340_o.func_73669_a("network-compression-threshold", super.func_175577_aI());
    }

    protected boolean func_152368_aE() {
        boolean flag = false;
        for (int i = 0; !flag && i <= 2; ++i) {
            if (i > 0) {
                field_155771_h.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag = PreYggdrasilConverter.func_152724_a((MinecraftServer)this);
        }
        boolean flag1 = false;
        for (int j = 0; !flag1 && j <= 2; ++j) {
            if (j > 0) {
                field_155771_h.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag1 = PreYggdrasilConverter.func_152722_b((MinecraftServer)this);
        }
        boolean flag2 = false;
        for (int k = 0; !flag2 && k <= 2; ++k) {
            if (k > 0) {
                field_155771_h.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag2 = PreYggdrasilConverter.func_152718_c((MinecraftServer)this);
        }
        boolean flag3 = false;
        for (int l = 0; !flag3 && l <= 2; ++l) {
            if (l > 0) {
                field_155771_h.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag3 = PreYggdrasilConverter.func_152710_d((MinecraftServer)this);
        }
        boolean flag4 = false;
        for (int i1 = 0; !flag4 && i1 <= 2; ++i1) {
            if (i1 > 0) {
                field_155771_h.warn("Encountered a problem while converting the player save files, retrying in a few seconds");
                this.func_152369_aG();
            }
            flag4 = PreYggdrasilConverter.func_152723_a((DedicatedServer)this, (PropertyManager)this.field_71340_o);
        }
        return flag || flag1 || flag2 || flag3 || flag4;
    }

    private void func_152369_aG() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long func_175593_aQ() {
        return this.field_71340_o.func_179885_a("max-tick-time", TimeUnit.MINUTES.toMillis(1L));
    }

    public String func_71258_A() {
        return "";
    }

    public String func_71252_i(String command) {
        this.field_184115_n.func_70007_b();
        this.func_195571_aL().func_197059_a(this.field_184115_n.func_195540_f(), command);
        return this.field_184115_n.func_70008_c();
    }

    @Override
    public void func_145747_a(ITextComponent message) {
        field_155771_h.info(message.func_150254_d());
    }
}

