/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerShulkerBox;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityShulkerBox
extends TileEntityLockableLoot
implements ISidedInventory,
ITickable {
    private static final int[] field_190595_a = IntStream.range(0, 27).toArray();
    private NonNullList<ItemStack> field_190596_f = NonNullList.func_191197_a((int)27, (Object)((Object)ItemStack.field_190927_a));
    private boolean field_190597_g;
    private int field_190598_h;
    private AnimationStatus field_190599_i = AnimationStatus.CLOSED;
    private float field_190600_j;
    private float field_190601_k;
    private EnumDyeColor field_190602_l;
    private boolean field_204400_o;
    private boolean field_190594_p;

    public TileEntityShulkerBox(@Nullable EnumDyeColor colorIn) {
        super(TileEntityType.field_200993_x);
        this.field_190602_l = colorIn;
    }

    public TileEntityShulkerBox() {
        this((EnumDyeColor)null);
        this.field_204400_o = true;
    }

    public void func_73660_a() {
        this.func_190583_o();
        if (this.field_190599_i == AnimationStatus.OPENING || this.field_190599_i == AnimationStatus.CLOSING) {
            this.func_190589_G();
        }
    }

    protected void func_190583_o() {
        this.field_190601_k = this.field_190600_j;
        switch (this.field_190599_i) {
            case CLOSED: {
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENING: {
                this.field_190600_j += 0.1f;
                if (!(this.field_190600_j >= 1.0f)) break;
                this.func_190589_G();
                this.field_190599_i = AnimationStatus.OPENED;
                this.field_190600_j = 1.0f;
                break;
            }
            case CLOSING: {
                this.field_190600_j -= 0.1f;
                if (!(this.field_190600_j <= 0.0f)) break;
                this.field_190599_i = AnimationStatus.CLOSED;
                this.field_190600_j = 0.0f;
                break;
            }
            case OPENED: {
                this.field_190600_j = 1.0f;
            }
        }
    }

    public AnimationStatus func_190591_p() {
        return this.field_190599_i;
    }

    public AxisAlignedBB func_190584_a(IBlockState p_190584_1_) {
        return this.func_190587_b((EnumFacing)((Object)p_190584_1_.func_177229_b((IProperty)BlockShulkerBox.field_190957_a)));
    }

    public AxisAlignedBB func_190587_b(EnumFacing p_190587_1_) {
        return VoxelShapes.func_197868_b().func_197752_a().func_72321_a((double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_82601_c()), (double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_96559_d()), (double)(0.5f * this.func_190585_a(1.0f) * (float)p_190587_1_.func_82599_e()));
    }

    private AxisAlignedBB func_190588_c(EnumFacing p_190588_1_) {
        EnumFacing enumfacing = p_190588_1_.func_176734_d();
        return this.func_190587_b(p_190588_1_).func_191195_a((double)enumfacing.func_82601_c(), (double)enumfacing.func_96559_d(), (double)enumfacing.func_82599_e());
    }

    private void func_190589_G() {
        EnumFacing enumfacing;
        AxisAlignedBB axisalignedbb;
        List list;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (iblockstate.func_177230_c() instanceof BlockShulkerBox && !(list = this.field_145850_b.func_72839_b(null, axisalignedbb = this.func_190588_c(enumfacing = (EnumFacing)((Object)iblockstate.func_177229_b((IProperty)BlockShulkerBox.field_190957_a))).func_186670_a(this.field_174879_c))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)((Object)list.get(i));
                if (entity.func_184192_z() == EnumPushReaction.IGNORE) continue;
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                AxisAlignedBB axisalignedbb1 = entity.func_174813_aQ();
                switch (enumfacing.func_176740_k()) {
                    case X: {
                        d0 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72336_d - axisalignedbb1.field_72340_a : axisalignedbb1.field_72336_d - axisalignedbb.field_72340_a;
                        d0 += 0.01;
                        break;
                    }
                    case Y: {
                        d1 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72337_e - axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e - axisalignedbb.field_72338_b;
                        d1 += 0.01;
                        break;
                    }
                    case Z: {
                        d2 = enumfacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? axisalignedbb.field_72334_f - axisalignedbb1.field_72339_c : axisalignedbb1.field_72334_f - axisalignedbb.field_72339_c;
                        d2 += 0.01;
                    }
                }
                entity.func_70091_d(MoverType.SHULKER_BOX, d0 * (double)enumfacing.func_82601_c(), d1 * (double)enumfacing.func_96559_d(), d2 * (double)enumfacing.func_82599_e());
            }
        }
    }

    public int func_70302_i_() {
        return this.field_190596_f.size();
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.field_190598_h = type;
            if (type == 0) {
                this.field_190599_i = AnimationStatus.CLOSING;
            }
            if (type == 1) {
                this.field_190599_i = AnimationStatus.OPENING;
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_190598_h < 0) {
                this.field_190598_h = 0;
            }
            ++this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h == 1) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191262_fB, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            --this.field_190598_h;
            this.field_145850_b.func_175641_c(this.field_174879_c, this.func_195044_w().func_177230_c(), 1, this.field_190598_h);
            if (this.field_190598_h <= 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_191261_fA, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerShulkerBox(playerInventory, (IInventory)this, playerIn);
    }

    public String func_174875_k() {
        return "minecraft:shulker_box";
    }

    public ITextComponent func_200200_C_() {
        ITextComponent itextcomponent = this.func_200201_e();
        return itextcomponent != null ? itextcomponent : new TextComponentTranslation("container.shulkerBox", new Object[0]);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.func_190586_e(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.func_190580_f(compound);
    }

    public void func_190586_e(NBTTagCompound compound) {
        this.field_190596_f = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (!this.func_184283_b(compound) && compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.field_190596_f);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_190580_f(NBTTagCompound compound) {
        ITextComponent itextcomponent;
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.field_190596_f, (boolean)false);
        }
        if ((itextcomponent = this.func_200201_e()) != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)itextcomponent));
        }
        if (!compound.func_74764_b("Lock") && this.func_174893_q_()) {
            this.func_174891_i().func_180157_a(compound);
        }
        return compound;
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_190596_f;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.field_190596_f = itemsIn;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_190596_f) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return field_190595_a;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable EnumFacing direction) {
        return !(Block.func_149634_a(itemStackIn.func_77973_b()) instanceof BlockShulkerBox);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    @Override
    public void func_174888_l() {
        this.field_190597_g = true;
        super.func_174888_l();
    }

    public boolean func_190590_r() {
        return this.field_190597_g;
    }

    public float func_190585_a(float p_190585_1_) {
        return this.field_190601_k + (this.field_190600_j - this.field_190601_k) * p_190585_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public EnumDyeColor func_190592_s() {
        if (this.field_204400_o) {
            this.field_190602_l = BlockShulkerBox.func_190954_c((Block)this.func_195044_w().func_177230_c());
            this.field_204400_o = false;
        }
        return this.field_190602_l;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 10, this.func_189517_E_());
    }

    public boolean func_190581_E() {
        return this.field_190594_p;
    }

    public void func_190579_a(boolean p_190579_1_) {
        this.field_190594_p = p_190579_1_;
    }

    public boolean func_190582_F() {
        return !this.func_190581_E() || !this.func_191420_l() || this.func_145818_k_() || this.field_184284_m != null;
    }

    @Override
    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    }

    public static enum AnimationStatus {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

