/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Region
implements IWorldReader {
    protected int field_72818_a;
    protected int field_72816_b;
    protected Chunk[][] field_72817_c;
    protected boolean field_72814_d;
    protected World field_72815_e;

    public Region(World worldIn, BlockPos posFromIn, BlockPos posToIn, int subIn) {
        this.field_72815_e = worldIn;
        this.field_72818_a = posFromIn.func_177958_n() - subIn >> 4;
        this.field_72816_b = posFromIn.func_177952_p() - subIn >> 4;
        int i = posToIn.func_177958_n() + subIn >> 4;
        int j = posToIn.func_177952_p() + subIn >> 4;
        this.field_72817_c = new Chunk[i - this.field_72818_a + 1][j - this.field_72816_b + 1];
        this.field_72814_d = true;
        for (int k = this.field_72818_a; k <= i; ++k) {
            for (int l = this.field_72816_b; l <= j; ++l) {
                this.field_72817_c[k - this.field_72818_a][l - this.field_72816_b] = worldIn.func_72964_e(k, l);
            }
        }
        for (int i1 = posFromIn.func_177958_n() >> 4; i1 <= posToIn.func_177958_n() >> 4; ++i1) {
            for (int j1 = posFromIn.func_177952_p() >> 4; j1 <= posToIn.func_177952_p() >> 4; ++j1) {
                Chunk chunk = this.field_72817_c[i1 - this.field_72818_a][j1 - this.field_72816_b];
                if (chunk == null || chunk.func_76606_c(posFromIn.func_177956_o(), posToIn.func_177956_o())) continue;
                this.field_72814_d = false;
            }
        }
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity func_190300_a(BlockPos pos, Chunk.EnumCreateEntityType createType) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
            return null;
        }
        return this.field_72817_c[i][j].func_177424_a(pos, createType);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        int i = this.func_175629_a(EnumLightType.SKY, pos);
        int j = this.func_175629_a(EnumLightType.BLOCK, pos);
        if (j < lightValue) {
            j = lightValue;
        }
        return i << 20 | j << 4;
    }

    public float func_205052_D(BlockPos pos) {
        return this.field_72815_e.field_73011_w.func_177497_p()[this.func_201696_r(pos)];
    }

    public int func_205049_d(BlockPos pos, int amount) {
        if (this.func_180495_p(pos).func_200130_c((IBlockReader)this, pos)) {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.values()) {
                int j = this.func_201669_a(pos.func_177972_a(enumfacing), amount);
                if (j > i) {
                    i = j;
                }
                if (i < 15) continue;
                return i;
            }
            return i;
        }
        return this.func_201669_a(pos, amount);
    }

    public Dimension func_201675_m() {
        return this.field_72815_e.func_201675_m();
    }

    public int func_201669_a(BlockPos pos, int amount) {
        if (pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() <= 30000000) {
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                int k = 15 - amount;
                if (k < 0) {
                    k = 0;
                }
                return k;
            }
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            return this.field_72817_c[i][j].func_177443_a(pos, amount);
        }
        return 15;
    }

    public boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return this.func_205054_a(x, z);
    }

    public boolean func_175678_i(BlockPos pos) {
        return false;
    }

    public boolean func_205054_a(int p_205054_1_, int p_205054_2_) {
        int i = p_205054_1_ - this.field_72818_a;
        int j = p_205054_2_ - this.field_72816_b;
        return i >= 0 && i < this.field_72817_c.length && j >= 0 && j < this.field_72817_c[i].length;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        throw new RuntimeException("NOT IMPLEMENTED!");
    }

    public WorldBorder func_175723_af() {
        return this.field_72815_e.func_175723_af();
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        throw new RuntimeException("This method should never be called here. No entity logic inside Region");
    }

    @Nullable
    public EntityPlayer func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        throw new RuntimeException("This method should never be called here. No entity logic inside Region");
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            if (i >= 0 && i < this.field_72817_c.length && j >= 0 && j < this.field_72817_c[i].length && (chunk = this.field_72817_c[i][j]) != null) {
                return chunk.func_180495_p(pos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public IFluidState func_204610_c(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            int j = (pos.func_177952_p() >> 4) - this.field_72816_b;
            if (i >= 0 && i < this.field_72817_c.length && j >= 0 && j < this.field_72817_c[i].length && (chunk = this.field_72817_c[i][j]) != null) {
                return chunk.func_204610_c(pos);
            }
        }
        return Fluids.field_204541_a.func_207188_f();
    }

    public int func_175657_ab() {
        return 0;
    }

    public Biome func_180494_b(BlockPos pos) {
        int j;
        int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
        if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
            return Biomes.field_76772_c;
        }
        return this.field_72817_c[i][j].func_201600_k(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    private int func_175629_a(EnumLightType type, BlockPos pos) {
        if (type == EnumLightType.SKY && !this.field_72815_e.func_201675_m().func_191066_m()) {
            return 0;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            int j;
            if (this.func_180495_p(pos).func_200130_c((IBlockReader)this, pos)) {
                int l = 0;
                for (EnumFacing enumfacing : EnumFacing.values()) {
                    int k = this.func_175642_b(type, pos.func_177972_a(enumfacing));
                    if (k > l) {
                        l = k;
                    }
                    if (l < 15) continue;
                    return l;
                }
                return l;
            }
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
                return type.field_77198_c;
            }
            return this.field_72817_c[i][j].func_177413_a(type, pos);
        }
        return type.field_77198_c;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    public int func_175642_b(EnumLightType type, BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            int j;
            int i = (pos.func_177958_n() >> 4) - this.field_72818_a;
            if (!this.withinBounds(i, j = (pos.func_177952_p() >> 4) - this.field_72816_b)) {
                return type.field_77198_c;
            }
            return this.field_72817_c[i][j].func_177413_a(type, pos);
        }
        return type.field_77198_c;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public boolean func_201670_d() {
        throw new RuntimeException("Not yet implemented");
    }

    public int func_181545_F() {
        throw new RuntimeException("Not yet implemented");
    }

    private boolean withinBounds(int x, int z) {
        return x >= 0 && x < this.field_72817_c.length && z >= 0 && z < this.field_72817_c[x].length && this.field_72817_c[x][z] != null;
    }
}

