/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Random;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.ITeleporter;

public class Teleporter
implements ITeleporter {
    private static final BlockPortal field_196236_a = (BlockPortal)Blocks.field_150427_aO;
    protected final WorldServer field_85192_a;
    protected final Random field_77187_a;
    protected final Long2ObjectMap<PortalPosition> field_85191_c = new Long2ObjectOpenHashMap(4096);

    public Teleporter(WorldServer worldIn) {
        this.field_85192_a = worldIn;
        this.field_77187_a = new Random(worldIn.func_72905_C());
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        if (this.field_85192_a.field_73011_w.func_186058_p() != DimensionType.THE_END) {
            if (!this.func_180620_b(entityIn, rotationYaw)) {
                this.func_85188_a(entityIn);
                this.func_180620_b(entityIn, rotationYaw);
            }
        } else {
            int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int j = MathHelper.func_76128_c((double)entityIn.field_70163_u) - 1;
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            boolean l = true;
            boolean i1 = false;
            for (int j1 = -2; j1 <= 2; ++j1) {
                for (int k1 = -2; k1 <= 2; ++k1) {
                    for (int l1 = -1; l1 < 3; ++l1) {
                        int i2 = i + k1 * 1 + j1 * 0;
                        int j2 = j + l1;
                        int k2 = k + k1 * 0 - j1 * 1;
                        boolean flag = l1 < 0;
                        this.field_85192_a.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            entityIn.func_70012_b(i, j, k, entityIn.field_70177_z, 0.0f);
            entityIn.field_70159_w = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70179_y = 0.0;
        }
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        int i = 128;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        boolean flag = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        if (this.field_85191_c.containsKey(l)) {
            PortalPosition teleporter$portalposition = (PortalPosition)((Object)this.field_85191_c.get(l));
            d0 = 0.0;
            blockpos = teleporter$portalposition;
            teleporter$portalposition.field_85087_d = this.field_85192_a.func_82737_E();
            flag = false;
        } else {
            BlockPos blockpos3 = new BlockPos(entityIn);
            for (int i1 = -128; i1 <= 128; ++i1) {
                for (int j1 = -128; j1 <= 128; ++j1) {
                    BlockPos blockpos1 = blockpos3.func_177982_a(i1, this.field_85192_a.func_72940_L() - 1 - blockpos3.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == field_196236_a) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (this.field_85192_a.func_180495_p(blockpos2).func_177230_c() == field_196236_a) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                this.field_85191_c.put(l, (Object)new PortalPosition(blockpos, this.field_85192_a.func_82737_E()));
            }
            double d5 = (double)blockpos.func_177958_n() + 0.5;
            double d7 = (double)blockpos.func_177952_p() + 0.5;
            BlockPattern.PatternHelper blockpattern$patternhelper = field_196236_a.func_181089_f(this.field_85192_a, blockpos);
            boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
            double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
            double d6 = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - entityIn.func_181014_aG().field_72448_b * (double)blockpattern$patternhelper.func_181119_e();
            if (flag1) {
                d2 += 1.0;
            }
            if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
                d7 = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            } else {
                d5 = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
            }
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH()) {
                f = 1.0f;
                f1 = 1.0f;
            } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176734_d()) {
                f = -1.0f;
                f1 = -1.0f;
            } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176746_e()) {
                f2 = 1.0f;
                f3 = -1.0f;
            } else {
                f2 = -1.0f;
                f3 = 1.0f;
            }
            double d3 = entityIn.field_70159_w;
            double d4 = entityIn.field_70179_y;
            entityIn.field_70159_w = d3 * (double)f + d4 * (double)f3;
            entityIn.field_70179_y = d3 * (double)f2 + d4 * (double)f1;
            entityIn.field_70177_z = rotationYaw - (float)(entityIn.func_181012_aH().func_176734_d().func_176736_b() * 90) + (float)(blockpattern$patternhelper.func_177669_b().func_176736_b() * 90);
            if (entityIn instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
                ((EntityPlayerMP)entityIn).field_71135_a.func_184342_d();
            } else {
                entityIn.func_70012_b(d5, d6, d7, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entityIn) {
        int i = 16;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70163_u);
        int l = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        int i1 = j;
        int j1 = k;
        int k1 = l;
        int l1 = 0;
        int i2 = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j2 = j - 16; j2 <= j + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - entityIn.field_70165_t;
            for (int l2 = l - 16; l2 <= l + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - entityIn.field_70161_v;
                block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - entityIn.field_70163_u;
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = j - 16; l5 <= j + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - entityIn.field_70165_t;
                for (int j6 = l - 16; j6 <= l + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - entityIn.field_70161_v;
                    block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int l7 = i2; l7 < i2 + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int k10 = -1; k10 < 4; ++k10) {
                                    int i11 = l5 + (i10 - 1) * l8;
                                    int j11 = i7 + k10;
                                    int k11 = j6 + (i10 - 1) * k9;
                                    blockpos$mutableblockpos.func_181079_c(i11, j11, k11);
                                    if (k10 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || k10 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - entityIn.field_70163_u;
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = l7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int l9 = i6 + (i8 - 1) * l6 + j7 * i3;
                        int j10 = k2 + i9;
                        int l10 = k6 + (i8 - 1) * i3 - j7 * l6;
                        boolean flag = i9 < 0;
                        blockpos$mutableblockpos.func_181079_c(l9, j10, l10);
                        this.field_85192_a.func_175656_a((BlockPos)blockpos$mutableblockpos, flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int k7 = -1; k7 < 3; ++k7) {
            for (int j8 = -1; j8 < 4; ++j8) {
                if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                blockpos$mutableblockpos.func_181079_c(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, Blocks.field_150343_Z.func_176223_P(), 3);
            }
        }
        IBlockState iblockstate = (IBlockState)field_196236_a.func_176223_P().func_206870_a((IProperty)BlockPortal.field_176550_a, (Comparable)((Object)(l6 == 0 ? EnumFacing.Axis.Z : EnumFacing.Axis.X)));
        for (int k8 = 0; k8 < 2; ++k8) {
            for (int j9 = 0; j9 < 3; ++j9) {
                blockpos$mutableblockpos.func_181079_c(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, iblockstate, 18);
            }
        }
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            long i = worldTime - 300L;
            ObjectIterator objectiterator = this.field_85191_c.values().iterator();
            while (objectiterator.hasNext()) {
                PortalPosition teleporter$portalposition = (PortalPosition)((Object)objectiterator.next());
                if (teleporter$portalposition != null && teleporter$portalposition.field_85087_d >= i) continue;
                objectiterator.remove();
            }
        }
    }

    public void placeEntity(World world, Entity entity, float yaw) {
        if (entity instanceof EntityPlayerMP) {
            this.func_180266_a(entity, yaw);
        } else {
            this.func_180620_b(entity, yaw);
        }
    }

    public class PortalPosition
    extends BlockPos {
        public long field_85087_d;

        public PortalPosition(BlockPos pos, long lastUpdate) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.field_85087_d = lastUpdate;
        }
    }
}

