/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathWorldListener;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEntityReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.extensions.IForgeWorld;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.WorldCapabilityData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.timings.TimeTracker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class World
extends CapabilityProvider<World>
implements IEntityReader,
IWorld,
IWorldReader,
AutoCloseable,
IForgeWorld {
    protected static final Logger field_195596_d = LogManager.getLogger();
    private static final EnumFacing[] field_200007_a = EnumFacing.values();
    private int field_181546_a = 63;
    public final List<Entity> field_72996_f = Lists.newArrayList();
    protected final List<Entity> field_72997_g = Lists.newArrayList();
    public final List<TileEntity> field_147482_g = Lists.newArrayList();
    public final List<TileEntity> field_175730_i = Lists.newArrayList();
    private final List<TileEntity> field_147484_a = Lists.newArrayList();
    private final List<TileEntity> field_147483_b = Lists.newArrayList();
    public final List<EntityPlayer> field_73010_i = Lists.newArrayList();
    public final List<Entity> field_73007_j = Lists.newArrayList();
    protected final IntHashMap<Entity> field_175729_l = new IntHashMap();
    private final long field_73001_c = 0xFFFFFFL;
    private int field_73008_k;
    protected int field_73005_l = new Random().nextInt();
    protected final int field_73006_m = 1013904223;
    public float field_73003_n;
    public float field_73004_o;
    public float field_73018_p;
    public float field_73017_q;
    private int field_73016_r;
    public final Random field_73012_v = new Random();
    public final Dimension field_73011_w;
    protected PathWorldListener field_184152_t = new PathWorldListener();
    protected List<IWorldEventListener> field_73021_x = Lists.newArrayList((Object[])new IWorldEventListener[]{this.field_184152_t});
    protected IChunkProvider field_73020_y;
    protected final ISaveHandler field_73019_z;
    protected WorldInfo field_72986_A;
    @Nullable
    private final WorldSavedDataStorage field_72988_C;
    public VillageCollection field_72982_D;
    public final Profiler field_72984_F;
    public final boolean field_72995_K;
    protected boolean field_72985_G = true;
    protected boolean field_72992_H = true;
    private boolean field_147481_N;
    private final WorldBorder field_175728_M;
    int[] field_72994_J = new int[32768];
    public boolean restoringBlockSnapshots = false;
    public boolean captureBlockSnapshots = false;
    public ArrayList<BlockSnapshot> capturedBlockSnapshots = new ArrayList();
    private WorldCapabilityData capabilityData;
    private double maxEntityRadius = 2.0;

    protected World(ISaveHandler p_i49813_1_, @Nullable WorldSavedDataStorage p_i49813_2_, WorldInfo p_i49813_3_, Dimension p_i49813_4_, Profiler p_i49813_5_, boolean p_i49813_6_) {
        super(World.class);
        this.field_73019_z = p_i49813_1_;
        this.field_72988_C = p_i49813_2_;
        this.field_72984_F = p_i49813_5_;
        this.field_72986_A = p_i49813_3_;
        this.field_73011_w = p_i49813_4_;
        this.field_72995_K = p_i49813_6_;
        this.field_175728_M = p_i49813_4_.func_177501_r();
    }

    public Biome func_180494_b(BlockPos pos) {
        return this.field_73011_w.getBiome(pos);
    }

    public Biome getBiomeBody(BlockPos pos) {
        if (this.func_175667_e(pos)) {
            Chunk chunk = this.func_175726_f(pos);
            try {
                return chunk.func_201600_k(pos);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Getting biome");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Coordinates of biome request");
                crashreportcategory.func_189529_a("Location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_180522_a(pos)));
                throw new ReportedException(crashreport);
            }
        }
        return this.field_73020_y.func_201711_g().func_202090_b().func_180300_a(pos, Biomes.field_76772_c);
    }

    protected abstract IChunkProvider func_72970_h();

    public void func_72963_a(WorldSettings settings) {
        this.field_72986_A.func_76091_d(true);
    }

    public boolean func_201670_d() {
        return this.field_72995_K;
    }

    @Nullable
    public MinecraftServer func_73046_m() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72974_f() {
        this.func_175652_B(new BlockPos(8, 64, 8));
    }

    public IBlockState func_184141_c(BlockPos pos) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), this.func_181545_F(), pos.func_177952_p());
        while (!this.func_175623_d(blockpos.func_177984_a())) {
            blockpos = blockpos.func_177984_a();
        }
        return this.func_180495_p(blockpos);
    }

    public static boolean func_175701_a(BlockPos p_175701_0_) {
        return !World.func_189509_E(p_175701_0_) && p_175701_0_.func_177958_n() >= -30000000 && p_175701_0_.func_177952_p() >= -30000000 && p_175701_0_.func_177958_n() < 30000000 && p_175701_0_.func_177952_p() < 30000000;
    }

    public static boolean func_189509_E(BlockPos p_189509_0_) {
        return p_189509_0_.func_177956_o() < 0 || p_189509_0_.func_177956_o() >= 256;
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).isAir((IBlockReader)this, pos);
    }

    public Chunk func_175726_f(BlockPos pos) {
        return this.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    @Override
    public Chunk func_72964_e(int chunkX, int chunkZ) {
        Chunk chunk = this.field_73020_y.func_186025_d(chunkX, chunkZ, true, true);
        if (chunk == null) {
            throw new IllegalStateException("Should always be able to create a chunk!");
        }
        return chunk;
    }

    public boolean func_180501_a(BlockPos pos, IBlockState newState, int flags) {
        if (World.func_189509_E(pos)) {
            return false;
        }
        if (!this.field_72995_K && this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            return false;
        }
        Chunk chunk = this.func_175726_f(pos);
        Block block = newState.func_177230_c();
        pos = pos.func_185334_h();
        BlockSnapshot blockSnapshot = null;
        if (this.captureBlockSnapshots && !this.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)this, (BlockPos)pos, (int)flags);
            this.capturedBlockSnapshots.add(blockSnapshot);
        }
        IBlockState old = this.func_180495_p(pos);
        int oldLight = old.getLightValue(this, pos);
        int oldOpacity = old.func_200016_a((IBlockReader)this, pos);
        IBlockState iblockstate = chunk.func_177436_a(pos, newState, (flags & 0x40) != 0);
        if (iblockstate == null) {
            if (blockSnapshot != null) {
                this.capturedBlockSnapshots.remove(blockSnapshot);
            }
            return false;
        }
        IBlockState iblockstate1 = this.func_180495_p(pos);
        if (iblockstate1.func_200016_a((IBlockReader)this, pos) != oldOpacity || iblockstate1.getLightValue(this, pos) != oldLight) {
            this.field_72984_F.func_76320_a("checkLight");
            this.func_175664_x(pos);
            this.field_72984_F.func_76319_b();
        }
        if (blockSnapshot == null) {
            this.markAndNotifyBlock(pos, chunk, iblockstate, newState, flags);
        }
        return true;
    }

    public void markAndNotifyBlock(BlockPos pos, @Nullable Chunk chunk, IBlockState iblockstate, IBlockState newState, int flags) {
        Block block = newState.func_177230_c();
        IBlockState iblockstate1 = this.func_180495_p(pos);
        if (iblockstate1 == newState) {
            if (iblockstate != iblockstate1) {
                this.func_175704_b(pos, pos);
            }
            if (!((flags & 2) == 0 || this.field_72995_K && (flags & 4) != 0 || chunk != null && !chunk.func_150802_k())) {
                this.func_184138_a(pos, iblockstate, newState, flags);
            }
            if (!this.field_72995_K && (flags & 1) != 0) {
                this.func_195592_c(pos, iblockstate.func_177230_c());
                if (newState.func_185912_n()) {
                    this.func_175666_e(pos, block);
                }
            }
            if ((flags & 0x10) == 0) {
                int i = flags & 0xFFFFFFFE;
                iblockstate.func_196948_b(this, pos, i);
                newState.func_196946_a(this, pos, i);
                newState.func_196948_b(this, pos, i);
            }
        }
    }

    public boolean func_175698_g(BlockPos pos) {
        IFluidState ifluidstate = this.func_204610_c(pos);
        return this.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }

    public boolean func_175655_b(BlockPos pos, boolean dropBlock) {
        IBlockState iblockstate = this.func_180495_p(pos);
        if (iblockstate.isAir((IBlockReader)this, pos)) {
            return false;
        }
        IFluidState ifluidstate = this.func_204610_c(pos);
        this.func_175718_b(2001, pos, Block.func_196246_j(iblockstate));
        if (dropBlock) {
            iblockstate.func_196949_c(this, pos, 0);
        }
        return this.func_180501_a(pos, ifluidstate.func_206883_i(), 3);
    }

    public boolean func_175656_a(BlockPos pos, IBlockState state) {
        return this.func_180501_a(pos, state, 3);
    }

    public void func_184138_a(BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_184376_a((IBlockReader)this, pos, oldState, newState, flags);
        }
    }

    @Override
    public void func_195592_c(BlockPos pos, Block blockIn) {
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.func_195593_d(pos, blockIn);
        }
    }

    public void func_72975_g(int x, int z, int y1, int y2) {
        if (y1 > y2) {
            int i = y2;
            y2 = y1;
            y1 = i;
        }
        if (this.field_73011_w.func_191066_m()) {
            for (int j = y1; j <= y2; ++j) {
                this.func_180500_c(EnumLightType.SKY, new BlockPos(x, j, z));
            }
        }
        this.func_147458_c(x, y1, z, x, y2, z);
    }

    public void func_175704_b(BlockPos rangeMin, BlockPos rangeMax) {
        this.func_147458_c(rangeMin.func_177958_n(), rangeMin.func_177956_o(), rangeMin.func_177952_p(), rangeMax.func_177958_n(), rangeMax.func_177956_o(), rangeMax.func_177952_p());
    }

    public void func_147458_c(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_147585_a(x1, y1, z1, x2, y2, z2);
        }
    }

    public void func_195593_d(BlockPos pos, Block blockIn) {
        if (ForgeEventFactory.onNeighborNotify((World)this, (BlockPos)pos, (IBlockState)this.func_180495_p(pos), EnumSet.allOf(EnumFacing.class), (boolean)false).isCanceled()) {
            return;
        }
        this.func_190524_a(pos.func_177976_e(), blockIn, pos);
        this.func_190524_a(pos.func_177974_f(), blockIn, pos);
        this.func_190524_a(pos.func_177977_b(), blockIn, pos);
        this.func_190524_a(pos.func_177984_a(), blockIn, pos);
        this.func_190524_a(pos.func_177978_c(), blockIn, pos);
        this.func_190524_a(pos.func_177968_d(), blockIn, pos);
    }

    public void func_175695_a(BlockPos pos, Block blockType, EnumFacing skipSide) {
        EnumSet<EnumFacing> directions = EnumSet.allOf(EnumFacing.class);
        directions.remove((Object)skipSide);
        if (ForgeEventFactory.onNeighborNotify((World)this, (BlockPos)pos, (IBlockState)this.func_180495_p(pos), directions, (boolean)false).isCanceled()) {
            return;
        }
        if (skipSide != EnumFacing.WEST) {
            this.func_190524_a(pos.func_177976_e(), blockType, pos);
        }
        if (skipSide != EnumFacing.EAST) {
            this.func_190524_a(pos.func_177974_f(), blockType, pos);
        }
        if (skipSide != EnumFacing.DOWN) {
            this.func_190524_a(pos.func_177977_b(), blockType, pos);
        }
        if (skipSide != EnumFacing.UP) {
            this.func_190524_a(pos.func_177984_a(), blockType, pos);
        }
        if (skipSide != EnumFacing.NORTH) {
            this.func_190524_a(pos.func_177978_c(), blockType, pos);
        }
        if (skipSide != EnumFacing.SOUTH) {
            this.func_190524_a(pos.func_177968_d(), blockType, pos);
        }
    }

    public void func_190524_a(BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.field_72995_K) {
            IBlockState iblockstate = this.func_180495_p(pos);
            try {
                iblockstate.func_189546_a(this, pos, blockIn, fromPos);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception while updating neighbours");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
                crashreportcategory.func_189529_a("Source block type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                    try {
                        return String.format("ID #%s (%s // %s)", blockIn.getRegistryName(), blockIn.func_149739_a(), ((Object)((Object)blockIn)).getClass().getCanonicalName());
                    }
                    catch (Throwable var2) {
                        return "ID #" + blockIn.getRegistryName();
                    }
                }));
                CrashReportCategory.func_175750_a(crashreportcategory, pos, iblockstate);
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean func_175678_i(BlockPos pos) {
        return this.func_175726_f(pos).func_177444_d(pos);
    }

    public int func_201669_a(BlockPos pos, int amount) {
        if (pos.func_177958_n() >= -30000000 && pos.func_177952_p() >= -30000000 && pos.func_177958_n() < 30000000 && pos.func_177952_p() < 30000000) {
            if (pos.func_177956_o() < 0) {
                return 0;
            }
            if (pos.func_177956_o() >= 256) {
                pos = new BlockPos(pos.func_177958_n(), 255, pos.func_177952_p());
            }
            return this.func_175726_f(pos).func_177443_a(pos, amount);
        }
        return 15;
    }

    public int func_201676_a(Heightmap.Type heightmapType, int x, int z) {
        int i = x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000 ? (this.func_175680_a(x >> 4, z >> 4, true) ? this.func_72964_e(x >> 4, z >> 4).func_201576_a(heightmapType, x & 0xF, z & 0xF) + 1 : 0) : this.func_181545_F() + 1;
        return i;
    }

    @Deprecated
    public int func_82734_g(int x, int z) {
        if (x >= -30000000 && z >= -30000000 && x < 30000000 && z < 30000000) {
            if (!this.func_175680_a(x >> 4, z >> 4, true)) {
                return 0;
            }
            Chunk chunk = this.func_72964_e(x >> 4, z >> 4);
            return chunk.func_177442_v();
        }
        return this.func_181545_F() + 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_175705_a(EnumLightType type, BlockPos pos) {
        if (!this.field_73011_w.func_191066_m() && type == EnumLightType.SKY) {
            return 0;
        }
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!World.func_175701_a(pos)) {
            return type.field_77198_c;
        }
        if (!this.func_175667_e(pos)) {
            return type.field_77198_c;
        }
        if (this.func_180495_p(pos).func_200130_c((IBlockReader)this, pos)) {
            int i = this.func_175642_b(type, pos.func_177984_a());
            int j = this.func_175642_b(type, pos.func_177974_f());
            int k = this.func_175642_b(type, pos.func_177976_e());
            int l = this.func_175642_b(type, pos.func_177968_d());
            int i1 = this.func_175642_b(type, pos.func_177978_c());
            if (j > i) {
                i = j;
            }
            if (k > i) {
                i = k;
            }
            if (l > i) {
                i = l;
            }
            if (i1 > i) {
                i = i1;
            }
            return i;
        }
        return this.func_175726_f(pos).func_177413_a(type, pos);
    }

    public int func_175642_b(EnumLightType type, BlockPos pos) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!World.func_175701_a(pos)) {
            return type.field_77198_c;
        }
        return !this.func_175667_e(pos) ? type.field_77198_c : this.func_175726_f(pos).func_177413_a(type, pos);
    }

    public void func_175653_a(EnumLightType type, BlockPos pos, int lightValue) {
        if (World.func_175701_a(pos) && this.func_175667_e(pos)) {
            this.func_175726_f(pos).func_177431_a(type, pos, lightValue);
            this.func_175679_n(pos);
        }
    }

    public void func_175679_n(BlockPos pos) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_174959_b(pos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        int i = this.func_175705_a(EnumLightType.SKY, pos);
        int j = this.func_175705_a(EnumLightType.BLOCK, pos);
        if (j < lightValue) {
            j = lightValue;
        }
        return i << 20 | j << 4;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        Chunk chunk = this.func_175726_f(pos);
        return chunk.func_180495_p(pos);
    }

    public IFluidState func_204610_c(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        Chunk chunk = this.func_175726_f(pos);
        return chunk.func_204610_c(pos);
    }

    public boolean func_72935_r() {
        return this.field_73011_w.isDaytime();
    }

    @Nullable
    public RayTraceResult func_72933_a(Vec3d start, Vec3d end) {
        return this.func_200259_a(start, end, RayTraceFluidMode.NEVER, false, false);
    }

    @Nullable
    public RayTraceResult func_200260_a(Vec3d start, Vec3d end, RayTraceFluidMode fluidMode) {
        return this.func_200259_a(start, end, fluidMode, false, false);
    }

    @Nullable
    public RayTraceResult func_200259_a(Vec3d start, Vec3d end, RayTraceFluidMode fluidMode, boolean p_200259_4_, boolean p_200259_5_) {
        double d0 = start.field_72450_a;
        double d1 = start.field_72448_b;
        double d2 = start.field_72449_c;
        if (!(Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                int i = MathHelper.func_76128_c((double)end.field_72450_a);
                int j = MathHelper.func_76128_c((double)end.field_72448_b);
                int k = MathHelper.func_76128_c((double)end.field_72449_c);
                int l = MathHelper.func_76128_c((double)d0);
                int i1 = MathHelper.func_76128_c((double)d1);
                int j1 = MathHelper.func_76128_c((double)d2);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = this.func_180495_p(blockpos);
                IFluidState ifluidstate = this.func_204610_c(blockpos);
                if (!p_200259_4_ || !iblockstate.func_196952_d((IBlockReader)this, blockpos).func_197766_b()) {
                    boolean flag = iblockstate.func_177230_c().func_200293_a(iblockstate);
                    boolean flag1 = fluidMode.field_209544_d.test(ifluidstate);
                    if (flag || flag1) {
                        RayTraceResult raytraceresult = null;
                        if (flag) {
                            raytraceresult = Block.func_180636_a(iblockstate, this, blockpos, start, end);
                        }
                        if (raytraceresult == null && flag1) {
                            raytraceresult = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)ifluidstate.func_206885_f(), (double)1.0).func_212433_a(start, end, blockpos);
                        }
                        if (raytraceresult != null) {
                            return raytraceresult;
                        }
                    }
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(d0) || Double.isNaN(d1) || Double.isNaN(d2)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return p_200259_5_ ? raytraceresult2 : null;
                    }
                    boolean flag4 = true;
                    boolean flag5 = true;
                    boolean flag6 = true;
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    if (i > l) {
                        d3 = (double)l + 1.0;
                    } else if (i < l) {
                        d3 = (double)l + 0.0;
                    } else {
                        flag4 = false;
                    }
                    if (j > i1) {
                        d4 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d4 = (double)i1 + 0.0;
                    } else {
                        flag5 = false;
                    }
                    if (k > j1) {
                        d5 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d5 = (double)j1 + 0.0;
                    } else {
                        flag6 = false;
                    }
                    double d6 = 999.0;
                    double d7 = 999.0;
                    double d8 = 999.0;
                    double d9 = end.field_72450_a - d0;
                    double d10 = end.field_72448_b - d1;
                    double d11 = end.field_72449_c - d2;
                    if (flag4) {
                        d6 = (d3 - d0) / d9;
                    }
                    if (flag5) {
                        d7 = (d4 - d1) / d10;
                    }
                    if (flag6) {
                        d8 = (d5 - d2) / d11;
                    }
                    if (d6 == -0.0) {
                        d6 = -1.0E-4;
                    }
                    if (d7 == -0.0) {
                        d7 = -1.0E-4;
                    }
                    if (d8 == -0.0) {
                        d8 = -1.0E-4;
                    }
                    if (d6 < d7 && d6 < d8) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        d0 = d3;
                        d1 += d10 * d6;
                        d2 += d11 * d6;
                    } else if (d7 < d8) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        d0 += d9 * d7;
                        d1 = d4;
                        d2 += d11 * d7;
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        d0 += d9 * d8;
                        d1 += d10 * d8;
                        d2 = d5;
                    }
                    l = MathHelper.func_76128_c((double)d0) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)d1) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)d2) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = this.func_180495_p(blockpos);
                    IFluidState ifluidstate1 = this.func_204610_c(blockpos);
                    if (p_200259_4_ && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_196952_d((IBlockReader)this, blockpos).func_197766_b()) continue;
                    boolean flag2 = iblockstate1.func_177230_c().func_200293_a(iblockstate1);
                    boolean flag3 = fluidMode.field_209544_d.test(ifluidstate1);
                    if (!flag2 && !flag3) {
                        raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, new Vec3d(d0, d1, d2), enumfacing, blockpos);
                        continue;
                    }
                    RayTraceResult raytraceresult1 = null;
                    if (flag2) {
                        raytraceresult1 = Block.func_180636_a(iblockstate1, this, blockpos, start, end);
                    }
                    if (raytraceresult1 == null && flag3) {
                        raytraceresult1 = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)ifluidstate1.func_206885_f(), (double)1.0).func_212433_a(start, end, blockpos);
                    }
                    if (raytraceresult1 == null) continue;
                    return raytraceresult1;
                }
                return p_200259_5_ ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void func_184133_a(@Nullable EntityPlayer player, BlockPos pos, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        this.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundIn, category, volume, pitch);
    }

    public void func_184148_a(@Nullable EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)player, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        pitch = event.getPitch();
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_184375_a(player, soundIn, category, x, y, z, volume, pitch);
        }
    }

    public void func_184134_a(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
    }

    public void func_184149_a(BlockPos pos, @Nullable SoundEvent soundEventIn) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_184377_a(soundEventIn, pos);
        }
    }

    @Override
    public void func_195594_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195461_a(particleData, particleData.func_197554_b().func_197575_f(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_195590_a(IParticleData particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195461_a(particleData, particleData.func_197554_b().func_197575_f() || forceAlwaysRender, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public void func_195589_b(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_195462_a(particleData, false, true, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public boolean func_72942_c(Entity entityIn) {
        this.field_73007_j.add(entityIn);
        return true;
    }

    public boolean func_72838_d(Entity entityIn) {
        if (!this.field_72995_K && (entityIn == null || entityIn instanceof EntityItem && this.restoringBlockSnapshots)) {
            return false;
        }
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        boolean flag = entityIn.field_98038_p;
        if (entityIn instanceof EntityPlayer) {
            flag = true;
        }
        if (!flag && !this.func_175680_a(i, j, false)) {
            return false;
        }
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            this.field_73010_i.add(entityplayer);
            this.func_72854_c();
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, this)) && !flag) {
            return false;
        }
        this.func_72964_e(i, j).func_76612_a(entityIn);
        this.field_72996_f.add(entityIn);
        this.func_72923_a(entityIn);
        return true;
    }

    public void func_72923_a(Entity entityIn) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_72703_a(entityIn);
        }
        entityIn.onAddedToWorld();
    }

    public void func_72847_b(Entity entityIn) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_72709_b(entityIn);
        }
        entityIn.onRemovedFromWorld();
    }

    public void func_72900_e(Entity entityIn) {
        this.removeEntity(entityIn, false);
    }

    public void removeEntity(Entity entityIn, boolean keepData) {
        if (entityIn.func_184207_aI()) {
            entityIn.func_184226_ay();
        }
        if (entityIn.func_184218_aH()) {
            entityIn.func_184210_p();
        }
        entityIn.remove(keepData);
        if (entityIn instanceof EntityPlayer) {
            this.field_73010_i.remove((Object)entityIn);
            this.func_72854_c();
            this.func_72847_b(entityIn);
        }
    }

    public void func_72973_f(Entity entityIn) {
        this.removeEntityDangerously(entityIn, false);
    }

    public void removeEntityDangerously(Entity entityIn, boolean keepData) {
        entityIn.func_184174_b(false);
        entityIn.remove(keepData);
        if (entityIn instanceof EntityPlayer) {
            this.field_73010_i.remove((Object)entityIn);
            this.func_72854_c();
        }
        int i = entityIn.field_70176_ah;
        int j = entityIn.field_70164_aj;
        if (entityIn.field_70175_ag && this.func_175680_a(i, j, true)) {
            this.func_72964_e(i, j).func_76622_b(entityIn);
        }
        this.field_72996_f.remove((Object)entityIn);
        this.func_72847_b(entityIn);
    }

    public void func_72954_a(IWorldEventListener listener) {
        this.field_73021_x.add(listener);
    }

    public void func_72848_b(IWorldEventListener listener) {
        this.field_73021_x.remove(listener);
    }

    public int func_72967_a(float partialTicks) {
        float f = 1.0f - this.field_73011_w.getSunBrightnessFactor(partialTicks);
        return (int)(f * 11.0f);
    }

    public float getSunBrightnessFactor(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_72971_b(float partialTicks) {
        return this.field_73011_w.getSunBrightness(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSunBrightnessBody(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72867_j(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(this.func_72819_i(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f + 0.2f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_72833_a(Entity entityIn, float partialTicks) {
        return this.field_73011_w.getSkyColor(entityIn, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getSkyColorBody(Entity entityIn, float partialTicks) {
        float f10;
        float f = this.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int j = MathHelper.func_76128_c((double)entityIn.field_70163_u);
        int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        BlockPos blockpos = new BlockPos(i, j, k);
        int l = ForgeHooksClient.getSkyBlendColour((World)this, (BlockPos)blockpos);
        float f3 = (float)(l >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(l >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(l & 0xFF) / 255.0f;
        f3 *= f1;
        f4 *= f1;
        f5 *= f1;
        float f6 = this.func_72867_j(partialTicks);
        if (f6 > 0.0f) {
            float f7 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f8 = 1.0f - f6 * 0.75f;
            f3 = f3 * f8 + f7 * (1.0f - f8);
            f4 = f4 * f8 + f7 * (1.0f - f8);
            f5 = f5 * f8 + f7 * (1.0f - f8);
        }
        if ((f10 = this.func_72819_i(partialTicks)) > 0.0f) {
            float f11 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.2f;
            float f9 = 1.0f - f10 * 0.75f;
            f3 = f3 * f9 + f11 * (1.0f - f9);
            f4 = f4 * f9 + f11 * (1.0f - f9);
            f5 = f5 * f9 + f11 * (1.0f - f9);
        }
        if (this.field_73016_r > 0) {
            float f12 = (float)this.field_73016_r - partialTicks;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            f3 = f3 * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            f4 = f4 * (1.0f - f12) + 0.8f * f12;
            f5 = f5 * (1.0f - f12) + 1.0f * f12;
        }
        return new Vec3d(f3, f4, f5);
    }

    public float func_72929_e(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        return f * ((float)Math.PI * 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_72824_f(float partialTicks) {
        return this.field_73011_w.getCloudColor(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d getCloudColorBody(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = this.func_72867_j(partialTicks);
        if (f5 > 0.0f) {
            float f6 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.6f;
            float f7 = 1.0f - f5 * 0.95f;
            f2 = f2 * f7 + f6 * (1.0f - f7);
            f3 = f3 * f7 + f6 * (1.0f - f7);
            f4 = f4 * f7 + f6 * (1.0f - f7);
        }
        f2 *= f1 * 0.9f + 0.1f;
        f3 *= f1 * 0.9f + 0.1f;
        f4 *= f1 * 0.85f + 0.15f;
        float f9 = this.func_72819_i(partialTicks);
        if (f9 > 0.0f) {
            float f10 = (f2 * 0.3f + f3 * 0.59f + f4 * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            f2 = f2 * f8 + f10 * (1.0f - f8);
            f3 = f3 * f8 + f10 * (1.0f - f8);
            f4 = f4 * f8 + f10 * (1.0f - f8);
        }
        return new Vec3d(f2, f3, f4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_72948_g(float partialTicks) {
        float f = this.func_72826_c(partialTicks);
        return this.field_73011_w.func_76562_b(f, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_72880_h(float partialTicks) {
        return this.field_73011_w.getStarBrightness(partialTicks);
    }

    public void func_72939_s() {
        this.field_72984_F.func_76320_a("entities");
        this.field_72984_F.func_76320_a("global");
        for (int i = 0; i < this.field_73007_j.size(); ++i) {
            Entity entity = this.field_73007_j.get(i);
            try {
                ++entity.field_70173_aa;
                if (entity.canUpdate()) {
                    entity.func_70071_h_();
                }
            }
            catch (Throwable throwable2) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable2, "Ticking entity");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being ticked");
                if (entity == null) {
                    crashreportcategory.func_71507_a("Entity", "~~NULL~~");
                } else {
                    entity.func_85029_a(crashreportcategory);
                }
                if (((Boolean)ForgeConfig.SERVER.removeErroringEntities.get()).booleanValue()) {
                    LogManager.getLogger().fatal("{}", (Object)crashreport.func_71502_e());
                    this.func_72900_e(entity);
                }
                throw new ReportedException(crashreport);
            }
            if (!entity.field_70128_L) continue;
            this.field_73007_j.remove(i--);
        }
        this.field_72984_F.func_76318_c("remove");
        this.field_72996_f.removeAll(this.field_72997_g);
        for (int k = 0; k < this.field_72997_g.size(); ++k) {
            Entity entity1 = this.field_72997_g.get(k);
            int j = entity1.field_70176_ah;
            int k1 = entity1.field_70164_aj;
            if (!entity1.field_70175_ag || !this.func_175680_a(j, k1, true)) continue;
            this.func_72964_e(j, k1).func_76622_b(entity1);
        }
        for (int l = 0; l < this.field_72997_g.size(); ++l) {
            this.func_72847_b(this.field_72997_g.get(l));
        }
        this.field_72997_g.clear();
        this.func_184147_l();
        this.field_72984_F.func_76318_c("regular");
        for (int i1 = 0; i1 < this.field_72996_f.size(); ++i1) {
            Entity entity2 = this.field_72996_f.get(i1);
            Entity entity3 = entity2.func_184187_bx();
            if (entity3 != null) {
                if (!entity3.field_70128_L && entity3.func_184196_w(entity2)) continue;
                entity2.func_184210_p();
            }
            this.field_72984_F.func_76320_a("tick");
            if (!entity2.field_70128_L && !(entity2 instanceof EntityPlayerMP)) {
                try {
                    TimeTracker.ENTITY_UPDATE.trackStart((Object)entity2);
                    this.func_72870_g(entity2);
                    TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity2);
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport1 = CrashReport.func_85055_a(throwable1, "Ticking entity");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Entity being ticked");
                    entity2.func_85029_a(crashreportcategory1);
                    if (((Boolean)ForgeConfig.SERVER.removeErroringEntities.get()).booleanValue()) {
                        LogManager.getLogger().fatal("{}", (Object)crashreport1.func_71502_e());
                        this.func_72900_e(entity2);
                    }
                    throw new ReportedException(crashreport1);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (entity2.field_70128_L) {
                int l1 = entity2.field_70176_ah;
                int i2 = entity2.field_70164_aj;
                if (entity2.field_70175_ag && this.func_175680_a(l1, i2, true)) {
                    this.func_72964_e(l1, i2).func_76622_b(entity2);
                }
                this.field_72996_f.remove(i1--);
                this.func_72847_b(entity2);
            }
            this.field_72984_F.func_76319_b();
        }
        this.field_72984_F.func_76318_c("blockEntities");
        this.field_147481_N = true;
        if (!this.field_147483_b.isEmpty()) {
            this.field_147483_b.forEach(e -> e.onChunkUnloaded());
            Set remove = Collections.newSetFromMap(new IdentityHashMap());
            remove.addAll(this.field_147483_b);
            this.field_175730_i.removeAll(remove);
            this.field_147482_g.removeAll(remove);
            this.field_147483_b.clear();
        }
        Iterator<TileEntity> iterator = this.field_175730_i.iterator();
        while (iterator.hasNext()) {
            Chunk chunk;
            BlockPos blockpos;
            TileEntity tileentity = iterator.next();
            if (!tileentity.func_145837_r() && tileentity.func_145830_o() && this.func_175668_a(blockpos = tileentity.func_174877_v(), false) && this.field_175728_M.func_177746_a(blockpos)) {
                try {
                    this.field_72984_F.func_194340_a(() -> String.valueOf(TileEntityType.func_200969_a(tileentity.func_200662_C())));
                    TimeTracker.TILE_ENTITY_UPDATE.trackStart((Object)tileentity);
                    ((ITickable)tileentity).func_73660_a();
                    TimeTracker.TILE_ENTITY_UPDATE.trackEnd((Object)tileentity);
                    this.field_72984_F.func_76319_b();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport2 = CrashReport.func_85055_a(throwable, "Ticking block entity");
                    CrashReportCategory crashreportcategory2 = crashreport2.func_85058_a("Block entity being ticked");
                    tileentity.func_145828_a(crashreportcategory2);
                    if (((Boolean)ForgeConfig.SERVER.removeErroringTileEntities.get()).booleanValue()) {
                        LogManager.getLogger().fatal("{}", (Object)crashreport2.func_71502_e());
                        tileentity.func_145843_s();
                        this.func_175713_t(tileentity.func_174877_v());
                    }
                    throw new ReportedException(crashreport2);
                }
            }
            if (!tileentity.func_145837_r()) continue;
            iterator.remove();
            this.field_147482_g.remove((Object)tileentity);
            if (!this.func_175667_e(tileentity.func_174877_v()) || (chunk = this.func_175726_f(tileentity.func_174877_v())).func_177424_a(tileentity.func_174877_v(), Chunk.EnumCreateEntityType.CHECK) != tileentity) continue;
            chunk.func_177425_e(tileentity.func_174877_v());
        }
        this.field_147481_N = false;
        this.field_72984_F.func_76318_c("pendingBlockEntities");
        if (!this.field_147484_a.isEmpty()) {
            for (int j1 = 0; j1 < this.field_147484_a.size(); ++j1) {
                TileEntity tileentity1 = this.field_147484_a.get(j1);
                if (tileentity1.func_145837_r()) continue;
                if (!this.field_147482_g.contains((Object)tileentity1)) {
                    this.func_175700_a(tileentity1);
                }
                if (!this.func_175667_e(tileentity1.func_174877_v())) continue;
                Chunk chunk = this.func_175726_f(tileentity1.func_174877_v());
                IBlockState iblockstate = chunk.func_180495_p(tileentity1.func_174877_v());
                chunk.func_177426_a(tileentity1.func_174877_v(), tileentity1);
                this.func_184138_a(tileentity1.func_174877_v(), iblockstate, iblockstate, 3);
            }
            this.field_147484_a.clear();
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76319_b();
    }

    protected void func_184147_l() {
    }

    public boolean func_175700_a(TileEntity tile) {
        if (tile.func_145831_w() != this) {
            tile.func_145834_a(this);
        }
        if (this.field_147481_N) {
            return this.field_147484_a.add(tile);
        }
        boolean flag = this.field_147482_g.add(tile);
        if (flag && tile instanceof ITickable) {
            this.field_175730_i.add(tile);
        }
        tile.onLoad();
        if (this.field_72995_K) {
            BlockPos blockpos = tile.func_174877_v();
            IBlockState iblockstate = this.func_180495_p(blockpos);
            this.func_184138_a(blockpos, iblockstate, iblockstate, 2);
        }
        return flag;
    }

    public void func_147448_a(Collection<TileEntity> tileEntityCollection) {
        if (this.field_147481_N) {
            for (TileEntity te : tileEntityCollection) {
                if (te.func_145831_w() == this) continue;
                te.func_145834_a(this);
            }
            this.field_147484_a.addAll(tileEntityCollection);
        } else {
            for (TileEntity tileentity : tileEntityCollection) {
                this.func_175700_a(tileentity);
            }
        }
    }

    public void func_72870_g(Entity ent) {
        this.func_72866_a(ent, true);
    }

    public void func_72866_a(Entity entityIn, boolean forceUpdate) {
        if (!(entityIn instanceof EntityPlayer)) {
            boolean canUpdate;
            int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int j = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            int k = 32;
            int range = this.func_212416_f(i >> 4, j >> 4) ? 0 : 32;
            boolean bl = canUpdate = !forceUpdate || this.func_175663_a(i - range, 0, j - range, i + range, 0, j + range, true);
            if (!canUpdate) {
                canUpdate = ForgeEventFactory.canEntityUpdate((Entity)entityIn);
            }
            if (!canUpdate) {
                return;
            }
        }
        entityIn.field_70142_S = entityIn.field_70165_t;
        entityIn.field_70137_T = entityIn.field_70163_u;
        entityIn.field_70136_U = entityIn.field_70161_v;
        entityIn.field_70126_B = entityIn.field_70177_z;
        entityIn.field_70127_C = entityIn.field_70125_A;
        if (forceUpdate && entityIn.field_70175_ag) {
            ++entityIn.field_70173_aa;
            if (entityIn.func_184218_aH()) {
                entityIn.func_70098_U();
            } else {
                this.field_72984_F.func_194340_a(() -> entityIn.func_200600_R().getRegistryName().toString());
                entityIn.func_70071_h_();
                this.field_72984_F.func_76319_b();
            }
        }
        this.field_72984_F.func_76320_a("chunkCheck");
        if (Double.isNaN(entityIn.field_70165_t) || Double.isInfinite(entityIn.field_70165_t)) {
            entityIn.field_70165_t = entityIn.field_70142_S;
        }
        if (Double.isNaN(entityIn.field_70163_u) || Double.isInfinite(entityIn.field_70163_u)) {
            entityIn.field_70163_u = entityIn.field_70137_T;
        }
        if (Double.isNaN(entityIn.field_70161_v) || Double.isInfinite(entityIn.field_70161_v)) {
            entityIn.field_70161_v = entityIn.field_70136_U;
        }
        if (Double.isNaN(entityIn.field_70125_A) || Double.isInfinite(entityIn.field_70125_A)) {
            entityIn.field_70125_A = entityIn.field_70127_C;
        }
        if (Double.isNaN(entityIn.field_70177_z) || Double.isInfinite(entityIn.field_70177_z)) {
            entityIn.field_70177_z = entityIn.field_70126_B;
        }
        int l = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int i1 = MathHelper.func_76128_c((double)(entityIn.field_70163_u / 16.0));
        int j1 = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        if (!entityIn.field_70175_ag || entityIn.field_70176_ah != l || entityIn.field_70162_ai != i1 || entityIn.field_70164_aj != j1) {
            if (entityIn.field_70175_ag && this.func_175680_a(entityIn.field_70176_ah, entityIn.field_70164_aj, true)) {
                this.func_72964_e(entityIn.field_70176_ah, entityIn.field_70164_aj).func_76608_a(entityIn, entityIn.field_70162_ai);
            }
            if (!entityIn.func_184189_br() && !this.func_175680_a(l, j1, true)) {
                entityIn.field_70175_ag = false;
            } else {
                this.func_72964_e(l, j1).func_76612_a(entityIn);
            }
        }
        this.field_72984_F.func_76319_b();
        if (forceUpdate && entityIn.field_70175_ag) {
            for (Entity entity : entityIn.func_184188_bt()) {
                if (!entity.field_70128_L && entity.func_184187_bx() == entityIn) {
                    if (!entity.canUpdate()) continue;
                    this.func_72870_g(entity);
                    continue;
                }
                entity.func_184210_p();
            }
        }
    }

    public boolean func_195585_a(@Nullable Entity entityIn, VoxelShape shape) {
        if (shape.func_197766_b()) {
            return true;
        }
        List list = this.func_72839_b(null, shape.func_197752_a());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)((Object)list.get(i));
            if (entity.field_70128_L || !entity.field_70156_m || entity == entityIn || entityIn != null && entity.func_184223_x(entityIn) || !VoxelShapes.func_197879_c((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ()), (IBooleanFunction)IBooleanFunction.AND)) continue;
            return false;
        }
        return true;
    }

    public boolean func_72829_c(AxisAlignedBB bb) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        boolean flag;
                        IBlockState iblockstate = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2));
                        if (iblockstate.isAir((IBlockReader)this, (BlockPos)blockpos$pooledmutableblockpos)) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean func_147470_e(AxisAlignedBB bb) {
        int j1;
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        if (this.func_175663_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)bb.field_72334_f), true)) {
            try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        for (int i2 = i1; i2 < j1; ++i2) {
                            IBlockState state = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2));
                            Block block = state.func_177230_c();
                            if (block == Blocks.field_150480_ab || block == Blocks.field_150353_l) {
                                boolean flag;
                                boolean bl = flag = true;
                                return bl;
                            }
                            if (!state.isBurning((IBlockReader)this, (BlockPos)blockpos$pooledmutableblockpos)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    @Nullable
    public IBlockState func_203067_a(AxisAlignedBB area, Block blockIn) {
        int j1;
        int i = MathHelper.func_76128_c((double)area.field_72340_a);
        int j = MathHelper.func_76143_f((double)area.field_72336_d);
        int k = MathHelper.func_76128_c((double)area.field_72338_b);
        int l = MathHelper.func_76143_f((double)area.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)area.field_72339_c);
        if (this.func_175663_a(i, k, i1, j, l, j1 = MathHelper.func_76143_f((double)area.field_72334_f), true)) {
            try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
                for (int k1 = i; k1 < j; ++k1) {
                    for (int l1 = k; l1 < l; ++l1) {
                        for (int i2 = i1; i2 < j1; ++i2) {
                            IBlockState iblockstate1;
                            IBlockState iblockstate = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2));
                            if (iblockstate.func_177230_c() != blockIn) continue;
                            IBlockState iBlockState = iblockstate1 = iblockstate;
                            return iBlockState;
                        }
                    }
                }
                IBlockState iBlockState = null;
                return iBlockState;
            }
        }
        return null;
    }

    public boolean func_72875_a(AxisAlignedBB bb, Material materialIn) {
        int i = MathHelper.func_76128_c((double)bb.field_72340_a);
        int j = MathHelper.func_76143_f((double)bb.field_72336_d);
        int k = MathHelper.func_76128_c((double)bb.field_72338_b);
        int l = MathHelper.func_76143_f((double)bb.field_72337_e);
        int i1 = MathHelper.func_76128_c((double)bb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)bb.field_72334_f);
        BlockMaterialMatcher blockmaterialmatcher = BlockMaterialMatcher.func_189886_a((Material)materialIn);
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        boolean flag;
                        if (!blockmaterialmatcher.test(this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2)))) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public Explosion func_72876_a(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean damagesTerrain) {
        return this.func_211529_a(entityIn, null, x, y, z, strength, false, damagesTerrain);
    }

    public Explosion func_72885_a(@Nullable Entity entityIn, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        return this.func_211529_a(entityIn, null, x, y, z, strength, causesFire, damagesTerrain);
    }

    public Explosion func_211529_a(@Nullable Entity entityIn, @Nullable DamageSource damageSourceIn, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        Explosion explosion = new Explosion(this, entityIn, x, y, z, strength, causesFire, damagesTerrain);
        if (damageSourceIn != null) {
            explosion.func_199592_a(damageSourceIn);
        }
        if (ForgeEventFactory.onExplosionStart((World)this, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        return explosion;
    }

    public float func_72842_a(Vec3d vec, AxisAlignedBB bb) {
        double d0 = 1.0 / ((bb.field_72336_d - bb.field_72340_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((bb.field_72337_e - bb.field_72338_b) * 2.0 + 1.0);
        double d2 = 1.0 / ((bb.field_72334_f - bb.field_72339_c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = bb.field_72340_a + (bb.field_72336_d - bb.field_72340_a) * (double)f;
                        double d6 = bb.field_72338_b + (bb.field_72337_e - bb.field_72338_b) * (double)f1;
                        double d7 = bb.field_72339_c + (bb.field_72334_f - bb.field_72339_c) * (double)f2;
                        if (this.func_72933_a(new Vec3d(d5 + d3, d6, d7 + d4), vec) == null) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public boolean func_175719_a(@Nullable EntityPlayer player, BlockPos pos, EnumFacing side) {
        if (this.func_180495_p(pos = pos.func_177972_a(side)).func_177230_c() == Blocks.field_150480_ab) {
            this.func_180498_a(player, 1009, pos, 0);
            this.func_175698_g(pos);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_72981_t() {
        return "All: " + this.field_72996_f.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_72827_u() {
        return this.field_73020_y.func_73148_d();
    }

    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return null;
        }
        TileEntity tileentity = null;
        if (this.field_147481_N) {
            tileentity = this.func_189508_F(pos);
        }
        if (tileentity == null) {
            tileentity = this.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = this.func_189508_F(pos);
        }
        return tileentity;
    }

    @Nullable
    private TileEntity func_189508_F(BlockPos pos) {
        for (int i = 0; i < this.field_147484_a.size(); ++i) {
            TileEntity tileentity = this.field_147484_a.get(i);
            if (tileentity.func_145837_r() || !tileentity.func_174877_v().equals((Object)pos)) continue;
            return tileentity;
        }
        return null;
    }

    public void func_175690_a(BlockPos pos, @Nullable TileEntity tileEntityIn) {
        if (!World.func_189509_E(pos = pos.func_185334_h()) && tileEntityIn != null && !tileEntityIn.func_145837_r()) {
            if (this.field_147481_N) {
                tileEntityIn.func_174878_a(pos);
                if (tileEntityIn.func_145831_w() != this) {
                    tileEntityIn.func_145834_a(this);
                }
                Iterator<TileEntity> iterator = this.field_147484_a.iterator();
                while (iterator.hasNext()) {
                    TileEntity tileentity = iterator.next();
                    if (!tileentity.func_174877_v().equals((Object)pos)) continue;
                    tileentity.func_145843_s();
                    iterator.remove();
                }
                this.field_147484_a.add(tileEntityIn);
            } else {
                Chunk chunk = this.func_175726_f(pos);
                if (chunk != null) {
                    chunk.func_177426_a(pos, tileEntityIn);
                }
                this.func_175700_a(tileEntityIn);
            }
        }
    }

    public void func_175713_t(BlockPos pos) {
        TileEntity tileentity = this.func_175625_s(pos);
        if (tileentity != null && this.field_147481_N) {
            tileentity.func_145843_s();
            this.field_147484_a.remove((Object)tileentity);
            if (!(tileentity instanceof ITickable)) {
                this.field_147482_g.remove((Object)tileentity);
            }
        } else {
            if (tileentity != null) {
                this.field_147484_a.remove((Object)tileentity);
                this.field_147482_g.remove((Object)tileentity);
                this.field_175730_i.remove((Object)tileentity);
            }
            this.func_175726_f(pos).func_177425_e(pos);
        }
        this.func_175666_e(pos, this.func_180495_p(pos).func_177230_c());
    }

    public void func_147457_a(TileEntity tileEntityIn) {
        this.field_147483_b.add(tileEntityIn);
    }

    public boolean func_175665_u(BlockPos pos) {
        return Block.func_208062_a(this.func_180495_p(pos).func_196952_d((IBlockReader)this, pos));
    }

    public boolean func_195588_v(BlockPos pos) {
        if (World.func_189509_E(pos)) {
            return false;
        }
        Chunk chunk = this.field_73020_y.func_186025_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, false, false);
        return chunk != null && !chunk.func_76621_g();
    }

    public boolean func_195595_w(BlockPos pos) {
        return this.func_195588_v(pos) && this.func_180495_p(pos).isTopSolid(this, pos);
    }

    public void func_72966_v() {
        int i = this.func_72967_a(1.0f);
        if (i != this.field_73008_k) {
            this.field_73008_k = i;
        }
    }

    public void func_72891_a(boolean hostile, boolean peaceful) {
        this.field_72985_G = hostile;
        this.field_72992_H = peaceful;
        this.field_73011_w.setAllowedSpawnTypes(hostile, peaceful);
    }

    public void func_72835_b(BooleanSupplier p_72835_1_) {
        this.field_175728_M.func_212673_r();
        this.func_72979_l();
    }

    protected void func_72947_a() {
        this.field_73011_w.calculateInitialWeather();
    }

    public void calculateInitialWeatherBody() {
        if (this.field_72986_A.func_76059_o()) {
            this.field_73004_o = 1.0f;
            if (this.field_72986_A.func_76061_m()) {
                this.field_73017_q = 1.0f;
            }
        }
    }

    @Override
    public void close() {
        this.field_73020_y.close();
    }

    protected void func_72979_l() {
        this.field_73011_w.updateWeather();
    }

    public void updateWeatherBody() {
        if (this.field_73011_w.func_191066_m() && !this.field_72995_K) {
            boolean flag = this.func_82736_K().func_82766_b("doWeatherCycle");
            if (flag) {
                int j;
                int i = this.field_72986_A.func_176133_A();
                if (i > 0) {
                    this.field_72986_A.func_176142_i(--i);
                    this.field_72986_A.func_76090_f(this.field_72986_A.func_76061_m() ? 1 : 2);
                    this.field_72986_A.func_76080_g(this.field_72986_A.func_76059_o() ? 1 : 2);
                }
                if ((j = this.field_72986_A.func_76071_n()) <= 0) {
                    if (this.field_72986_A.func_76061_m()) {
                        this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(12000) + 3600);
                    } else {
                        this.field_72986_A.func_76090_f(this.field_73012_v.nextInt(168000) + 12000);
                    }
                } else {
                    this.field_72986_A.func_76090_f(--j);
                    if (j <= 0) {
                        this.field_72986_A.func_76069_a(!this.field_72986_A.func_76061_m());
                    }
                }
                int k = this.field_72986_A.func_76083_p();
                if (k <= 0) {
                    if (this.field_72986_A.func_76059_o()) {
                        this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(12000) + 12000);
                    } else {
                        this.field_72986_A.func_76080_g(this.field_73012_v.nextInt(168000) + 12000);
                    }
                } else {
                    this.field_72986_A.func_76080_g(--k);
                    if (k <= 0) {
                        this.field_72986_A.func_76084_b(!this.field_72986_A.func_76059_o());
                    }
                }
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            this.field_73017_q = MathHelper.func_76131_a((float)this.field_73017_q, (float)0.0f, (float)1.0f);
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            this.field_73004_o = MathHelper.func_76131_a((float)this.field_73004_o, (float)0.0f, (float)1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void func_147467_a(int x, int z, Chunk chunkIn) {
        chunkIn.func_76594_o();
    }

    protected void func_147456_g() {
    }

    public boolean func_175664_x(BlockPos pos) {
        boolean flag = false;
        if (this.field_73011_w.func_191066_m()) {
            flag |= this.func_180500_c(EnumLightType.SKY, pos);
        }
        return flag |= this.func_180500_c(EnumLightType.BLOCK, pos);
    }

    private int func_175638_a(BlockPos pos, EnumLightType lightType) {
        if (lightType == EnumLightType.SKY && this.func_175678_i(pos)) {
            return 15;
        }
        IBlockState iblockstate = this.func_180495_p(pos);
        int i = lightType == EnumLightType.SKY ? 0 : iblockstate.getLightValue(this, pos);
        int j = iblockstate.func_200016_a((IBlockReader)this, pos);
        if (j < 1) {
            j = 1;
        }
        if (j >= 15) {
            return i;
        }
        if (i >= 14) {
            return i;
        }
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (EnumFacing enumfacing : field_200007_a) {
                int l;
                blockpos$pooledmutableblockpos.func_189533_g((Vec3i)pos).func_189536_c(enumfacing);
                int k = this.func_175642_b(lightType, (BlockPos)blockpos$pooledmutableblockpos) - j;
                if (k > i) {
                    i = k;
                }
                if (i < 14) continue;
                int n = l = i;
                return n;
            }
            int n = i;
            return n;
        }
    }

    public boolean func_180500_c(EnumLightType lightType, BlockPos pos) {
        if (!this.func_175648_a(pos, 16, false)) {
            return false;
        }
        int i = 0;
        int j = 0;
        int updateRange = this.func_175648_a(pos, 18, false) ? 17 : 15;
        this.field_72984_F.func_76320_a("getBrightness");
        int k = this.func_175642_b(lightType, pos);
        int l = this.func_175638_a(pos, lightType);
        int i1 = pos.func_177958_n();
        int j1 = pos.func_177956_o();
        int k1 = pos.func_177952_p();
        if (l > k) {
            this.field_72994_J[j++] = 133152;
        } else if (l < k) {
            this.field_72994_J[j++] = 0x20820 | k << 18;
            while (i < j) {
                int l3;
                int k3;
                int j3;
                int l1 = this.field_72994_J[i++];
                int i2 = (l1 & 0x3F) - 32 + i1;
                int j2 = (l1 >> 6 & 0x3F) - 32 + j1;
                int k2 = (l1 >> 12 & 0x3F) - 32 + k1;
                int l2 = l1 >> 18 & 0xF;
                BlockPos blockpos = new BlockPos(i2, j2, k2);
                int i3 = this.func_175642_b(lightType, blockpos);
                if (i3 != l2) continue;
                this.func_175653_a(lightType, blockpos, 0);
                if (l2 <= 0 || (j3 = MathHelper.func_76130_a((int)(i2 - i1))) + (k3 = MathHelper.func_76130_a((int)(j2 - j1))) + (l3 = MathHelper.func_76130_a((int)(k2 - k1))) >= updateRange) continue;
                BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
                Throwable throwable = null;
                try {
                    for (EnumFacing enumfacing : field_200007_a) {
                        int i4 = i2 + enumfacing.func_82601_c();
                        int j4 = j2 + enumfacing.func_96559_d();
                        int k4 = k2 + enumfacing.func_82599_e();
                        blockpos$pooledmutableblockpos.func_181079_c(i4, j4, k4);
                        int l4 = Math.max(1, this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos).func_200016_a((IBlockReader)this, (BlockPos)blockpos$pooledmutableblockpos));
                        i3 = this.func_175642_b(lightType, (BlockPos)blockpos$pooledmutableblockpos);
                        if (i3 != l2 - l4 || j >= this.field_72994_J.length) continue;
                        this.field_72994_J[j++] = i4 - i1 + 32 | j4 - j1 + 32 << 6 | k4 - k1 + 32 << 12 | l2 - l4 << 18;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (blockpos$pooledmutableblockpos == null) continue;
                    if (throwable != null) {
                        try {
                            blockpos$pooledmutableblockpos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    blockpos$pooledmutableblockpos.close();
                }
            }
            i = 0;
        }
        this.field_72984_F.func_76319_b();
        this.field_72984_F.func_76320_a("checkedPosition < toCheckCount");
        while (i < j) {
            boolean flag;
            int i5 = this.field_72994_J[i++];
            int j5 = (i5 & 0x3F) - 32 + i1;
            int k5 = (i5 >> 6 & 0x3F) - 32 + j1;
            int l5 = (i5 >> 12 & 0x3F) - 32 + k1;
            BlockPos blockpos1 = new BlockPos(j5, k5, l5);
            int i6 = this.func_175642_b(lightType, blockpos1);
            int j6 = this.func_175638_a(blockpos1, lightType);
            if (j6 == i6) continue;
            this.func_175653_a(lightType, blockpos1, j6);
            if (j6 <= i6) continue;
            int k6 = Math.abs(j5 - i1);
            int l6 = Math.abs(k5 - j1);
            int i7 = Math.abs(l5 - k1);
            boolean bl = flag = j < this.field_72994_J.length - 6;
            if (k6 + l6 + i7 >= updateRange || !flag) continue;
            if (this.func_175642_b(lightType, blockpos1.func_177976_e()) < j6) {
                this.field_72994_J[j++] = j5 - 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.func_175642_b(lightType, blockpos1.func_177974_f()) < j6) {
                this.field_72994_J[j++] = j5 + 1 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.func_175642_b(lightType, blockpos1.func_177977_b()) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.func_175642_b(lightType, blockpos1.func_177984_a()) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 + 1 - j1 + 32 << 6) + (l5 - k1 + 32 << 12);
            }
            if (this.func_175642_b(lightType, blockpos1.func_177978_c()) < j6) {
                this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 - 1 - k1 + 32 << 12);
            }
            if (this.func_175642_b(lightType, blockpos1.func_177968_d()) >= j6) continue;
            this.field_72994_J[j++] = j5 - i1 + 32 + (k5 - j1 + 32 << 6) + (l5 + 1 - k1 + 32 << 12);
        }
        this.field_72984_F.func_76319_b();
        return true;
    }

    public Stream<VoxelShape> func_212392_a(@Nullable Entity p_212392_1_, VoxelShape p_212392_2_, VoxelShape p_212392_3_, Set<Entity> p_212392_4_) {
        Stream stream = IWorld.super.func_212392_a(p_212392_1_, p_212392_2_, p_212392_3_, p_212392_4_);
        return p_212392_1_ == null ? stream : Stream.concat(stream, this.func_211155_a(p_212392_1_, p_212392_2_, p_212392_4_));
    }

    public List<Entity> func_175674_a(@Nullable Entity entityIn, AxisAlignedBB boundingBox, @Nullable Predicate<? super Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)((boundingBox.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76128_c((double)((boundingBox.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((boundingBox.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76128_c((double)((boundingBox.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        for (int i1 = i; i1 <= j; ++i1) {
            for (int j1 = k; j1 <= l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177414_a(entityIn, boundingBox, list, predicate);
            }
        }
        return list;
    }

    public <T extends Entity> List<T> func_175644_a(Class<? extends T> entityType, Predicate<? super T> filter) {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.field_72996_f) {
            if (!entityType.isAssignableFrom(((Object)((Object)entity)).getClass()) || !filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public <T extends Entity> List<T> func_175661_b(Class<? extends T> playerType, Predicate<? super T> filter) {
        ArrayList list = Lists.newArrayList();
        for (Entity entity : this.field_73010_i) {
            if (!playerType.isAssignableFrom(((Object)((Object)entity)).getClass()) || !filter.test(entity)) continue;
            list.add(entity);
        }
        return list;
    }

    public <T extends Entity> List<T> func_72872_a(Class<? extends T> classEntity, AxisAlignedBB bb) {
        return this.func_175647_a(classEntity, bb, EntitySelectors.field_180132_d);
    }

    public <T extends Entity> List<T> func_175647_a(Class<? extends T> clazz, AxisAlignedBB aabb, @Nullable Predicate<? super T> filter) {
        int i = MathHelper.func_76128_c((double)((aabb.field_72340_a - this.getMaxEntityRadius()) / 16.0));
        int j = MathHelper.func_76143_f((double)((aabb.field_72336_d + this.getMaxEntityRadius()) / 16.0));
        int k = MathHelper.func_76128_c((double)((aabb.field_72339_c - this.getMaxEntityRadius()) / 16.0));
        int l = MathHelper.func_76143_f((double)((aabb.field_72334_f + this.getMaxEntityRadius()) / 16.0));
        ArrayList list = Lists.newArrayList();
        for (int i1 = i; i1 < j; ++i1) {
            for (int j1 = k; j1 < l; ++j1) {
                if (!this.func_175680_a(i1, j1, true)) continue;
                this.func_72964_e(i1, j1).func_177430_a(clazz, aabb, list, filter);
            }
        }
        return list;
    }

    @Nullable
    public <T extends Entity> T func_72857_a(Class<? extends T> entityType, AxisAlignedBB aabb, T closestTo) {
        List<T> list = this.func_72872_a(entityType, aabb);
        Entity t = null;
        double d0 = Double.MAX_VALUE;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity t1 = (Entity)((Object)list.get(i));
            if (t1 == closestTo || !EntitySelectors.field_180132_d.test(t1) || (d1 = closestTo.func_70068_e(t1)) > d0) continue;
            t = t1;
            d0 = d1;
        }
        return (T)((Object)t);
    }

    @Nullable
    public Entity func_73045_a(int id) {
        return (Entity)((Object)this.field_175729_l.func_76041_a(id));
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_212419_R() {
        return this.field_72996_f.size();
    }

    public void func_175646_b(BlockPos pos, TileEntity unusedTileEntity) {
        if (this.func_175667_e(pos)) {
            this.func_175726_f(pos).func_76630_e();
        }
    }

    public int func_72907_a(Class<?> entityType, int p_72907_2_) {
        int i = 0;
        Iterator<Entity> iterator = this.field_72996_f.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return i;
            }
            Entity entity = iterator.next();
            if (entity instanceof EntityLiving && ((EntityLiving)entity).func_104002_bU()) continue;
            if (entityType.isAssignableFrom(((Object)((Object)entity)).getClass())) {
                ++i;
            }
            if (i > p_72907_2_) break;
        }
        return i;
    }

    public void func_212420_a(Stream<Entity> p_212420_1_) {
        p_212420_1_.filter(e -> !MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(e, this))).forEach(p_212418_1_ -> {
            this.field_72996_f.add((Entity)((Object)p_212418_1_));
            this.func_72923_a((Entity)((Object)p_212418_1_));
        });
    }

    public void func_175681_c(Collection<Entity> entityCollection) {
        this.field_72997_g.addAll(entityCollection);
    }

    public int func_181545_F() {
        return this.field_181546_a;
    }

    @Override
    public World func_201672_e() {
        return this;
    }

    public void func_181544_b(int seaLevelIn) {
        this.field_181546_a = seaLevelIn;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return this.func_180495_p(pos).func_185893_b((IBlockReader)this, pos, direction);
    }

    public WorldType func_175624_G() {
        return this.field_72986_A.func_76067_t();
    }

    public int func_175676_y(BlockPos pos) {
        int i = 0;
        if ((i = Math.max(i, this.func_175627_a(pos.func_177977_b(), EnumFacing.DOWN))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177984_a(), EnumFacing.UP))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177978_c(), EnumFacing.NORTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177968_d(), EnumFacing.SOUTH))) >= 15) {
            return i;
        }
        if ((i = Math.max(i, this.func_175627_a(pos.func_177976_e(), EnumFacing.WEST))) >= 15) {
            return i;
        }
        return (i = Math.max(i, this.func_175627_a(pos.func_177974_f(), EnumFacing.EAST))) >= 15 ? i : i;
    }

    public boolean func_175709_b(BlockPos pos, EnumFacing side) {
        return this.func_175651_c(pos, side) > 0;
    }

    public int func_175651_c(BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = this.func_180495_p(pos);
        return iblockstate.shouldCheckWeakPower(this, pos, facing) ? this.func_175676_y(pos) : iblockstate.func_185911_a((IBlockReader)this, pos, facing);
    }

    public boolean func_175640_z(BlockPos pos) {
        if (this.func_175651_c(pos.func_177977_b(), EnumFacing.DOWN) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177984_a(), EnumFacing.UP) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177978_c(), EnumFacing.NORTH) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177968_d(), EnumFacing.SOUTH) > 0) {
            return true;
        }
        if (this.func_175651_c(pos.func_177976_e(), EnumFacing.WEST) > 0) {
            return true;
        }
        return this.func_175651_c(pos.func_177974_f(), EnumFacing.EAST) > 0;
    }

    public int func_175687_A(BlockPos pos) {
        int i = 0;
        for (EnumFacing enumfacing : field_200007_a) {
            int j = this.func_175651_c(pos.func_177972_a(enumfacing), enumfacing);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    @Nullable
    public EntityPlayer func_190525_a(double x, double y, double z, double distance, Predicate<Entity> predicate) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = this.field_73010_i.get(i);
            if (!predicate.test(entityplayer1)) continue;
            double d1 = entityplayer1.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(d1 < distance * distance) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public boolean func_175636_b(double x, double y, double z, double range) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = this.field_73010_i.get(i);
            if (!EntitySelectors.field_180132_d.test(entityplayer)) continue;
            double d0 = entityplayer.func_70092_e(x, y, z);
            if (!(range < 0.0) && !(d0 < range * range)) continue;
            return true;
        }
        return false;
    }

    public boolean func_212417_b(double p_212417_1_, double p_212417_3_, double p_212417_5_, double p_212417_7_) {
        for (EntityPlayer entityplayer : this.field_73010_i) {
            if (!EntitySelectors.field_180132_d.test(entityplayer) || !EntitySelectors.field_212545_b.test(entityplayer)) continue;
            double d0 = entityplayer.func_70092_e(p_212417_1_, p_212417_3_, p_212417_5_);
            if (!(p_212417_7_ < 0.0) && !(d0 < p_212417_7_ * p_212417_7_)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public EntityPlayer func_212817_a(double p_212817_1_, double p_212817_3_, double p_212817_5_) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = this.field_73010_i.get(i);
            if (!EntitySelectors.field_180132_d.test(entityplayer1)) continue;
            double d1 = entityplayer1.func_70092_e(p_212817_1_, entityplayer1.field_70163_u, p_212817_3_);
            if (!(p_212817_5_ < 0.0) && !(d1 < p_212817_5_ * p_212817_5_) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    @Nullable
    public EntityPlayer func_184142_a(Entity entityIn, double maxXZDistance, double maxYDistance) {
        return this.func_184150_a(entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, maxXZDistance, maxYDistance, null, null);
    }

    @Nullable
    public EntityPlayer func_184139_a(BlockPos pos, double maxXZDistance, double maxYDistance) {
        return this.func_184150_a((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, maxXZDistance, maxYDistance, null, null);
    }

    @Nullable
    public EntityPlayer func_184150_a(double posX, double posY, double posZ, double maxXZDistance, double maxYDistance, @Nullable Function<EntityPlayer, Double> playerToDouble, @Nullable Predicate<EntityPlayer> predicate) {
        double d0 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer1 = this.field_73010_i.get(i);
            if (entityplayer1.field_71075_bZ.field_75102_a || !entityplayer1.func_70089_S() || entityplayer1.func_175149_v() || predicate != null && !predicate.test(entityplayer1)) continue;
            double d1 = entityplayer1.func_70092_e(posX, entityplayer1.field_70163_u, posZ);
            double d2 = maxXZDistance;
            if (entityplayer1.func_70093_af()) {
                d2 = maxXZDistance * (double)0.8f;
            }
            if (entityplayer1.func_82150_aj()) {
                float f = entityplayer1.func_82243_bO();
                if (f < 0.1f) {
                    f = 0.1f;
                }
                d2 *= (double)(0.7f * f);
            }
            if (playerToDouble != null) {
                d2 *= ((Double)MoreObjects.firstNonNull((Object)playerToDouble.apply(entityplayer1), (Object)1.0)).doubleValue();
            }
            d2 = ForgeHooks.getPlayerVisibilityDistance((EntityPlayer)entityplayer1, (double)d2, (double)maxYDistance);
            if (!(maxYDistance < 0.0) && !(Math.abs(entityplayer1.field_70163_u - posY) < maxYDistance * maxYDistance) || !(maxXZDistance < 0.0) && !(d1 < d2 * d2) || d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    @Nullable
    public EntityPlayer func_72924_a(String name) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = this.field_73010_i.get(i);
            if (!name.equals(entityplayer.func_200200_C_().getString())) continue;
            return entityplayer;
        }
        return null;
    }

    @Nullable
    public EntityPlayer func_152378_a(UUID uuid) {
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = this.field_73010_i.get(i);
            if (!uuid.equals(entityplayer.func_110124_au())) continue;
            return entityplayer;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72882_A() {
    }

    public void func_72906_B() throws SessionLockException {
        this.field_73019_z.func_75762_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_82738_a(long worldTime) {
        this.field_72986_A.func_82572_b(worldTime);
    }

    @Override
    public long func_72905_C() {
        return this.field_73011_w.getSeed();
    }

    public long func_82737_E() {
        return this.field_72986_A.func_82573_f();
    }

    public long func_72820_D() {
        return this.field_73011_w.getWorldTime();
    }

    public void func_72877_b(long time) {
        this.field_73011_w.setWorldTime(time);
    }

    @Override
    public BlockPos func_175694_M() {
        BlockPos blockpos = this.field_73011_w.getSpawnPoint();
        if (!this.func_175723_af().func_177746_a(blockpos)) {
            blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_177731_f(), 0.0, this.func_175723_af().func_177721_g()));
        }
        return blockpos;
    }

    public void func_175652_B(BlockPos pos) {
        this.field_73011_w.setSpawnPoint(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72897_h(Entity entityIn) {
        int i = MathHelper.func_76128_c((double)(entityIn.field_70165_t / 16.0));
        int j = MathHelper.func_76128_c((double)(entityIn.field_70161_v / 16.0));
        int k = 2;
        for (int l = -2; l <= 2; ++l) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                this.func_72964_e(i + l, j + i1);
            }
        }
        if (!this.field_72996_f.contains((Object)entityIn) && !MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(entityIn, this))) {
            this.field_72996_f.add(entityIn);
        }
    }

    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        return this.field_73011_w.canMineBlock(player, pos);
    }

    public boolean canMineBlockBody(EntityPlayer player, BlockPos pos) {
        return true;
    }

    public void func_72960_a(Entity entityIn, byte state) {
    }

    @Override
    public IChunkProvider func_72863_F() {
        return this.field_73020_y;
    }

    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.func_180495_p(pos).func_189547_a(this, pos, eventID, eventParam);
    }

    @Override
    public ISaveHandler func_72860_G() {
        return this.field_73019_z;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_72986_A;
    }

    public GameRules func_82736_K() {
        return this.field_72986_A.func_82574_x();
    }

    public void func_72854_c() {
    }

    public float func_72819_i(float delta) {
        return (this.field_73018_p + (this.field_73017_q - this.field_73018_p) * delta) * this.func_72867_j(delta);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_147442_i(float strength) {
        this.field_73018_p = strength;
        this.field_73017_q = strength;
    }

    public float func_72867_j(float delta) {
        return this.field_73003_n + (this.field_73004_o - this.field_73003_n) * delta;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_72894_k(float strength) {
        this.field_73003_n = strength;
        this.field_73004_o = strength;
    }

    public boolean func_72911_I() {
        if (this.field_73011_w.func_191066_m() && !this.field_73011_w.func_177495_o()) {
            return (double)this.func_72819_i(1.0f) > 0.9;
        }
        return false;
    }

    public boolean func_72896_J() {
        return (double)this.func_72867_j(1.0f) > 0.2;
    }

    public boolean func_175727_C(BlockPos position) {
        if (!this.func_72896_J()) {
            return false;
        }
        if (!this.func_175678_i(position)) {
            return false;
        }
        if (this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, position).func_177956_o() > position.func_177956_o()) {
            return false;
        }
        return this.func_180494_b(position).func_201851_b() == Biome.RainType.RAIN;
    }

    public boolean func_180502_D(BlockPos pos) {
        return this.field_73011_w.isHighHumidity(pos);
    }

    @Nullable
    public WorldSavedDataStorage func_175693_T() {
        return this.field_72988_C;
    }

    public void func_175669_a(int id, BlockPos pos, int data) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            this.field_73021_x.get(i).func_180440_a(id, pos, data);
        }
    }

    public void func_175718_b(int type, BlockPos pos, int data) {
        this.func_180498_a(null, type, pos, data);
    }

    public void func_180498_a(@Nullable EntityPlayer player, int type, BlockPos pos, int data) {
        try {
            for (int i = 0; i < this.field_73021_x.size(); ++i) {
                this.field_73021_x.get(i).func_180439_a(player, type, pos, data);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Playing level event");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Level event being played");
            crashreportcategory.func_71507_a("Block coordinates", CrashReportCategory.func_180522_a(pos));
            crashreportcategory.func_71507_a("Event source", (Object)player);
            crashreportcategory.func_71507_a("Event type", type);
            crashreportcategory.func_71507_a("Event data", data);
            throw new ReportedException(crashreport);
        }
    }

    public int func_72800_K() {
        return this.field_73011_w.getHeight();
    }

    public int func_72940_L() {
        return this.field_73011_w.getActualHeight();
    }

    public double func_72919_O() {
        return this.field_73011_w.getHorizon();
    }

    public CrashReportCategory func_72914_a(CrashReport report) {
        CrashReportCategory crashreportcategory = report.func_85057_a("Affected level", 1);
        crashreportcategory.func_71507_a("Level name", this.field_72986_A == null ? "????" : this.field_72986_A.func_76065_j());
        crashreportcategory.func_189529_a("All players", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73010_i.size() + " total; " + this.field_73010_i));
        crashreportcategory.func_189529_a("Chunk stats", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_73020_y.func_73148_d()));
        try {
            this.field_72986_A.func_85118_a(crashreportcategory);
        }
        catch (Throwable throwable) {
            crashreportcategory.func_71499_a("Level Data Unobtainable", throwable);
        }
        return crashreportcategory;
    }

    public void func_175715_c(int breakerId, BlockPos pos, int progress) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            IWorldEventListener iworldeventlistener = this.field_73021_x.get(i);
            iworldeventlistener.func_180441_b(breakerId, pos, progress);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_92088_a(double x, double y, double z, double motionX, double motionY, double motionZ, @Nullable NBTTagCompound compound) {
    }

    public abstract Scoreboard func_96441_U();

    public void func_175666_e(BlockPos pos, Block blockIn) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            if (!this.func_175667_e(blockpos)) continue;
            IBlockState iblockstate = this.func_180495_p(blockpos);
            iblockstate.onNeighborChange(this, blockpos, pos);
            if (!iblockstate.isNormalCube((IBlockReader)this, blockpos) || !(iblockstate = this.func_180495_p(blockpos = blockpos.func_177972_a(enumfacing))).getWeakChanges(this, blockpos)) continue;
            iblockstate.func_189546_a(this, blockpos, blockIn, pos);
        }
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos pos) {
        long i = 0L;
        float f = 0.0f;
        if (this.func_175667_e(pos)) {
            f = this.func_130001_d();
            i = this.func_175726_f(pos).func_177416_w();
        }
        return new DifficultyInstance(this.func_175659_aa(), this.func_72820_D(), i, f);
    }

    public int func_175657_ab() {
        return this.field_73008_k;
    }

    public void func_175692_b(int newSkylightSubtracted) {
        this.field_73008_k = newSkylightSubtracted;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_175658_ac() {
        return this.field_73016_r;
    }

    public void func_175702_c(int lastLightningBoltIn) {
        this.field_73016_r = lastLightningBoltIn;
    }

    public VillageCollection func_175714_ae() {
        return this.field_72982_D;
    }

    public WorldBorder func_175723_af() {
        return this.field_175728_M;
    }

    public boolean func_72916_c(int x, int z) {
        BlockPos blockpos = this.func_175694_M();
        int i = x * 16 + 8 - blockpos.func_177958_n();
        int j = z * 16 + 8 - blockpos.func_177952_p();
        int k = 128;
        return i >= -128 && i <= 128 && j >= -128 && j <= 128;
    }

    public LongSet func_212412_ag() {
        ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        return forcedchunkssavedata != null ? LongSets.unmodifiable((LongSet)forcedchunkssavedata.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_212416_f(int p_212416_1_, int p_212416_2_) {
        ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        return forcedchunkssavedata != null && forcedchunkssavedata.func_212438_a().contains(ChunkPos.func_77272_a((int)p_212416_1_, (int)p_212416_2_));
    }

    public boolean func_212414_b(int p_212414_1_, int p_212414_2_, boolean p_212414_3_) {
        boolean flag;
        String s = "chunks";
        ForcedChunksSaveData forcedchunkssavedata = (ForcedChunksSaveData)this.func_212411_a(this.field_73011_w.func_186058_p(), ForcedChunksSaveData::new, "chunks");
        if (forcedchunkssavedata == null) {
            forcedchunkssavedata = new ForcedChunksSaveData("chunks");
            this.func_212409_a(this.field_73011_w.func_186058_p(), "chunks", (WorldSavedData)forcedchunkssavedata);
        }
        long i = ChunkPos.func_77272_a((int)p_212414_1_, (int)p_212414_2_);
        if (p_212414_3_) {
            flag = forcedchunkssavedata.func_212438_a().add(i);
            if (flag) {
                this.func_72964_e(p_212414_1_, p_212414_2_);
            }
        } else {
            flag = forcedchunkssavedata.func_212438_a().remove(i);
        }
        forcedchunkssavedata.func_76186_a(flag);
        return flag;
    }

    public void func_184135_a(Packet<?> packetIn) {
        throw new UnsupportedOperationException("Can't send packets to server unless you're on the client.");
    }

    @Nullable
    public BlockPos func_211157_a(String name, BlockPos pos, int radius, boolean p_211157_4_) {
        return null;
    }

    public Dimension func_201675_m() {
        return this.field_73011_w;
    }

    @Override
    public Random func_201674_k() {
        return this.field_73012_v;
    }

    public abstract RecipeManager func_199532_z();

    public abstract NetworkTagManager func_205772_D();

    protected void initCapabilities() {
        ICapabilityProvider parent = this.field_73011_w.initCapabilities();
        this.gatherCapabilities(parent);
        WorldCapabilityData data = (WorldCapabilityData)this.func_175693_T().func_212426_a(this.func_201675_m().func_186058_p(), WorldCapabilityData::new, "capabilities");
        if (data == null) {
            this.capabilityData = new WorldCapabilityData((INBTSerializable)this.getCapabilities());
            this.func_175693_T().func_212424_a(this.func_201675_m().func_186058_p(), this.capabilityData.func_195925_e(), (WorldSavedData)this.capabilityData);
        } else {
            this.capabilityData = data;
            this.capabilityData.setCapabilities(this.field_73011_w, (INBTSerializable)this.getCapabilities());
        }
    }

    public int countEntities(EnumCreatureType type, int max, boolean forSpawnCount) {
        int ret = 0;
        for (Entity entity : this.field_72996_f) {
            if (!entity.isCreatureType(type, forSpawnCount) || ret++ <= max) continue;
            return ret;
        }
        return ret;
    }

    public double getMaxEntityRadius() {
        return this.maxEntityRadius;
    }

    public double increaseMaxEntityRadius(double value) {
        if (value > this.maxEntityRadius) {
            this.maxEntityRadius = value;
        }
        return this.maxEntityRadius;
    }
}

