/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.INpc;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockAction;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.network.play.server.SPacketSpawnGlobalEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.profiler.Profiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ScoreboardSaveData;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServerMulti;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.BonusChestFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraft.world.storage.WorldSavedDataCallableSave;
import net.minecraft.world.storage.WorldSavedDataStorage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeWorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldServer
extends World
implements IThreadListener,
IForgeWorldServer {
    private static final Logger field_147491_a = LogManager.getLogger();
    private final MinecraftServer field_73061_a;
    private final EntityTracker field_73062_L;
    private final PlayerChunkMap field_73063_M;
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final WorldEntitySpawner field_175742_R = new WorldEntitySpawner();
    private final ServerTickList<Block> field_94579_S = new ServerTickList(this, p_205341_0_ -> p_205341_0_ == null || p_205341_0_.func_176223_P().func_196958_f(), IRegistry.field_212618_g::func_177774_c, IRegistry.field_212618_g::func_82594_a, this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList(this, p_205774_0_ -> p_205774_0_ == null || p_205774_0_ == Fluids.field_204541_a, IRegistry.field_212619_h::func_177774_c, IRegistry.field_212619_h::func_82594_a, this::func_205339_a);
    protected final VillageSiege field_175740_d = new VillageSiege(this);
    ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    protected Set<ChunkPos> doneChunks = new HashSet<ChunkPos>();
    public List<Teleporter> customTeleporters = new ArrayList<Teleporter>();

    public WorldServer(MinecraftServer p_i49819_1_, ISaveHandler p_i49819_2_, WorldSavedDataStorage p_i49819_3_, WorldInfo p_i49819_4_, DimensionType p_i49819_5_, Profiler p_i49819_6_) {
        super(p_i49819_2_, p_i49819_3_, p_i49819_4_, p_i49819_5_.func_186070_d(), p_i49819_6_, false);
        this.field_73061_a = p_i49819_1_;
        this.field_73062_L = new EntityTracker(this);
        this.field_73063_M = new PlayerChunkMap(this);
        this.field_73011_w.func_76558_a(this);
        this.field_73020_y = this.func_72970_h();
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(p_i49819_1_.func_175580_aG());
    }

    public WorldServer func_212251_i__() {
        String s = VillageCollection.func_176062_a(this.field_73011_w);
        DimensionType key = this.func_201675_m().func_186058_p().isVanilla() ? DimensionType.OVERWORLD : this.func_201675_m().func_186058_p();
        VillageCollection villagecollection = (VillageCollection)this.func_212411_a(key, VillageCollection::new, s);
        if (villagecollection == null) {
            this.field_72982_D = new VillageCollection(this);
            this.func_212409_a(key, s, this.field_72982_D);
        } else {
            this.field_72982_D = villagecollection;
            this.field_72982_D.func_82566_a(this);
        }
        ScoreboardSaveData scoreboardsavedata = (ScoreboardSaveData)this.func_212411_a(this.func_201675_m().func_186058_p(), ScoreboardSaveData::new, "scoreboard");
        if (scoreboardsavedata == null) {
            scoreboardsavedata = new ScoreboardSaveData();
            this.func_212409_a(this.func_201675_m().func_186058_p(), "scoreboard", (WorldSavedData)scoreboardsavedata);
        }
        scoreboardsavedata.func_96499_a((Scoreboard)this.field_73061_a.func_200251_aP());
        this.field_73061_a.func_200251_aP().func_186684_a((Runnable)new WorldSavedDataCallableSave((WorldSavedData)scoreboardsavedata));
        this.func_175723_af().func_177739_c(this.field_72986_A.func_176120_C(), this.field_72986_A.func_176126_D());
        this.func_175723_af().func_177744_c(this.field_72986_A.func_176140_I());
        this.func_175723_af().func_177724_b(this.field_72986_A.func_176138_H());
        this.func_175723_af().func_177747_c(this.field_72986_A.func_176131_J());
        this.func_175723_af().func_177723_b(this.field_72986_A.func_176139_K());
        if (this.field_72986_A.func_176134_F() > 0L) {
            this.func_175723_af().func_177738_a(this.field_72986_A.func_176137_E(), this.field_72986_A.func_176132_G(), this.field_72986_A.func_176134_F());
        } else {
            this.func_175723_af().func_177750_a(this.field_72986_A.func_176137_E());
        }
        this.initCapabilities();
        return this;
    }

    @Override
    public void func_72835_b(BooleanSupplier p_72835_1_) {
        this.field_211159_Q = true;
        super.func_72835_b(p_72835_1_);
        if (this.func_72912_H().func_76093_s() && this.func_175659_aa() != EnumDifficulty.HARD) {
            this.func_72912_H().func_176144_a(EnumDifficulty.HARD);
        }
        this.field_73020_y.func_201711_g().func_202090_b().func_73660_a();
        if (this.func_73056_e()) {
            if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
                long i = this.func_72820_D() + 24000L;
                this.func_72877_b(i - i % 24000L);
            }
            this.func_73053_d();
        }
        this.field_72984_F.func_76320_a("spawner");
        if (this.func_82736_K().func_82766_b("doMobSpawning") && this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.field_175742_R.func_77192_a(this, this.field_72985_G, this.field_72992_H, this.field_72986_A.func_82573_f() % 400L == 0L);
            this.func_72863_F().func_203082_a(this, this.field_72985_G, this.field_72992_H);
        }
        this.field_72984_F.func_76318_c("chunkSource");
        this.field_73020_y.func_73156_b(p_72835_1_);
        int j = this.func_72967_a(1.0f);
        if (j != this.func_175657_ab()) {
            this.func_175692_b(j);
        }
        this.field_72986_A.func_82572_b(this.field_72986_A.func_82573_f() + 1L);
        if (this.func_82736_K().func_82766_b("doDaylightCycle")) {
            this.func_72877_b(this.func_72820_D() + 1L);
        }
        this.field_72984_F.func_76318_c("tickPending");
        this.func_72955_a();
        this.field_72984_F.func_76318_c("tickBlocks");
        this.func_147456_g();
        this.field_72984_F.func_76318_c("chunkMap");
        this.field_73063_M.func_72693_b();
        this.field_72984_F.func_76318_c("village");
        this.field_72982_D.func_75544_a();
        this.field_175740_d.func_75528_a();
        this.field_72984_F.func_76318_c("portalForcer");
        this.field_85177_Q.func_85189_a(this.func_82737_E());
        this.customTeleporters.forEach(t -> t.func_85189_a(this.func_82737_E()));
        this.field_72984_F.func_76319_b();
        this.func_147488_Z();
        this.field_211159_Q = false;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    @Nullable
    public Biome.SpawnListEntry func_175734_a(EnumCreatureType creatureType, BlockPos pos) {
        List list = this.func_72863_F().func_177458_a(creatureType, pos);
        return (list = ForgeEventFactory.getPotentialSpawns((WorldServer)this, (EnumCreatureType)creatureType, (BlockPos)pos, list)).isEmpty() ? null : (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)this.field_73012_v, (List)list);
    }

    public boolean func_175732_a(EnumCreatureType creatureType, Biome.SpawnListEntry spawnListEntry, BlockPos pos) {
        List list = this.func_72863_F().func_177458_a(creatureType, pos);
        return (list = ForgeEventFactory.getPotentialSpawns((WorldServer)this, (EnumCreatureType)creatureType, (BlockPos)pos, list)) != null && !list.isEmpty() ? list.contains((Object)spawnListEntry) : false;
    }

    @Override
    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_73010_i.isEmpty()) {
            int i = 0;
            int j = 0;
            for (EntityPlayer entityplayer : this.field_73010_i) {
                if (entityplayer.func_175149_v()) {
                    ++i;
                    continue;
                }
                if (!entityplayer.func_70608_bn()) continue;
                ++j;
            }
            this.field_73068_P = j > 0 && j >= this.field_73010_i.size() - i;
        }
    }

    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    protected void func_73053_d() {
        this.field_73068_P = false;
        for (EntityPlayer entityplayer : this.field_73010_i.stream().filter(EntityPlayer::func_70608_bn).collect(Collectors.toList())) {
            entityplayer.func_70999_a(false, false, true);
        }
        if (this.func_82736_K().func_82766_b("doWeatherCycle")) {
            this.func_73051_P();
        }
    }

    private void func_73051_P() {
        this.field_73011_w.resetRainAndThunder();
    }

    public boolean func_73056_e() {
        if (this.field_73068_P && !this.field_72995_K) {
            for (EntityPlayer entityplayer : this.field_73010_i) {
                if (entityplayer.func_175149_v() || entityplayer.func_71026_bH()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_72974_f() {
        if (this.field_72986_A.func_76075_d() <= 0) {
            this.field_72986_A.func_76056_b(this.func_181545_F() + 1);
        }
        int i = this.field_72986_A.func_76079_c();
        int j = this.field_72986_A.func_76074_e();
        int k = 0;
        while (this.func_184141_c(new BlockPos(i, 0, j)).isAir((IBlockReader)this, new BlockPos(i, 0, j))) {
            i += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            j += this.field_73012_v.nextInt(8) - this.field_73012_v.nextInt(8);
            if (++k != 10000) continue;
        }
        this.field_72986_A.func_76058_a(i);
        this.field_72986_A.func_76087_c(j);
    }

    public boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return this.func_201697_a(x, z);
    }

    public boolean func_201697_a(int p_201697_1_, int p_201697_2_) {
        return this.func_72863_F().func_73149_a(p_201697_1_, p_201697_2_);
    }

    protected void func_184162_i() {
        this.field_72984_F.func_76320_a("playerCheckLight");
        if (!this.field_73010_i.isEmpty()) {
            int i = this.field_73012_v.nextInt(this.field_73010_i.size());
            EntityPlayer entityplayer = (EntityPlayer)((Object)this.field_73010_i.get(i));
            int j = MathHelper.func_76128_c((double)entityplayer.field_70165_t) + this.field_73012_v.nextInt(11) - 5;
            int k = MathHelper.func_76128_c((double)entityplayer.field_70163_u) + this.field_73012_v.nextInt(11) - 5;
            int l = MathHelper.func_76128_c((double)entityplayer.field_70161_v) + this.field_73012_v.nextInt(11) - 5;
            this.func_175664_x(new BlockPos(j, k, l));
        }
        this.field_72984_F.func_76319_b();
    }

    @Override
    protected void func_147456_g() {
        this.func_184162_i();
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            Iterator iterator1 = this.field_73063_M.func_187300_b();
            while (iterator1.hasNext()) {
                ((Chunk)iterator1.next()).func_150804_b(false);
            }
        } else {
            int i = this.func_82736_K().func_180263_c("randomTickSpeed");
            boolean flag = this.func_72896_J();
            boolean flag1 = this.func_72911_I();
            this.field_72984_F.func_76320_a("pollingChunks");
            Stream<Chunk> chunks = Stream.concat(StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.field_73063_M.func_187300_b(), 0), false), this.func_212412_ag().stream().map(l -> this.func_72964_e(ChunkPos.func_212578_a((long)l), ChunkPos.func_212579_b((long)l)))).distinct();
            Iterator iterator = chunks.iterator();
            while (iterator.hasNext()) {
                this.field_72984_F.func_76320_a("getChunk");
                Chunk chunk = (Chunk)iterator.next();
                int j = chunk.field_76635_g * 16;
                int k = chunk.field_76647_h * 16;
                this.field_72984_F.func_76318_c("checkNextLight");
                chunk.func_76594_o();
                this.field_72984_F.func_76318_c("tickChunk");
                chunk.func_150804_b(false);
                this.field_72984_F.func_76318_c("thunder");
                if (this.field_73011_w.canDoLightning(chunk) && flag && flag1 && this.field_73012_v.nextInt(100000) == 0) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    int l2 = this.field_73005_l >> 2;
                    BlockPos blockpos = this.func_175736_a(new BlockPos(j + (l2 & 0xF), 0, k + (l2 >> 8 & 0xF)));
                    if (this.func_175727_C(blockpos)) {
                        boolean flag2;
                        DifficultyInstance difficultyinstance = this.func_175649_E(blockpos);
                        boolean bl = flag2 = this.func_82736_K().func_82766_b("doMobSpawning") && this.field_73012_v.nextDouble() < (double)difficultyinstance.func_180168_b() * 0.01;
                        if (flag2) {
                            EntitySkeletonHorse entityskeletonhorse = new EntitySkeletonHorse((World)this);
                            entityskeletonhorse.func_190691_p(true);
                            entityskeletonhorse.func_70873_a(0);
                            entityskeletonhorse.func_70107_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p());
                            this.func_72838_d((Entity)entityskeletonhorse);
                        }
                        this.func_72942_c((Entity)((Object)new EntityLightningBolt(this, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, flag2)));
                    }
                }
                this.field_72984_F.func_76318_c("iceandsnow");
                if (this.field_73011_w.canDoRainSnowIce(chunk) && this.field_73012_v.nextInt(16) == 0) {
                    this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                    int i2 = this.field_73005_l >> 2;
                    BlockPos blockpos1 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(j + (i2 & 0xF), 0, k + (i2 >> 8 & 0xF)));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    Biome biome = this.func_180494_b(blockpos1);
                    if (this.func_175648_a(blockpos2, 1, false) && biome.func_201848_a(this, blockpos2)) {
                        this.func_175656_a(blockpos2, Blocks.field_150432_aD.func_176223_P());
                    }
                    if (flag && biome.func_201850_b(this, blockpos1)) {
                        this.func_175656_a(blockpos1, Blocks.field_150433_aE.func_176223_P());
                    }
                    if (flag && this.func_180494_b(blockpos2).func_201851_b() == Biome.RainType.RAIN) {
                        this.func_180495_p(blockpos2).func_177230_c().func_176224_k(this, blockpos2);
                    }
                }
                this.field_72984_F.func_76318_c("tickBlocks");
                if (i > 0) {
                    for (ChunkSection chunksection : chunk.func_76587_i()) {
                        if (chunksection == Chunk.field_186036_a || !chunksection.func_206915_b()) continue;
                        for (int j2 = 0; j2 < i; ++j2) {
                            this.field_73005_l = this.field_73005_l * 3 + 1013904223;
                            int i1 = this.field_73005_l >> 2;
                            int j1 = i1 & 0xF;
                            int k1 = i1 >> 8 & 0xF;
                            int l1 = i1 >> 16 & 0xF;
                            IBlockState iblockstate = chunksection.func_177485_a(j1, l1, k1);
                            IFluidState ifluidstate = chunksection.func_206914_b(j1, l1, k1);
                            this.field_72984_F.func_76320_a("randomTick");
                            if (iblockstate.func_204519_t()) {
                                iblockstate.func_196944_b(this, new BlockPos(j1 + j, l1 + chunksection.func_76662_d(), k1 + k), this.field_73012_v);
                            }
                            if (ifluidstate.func_206890_h()) {
                                ifluidstate.func_206891_b(this, new BlockPos(j1 + j, l1 + chunksection.func_76662_d(), k1 + k), this.field_73012_v);
                            }
                            this.field_72984_F.func_76319_b();
                        }
                    }
                }
                this.field_72984_F.func_76319_b();
            }
            this.field_72984_F.func_76319_b();
        }
    }

    protected BlockPos func_175736_a(BlockPos pos) {
        BlockPos blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(blockpos, new BlockPos(blockpos.func_177958_n(), this.func_72800_K(), blockpos.func_177952_p())).func_186662_g(3.0);
        List<EntityLivingBase> list = this.func_175647_a(EntityLivingBase.class, axisalignedbb, p_210194_1_ -> p_210194_1_ != null && p_210194_1_.func_70089_S() && this.func_175678_i(p_210194_1_.func_180425_c()));
        if (!list.isEmpty()) {
            return list.get(this.field_73012_v.nextInt(list.size())).func_180425_c();
        }
        if (blockpos.func_177956_o() == -1) {
            blockpos = blockpos.func_177981_b(2);
        }
        return blockpos;
    }

    @Override
    public void func_72939_s() {
        if (this.field_73010_i.isEmpty() && this.func_212412_ag().isEmpty()) {
            if (this.field_80004_Q++ >= 300) {
                return;
            }
        } else {
            this.func_82742_i();
        }
        this.field_73011_w.func_186059_r();
        super.func_72939_s();
    }

    @Override
    protected void func_184147_l() {
        super.func_184147_l();
        this.field_72984_F.func_76318_c("players");
        for (int i = 0; i < this.field_73010_i.size(); ++i) {
            Entity entity = (Entity)((Object)this.field_73010_i.get(i));
            Entity entity1 = entity.func_184187_bx();
            if (entity1 != null) {
                if (!entity1.field_70128_L && entity1.func_184196_w(entity)) continue;
                entity.func_184210_p();
            }
            this.field_72984_F.func_76320_a("tick");
            if (!entity.field_70128_L) {
                try {
                    this.func_72870_g(entity);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking player");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Player being ticked");
                    entity.func_85029_a(crashreportcategory);
                    throw new ReportedException(crashreport);
                }
            }
            this.field_72984_F.func_76319_b();
            this.field_72984_F.func_76320_a("remove");
            if (entity.field_70128_L) {
                int j = entity.field_70176_ah;
                int k = entity.field_70164_aj;
                if (entity.field_70175_ag && this.func_175680_a(j, k, true)) {
                    this.func_72964_e(j, k).func_76622_b(entity);
                }
                this.field_72996_f.remove((Object)entity);
                this.func_72847_b(entity);
            }
            this.field_72984_F.func_76319_b();
        }
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    public void func_72955_a() {
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
    }

    private void func_205339_a(NextTickListEntry<Fluid> fluidTickEntry) {
        IFluidState ifluidstate = this.func_204610_c(fluidTickEntry.field_180282_a);
        if (ifluidstate.func_206886_c() == fluidTickEntry.func_151351_a()) {
            ifluidstate.func_206880_a(this, fluidTickEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> blockTickEntry) {
        IBlockState iblockstate = this.func_180495_p(blockTickEntry.field_180282_a);
        if (iblockstate.func_177230_c() == blockTickEntry.func_151351_a()) {
            iblockstate.func_196940_a(this, blockTickEntry.field_180282_a, this.field_73012_v);
        }
    }

    @Override
    public void func_72866_a(Entity entityIn, boolean forceUpdate) {
        if (!this.func_175735_ai() && (entityIn instanceof EntityAnimal || entityIn instanceof EntityWaterMob)) {
            entityIn.func_70106_y();
        }
        if (!this.func_175738_ah() && entityIn instanceof INpc) {
            entityIn.func_70106_y();
        }
        super.func_72866_a(entityIn, forceUpdate);
    }

    private boolean func_175738_ah() {
        return this.field_73061_a.func_71220_V();
    }

    private boolean func_175735_ai() {
        return this.field_73061_a.func_71268_U();
    }

    @Override
    protected IChunkProvider func_72970_h() {
        IChunkLoader ichunkloader = this.field_73019_z.func_75763_a(this.field_73011_w);
        return new ChunkProviderServer(this, ichunkloader, this.func_175624_G().createChunkGenerator(this), this.field_73061_a);
    }

    @Override
    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        return super.func_175660_a(player, pos);
    }

    @Override
    public boolean canMineBlockBody(EntityPlayer player, BlockPos pos) {
        return !this.field_73061_a.func_175579_a(this, pos, player) && this.func_175723_af().func_177746_a(pos);
    }

    @Override
    public void func_72963_a(WorldSettings settings) {
        if (!this.field_72986_A.func_76070_v()) {
            try {
                this.func_73052_b(settings);
                if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
                    this.func_175737_aj();
                }
                super.func_72963_a(settings);
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception initializing level");
                try {
                    this.func_72914_a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            this.field_72986_A.func_76091_d(true);
        }
    }

    private void func_175737_aj() {
        this.field_72986_A.func_176128_f(false);
        this.field_72986_A.func_176121_c(true);
        this.field_72986_A.func_76084_b(false);
        this.field_72986_A.func_76069_a(false);
        this.field_72986_A.func_176142_i(1000000000);
        this.field_72986_A.func_76068_b(6000L);
        this.field_72986_A.func_76060_a(GameType.SPECTATOR);
        this.field_72986_A.func_176119_g(false);
        this.field_72986_A.func_176144_a(EnumDifficulty.PEACEFUL);
        this.field_72986_A.func_180783_e(true);
        this.func_82736_K().func_82764_b("doDaylightCycle", "false", this.field_73061_a);
    }

    private void func_73052_b(WorldSettings settings) {
        if (!this.field_73011_w.func_76567_e()) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177981_b(this.field_73020_y.func_201711_g().func_205470_d()));
        } else if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177984_a());
        } else {
            ChunkPos chunkpos;
            Random random;
            List list;
            if (ForgeEventFactory.onCreateWorldSpawn((World)this, (WorldSettings)settings)) {
                return;
            }
            BiomeProvider biomeprovider = this.field_73020_y.func_201711_g().func_202090_b();
            BlockPos blockpos = biomeprovider.func_180630_a(0, 0, 256, list = biomeprovider.func_76932_a(), random = new Random(this.func_72905_C()));
            ChunkPos chunkPos = chunkpos = blockpos == null ? new ChunkPos(0, 0) : new ChunkPos(blockpos);
            if (blockpos == null) {
                field_147491_a.warn("Unable to find spawn biome");
            }
            boolean flag = false;
            for (Block block : BlockTags.field_205599_H.func_199885_a()) {
                if (!biomeprovider.func_205706_b().contains(block.func_176223_P())) continue;
                flag = true;
                break;
            }
            this.field_72986_A.func_176143_a(chunkpos.func_206849_h().func_177982_a(8, this.field_73020_y.func_201711_g().func_205470_d(), 8));
            int i1 = 0;
            int j1 = 0;
            int i = 0;
            int j = -1;
            int k = 32;
            for (int l = 0; l < 1024; ++l) {
                BlockPos blockpos1;
                if (i1 > -16 && i1 <= 16 && j1 > -16 && j1 <= 16 && (blockpos1 = this.field_73011_w.func_206920_a(new ChunkPos(chunkpos.field_77276_a + i1, chunkpos.field_77275_b + j1), flag)) != null) {
                    this.field_72986_A.func_176143_a(blockpos1);
                    break;
                }
                if (i1 == j1 || i1 < 0 && i1 == -j1 || i1 > 0 && i1 == 1 - j1) {
                    int k1 = i;
                    i = -j;
                    j = k1;
                }
                i1 += i;
                j1 += j;
            }
            if (settings.func_77167_c()) {
                this.func_73047_i();
            }
        }
    }

    protected void func_73047_i() {
        BonusChestFeature bonuschestfeature = new BonusChestFeature();
        for (int i = 0; i < 10; ++i) {
            int j = this.field_72986_A.func_76079_c() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            int k = this.field_72986_A.func_76074_e() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            BlockPos blockpos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(j, 0, k)).func_177984_a();
            if (bonuschestfeature.func_212245_a((IWorld)this, (IChunkGenerator<? extends IChunkGenSettings>)this.field_73020_y.func_201711_g(), this.field_73012_v, blockpos, IFeatureConfig.field_202429_e)) break;
        }
    }

    @Nullable
    public BlockPos func_180504_m() {
        return this.field_73011_w.func_177496_h();
    }

    public void func_73044_a(boolean all, @Nullable IProgressUpdate progressCallback) throws SessionLockException {
        ChunkProviderServer chunkproviderserver = this.func_72863_F();
        if (chunkproviderserver.func_73157_c()) {
            if (progressCallback != null) {
                progressCallback.func_200210_a((ITextComponent)new TextComponentTranslation("menu.savingLevel", new Object[0]));
            }
            this.func_73042_a();
            if (progressCallback != null) {
                progressCallback.func_200209_c((ITextComponent)new TextComponentTranslation("menu.savingChunks", new Object[0]));
            }
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Save((IWorld)this));
            chunkproviderserver.func_186027_a(all);
            for (Chunk chunk : Lists.newArrayList(chunkproviderserver.func_189548_a())) {
                if (chunk == null || this.field_73063_M.func_152621_a(chunk.field_76635_g, chunk.field_76647_h)) continue;
                chunkproviderserver.func_189549_a(chunk);
            }
        }
    }

    public void func_104140_m() {
        ChunkProviderServer chunkproviderserver = this.func_72863_F();
        if (chunkproviderserver.func_73157_c()) {
            chunkproviderserver.func_104112_b();
        }
    }

    protected void func_73042_a() throws SessionLockException {
        this.func_72906_B();
        for (WorldServer worldserver : this.field_73061_a.func_212370_w()) {
            if (!(worldserver instanceof WorldServerMulti)) continue;
            ((WorldServerMulti)worldserver).func_184166_c();
        }
        this.field_72986_A.func_176145_a(this.func_175723_af().func_177741_h());
        this.field_72986_A.func_176124_d(this.func_175723_af().func_177731_f());
        this.field_72986_A.func_176141_c(this.func_175723_af().func_177721_g());
        this.field_72986_A.func_176129_e(this.func_175723_af().func_177742_m());
        this.field_72986_A.func_176125_f(this.func_175723_af().func_177727_n());
        this.field_72986_A.func_176122_j(this.func_175723_af().func_177748_q());
        this.field_72986_A.func_176136_k(this.func_175723_af().func_177740_p());
        this.field_72986_A.func_176118_b(this.func_175723_af().func_177751_j());
        this.field_72986_A.func_176135_e(this.func_175723_af().func_177732_i());
        this.field_72986_A.func_201356_c(this.field_73061_a.func_201300_aS().func_201380_c());
        this.field_73019_z.func_75755_a(this.field_72986_A, this.field_73061_a.func_184103_al().func_72378_q());
        this.func_175693_T().func_75744_a();
    }

    @Override
    public boolean func_72838_d(Entity entityIn) {
        return this.func_184165_i(entityIn) ? super.func_72838_d(entityIn) : false;
    }

    @Override
    public void func_212420_a(Stream<Entity> p_212420_1_) {
        p_212420_1_.forEach(p_212421_1_ -> {
            if (this.func_184165_i((Entity)((Object)p_212421_1_)) && !MinecraftForge.EVENT_BUS.post((Event)new EntityJoinWorldEvent(p_212421_1_, (World)this))) {
                this.field_72996_f.add(p_212421_1_);
                this.func_72923_a((Entity)((Object)p_212421_1_));
            }
        });
    }

    private boolean func_184165_i(Entity entityIn) {
        if (entityIn.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entityIn.func_200600_R()));
            return false;
        }
        UUID uuid = entityIn.func_110124_au();
        if (this.field_175741_N.containsKey(uuid)) {
            Entity entity = this.field_175741_N.get(uuid);
            if (this.field_72997_g.contains((Object)entity)) {
                this.field_72997_g.remove((Object)entity);
            } else {
                if (!(entityIn instanceof EntityPlayer)) {
                    field_147491_a.warn("Keeping entity {} that already exists with UUID {}", (Object)EntityType.func_200718_a(entity.func_200600_R()), (Object)uuid.toString());
                    return false;
                }
                field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)uuid.toString());
            }
            this.func_72973_f(entity);
        }
        return true;
    }

    @Override
    public void func_72923_a(Entity entityIn) {
        super.func_72923_a(entityIn);
        this.field_175729_l.func_76038_a(entityIn.func_145782_y(), (Object)entityIn);
        this.field_175741_N.put(entityIn.func_110124_au(), entityIn);
        Entity[] aentity = entityIn.func_70021_al();
        if (aentity != null) {
            for (Entity entity : aentity) {
                this.field_175729_l.func_76038_a(entity.func_145782_y(), (Object)entity);
            }
        }
    }

    @Override
    public void func_72847_b(Entity entityIn) {
        super.func_72847_b(entityIn);
        this.field_175729_l.func_76049_d(entityIn.func_145782_y());
        this.field_175741_N.remove(entityIn.func_110124_au());
        Entity[] aentity = entityIn.func_70021_al();
        if (aentity != null) {
            for (Entity entity : aentity) {
                this.field_175729_l.func_76049_d(entity.func_145782_y());
            }
        }
    }

    @Override
    public boolean func_72942_c(Entity entityIn) {
        if (super.func_72942_c(entityIn)) {
            this.field_73061_a.func_184103_al().func_148543_a(null, entityIn.field_70165_t, entityIn.field_70163_u, entityIn.field_70161_v, 512.0, this.field_73011_w.func_186058_p(), (Packet<?>)new SPacketSpawnGlobalEntity(entityIn));
            return true;
        }
        return false;
    }

    @Override
    public void func_72960_a(Entity entityIn, byte state) {
        this.func_73039_n().func_151248_b(entityIn, (Packet<?>)new SPacketEntityStatus(entityIn, state));
    }

    @Override
    public ChunkProviderServer func_72863_F() {
        return (ChunkProviderServer)super.func_72863_F();
    }

    @Override
    public Explosion func_211529_a(@Nullable Entity entityIn, DamageSource damageSourceIn, double x, double y, double z, float strength, boolean causesFire, boolean damagesTerrain) {
        Explosion explosion = new Explosion(this, entityIn, x, y, z, strength, causesFire, damagesTerrain);
        if (ForgeEventFactory.onExplosionStart((World)this, (Explosion)explosion)) {
            return explosion;
        }
        if (damageSourceIn != null) {
            explosion.func_199592_a(damageSourceIn);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (!damagesTerrain) {
            explosion.func_180342_d();
        }
        for (EntityPlayer entityplayer : this.field_73010_i) {
            if (!(entityplayer.func_70092_e(x, y, z) < 4096.0)) continue;
            ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet<?>)new SPacketExplosion(x, y, z, strength, explosion.func_180343_e(), explosion.func_77277_b().get((Object)entityplayer)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos pos, Block blockIn, int eventID, int eventParam) {
        this.field_147490_S.add((Object)new BlockEventData(pos, blockIn, eventID, eventParam));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockeventdata = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockeventdata)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockeventdata.func_180328_a().func_177958_n(), blockeventdata.func_180328_a().func_177956_o(), blockeventdata.func_180328_a().func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), (Packet<?>)new SPacketBlockAction(blockeventdata.func_180328_a(), blockeventdata.func_151337_f(), blockeventdata.func_151339_d(), blockeventdata.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData event) {
        IBlockState iblockstate = this.func_180495_p(event.func_180328_a());
        return iblockstate.func_177230_c() == event.func_151337_f() ? iblockstate.func_189547_a(this, event.func_180328_a(), event.func_151339_d(), event.func_151338_e()) : false;
    }

    @Override
    public void close() {
        this.field_73019_z.func_75759_a();
        super.close();
    }

    @Override
    protected void func_72979_l() {
        boolean flag = this.func_72896_J();
        super.func_72979_l();
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(7, this.field_73004_o), this.field_73011_w.func_186058_p());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
        if (flag != this.func_72896_J()) {
            if (flag) {
                this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(2, 0.0f), this.field_73011_w.func_186058_p());
            } else {
                this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(1, 0.0f), this.field_73011_w.func_186058_p());
            }
            this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(7, this.field_73004_o), this.field_73011_w.func_186058_p());
            this.field_73061_a.func_184103_al().func_148537_a((Packet<?>)new SPacketChangeGameState(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public EntityTracker func_73039_n() {
        return this.field_73062_L;
    }

    public PlayerChunkMap func_184164_w() {
        return this.field_73063_M;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_73019_z.func_186340_h();
    }

    public <T extends IParticleData> int func_195598_a(T p_195598_1_, double p_195598_2_, double p_195598_4_, double p_195598_6_, int p_195598_8_, double p_195598_9_, double p_195598_11_, double p_195598_13_, double p_195598_15_) {
        SPacketParticles spacketparticles = new SPacketParticles(p_195598_1_, false, (float)p_195598_2_, (float)p_195598_4_, (float)p_195598_6_, (float)p_195598_9_, (float)p_195598_11_, (float)p_195598_13_, (float)p_195598_15_, p_195598_8_);
        int i = 0;
        for (int j = 0; j < this.field_73010_i.size(); ++j) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)((Object)this.field_73010_i.get(j));
            if (!this.func_195601_a(entityplayermp, false, p_195598_2_, p_195598_4_, p_195598_6_, (Packet<?>)spacketparticles)) continue;
            ++i;
        }
        return i;
    }

    public <T extends IParticleData> boolean func_195600_a(EntityPlayerMP p_195600_1_, T p_195600_2_, boolean p_195600_3_, double p_195600_4_, double p_195600_6_, double p_195600_8_, int p_195600_10_, double p_195600_11_, double p_195600_13_, double p_195600_15_, double p_195600_17_) {
        SPacketParticles packet = new SPacketParticles(p_195600_2_, p_195600_3_, (float)p_195600_4_, (float)p_195600_6_, (float)p_195600_8_, (float)p_195600_11_, (float)p_195600_13_, (float)p_195600_15_, (float)p_195600_17_, p_195600_10_);
        return this.func_195601_a(p_195600_1_, p_195600_3_, p_195600_4_, p_195600_6_, p_195600_8_, (Packet<?>)packet);
    }

    private boolean func_195601_a(EntityPlayerMP p_195601_1_, boolean p_195601_2_, double p_195601_3_, double p_195601_5_, double p_195601_7_, Packet<?> p_195601_9_) {
        if (p_195601_1_.func_71121_q() != this) {
            return false;
        }
        BlockPos blockpos = p_195601_1_.func_180425_c();
        double d0 = blockpos.func_177954_c(p_195601_3_, p_195601_5_, p_195601_7_);
        if (!(d0 <= 1024.0 || p_195601_2_ && d0 <= 262144.0)) {
            return false;
        }
        p_195601_1_.field_71135_a.func_147359_a(p_195601_9_);
        return true;
    }

    @Nullable
    public Entity func_175733_a(UUID uuid) {
        return this.field_175741_N.get(uuid);
    }

    public ListenableFuture<Object> func_152344_a(Runnable runnableToSchedule) {
        return this.field_73061_a.func_152344_a(runnableToSchedule);
    }

    public boolean func_152345_ab() {
        return this.field_73061_a.func_152345_ab();
    }

    @Override
    @Nullable
    public BlockPos func_211157_a(String name, BlockPos pos, int radius, boolean p_211157_4_) {
        return this.func_72863_F().func_211268_a(this, name, pos, radius, p_211157_4_);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73061_a.func_199731_aO();
    }

    public File getChunkSaveLocation() {
        return ((AnvilChunkLoader)this.func_72863_F().field_73247_e).field_75825_d;
    }
}

