/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.dimension;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.CheckerboardBiomeProviderSettings;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.EndGenSettings;
import net.minecraft.world.gen.FlatGenSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OverworldDimension
extends Dimension {
    private final DimensionType type;

    public OverworldDimension() {
        this(DimensionType.OVERWORLD);
    }

    public OverworldDimension(DimensionType type) {
        this.type = type;
    }

    @Override
    public DimensionType func_186058_p() {
        return this.type;
    }

    @Override
    public boolean func_186056_c(int x, int z) {
        return (this.type != DimensionType.OVERWORLD || !this.field_76579_a.func_72916_c(x, z)) && super.func_186056_c(x, z);
    }

    @Override
    protected void func_76572_b() {
        this.field_191067_f = true;
    }

    public IChunkGenerator<? extends IChunkGenSettings> func_186060_c() {
        WorldType worldtype = this.field_76579_a.func_72912_H().func_76067_t();
        ChunkGeneratorType chunkgeneratortype = ChunkGeneratorType.field_205489_f;
        ChunkGeneratorType chunkgeneratortype1 = ChunkGeneratorType.field_205488_e;
        ChunkGeneratorType chunkgeneratortype2 = ChunkGeneratorType.field_206912_c;
        ChunkGeneratorType chunkgeneratortype3 = ChunkGeneratorType.field_206913_d;
        ChunkGeneratorType chunkgeneratortype4 = ChunkGeneratorType.field_206911_b;
        BiomeProviderType biomeprovidertype = BiomeProviderType.field_205461_c;
        BiomeProviderType biomeprovidertype1 = BiomeProviderType.field_206859_d;
        BiomeProviderType biomeprovidertype2 = BiomeProviderType.field_205460_b;
        if (worldtype == WorldType.field_77138_c) {
            FlatGenSettings flatgensettings = FlatGenSettings.func_210835_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_76579_a.func_72912_H().func_211027_A()));
            SingleBiomeProviderSettings singlebiomeprovidersettings1 = ((SingleBiomeProviderSettings)biomeprovidertype.func_205458_a()).func_205436_a(flatgensettings.func_82648_a());
            return chunkgeneratortype.create(this.field_76579_a, biomeprovidertype.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings1), (IChunkGenSettings)flatgensettings);
        }
        if (worldtype == WorldType.field_180272_g) {
            SingleBiomeProviderSettings singlebiomeprovidersettings = ((SingleBiomeProviderSettings)biomeprovidertype.func_205458_a()).func_205436_a(Biomes.field_76772_c);
            return chunkgeneratortype1.create(this.field_76579_a, biomeprovidertype.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings), chunkgeneratortype1.func_205483_a());
        }
        if (worldtype != WorldType.field_205394_h) {
            OverworldGenSettings overworldgensettings = (OverworldGenSettings)chunkgeneratortype4.func_205483_a();
            OverworldBiomeProviderSettings overworldbiomeprovidersettings = ((OverworldBiomeProviderSettings)biomeprovidertype1.func_205458_a()).func_205439_a(this.field_76579_a.func_72912_H()).func_205441_a(overworldgensettings);
            return chunkgeneratortype4.create(this.field_76579_a, biomeprovidertype1.func_205457_a((IBiomeProviderSettings)overworldbiomeprovidersettings), (IChunkGenSettings)overworldgensettings);
        }
        BiomeProvider biomeprovider = null;
        JsonElement jsonelement = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_76579_a.func_72912_H().func_211027_A());
        JsonObject jsonobject = jsonelement.getAsJsonObject();
        if (jsonobject.has("biome_source") && jsonobject.getAsJsonObject("biome_source").has("type") && jsonobject.getAsJsonObject("biome_source").has("options")) {
            ResourceLocation resourcelocation = new ResourceLocation(jsonobject.getAsJsonObject("biome_source").getAsJsonPrimitive("type").getAsString());
            JsonObject jsonobject1 = jsonobject.getAsJsonObject("biome_source").getAsJsonObject("options");
            Biome[] abiome = new Biome[]{Biomes.field_76771_b};
            if (jsonobject1.has("biomes")) {
                Biome[] biomeArray;
                JsonArray jsonarray = jsonobject1.getAsJsonArray("biomes");
                if (jsonarray.size() > 0) {
                    biomeArray = new Biome[jsonarray.size()];
                } else {
                    Biome[] biomeArray2 = new Biome[1];
                    biomeArray = biomeArray2;
                    biomeArray2[0] = Biomes.field_76771_b;
                }
                abiome = biomeArray;
                for (int i = 0; i < jsonarray.size(); ++i) {
                    Biome biome = IRegistry.field_212624_m.func_212608_b(new ResourceLocation(jsonarray.get(i).getAsString()));
                    abiome[i] = biome != null ? biome : Biomes.field_76771_b;
                }
            }
            if (BiomeProviderType.field_205461_c.func_206858_b().equals((Object)resourcelocation)) {
                SingleBiomeProviderSettings singlebiomeprovidersettings2 = ((SingleBiomeProviderSettings)biomeprovidertype.func_205458_a()).func_205436_a(abiome[0]);
                biomeprovider = biomeprovidertype.func_205457_a((IBiomeProviderSettings)singlebiomeprovidersettings2);
            }
            if (BiomeProviderType.field_205460_b.func_206858_b().equals((Object)resourcelocation)) {
                int j = jsonobject1.has("size") ? jsonobject1.getAsJsonPrimitive("size").getAsInt() : 2;
                CheckerboardBiomeProviderSettings checkerboardbiomeprovidersettings = ((CheckerboardBiomeProviderSettings)biomeprovidertype2.func_205458_a()).func_206860_a(abiome).func_206861_a(j);
                biomeprovider = biomeprovidertype2.func_205457_a((IBiomeProviderSettings)checkerboardbiomeprovidersettings);
            }
            if (BiomeProviderType.field_206859_d.func_206858_b().equals((Object)resourcelocation)) {
                OverworldBiomeProviderSettings overworldbiomeprovidersettings1 = ((OverworldBiomeProviderSettings)biomeprovidertype1.func_205458_a()).func_205441_a(new OverworldGenSettings()).func_205439_a(this.field_76579_a.func_72912_H());
                biomeprovider = biomeprovidertype1.func_205457_a((IBiomeProviderSettings)overworldbiomeprovidersettings1);
            }
        }
        if (biomeprovider == null) {
            biomeprovider = biomeprovidertype.func_205457_a((IBiomeProviderSettings)((SingleBiomeProviderSettings)biomeprovidertype.func_205458_a()).func_205436_a(Biomes.field_76771_b));
        }
        IBlockState iblockstate = Blocks.field_150348_b.func_176223_P();
        IBlockState iblockstate1 = Blocks.field_150355_j.func_176223_P();
        if (jsonobject.has("chunk_generator") && jsonobject.getAsJsonObject("chunk_generator").has("options")) {
            String s1;
            Block block1;
            String s;
            Block block;
            if (jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_block") && (block = IRegistry.field_212618_g.func_82594_a(new ResourceLocation(s = jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_block").getAsString()))) != null) {
                iblockstate = block.func_176223_P();
            }
            if (jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_fluid") && (block1 = IRegistry.field_212618_g.func_82594_a(new ResourceLocation(s1 = jsonobject.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_fluid").getAsString()))) != null) {
                iblockstate1 = block1.func_176223_P();
            }
        }
        if (jsonobject.has("chunk_generator") && jsonobject.getAsJsonObject("chunk_generator").has("type")) {
            ResourceLocation resourcelocation1 = new ResourceLocation(jsonobject.getAsJsonObject("chunk_generator").getAsJsonPrimitive("type").getAsString());
            if (ChunkGeneratorType.field_206912_c.func_205482_c().equals((Object)resourcelocation1)) {
                NetherGenSettings nethergensettings = (NetherGenSettings)chunkgeneratortype2.func_205483_a();
                nethergensettings.func_205535_a(iblockstate);
                nethergensettings.func_205534_b(iblockstate1);
                return chunkgeneratortype2.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)nethergensettings);
            }
            if (ChunkGeneratorType.field_206913_d.func_205482_c().equals((Object)resourcelocation1)) {
                EndGenSettings endgensettings = (EndGenSettings)chunkgeneratortype3.func_205483_a();
                endgensettings.func_205538_a(new BlockPos(0, 64, 0));
                endgensettings.func_205535_a(iblockstate);
                endgensettings.func_205534_b(iblockstate1);
                return chunkgeneratortype3.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)endgensettings);
            }
        }
        OverworldGenSettings overworldgensettings1 = (OverworldGenSettings)chunkgeneratortype4.func_205483_a();
        overworldgensettings1.func_205535_a(iblockstate);
        overworldgensettings1.func_205534_b(iblockstate1);
        return chunkgeneratortype4.create(this.field_76579_a, biomeprovider, (IChunkGenSettings)overworldgensettings1);
    }

    @Override
    @Nullable
    public BlockPos func_206920_a(ChunkPos p_206920_1_, boolean checkValid) {
        for (int i = p_206920_1_.func_180334_c(); i <= p_206920_1_.func_180332_e(); ++i) {
            for (int j = p_206920_1_.func_180333_d(); j <= p_206920_1_.func_180330_f(); ++j) {
                BlockPos blockpos = this.func_206921_a(i, j, checkValid);
                if (blockpos == null) continue;
                return blockpos;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos func_206921_a(int p_206921_1_, int p_206921_2_, boolean checkValid) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_206921_1_, 0, p_206921_2_);
        Biome biome = this.field_76579_a.func_180494_b((BlockPos)blockpos$mutableblockpos);
        IBlockState iblockstate = biome.func_203944_q().func_204108_a();
        if (checkValid && !iblockstate.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk chunk = this.field_76579_a.func_72964_e(p_206921_1_ >> 4, p_206921_2_ >> 4);
        int i = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, p_206921_1_ & 0xF, p_206921_2_ & 0xF);
        if (i < 0) {
            return null;
        }
        if (chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, p_206921_1_ & 0xF, p_206921_2_ & 0xF) > chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR, p_206921_1_ & 0xF, p_206921_2_ & 0xF)) {
            return null;
        }
        for (int j = i + 1; j >= 0; --j) {
            blockpos$mutableblockpos.func_181079_c(p_206921_1_, j, p_206921_2_);
            IBlockState iblockstate1 = this.field_76579_a.func_180495_p((BlockPos)blockpos$mutableblockpos);
            if (!iblockstate1.func_204520_s().func_206888_e()) break;
            if (!iblockstate1.equals(iblockstate)) continue;
            return blockpos$mutableblockpos.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Override
    public float func_76563_a(long worldTime, float partialTicks) {
        int i = (int)(worldTime % 24000L);
        float f = ((float)i + partialTicks) / 24000.0f - 0.25f;
        if (f < 0.0f) {
            f += 1.0f;
        }
        if (f > 1.0f) {
            f -= 1.0f;
        }
        float f1 = 1.0f - (float)((Math.cos((double)f * Math.PI) + 1.0) / 2.0);
        f += (f1 - f) / 3.0f;
        return f;
    }

    @Override
    public boolean func_76569_d() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.func_76134_b((float)(p_76562_1_ * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        float f1 = 0.7529412f;
        float f2 = 0.84705883f;
        float f3 = 1.0f;
        return new Vec3d(f1 *= f * 0.94f + 0.06f, f2 *= f * 0.94f + 0.06f, f3 *= f * 0.91f + 0.09f);
    }

    @Override
    public boolean func_76567_e() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return false;
    }
}

