/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public abstract class AbstractTreeFeature<T extends IFeatureConfig>
extends Feature<T> {
    public AbstractTreeFeature(boolean notify) {
        super(notify);
    }

    protected boolean canGrowInto(IBlockReader world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        return iblockstate.isAir(world, pos) || iblockstate.func_203425_a(BlockTags.field_206952_E) || iblockstate.func_177230_c() == Blocks.field_196658_i || Block.func_196245_f(iblockstate.func_177230_c()) || iblockstate.func_203425_a(BlockTags.field_200031_h) || iblockstate.func_203425_a(BlockTags.field_200030_g) || iblockstate.func_177230_c() == Blocks.field_150395_bd;
    }

    protected void setDirtAt(IWorld worldIn, BlockPos pos, BlockPos origin) {
        worldIn.func_180495_p(pos).onPlantGrow(worldIn, pos, origin);
    }

    @Override
    protected void func_202278_a(IWorld worldIn, BlockPos pos, IBlockState state) {
        this.func_208521_b(worldIn, pos, state);
    }

    protected final void func_208520_a(Set<BlockPos> changedBlocks, IWorld worldIn, BlockPos p_208520_3_, IBlockState p_208520_4_) {
        this.func_208521_b(worldIn, p_208520_3_, p_208520_4_);
        if (BlockTags.field_200031_h.func_199685_a_(p_208520_4_.func_177230_c())) {
            changedBlocks.add(p_208520_3_.func_185334_h());
        }
    }

    private void func_208521_b(IWorld p_208521_1_, BlockPos p_208521_2_, IBlockState p_208521_3_) {
        if (this.field_76488_a) {
            p_208521_1_.func_180501_a(p_208521_2_, p_208521_3_, 19);
        } else {
            p_208521_1_.func_180501_a(p_208521_2_, p_208521_3_, 18);
        }
    }

    @Override
    public final boolean func_212245_a(IWorld p_212245_1_, IChunkGenerator<? extends IChunkGenSettings> p_212245_2_, Random p_212245_3_, BlockPos p_212245_4_, T p_212245_5_) {
        HashSet set = Sets.newHashSet();
        boolean flag = this.func_208519_a(set, p_212245_1_, p_212245_3_, p_212245_4_);
        ArrayList list = Lists.newArrayList();
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        try (BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();){
            if (flag && !set.isEmpty()) {
                for (BlockPos blockpos : Lists.newArrayList((Iterable)set)) {
                    for (EnumFacing enumfacing : EnumFacing.values()) {
                        IBlockState iblockstate;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos).func_189536_c(enumfacing);
                        if (set.contains(blockpos$pooledmutableblockpos) || !(iblockstate = p_212245_1_.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa)) continue;
                        ((Set)list.get(0)).add(blockpos$pooledmutableblockpos.func_185334_h());
                        this.func_208521_b(p_212245_1_, (BlockPos)blockpos$pooledmutableblockpos, (IBlockState)iblockstate.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, Integer.valueOf(1)));
                    }
                }
            }
            for (int l = 1; l < 6; ++l) {
                Set set1 = (Set)list.get(l - 1);
                Set set2 = (Set)list.get(l);
                for (BlockPos blockpos1 : set1) {
                    for (EnumFacing enumfacing1 : EnumFacing.values()) {
                        int k;
                        IBlockState iblockstate1;
                        blockpos$pooledmutableblockpos.func_189533_g((Vec3i)blockpos1).func_189536_c(enumfacing1);
                        if (set1.contains(blockpos$pooledmutableblockpos) || set2.contains(blockpos$pooledmutableblockpos) || !(iblockstate1 = p_212245_1_.func_180495_p((BlockPos)blockpos$pooledmutableblockpos)).func_196959_b((IProperty)BlockStateProperties.field_208514_aa) || (k = ((Integer)iblockstate1.func_177229_b((IProperty)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                        IBlockState iblockstate2 = (IBlockState)iblockstate1.func_206870_a((IProperty)BlockStateProperties.field_208514_aa, Integer.valueOf(l + 1));
                        this.func_208521_b(p_212245_1_, (BlockPos)blockpos$pooledmutableblockpos, iblockstate2);
                        set2.add(blockpos$pooledmutableblockpos.func_185334_h());
                    }
                }
            }
        }
        return flag;
    }

    protected abstract boolean func_208519_a(Set<BlockPos> var1, IWorld var2, Random var3, BlockPos var4);
}

