/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.HugeTreesFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class MegaPineTree
extends HugeTreesFeature<NoFeatureConfig> {
    private static final IBlockState field_181633_e = Blocks.field_196618_L.func_176223_P();
    private static final IBlockState field_181634_f = Blocks.field_196645_X.func_176223_P();
    private static final IBlockState field_181635_g = Blocks.field_196661_l.func_176223_P();
    private final boolean field_150542_e;

    public MegaPineTree(boolean notify, boolean p_i45457_2_) {
        super(notify, 13, 15, field_181633_e, field_181634_f);
        this.field_150542_e = p_i45457_2_;
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = this.func_150533_a(rand);
        if (!this.func_203427_a(worldIn, position, i)) {
            return false;
        }
        this.func_150541_c(worldIn, position.func_177958_n(), position.func_177952_p(), position.func_177956_o() + i, 0, rand);
        for (int j = 0; j < i; ++j) {
            IBlockState iblockstate = worldIn.func_180495_p(position.func_177981_b(j));
            if (iblockstate.isAir((IBlockReader)worldIn, position.func_177981_b(j)) || iblockstate.func_203425_a(BlockTags.field_206952_E)) {
                this.func_208520_a(changedBlocks, worldIn, position.func_177981_b(j), this.field_76520_b);
            }
            if (j >= i - 1) continue;
            iblockstate = worldIn.func_180495_p(position.func_177982_a(1, j, 0));
            if (iblockstate.isAir((IBlockReader)worldIn, position.func_177982_a(1, j, 0)) || iblockstate.func_203425_a(BlockTags.field_206952_E)) {
                this.func_208520_a(changedBlocks, worldIn, position.func_177982_a(1, j, 0), this.field_76520_b);
            }
            if ((iblockstate = worldIn.func_180495_p(position.func_177982_a(1, j, 1))).isAir((IBlockReader)worldIn, position.func_177982_a(1, j, 1)) || iblockstate.func_203425_a(BlockTags.field_206952_E)) {
                this.func_208520_a(changedBlocks, worldIn, position.func_177982_a(1, j, 1), this.field_76520_b);
            }
            if (!(iblockstate = worldIn.func_180495_p(position.func_177982_a(0, j, 1))).isAir((IBlockReader)worldIn, position.func_177982_a(0, j, 1)) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
            this.func_208520_a(changedBlocks, worldIn, position.func_177982_a(0, j, 1), this.field_76520_b);
        }
        this.func_180711_a(worldIn, rand, position);
        return true;
    }

    private void func_150541_c(IWorld worldIn, int x, int z, int y, int p_150541_5_, Random rand) {
        int i = rand.nextInt(5) + (this.field_150542_e ? this.field_76522_a : 3);
        int j = 0;
        for (int k = y - i; k <= y; ++k) {
            int l = y - k;
            int i1 = p_150541_5_ + MathHelper.func_76141_d((float)((float)l / (float)i * 3.5f));
            this.func_175925_a(worldIn, new BlockPos(x, k, z), i1 + (l > 0 && i1 == j && (k & 1) == 0 ? 1 : 0));
            j = i1;
        }
    }

    public void func_180711_a(IWorld worldIn, Random random, BlockPos pos) {
        this.func_175933_b(worldIn, pos.func_177976_e().func_177978_c());
        this.func_175933_b(worldIn, pos.func_177965_g(2).func_177978_c());
        this.func_175933_b(worldIn, pos.func_177976_e().func_177970_e(2));
        this.func_175933_b(worldIn, pos.func_177965_g(2).func_177970_e(2));
        for (int i = 0; i < 5; ++i) {
            int j = random.nextInt(64);
            int k = j % 8;
            int l = j / 8;
            if (k != 0 && k != 7 && l != 0 && l != 7) continue;
            this.func_175933_b(worldIn, pos.func_177982_a(-3 + k, 0, -3 + l));
        }
    }

    private void func_175933_b(IWorld worldIn, BlockPos center) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.func_175934_c(worldIn, center.func_177982_a(i, 0, j));
            }
        }
    }

    private void func_175934_c(IWorld worldIn, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if (block == Blocks.field_196658_i || Block.func_196245_f(block)) {
                this.func_202278_a(worldIn, blockpos, field_181635_g);
                break;
            }
            if (!iblockstate.isAir((IBlockReader)worldIn, blockpos) && i < 0) break;
        }
    }
}

