/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class SavannaTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final IBlockState field_181643_a = Blocks.field_196621_O.func_176223_P();
    private static final IBlockState field_181644_b = Blocks.field_196572_aa.func_176223_P();

    public SavannaTreeFeature(boolean doBlockNotify) {
        super(doBlockNotify);
    }

    @Override
    public boolean func_208519_a(Set<BlockPos> changedBlocks, IWorld worldIn, Random rand, BlockPos position) {
        int i = rand.nextInt(3) + rand.nextInt(3) + 5;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_201672_e().func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_201672_e().func_72800_K()) {
                            if (this.canGrowInto((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            boolean isSoil = worldIn.func_180495_p(position.func_177977_b()).canSustainPlant((IBlockReader)worldIn, position.func_177977_b(), EnumFacing.UP, (BlockSapling)Blocks.field_196679_x);
            if (isSoil && position.func_177956_o() < worldIn.func_201672_e().func_72800_K() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                EnumFacing enumfacing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                int k2 = i - rand.nextInt(4) - 1;
                int l2 = 3 - rand.nextInt(3);
                int i3 = position.func_177958_n();
                int j1 = position.func_177952_p();
                int k1 = 0;
                for (int l1 = 0; l1 < i; ++l1) {
                    BlockPos blockpos;
                    IBlockState iblockstate;
                    int i2 = position.func_177956_o() + l1;
                    if (l1 >= k2 && l2 > 0) {
                        i3 += enumfacing.func_82601_c();
                        j1 += enumfacing.func_82599_e();
                        --l2;
                    }
                    if (!(iblockstate = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, j1))).isAir((IBlockReader)worldIn, blockpos) && !iblockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                    this.func_208532_a(changedBlocks, worldIn, blockpos);
                    k1 = i2;
                }
                BlockPos blockpos2 = new BlockPos(i3, k1, j1);
                for (int j3 = -3; j3 <= 3; ++j3) {
                    for (int i4 = -3; i4 <= 3; ++i4) {
                        if (Math.abs(j3) == 3 && Math.abs(i4) == 3) continue;
                        this.func_175924_b(worldIn, blockpos2.func_177982_a(j3, 0, i4));
                    }
                }
                blockpos2 = blockpos2.func_177984_a();
                for (int k3 = -1; k3 <= 1; ++k3) {
                    for (int j4 = -1; j4 <= 1; ++j4) {
                        this.func_175924_b(worldIn, blockpos2.func_177982_a(k3, 0, j4));
                    }
                }
                this.func_175924_b(worldIn, blockpos2.func_177965_g(2));
                this.func_175924_b(worldIn, blockpos2.func_177985_f(2));
                this.func_175924_b(worldIn, blockpos2.func_177970_e(2));
                this.func_175924_b(worldIn, blockpos2.func_177964_d(2));
                i3 = position.func_177958_n();
                j1 = position.func_177952_p();
                EnumFacing enumfacing1 = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                if (enumfacing1 != enumfacing) {
                    int l3 = k2 - rand.nextInt(2) - 1;
                    int k4 = 1 + rand.nextInt(3);
                    k1 = 0;
                    for (int l4 = l3; l4 < i && k4 > 0; ++l4, --k4) {
                        if (l4 < 1) continue;
                        int j2 = position.func_177956_o() + l4;
                        BlockPos blockpos1 = new BlockPos(i3 += enumfacing1.func_82601_c(), j2, j1 += enumfacing1.func_82599_e());
                        IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
                        if (!iblockstate1.isAir((IBlockReader)worldIn, blockpos1) && !iblockstate1.func_203425_a(BlockTags.field_206952_E)) continue;
                        this.func_208532_a(changedBlocks, worldIn, blockpos1);
                        k1 = j2;
                    }
                    if (k1 > 0) {
                        BlockPos blockpos3 = new BlockPos(i3, k1, j1);
                        for (int i5 = -2; i5 <= 2; ++i5) {
                            for (int k5 = -2; k5 <= 2; ++k5) {
                                if (Math.abs(i5) == 2 && Math.abs(k5) == 2) continue;
                                this.func_175924_b(worldIn, blockpos3.func_177982_a(i5, 0, k5));
                            }
                        }
                        blockpos3 = blockpos3.func_177984_a();
                        for (int j5 = -1; j5 <= 1; ++j5) {
                            for (int l5 = -1; l5 <= 1; ++l5) {
                                this.func_175924_b(worldIn, blockpos3.func_177982_a(j5, 0, l5));
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void func_208532_a(Set<BlockPos> p_208532_1_, IWorld p_208532_2_, BlockPos p_208532_3_) {
        this.func_208520_a(p_208532_1_, p_208532_2_, p_208532_3_, field_181643_a);
    }

    private void func_175924_b(IWorld worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.canBeReplacedByLeaves(worldIn, pos)) {
            this.func_202278_a(worldIn, pos, field_181644_b);
        }
    }
}

