/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.EndCityConfig;
import net.minecraft.world.gen.feature.structure.EndCityPieces;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EndCityStructure
extends Structure<EndCityConfig> {
    protected ChunkPos func_211744_a(IChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = chunkGenerator.func_201496_a_().func_202178_h();
        int j = chunkGenerator.func_201496_a_().func_211728_o();
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387313);
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2, l1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2);
    }

    protected boolean func_202372_a(IChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            Biome biome = chunkGen.func_202090_b().func_180300_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9), Biomes.field_180279_ad);
            if (!chunkGen.func_202094_a(biome, Feature.field_202338_p)) {
                return false;
            }
            int i = EndCityStructure.func_191070_b(chunkPosX, chunkPosZ, chunkGen);
            return i >= 60;
        }
        return false;
    }

    protected boolean func_202365_a(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    protected StructureStart func_202369_a(IWorld worldIn, IChunkGenerator<?> generator, SharedSeedRandom random, int x, int z) {
        Biome biome = generator.func_202090_b().func_180300_a(new BlockPos((x << 4) + 9, 0, (z << 4) + 9), Biomes.field_180279_ad);
        return new Start(worldIn, generator, random, x, z, biome);
    }

    protected String func_143025_a() {
        return "EndCity";
    }

    public int func_202367_b() {
        return 9;
    }

    private static int func_191070_b(int chunkX, int chunkY, IChunkGenerator<?> generatorIn) {
        Random random = new Random(chunkX + chunkY * 10387313);
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        ChunkPrimer chunkprimer = new ChunkPrimer(new ChunkPos(chunkX, chunkY), UpgradeData.field_196994_a);
        generatorIn.func_202088_a((IChunk)chunkprimer);
        int i = 5;
        int j = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            i = -5;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            i = -5;
            j = -5;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            j = -5;
        }
        int k = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7);
        int l = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7 + j);
        int i1 = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + i, 7);
        int j1 = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + i, 7 + j);
        return Math.min(Math.min(k, l), Math.min(i1, j1));
    }

    public static class Start
    extends StructureStart {
        private boolean field_186163_c;

        public Start() {
        }

        public Start(IWorld worldIn, IChunkGenerator<?> chunkGenerator, SharedSeedRandom sharedSeed, int chunkX, int chunkZ, Biome biomeIn) {
            super(chunkX, chunkZ, biomeIn, sharedSeed, worldIn.func_72905_C());
            Rotation rotation = Rotation.values()[sharedSeed.nextInt(Rotation.values().length)];
            int i = EndCityStructure.func_191070_b(chunkX, chunkZ, chunkGenerator);
            if (i < 60) {
                this.field_186163_c = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, i, chunkZ * 16 + 8);
                EndCityPieces.func_191087_a((TemplateManager)worldIn.func_72860_G().func_186340_h(), (BlockPos)blockpos, (Rotation)rotation, (List)this.field_75075_a, (Random)sharedSeed);
                this.func_202500_a((IBlockReader)worldIn);
                this.field_186163_c = true;
            }
        }

        @Override
        public boolean func_75069_d() {
            return this.field_186163_c;
        }

        @Override
        public void func_143022_a(NBTTagCompound tag) {
            super.func_143022_a(tag);
            tag.func_74757_a("Valid", this.field_186163_c);
        }

        @Override
        public void func_143017_b(NBTTagCompound tag) {
            super.func_143017_b(tag);
            this.field_186163_c = tag.func_74764_b("Valid") && tag.func_74767_n("Valid");
        }
    }
}

