/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.structure.VillagePieces;

public class VillageStructure
extends Structure<VillageConfig> {
    public String func_143025_a() {
        return "Village";
    }

    public int func_202367_b() {
        return 8;
    }

    protected boolean func_202365_a(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    protected ChunkPos func_211744_a(IChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = chunkGenerator.func_201496_a_().func_202173_a();
        int j = chunkGenerator.func_201496_a_().func_211729_b();
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387312);
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += random.nextInt(i - j), l1 += random.nextInt(i - j));
    }

    protected boolean func_202372_a(IChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            Biome biome = chunkGen.func_202090_b().func_180300_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9), Biomes.field_180279_ad);
            return chunkGen.func_202094_a(biome, Feature.field_202328_f);
        }
        return false;
    }

    protected StructureStart func_202369_a(IWorld worldIn, IChunkGenerator<?> generator, SharedSeedRandom random, int x, int z) {
        Biome biome = generator.func_202090_b().func_180300_a(new BlockPos((x << 4) + 9, 0, (z << 4) + 9), Biomes.field_180279_ad);
        return new Start(worldIn, generator, random, x, z, biome);
    }

    public static class Start
    extends StructureStart {
        private boolean field_75076_c;

        public Start() {
        }

        public Start(IWorld p_i48753_1_, IChunkGenerator<?> p_i48753_2_, SharedSeedRandom p_i48753_3_, int p_i48753_4_, int p_i48753_5_, Biome p_i48753_6_) {
            super(p_i48753_4_, p_i48753_5_, p_i48753_6_, p_i48753_3_, p_i48753_1_.func_72905_C());
            VillageConfig villageconfig = (VillageConfig)p_i48753_2_.func_202087_b(p_i48753_6_, Feature.field_202328_f);
            List<VillagePieces.PieceWeight> list = VillagePieces.func_75084_a((Random)p_i48753_3_, villageconfig.field_202461_a);
            VillagePieces.Start villagepieces$start = new VillagePieces.Start(0, (Random)p_i48753_3_, (p_i48753_4_ << 4) + 2, (p_i48753_5_ << 4) + 2, list, villageconfig, p_i48753_6_);
            this.field_75075_a.add(villagepieces$start);
            villagepieces$start.func_74861_a(villagepieces$start, this.field_75075_a, (Random)p_i48753_3_);
            List<StructurePiece> list1 = villagepieces$start.field_74930_j;
            List<StructurePiece> list2 = villagepieces$start.field_74932_i;
            while (!list1.isEmpty() || !list2.isEmpty()) {
                if (list1.isEmpty()) {
                    int i = p_i48753_3_.nextInt(list2.size());
                    StructurePiece structurepiece = list2.remove(i);
                    structurepiece.func_74861_a(villagepieces$start, this.field_75075_a, (Random)p_i48753_3_);
                    continue;
                }
                int j = p_i48753_3_.nextInt(list1.size());
                StructurePiece structurepiece2 = list1.remove(j);
                structurepiece2.func_74861_a(villagepieces$start, this.field_75075_a, (Random)p_i48753_3_);
            }
            this.func_202500_a((IBlockReader)p_i48753_1_);
            int k = 0;
            for (StructurePiece structurepiece1 : this.field_75075_a) {
                if (structurepiece1 instanceof VillagePieces.Road) continue;
                ++k;
            }
            this.field_75076_c = k > 2;
        }

        @Override
        public boolean func_75069_d() {
            return this.field_75076_c;
        }

        @Override
        public void func_143022_a(NBTTagCompound tagCompound) {
            super.func_143022_a(tagCompound);
            tagCompound.func_74757_a("Valid", this.field_75076_c);
        }

        @Override
        public void func_143017_b(NBTTagCompound tagCompound) {
            super.func_143017_b(tagCompound);
            this.field_75076_c = tagCompound.func_74767_n("Valid");
        }
    }
}

