/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.WoodlandMansionConfig;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class WoodlandMansionStructure
extends Structure<WoodlandMansionConfig> {
    protected ChunkPos func_211744_a(IChunkGenerator<?> chunkGenerator, Random random, int x, int z, int spacingOffsetsX, int spacingOffsetsZ) {
        int i = chunkGenerator.func_201496_a_().func_202179_i();
        int j = chunkGenerator.func_201496_a_().func_211726_q();
        int k = x + i * spacingOffsetsX;
        int l = z + i * spacingOffsetsZ;
        int i1 = k < 0 ? k - i + 1 : k;
        int j1 = l < 0 ? l - i + 1 : l;
        int k1 = i1 / i;
        int l1 = j1 / i;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), k1, l1, 10387319);
        k1 *= i;
        l1 *= i;
        return new ChunkPos(k1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2, l1 += (random.nextInt(i - j) + random.nextInt(i - j)) / 2);
    }

    protected boolean func_202372_a(IChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkpos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkpos.field_77276_a && chunkPosZ == chunkpos.field_77275_b) {
            for (Biome biome : chunkGen.func_202090_b().func_201538_a(chunkPosX * 16 + 9, chunkPosZ * 16 + 9, 32)) {
                if (chunkGen.func_202094_a(biome, Feature.field_202330_h)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean func_202365_a(IWorld worldIn) {
        return worldIn.func_72912_H().func_76089_r();
    }

    protected StructureStart func_202369_a(IWorld worldIn, IChunkGenerator<?> generator, SharedSeedRandom random, int x, int z) {
        Biome biome = generator.func_202090_b().func_180300_a(new BlockPos((x << 4) + 9, 0, (z << 4) + 9), Biomes.field_180279_ad);
        return new Start(worldIn, generator, random, x, z, biome);
    }

    protected String func_143025_a() {
        return "Mansion";
    }

    public int func_202367_b() {
        return 8;
    }

    public static class Start
    extends StructureStart {
        private boolean field_191093_c;

        public Start() {
        }

        public Start(IWorld world, IChunkGenerator<?> generator, SharedSeedRandom seed, int x, int z, Biome biome) {
            super(x, z, biome, seed, world.func_72905_C());
            Rotation rotation = Rotation.values()[seed.nextInt(Rotation.values().length)];
            int i = 5;
            int j = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                i = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                i = -5;
                j = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                j = -5;
            }
            ChunkPrimer chunkprimer = new ChunkPrimer(new ChunkPos(x, z), UpgradeData.field_196994_a);
            generator.func_202088_a((IChunk)chunkprimer);
            int k = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7);
            int l = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7, 7 + j);
            int i1 = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + i, 7);
            int j1 = chunkprimer.func_201576_a(Heightmap.Type.MOTION_BLOCKING, 7 + i, 7 + j);
            int k1 = Math.min(Math.min(k, l), Math.min(i1, j1));
            if (k1 < 60) {
                this.field_191093_c = false;
            } else {
                BlockPos blockpos = new BlockPos(x * 16 + 8, k1 + 1, z * 16 + 8);
                LinkedList list = Lists.newLinkedList();
                WoodlandMansionPieces.func_191152_a((TemplateManager)world.func_72860_G().func_186340_h(), (BlockPos)blockpos, (Rotation)rotation, (List)list, (Random)seed);
                this.field_75075_a.addAll(list);
                this.func_202500_a((IBlockReader)world);
                this.field_191093_c = true;
            }
        }

        @Override
        public void func_75068_a(IWorld worldIn, Random rand, MutableBoundingBox structurebb, ChunkPos p_75068_4_) {
            super.func_75068_a(worldIn, rand, structurebb, p_75068_4_);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructurePiece structurepiece : this.field_75075_a) {
                        if (!structurepiece.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }

        @Override
        public boolean func_75069_d() {
            return this.field_191093_c;
        }

        @Override
        public void func_143022_a(NBTTagCompound tag) {
            super.func_143022_a(tag);
            tag.func_74757_a("Valid", this.field_191093_c);
        }

        @Override
        public void func_143017_b(NBTTagCompound tag) {
            super.func_143017_b(tag);
            this.field_191093_c = tag.func_74764_b("Valid") && tag.func_74767_n("Valid");
        }
    }
}

