/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.VoxelShapePartBitSet;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.ITemplateProcessor;
import net.minecraft.world.gen.feature.template.IntegrityProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class Template {
    private final List<List<BlockInfo>> field_204769_a = Lists.newArrayList();
    private final List<EntityInfo> field_186271_b = Lists.newArrayList();
    private BlockPos field_186272_c = BlockPos.field_177992_a;
    private String field_186273_d = "?";

    public BlockPos func_186259_a() {
        return this.field_186272_c;
    }

    public void func_186252_a(String authorIn) {
        this.field_186273_d = authorIn;
    }

    public String func_186261_b() {
        return this.field_186273_d;
    }

    public void func_186254_a(World worldIn, BlockPos startPos, BlockPos size, boolean takeEntities, @Nullable Block toIgnore) {
        if (size.func_177958_n() >= 1 && size.func_177956_o() >= 1 && size.func_177952_p() >= 1) {
            BlockPos blockpos = startPos.func_177971_a((Vec3i)size).func_177982_a(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPos blockpos1 = new BlockPos(Math.min(startPos.func_177958_n(), blockpos.func_177958_n()), Math.min(startPos.func_177956_o(), blockpos.func_177956_o()), Math.min(startPos.func_177952_p(), blockpos.func_177952_p()));
            BlockPos blockpos2 = new BlockPos(Math.max(startPos.func_177958_n(), blockpos.func_177958_n()), Math.max(startPos.func_177956_o(), blockpos.func_177956_o()), Math.max(startPos.func_177952_p(), blockpos.func_177952_p()));
            this.field_186272_c = size;
            for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)blockpos1, (BlockPos)blockpos2)) {
                BlockPos blockpos3 = blockpos$mutableblockpos.func_177973_b((Vec3i)blockpos1);
                IBlockState iblockstate = worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos);
                if (toIgnore != null && toIgnore == iblockstate.func_177230_c()) continue;
                TileEntity tileentity = worldIn.func_175625_s((BlockPos)blockpos$mutableblockpos);
                if (tileentity != null) {
                    NBTTagCompound nbttagcompound = tileentity.func_189515_b(new NBTTagCompound());
                    nbttagcompound.func_82580_o("x");
                    nbttagcompound.func_82580_o("y");
                    nbttagcompound.func_82580_o("z");
                    list1.add(new BlockInfo(blockpos3, iblockstate, nbttagcompound));
                    continue;
                }
                if (!iblockstate.func_200015_d((IBlockReader)worldIn, (BlockPos)blockpos$mutableblockpos) && !iblockstate.func_185917_h()) {
                    list2.add(new BlockInfo(blockpos3, iblockstate, null));
                    continue;
                }
                list.add(new BlockInfo(blockpos3, iblockstate, null));
            }
            ArrayList list3 = Lists.newArrayList();
            list3.addAll(list);
            list3.addAll(list1);
            list3.addAll(list2);
            this.field_204769_a.clear();
            this.field_204769_a.add(list3);
            if (takeEntities) {
                this.func_186255_a(worldIn, blockpos1, blockpos2.func_177982_a(1, 1, 1));
            } else {
                this.field_186271_b.clear();
            }
        }
    }

    private void func_186255_a(World worldIn, BlockPos startPos, BlockPos endPos) {
        List<Entity> list = worldIn.func_175647_a(Entity.class, new AxisAlignedBB(startPos, endPos), p_201048_0_ -> !(p_201048_0_ instanceof EntityPlayer));
        this.field_186271_b.clear();
        for (Entity entity : list) {
            Vec3d vec3d = new Vec3d(entity.field_70165_t - (double)startPos.func_177958_n(), entity.field_70163_u - (double)startPos.func_177956_o(), entity.field_70161_v - (double)startPos.func_177952_p());
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            entity.func_70039_c(nbttagcompound);
            BlockPos blockpos = entity instanceof EntityPainting ? ((EntityPainting)entity).func_174857_n().func_177973_b((Vec3i)startPos) : new BlockPos(vec3d);
            this.field_186271_b.add(new EntityInfo(vec3d, blockpos, nbttagcompound));
        }
    }

    public Map<BlockPos, String> func_186258_a(BlockPos pos, PlacementSettings placementIn) {
        HashMap map = Maps.newHashMap();
        MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
        for (BlockInfo template$blockinfo : placementIn.func_204764_a(this.field_204769_a, pos)) {
            StructureMode structuremode;
            IBlockState iblockstate;
            BlockPos blockpos = Template.func_186266_a(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos);
            if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos) || (iblockstate = template$blockinfo.field_186243_b).func_177230_c() != Blocks.field_185779_df || template$blockinfo.field_186244_c == null || (structuremode = StructureMode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            map.put(blockpos, template$blockinfo.field_186244_c.func_74779_i("metadata"));
        }
        return map;
    }

    public BlockPos func_186262_a(PlacementSettings placementIn, BlockPos p_186262_2_, PlacementSettings p_186262_3_, BlockPos p_186262_4_) {
        BlockPos blockpos = Template.func_186266_a(placementIn, p_186262_2_);
        BlockPos blockpos1 = Template.func_186266_a(p_186262_3_, p_186262_4_);
        return blockpos.func_177973_b((Vec3i)blockpos1);
    }

    public static BlockPos func_186266_a(PlacementSettings placementIn, BlockPos pos) {
        return Template.func_207669_a(pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d());
    }

    public void func_186260_a(IWorld worldIn, BlockPos pos, PlacementSettings placementIn) {
        placementIn.func_186224_i();
        this.func_186253_b(worldIn, pos, placementIn);
    }

    public void func_186253_b(IWorld worldIn, BlockPos pos, PlacementSettings placementIn) {
        this.func_189960_a(worldIn, pos, (ITemplateProcessor)new IntegrityProcessor(pos, placementIn), placementIn, 2);
    }

    public boolean func_189962_a(IWorld worldIn, BlockPos pos, PlacementSettings placementIn, int flags) {
        return this.func_189960_a(worldIn, pos, (ITemplateProcessor)new IntegrityProcessor(pos, placementIn), placementIn, flags);
    }

    public boolean func_189960_a(IWorld worldIn, BlockPos pos, @Nullable ITemplateProcessor templateProcessor, PlacementSettings placementIn, int flags) {
        if (this.field_204769_a.isEmpty()) {
            return false;
        }
        List list = placementIn.func_204764_a(this.field_204769_a, pos);
        if (!(list.isEmpty() && (placementIn.func_186221_e() || this.field_186271_b.isEmpty()) || this.field_186272_c.func_177958_n() < 1 || this.field_186272_c.func_177956_o() < 1 || this.field_186272_c.func_177952_p() < 1)) {
            Block block = placementIn.func_186219_f();
            MutableBoundingBox mutableboundingbox = placementIn.func_186213_g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(placementIn.func_204763_l() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
            int i = Integer.MAX_VALUE;
            int j = Integer.MAX_VALUE;
            int k = Integer.MAX_VALUE;
            int l = Integer.MIN_VALUE;
            int i1 = Integer.MIN_VALUE;
            int j1 = Integer.MIN_VALUE;
            for (BlockInfo template$blockinfo : list) {
                TileEntity tileentity2;
                BlockInfo template$blockinfo1;
                BlockPos blockpos = Template.func_186266_a(placementIn, template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos);
                if (mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos) || (template$blockinfo1 = templateProcessor != null ? templateProcessor.func_189943_a((IBlockReader)worldIn, blockpos, template$blockinfo) : template$blockinfo) == null) continue;
                Block block1 = template$blockinfo1.field_186243_b.func_177230_c();
                if (block != null && block == block1 || placementIn.func_186227_h() && block1 == Blocks.field_185779_df || mutableboundingbox != null && !mutableboundingbox.func_175898_b((Vec3i)blockpos)) continue;
                IFluidState ifluidstate = placementIn.func_204763_l() ? worldIn.func_204610_c(blockpos) : null;
                IBlockState iblockstate = template$blockinfo1.field_186243_b.func_185902_a(placementIn.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(placementIn.func_186215_c());
                if (template$blockinfo1.field_186244_c != null) {
                    TileEntity tileentity = worldIn.func_175625_s(blockpos);
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!worldIn.func_180501_a(blockpos, iblockstate1, flags)) continue;
                i = Math.min(i, blockpos.func_177958_n());
                j = Math.min(j, blockpos.func_177956_o());
                k = Math.min(k, blockpos.func_177952_p());
                l = Math.max(l, blockpos.func_177958_n());
                i1 = Math.max(i1, blockpos.func_177956_o());
                j1 = Math.max(j1, blockpos.func_177952_p());
                list2.add(Pair.of((Object)blockpos, (Object)template$blockinfo.field_186244_c));
                if (template$blockinfo1.field_186244_c != null && (tileentity2 = worldIn.func_175625_s(blockpos)) != null) {
                    template$blockinfo1.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                    template$blockinfo1.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                    template$blockinfo1.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                    tileentity2.func_145839_a(template$blockinfo1.field_186244_c);
                    tileentity2.func_189668_a(placementIn.func_186212_b());
                    tileentity2.func_189667_a(placementIn.func_186215_c());
                }
                if (ifluidstate == null || !(iblockstate1.func_177230_c() instanceof ILiquidContainer)) continue;
                ((ILiquidContainer)iblockstate1.func_177230_c()).func_204509_a(worldIn, blockpos, iblockstate1, ifluidstate);
                if (ifluidstate.func_206889_d()) continue;
                list1.add(blockpos);
            }
            boolean flag = true;
            EnumFacing[] aenumfacing = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    IBlockState iblockstate4;
                    BlockPos blockpos1 = (BlockPos)iterator.next();
                    IFluidState ifluidstate1 = worldIn.func_204610_c(blockpos1);
                    for (int i2 = 0; i2 < aenumfacing.length && !ifluidstate1.func_206889_d(); ++i2) {
                        IFluidState ifluidstate2 = worldIn.func_204610_c(blockpos1.func_177972_a(aenumfacing[i2]));
                        if (!(ifluidstate2.func_206885_f() > ifluidstate1.func_206885_f()) && (!ifluidstate2.func_206889_d() || ifluidstate1.func_206889_d())) continue;
                        ifluidstate1 = ifluidstate2;
                    }
                    if (!ifluidstate1.func_206889_d() || !((iblockstate4 = worldIn.func_180495_p(blockpos1)).func_177230_c() instanceof ILiquidContainer)) continue;
                    ((ILiquidContainer)iblockstate4.func_177230_c()).func_204509_a(worldIn, blockpos1, iblockstate4, ifluidstate1);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i <= l) {
                VoxelShapePartBitSet voxelshapepart = new VoxelShapePartBitSet(l - i + 1, i1 - j + 1, j1 - k + 1);
                int k1 = i;
                int l1 = j;
                int j2 = k;
                for (Pair pair : list2) {
                    BlockPos blockpos2 = (BlockPos)pair.getFirst();
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - k1, blockpos2.func_177956_o() - l1, blockpos2.func_177952_p() - j2, true, true);
                }
                voxelshapepart.func_211540_a((p_211754_5_, p_211754_6_, p_211754_7_, p_211754_8_) -> {
                    IBlockState iblockstate8;
                    IBlockState iblockstate6;
                    IBlockState iblockstate7;
                    BlockPos blockpos4 = new BlockPos(k1 + p_211754_6_, l1 + p_211754_7_, j2 + p_211754_8_);
                    BlockPos blockpos5 = blockpos4.func_177972_a(p_211754_5_);
                    IBlockState iblockstate5 = worldIn.func_180495_p(blockpos4);
                    if (iblockstate5 != (iblockstate7 = iblockstate5.func_196956_a(p_211754_5_, iblockstate6 = worldIn.func_180495_p(blockpos5), worldIn, blockpos4, blockpos5))) {
                        worldIn.func_180501_a(blockpos4, iblockstate7, flags & 0xFFFFFFFE | 0x10);
                    }
                    if (iblockstate6 != (iblockstate8 = iblockstate6.func_196956_a(p_211754_5_.func_176734_d(), iblockstate7, worldIn, blockpos5, blockpos4))) {
                        worldIn.func_180501_a(blockpos5, iblockstate8, flags & 0xFFFFFFFE | 0x10);
                    }
                });
                for (Pair pair1 : list2) {
                    TileEntity tileentity1;
                    IBlockState iblockstate3;
                    BlockPos blockpos3 = (BlockPos)pair1.getFirst();
                    IBlockState iblockstate2 = worldIn.func_180495_p(blockpos3);
                    if (iblockstate2 != (iblockstate3 = Block.func_199770_b(iblockstate2, worldIn, blockpos3))) {
                        worldIn.func_180501_a(blockpos3, iblockstate3, flags & 0xFFFFFFFE | 0x10);
                    }
                    worldIn.func_195592_c(blockpos3, iblockstate3.func_177230_c());
                    if (pair1.getSecond() == null || (tileentity1 = worldIn.func_175625_s(blockpos3)) == null) continue;
                    tileentity1.func_70296_d();
                }
            }
            if (!placementIn.func_186221_e()) {
                this.func_207668_a(worldIn, pos, placementIn.func_186212_b(), placementIn.func_186215_c(), placementIn.func_207664_d(), mutableboundingbox);
            }
            return true;
        }
        return false;
    }

    private void func_207668_a(IWorld p_207668_1_, BlockPos p_207668_2_, Mirror p_207668_3_, Rotation p_207668_4_, BlockPos p_207668_5_, @Nullable MutableBoundingBox p_207668_6_) {
        for (EntityInfo template$entityinfo : this.field_186271_b) {
            Entity entity;
            BlockPos blockpos = Template.func_207669_a(template$entityinfo.field_186248_b, p_207668_3_, p_207668_4_, p_207668_5_).func_177971_a((Vec3i)p_207668_2_);
            if (p_207668_6_ != null && !p_207668_6_.func_175898_b((Vec3i)blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.field_186249_c;
            Vec3d vec3d = Template.func_207667_a(template$entityinfo.field_186247_a, p_207668_3_, p_207668_4_, p_207668_5_);
            Vec3d vec3d1 = vec3d.func_72441_c(p_207668_2_.func_177958_n(), p_207668_2_.func_177956_o(), p_207668_2_.func_177952_p());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.add((INBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.add((INBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.add((INBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbttagcompound.func_74782_a("Pos", (INBTBase)nbttaglist);
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityType.func_200716_a(nbttagcompound, p_207668_1_.func_201672_e());
            }
            catch (Exception var16) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.func_184217_a(p_207668_3_);
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(p_207668_4_), entity.field_70125_A);
            p_207668_1_.func_72838_d(entity);
        }
    }

    public BlockPos func_186257_a(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.field_186272_c.func_177952_p(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177958_n());
            }
        }
        return this.field_186272_c;
    }

    public static BlockPos func_207669_a(BlockPos targetPos, Mirror mirrorIn, Rotation rotationIn, BlockPos offset) {
        int i = targetPos.func_177958_n();
        int j = targetPos.func_177956_o();
        int k = targetPos.func_177952_p();
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                k = -k;
                break;
            }
            case FRONT_BACK: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = offset.func_177958_n();
        int i1 = offset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new BlockPos(l - i1 + k, j, l + i1 - i);
            }
            case CLOCKWISE_90: {
                return new BlockPos(l + i1 - k, j, i1 - l + i);
            }
            case CLOCKWISE_180: {
                return new BlockPos(l + l - i, j, i1 + i1 - k);
            }
        }
        return flag ? new BlockPos(i, j, k) : targetPos;
    }

    private static Vec3d func_207667_a(Vec3d target, Mirror mirrorIn, Rotation rotationIn, BlockPos centerOffset) {
        double d0 = target.field_72450_a;
        double d1 = target.field_72448_b;
        double d2 = target.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        int i = centerOffset.func_177958_n();
        int j = centerOffset.func_177952_p();
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d((double)(i - j) + d2, d1, (double)(i + j + 1) - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d((double)(i + j + 1) - d2, d1, (double)(j - i) + d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d((double)(i + i + 1) - d0, d1, (double)(j + j + 1) - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : target;
    }

    public BlockPos func_189961_a(BlockPos p_189961_1_, Mirror p_189961_2_, Rotation p_189961_3_) {
        return Template.func_191157_a(p_189961_1_, p_189961_2_, p_189961_3_, this.func_186259_a().func_177958_n(), this.func_186259_a().func_177952_p());
    }

    public static BlockPos func_191157_a(BlockPos p_191157_0_, Mirror p_191157_1_, Rotation p_191157_2_, int p_191157_3_, int p_191157_4_) {
        int i = p_191157_1_ == Mirror.FRONT_BACK ? --p_191157_3_ : 0;
        int j = p_191157_1_ == Mirror.LEFT_RIGHT ? --p_191157_4_ : 0;
        BlockPos blockpos = p_191157_0_;
        switch (p_191157_2_) {
            case COUNTERCLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(j, 0, p_191157_3_ - i);
                break;
            }
            case CLOCKWISE_90: {
                blockpos = p_191157_0_.func_177982_a(p_191157_4_ - j, 0, i);
                break;
            }
            case CLOCKWISE_180: {
                blockpos = p_191157_0_.func_177982_a(p_191157_3_ - i, 0, p_191157_4_ - j);
                break;
            }
            case NONE: {
                blockpos = p_191157_0_.func_177982_a(i, 0, j);
            }
        }
        return blockpos;
    }

    public NBTTagCompound func_189552_a(NBTTagCompound nbt) {
        if (this.field_204769_a.isEmpty()) {
            nbt.func_74782_a("blocks", (INBTBase)new NBTTagList());
            nbt.func_74782_a("palette", (INBTBase)new NBTTagList());
        } else {
            ArrayList list = Lists.newArrayList();
            BasicPalette template$basicpalette = new BasicPalette();
            list.add(template$basicpalette);
            for (int i = 1; i < this.field_204769_a.size(); ++i) {
                list.add(new BasicPalette());
            }
            NBTTagList nbttaglist1 = new NBTTagList();
            List<BlockInfo> list1 = this.field_204769_a.get(0);
            for (int j = 0; j < list1.size(); ++j) {
                BlockInfo template$blockinfo = list1.get(j);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74782_a("pos", (INBTBase)this.func_186267_a(template$blockinfo.field_186242_a.func_177958_n(), template$blockinfo.field_186242_a.func_177956_o(), template$blockinfo.field_186242_a.func_177952_p()));
                int k = template$basicpalette.func_189954_a(template$blockinfo.field_186243_b);
                nbttagcompound.func_74768_a("state", k);
                if (template$blockinfo.field_186244_c != null) {
                    nbttagcompound.func_74782_a("nbt", template$blockinfo.field_186244_c);
                }
                nbttaglist1.add((INBTBase)nbttagcompound);
                for (int l = 1; l < this.field_204769_a.size(); ++l) {
                    BasicPalette template$basicpalette1 = (BasicPalette)list.get(l);
                    template$basicpalette1.func_189956_a(this.field_204769_a.get((int)l).get((int)j).field_186243_b, k);
                }
            }
            nbt.func_74782_a("blocks", (INBTBase)nbttaglist1);
            if (list.size() == 1) {
                NBTTagList nbttaglist2 = new NBTTagList();
                for (IBlockState iblockstate : template$basicpalette) {
                    nbttaglist2.add((INBTBase)NBTUtil.func_190009_a((IBlockState)iblockstate));
                }
                nbt.func_74782_a("palette", (INBTBase)nbttaglist2);
            } else {
                NBTTagList nbttaglist3 = new NBTTagList();
                for (BasicPalette template$basicpalette2 : list) {
                    NBTTagList nbttaglist4 = new NBTTagList();
                    for (IBlockState iblockstate1 : template$basicpalette2) {
                        nbttaglist4.add((INBTBase)NBTUtil.func_190009_a((IBlockState)iblockstate1));
                    }
                    nbttaglist3.add((INBTBase)nbttaglist4);
                }
                nbt.func_74782_a("palettes", (INBTBase)nbttaglist3);
            }
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (EntityInfo template$entityinfo : this.field_186271_b) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("pos", (INBTBase)this.func_186264_a(template$entityinfo.field_186247_a.field_72450_a, template$entityinfo.field_186247_a.field_72448_b, template$entityinfo.field_186247_a.field_72449_c));
            nbttagcompound1.func_74782_a("blockPos", (INBTBase)this.func_186267_a(template$entityinfo.field_186248_b.func_177958_n(), template$entityinfo.field_186248_b.func_177956_o(), template$entityinfo.field_186248_b.func_177952_p()));
            if (template$entityinfo.field_186249_c != null) {
                nbttagcompound1.func_74782_a("nbt", template$entityinfo.field_186249_c);
            }
            nbttaglist.add((INBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("entities", (INBTBase)nbttaglist);
        nbt.func_74782_a("size", (INBTBase)this.func_186267_a(this.field_186272_c.func_177958_n(), this.field_186272_c.func_177956_o(), this.field_186272_c.func_177952_p()));
        nbt.func_74768_a("DataVersion", 1631);
        return nbt;
    }

    public void func_186256_b(NBTTagCompound compound) {
        this.field_204769_a.clear();
        this.field_186271_b.clear();
        NBTTagList nbttaglist = compound.func_150295_c("size", 3);
        this.field_186272_c = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
        NBTTagList nbttaglist1 = compound.func_150295_c("blocks", 10);
        if (compound.func_150297_b("palettes", 9)) {
            NBTTagList nbttaglist2 = compound.func_150295_c("palettes", 9);
            for (int i = 0; i < nbttaglist2.size(); ++i) {
                this.func_204768_a(nbttaglist2.func_202169_e(i), nbttaglist1);
            }
        } else {
            this.func_204768_a(compound.func_150295_c("palette", 10), nbttaglist1);
        }
        NBTTagList nbttaglist5 = compound.func_150295_c("entities", 10);
        for (int j = 0; j < nbttaglist5.size(); ++j) {
            NBTTagCompound nbttagcompound = nbttaglist5.func_150305_b(j);
            NBTTagList nbttaglist3 = nbttagcompound.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(nbttaglist3.func_150309_d(0), nbttaglist3.func_150309_d(1), nbttaglist3.func_150309_d(2));
            NBTTagList nbttaglist4 = nbttagcompound.func_150295_c("blockPos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist4.func_186858_c(0), nbttaglist4.func_186858_c(1), nbttaglist4.func_186858_c(2));
            if (!nbttagcompound.func_74764_b("nbt")) continue;
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("nbt");
            this.field_186271_b.add(new EntityInfo(vec3d, blockpos, nbttagcompound1));
        }
    }

    private void func_204768_a(NBTTagList p_204768_1_, NBTTagList p_204768_2_) {
        BasicPalette template$basicpalette = new BasicPalette();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_204768_1_.size(); ++i) {
            template$basicpalette.func_189956_a(NBTUtil.func_190008_d((NBTTagCompound)p_204768_1_.func_150305_b(i)), i);
        }
        for (int j = 0; j < p_204768_2_.size(); ++j) {
            NBTTagCompound nbttagcompound = p_204768_2_.func_150305_b(j);
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("pos", 3);
            BlockPos blockpos = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
            IBlockState iblockstate = template$basicpalette.func_189955_a(nbttagcompound.func_74762_e("state"));
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74764_b("nbt") ? nbttagcompound.func_74775_l("nbt") : null;
            list.add(new BlockInfo(blockpos, iblockstate, nbttagcompound1));
        }
        this.field_204769_a.add(list);
    }

    private NBTTagList func_186267_a(int ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : values) {
            nbttaglist.add((INBTBase)new NBTTagInt(i));
        }
        return nbttaglist;
    }

    private NBTTagList func_186264_a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : values) {
            nbttaglist.add((INBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    public static class EntityInfo {
        public final Vec3d field_186247_a;
        public final BlockPos field_186248_b;
        public final NBTTagCompound field_186249_c;

        public EntityInfo(Vec3d vecIn, BlockPos posIn, NBTTagCompound compoundIn) {
            this.field_186247_a = vecIn;
            this.field_186248_b = posIn;
            this.field_186249_c = compoundIn;
        }
    }

    public static class BlockInfo {
        public final BlockPos field_186242_a;
        public final IBlockState field_186243_b;
        public final NBTTagCompound field_186244_c;

        public BlockInfo(BlockPos posIn, IBlockState stateIn, @Nullable NBTTagCompound compoundIn) {
            this.field_186242_a = posIn;
            this.field_186243_b = stateIn;
            this.field_186244_c = compoundIn;
        }
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState field_189957_a = Blocks.field_150350_a.func_176223_P();
        private final ObjectIntIdentityMap<IBlockState> field_189958_b = new ObjectIntIdentityMap(16);
        private int field_189959_c;

        private BasicPalette() {
        }

        public int func_189954_a(IBlockState state) {
            int i = this.field_189958_b.func_148747_b((Object)state);
            if (i == -1) {
                i = this.field_189959_c++;
                this.field_189958_b.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public IBlockState func_189955_a(int id) {
            IBlockState iblockstate = (IBlockState)this.field_189958_b.func_148745_a(id);
            return iblockstate == null ? field_189957_a : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.field_189958_b.iterator();
        }

        public void func_189956_a(IBlockState p_189956_1_, int p_189956_2_) {
            this.field_189958_b.func_148746_a((Object)p_189956_1_, p_189956_2_);
        }
    }
}

