/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.WorldPersistenceHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaveFormatOld
implements ISaveFormat {
    private static final Logger field_151479_b = LogManager.getLogger();
    public final Path field_75808_a;
    protected final Path field_197717_b;
    protected final DataFixer field_186354_b;

    public SaveFormatOld(Path p_i49565_1_, Path p_i49565_2_, DataFixer p_i49565_3_) {
        this.field_186354_b = p_i49565_3_;
        try {
            Files.createDirectories(Files.exists(p_i49565_1_, new LinkOption[0]) ? p_i49565_1_.toRealPath(new LinkOption[0]) : p_i49565_1_, new FileAttribute[0]);
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        this.field_75808_a = p_i49565_1_;
        this.field_197717_b = p_i49565_2_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_207741_a() {
        return "Old Format";
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<WorldSummary> func_75799_b() throws AnvilConverterException {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            String s = "World" + (i + 1);
            WorldInfo worldinfo = this.func_75803_c(s);
            if (worldinfo == null) continue;
            list.add(new WorldSummary(worldinfo, s, "", worldinfo.func_76092_g(), false));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75800_d() {
    }

    @Nullable
    public WorldInfo func_75803_c(String saveName) {
        WorldInfo worldinfo;
        File file1 = new File(this.field_75808_a.toFile(), saveName);
        if (!file1.exists()) {
            return null;
        }
        File file2 = new File(file1, "level.dat");
        if (file2.exists() && (worldinfo = SaveFormatOld.func_186353_a(file2, this.field_186354_b)) != null) {
            return worldinfo;
        }
        file2 = new File(file1, "level.dat_old");
        return file2.exists() ? SaveFormatOld.func_186353_a(file2, this.field_186354_b) : null;
    }

    @Nullable
    public static WorldInfo func_186353_a(File p_186353_0_, DataFixer dataFixerIn) {
        return SaveFormatOld.getWorldData(p_186353_0_, dataFixerIn, null);
    }

    @Nullable
    public static WorldInfo getWorldData(File p_186353_0_, DataFixer dataFixerIn, @Nullable SaveHandler saveHandler) {
        try {
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a(new FileInputStream(p_186353_0_));
            NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
            NBTTagCompound nbttagcompound2 = nbttagcompound1.func_150297_b("Player", 10) ? nbttagcompound1.func_74775_l("Player") : null;
            nbttagcompound1.func_82580_o("Player");
            int i = nbttagcompound1.func_150297_b("DataVersion", 99) ? nbttagcompound1.func_74762_e("DataVersion") : -1;
            WorldInfo ret = new WorldInfo(NBTUtil.func_210822_a((DataFixer)dataFixerIn, (DSL.TypeReference)DataFixTypes.LEVEL, (NBTTagCompound)nbttagcompound1, (int)i), dataFixerIn, i, nbttagcompound2);
            if (saveHandler != null) {
                WorldPersistenceHooks.handleWorldDataLoad((SaveHandler)saveHandler, (WorldInfo)ret, (NBTTagCompound)nbttagcompound);
            }
            return ret;
        }
        catch (StartupQuery.AbortedException e) {
            throw e;
        }
        catch (Exception exception) {
            field_151479_b.error("Exception reading {}", (Object)p_186353_0_, (Object)exception);
            return null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_75806_a(String dirName, String newName) {
        File file2;
        File file1 = new File(this.field_75808_a.toFile(), dirName);
        if (file1.exists() && (file2 = new File(file1, "level.dat")).exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a(new FileInputStream(file2));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("Data");
                nbttagcompound1.func_74778_a("LevelName", newName);
                CompressedStreamTools.func_74799_a(nbttagcompound, new FileOutputStream(file2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_207742_d(String saveName) {
        File file1 = new File(this.field_75808_a.toFile(), saveName);
        if (file1.exists()) {
            return false;
        }
        try {
            file1.mkdir();
            file1.delete();
            return true;
        }
        catch (Throwable throwable) {
            field_151479_b.warn("Couldn't make new level", throwable);
            return false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_75802_e(String saveName) {
        File file1 = new File(this.field_75808_a.toFile(), saveName);
        if (!file1.exists()) {
            return true;
        }
        field_151479_b.info("Deleting level {}", (Object)saveName);
        for (int i = 1; i <= 5; ++i) {
            field_151479_b.info("Attempt {}...", (Object)i);
            if (SaveFormatOld.func_75807_a(file1.listFiles())) break;
            field_151479_b.warn("Unsuccessful in deleting contents.");
            if (i >= 5) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return file1.delete();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static boolean func_75807_a(File[] files) {
        for (File file1 : files) {
            field_151479_b.debug("Deleting {}", (Object)file1);
            if (file1.isDirectory() && !SaveFormatOld.func_75807_a(file1.listFiles())) {
                field_151479_b.warn("Couldn't delete directory {}", (Object)file1);
                return false;
            }
            if (file1.delete()) continue;
            field_151479_b.warn("Couldn't delete file {}", (Object)file1);
            return false;
        }
        return true;
    }

    public ISaveHandler func_197715_a(String saveName, @Nullable MinecraftServer server) {
        return new SaveHandler(this.field_75808_a.toFile(), saveName, server, this.field_186354_b);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_207743_a(String saveName) {
        return false;
    }

    public boolean func_75801_b(String saveName) {
        return false;
    }

    public boolean func_75805_a(String filename, IProgressUpdate progressCallback) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_90033_f(String saveName) {
        return Files.isDirectory(this.field_75808_a.resolve(saveName), new LinkOption[0]);
    }

    public File func_186352_b(String saveName, String filePath) {
        return this.field_75808_a.resolve(saveName).resolve(filePath).toFile();
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_197714_g(String saveName) {
        return this.field_75808_a.resolve(saveName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Path func_197712_e() {
        return this.field_197717_b;
    }
}

