/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableManager
implements IResourceManagerReloadListener {
    private static final Logger field_186525_a = LogManager.getLogger();
    private static final Gson field_186526_b = new GsonBuilder().registerTypeAdapter(RandomValueRange.class, (Object)new RandomValueRange.Serializer()).registerTypeAdapter(LootPool.class, (Object)new LootPool.Serializer()).registerTypeAdapter(LootTable.class, (Object)new LootTable.Serializer()).registerTypeHierarchyAdapter(LootEntry.class, (Object)new LootEntry.Serializer()).registerTypeHierarchyAdapter(LootFunction.class, (Object)new LootFunctionManager.Serializer()).registerTypeHierarchyAdapter(LootCondition.class, (Object)new LootConditionManager.Serializer()).registerTypeHierarchyAdapter(LootContext.EntityTarget.class, (Object)new LootContext.EntityTarget.Serializer()).create();
    private final Map<ResourceLocation, LootTable> field_186527_c = Maps.newHashMap();
    public static final int field_195435_a = "loot_tables/".length();
    public static final int field_195436_b = ".json".length();

    public LootTable func_186521_a(ResourceLocation ressources) {
        return this.field_186527_c.getOrDefault(ressources, LootTable.field_186464_a);
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_186527_c.clear();
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("loot_tables", p_195434_0_ -> p_195434_0_.endsWith(".json"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(field_195435_a, s.length() - field_195436_b));
            try {
                IResource iresource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    LootTable loottable = ForgeHooks.loadLootTable((Gson)field_186526_b, (ResourceLocation)resourcelocation, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), (boolean)iresource.func_199026_d().equals("Default"), (LootTableManager)this);
                    if (loottable == null) continue;
                    this.field_186527_c.put(resourcelocation1, loottable);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (Throwable throwable) {
                field_186525_a.error("Couldn't read loot table {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)throwable);
            }
        }
    }
}

