/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer;

import java.util.Objects;
import java.util.Set;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.Target;
import org.objectweb.asm.tree.ClassNode;

public class InnerClassTarget
extends Target<ClassNode> {
    private final String innerName;

    public InnerClassTarget(String className, String innerName) {
        super(className);
        this.innerName = innerName;
    }

    @Override
    public String targetName() {
        return this.innerName;
    }

    @Override
    public String toString() {
        int idx = this.innerName.lastIndexOf(36);
        return Objects.toString(this.getClassName()) + " INNERCLASS " + Objects.toString(this.innerName.substring(idx + 1));
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof InnerClassTarget)) {
            return false;
        }
        return super.equals(obj) && Objects.equals(this.innerName, ((InnerClassTarget)obj).innerName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), this.innerName});
    }

    @Override
    public void apply(ClassNode node, AccessTransformer.Modifier targetAccess, AccessTransformer.FinalState targetFinalState, Set<String> privateChanged) {
        node.innerClasses.stream().filter(c -> c.name.equals(this.innerName)).forEach(inner -> {
            inner.access = targetAccess.mergeWith(inner.access);
            inner.access = targetFinalState.mergeWith(inner.access);
        });
    }
}

