/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import javax.annotation.Nullable;
import net.minecraft.block.state.PistonBlockStructureHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Cancelable;

public abstract class PistonEvent
extends BlockEvent {
    private final Direction direction;
    private final PistonMoveType moveType;

    public PistonEvent(World world, BlockPos pos, Direction direction, PistonMoveType moveType) {
        super((IWorld)world, pos, world.func_180495_p(pos));
        this.direction = direction;
        this.moveType = moveType;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getFaceOffsetPos() {
        return this.getPos().func_177972_a(this.direction);
    }

    public PistonMoveType getPistonMoveType() {
        return this.moveType;
    }

    @Nullable
    public PistonBlockStructureHelper getStructureHelper() {
        if (this.getWorld() instanceof World) {
            return new PistonBlockStructureHelper((World)this.getWorld(), this.getPos(), this.getDirection(), this.getPistonMoveType().isExtend);
        }
        return null;
    }

    public static enum PistonMoveType {
        EXTEND(true),
        RETRACT(false);

        public final boolean isExtend;

        private PistonMoveType(boolean isExtend) {
            this.isExtend = isExtend;
        }
    }

    @Cancelable
    public static class Pre
    extends PistonEvent {
        public Pre(World world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }

    public static class Post
    extends PistonEvent {
        public Post(World world, BlockPos pos, Direction direction, PistonMoveType moveType) {
            super(world, pos, direction, moveType);
        }
    }
}

