/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.server;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.IResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ForgeI18n;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Pattern PATTERN = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static List<Map<String, String>> capturedTables = new ArrayList<Map<String, String>>(2);
    private static Map<String, String> modTable;

    public static void captureLanguageMap(Map<String, String> table) {
        capturedTables.add(table);
        if (modTable != null) {
            capturedTables.forEach(t -> t.putAll(modTable));
        }
    }

    private static void loadLocaleData(List<IResource> allResources) {
        allResources.stream().map(IResource::func_199027_b).forEach(LanguageHook::loadLocaleData);
    }

    private static void loadLocaleData(InputStream inputstream) {
        try {
            JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonElement.class);
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"strings");
            jsonobject.entrySet().forEach(entry -> {
                String s = PATTERN.matcher(JSONUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                modTable.put((String)entry.getKey(), s);
            });
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    private static void loadLanguage(String langName, MinecraftServer server) {
        String langFile = String.format("lang/%s.json", langName);
        server.func_195570_aG().func_199001_a().forEach(namespace -> {
            try {
                ResourceLocation langResource = new ResourceLocation(namespace, langFile);
                LanguageHook.loadLocaleData(server.func_195570_aG().func_199004_b(langResource));
            }
            catch (FileNotFoundException langResource) {
            }
            catch (Exception exception) {
                LOGGER.warn("Skipped language file: {}:{}", namespace, (Object)langFile, (Object)exception);
            }
        });
    }

    public static void loadForgeAndMCLangs() {
        modTable = new HashMap<String, String>(5000);
        InputStream mc = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/lang/en_us.json");
        InputStream forge = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/forge/lang/en_us.json");
        LanguageHook.loadLocaleData(mc);
        LanguageHook.loadLocaleData(forge);
        capturedTables.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }

    static void loadLanguagesOnServer(MinecraftServer server) {
        modTable = new HashMap<String, String>(5000);
        for (String lang : Arrays.asList("en_us")) {
            LanguageHook.loadLanguage(lang, server);
        }
        capturedTables.forEach(t -> t.putAll(modTable));
        ForgeI18n.loadLanguageData(modTable);
    }
}

