/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types.constant;

import com.google.common.base.Function;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.templates.Const;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;

public final class NamespacedStringType
extends Const.ConstType<String> {
    public static Function<String, String> ENSURE_NAMESPACE = s -> s;

    @Override
    public <T> Pair<T, Optional<String>> read(DynamicOps<T> ops, T input) {
        return ops.getStringValue(input).map(v -> Pair.of(ops.empty(), Optional.of(ENSURE_NAMESPACE.apply(v)))).orElseGet(() -> Pair.of(input, Optional.empty()));
    }

    @Override
    public <T> T write(DynamicOps<T> ops, T rest, String value) {
        return ops.createString(value);
    }

    public String toString() {
        return "NamespacedString";
    }
}

