/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.Subscription;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.gui.screens.RealmsLongConfirmationScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsSubscriptionInfoScreen
extends RealmsScreen {
    private static final Logger field_224579_a = LogManager.getLogger();
    private final RealmsScreen field_224580_b;
    private final RealmsServer field_224581_c;
    private final RealmsScreen field_224582_d;
    private final int field_224583_e = 0;
    private final int field_224584_f = 1;
    private final int field_224585_g = 2;
    private final String field_224586_h;
    private final String field_224587_i;
    private final String field_224588_j;
    private final String field_224589_k;
    private int field_224590_l;
    private String field_224591_m;
    private Subscription.Type field_224592_n;
    private final String field_224593_o = "https://account.mojang.com/buy/realms";

    public RealmsSubscriptionInfoScreen(RealmsScreen realmsScreen, RealmsServer realmsServer, RealmsScreen realmsScreen2) {
        this.field_224580_b = realmsScreen;
        this.field_224581_c = realmsServer;
        this.field_224582_d = realmsScreen2;
        this.field_224586_h = RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.title");
        this.field_224587_i = RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.start");
        this.field_224588_j = RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.timeleft");
        this.field_224589_k = RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.recurring.daysleft");
    }

    @Override
    public void init() {
        this.func_224573_a(this.field_224581_c.id);
        Realms.narrateNow(this.field_224586_h, this.field_224587_i, this.field_224591_m, this.field_224588_j, this.func_224576_a(this.field_224590_l));
        this.setKeyboardHandlerSendRepeatsToGui(true);
        this.buttonsAdd(new RealmsButton(2, this.width() / 2 - 100, RealmsConstants.func_225109_a(6), RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.extend")){

            @Override
            public void onPress() {
                String string = "https://account.mojang.com/buy/realms?sid=" + ((RealmsSubscriptionInfoScreen)RealmsSubscriptionInfoScreen.this).field_224581_c.remoteSubscriptionId + "&pid=" + Realms.getUUID();
                Realms.setClipboard(string);
                RealmsUtil.func_225190_c(string);
            }
        });
        this.buttonsAdd(new RealmsButton(0, this.width() / 2 - 100, RealmsConstants.func_225109_a(12), RealmsSubscriptionInfoScreen.getLocalizedString("gui.back")){

            @Override
            public void onPress() {
                Realms.setScreen(RealmsSubscriptionInfoScreen.this.field_224580_b);
            }
        });
        if (this.field_224581_c.expired) {
            this.buttonsAdd(new RealmsButton(1, this.width() / 2 - 100, RealmsConstants.func_225109_a(10), RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.delete.button")){

                @Override
                public void onPress() {
                    String string = RealmsScreen.getLocalizedString("mco.configure.world.delete.question.line1");
                    \u2603 = RealmsScreen.getLocalizedString("mco.configure.world.delete.question.line2");
                    Realms.setScreen(new RealmsLongConfirmationScreen(RealmsSubscriptionInfoScreen.this, RealmsLongConfirmationScreen.Type.Warning, string, \u2603, true, 1));
                }
            });
        }
    }

    private void func_224573_a(long l) {
        RealmsClient realmsClient = RealmsClient.func_224911_a();
        try {
            Subscription subscription = realmsClient.func_224933_g(l);
            this.field_224590_l = subscription.daysLeft;
            this.field_224591_m = this.func_224574_b(subscription.startDate);
            this.field_224592_n = subscription.type;
        }
        catch (RealmsServiceException realmsServiceException) {
            field_224579_a.error("Couldn't get subscription");
            Realms.setScreen(new RealmsGenericErrorScreen(realmsServiceException, this.field_224580_b));
        }
        catch (IOException iOException) {
            field_224579_a.error("Couldn't parse response subscribing");
        }
    }

    @Override
    public void confirmResult(boolean bl, int n) {
        if (n == 1 && bl) {
            new Thread("Realms-delete-realm"){

                @Override
                public void run() {
                    try {
                        RealmsClient realmsClient = RealmsClient.func_224911_a();
                        realmsClient.func_224916_h(((RealmsSubscriptionInfoScreen)RealmsSubscriptionInfoScreen.this).field_224581_c.id);
                    }
                    catch (RealmsServiceException realmsServiceException) {
                        field_224579_a.error("Couldn't delete world");
                        field_224579_a.error((Object)realmsServiceException);
                    }
                    catch (IOException iOException) {
                        field_224579_a.error("Couldn't delete world");
                        iOException.printStackTrace();
                    }
                    Realms.setScreen(RealmsSubscriptionInfoScreen.this.field_224582_d);
                }
            }.start();
        }
        Realms.setScreen(this);
    }

    private String func_224574_b(long l) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getDefault());
        gregorianCalendar.setTimeInMillis(l);
        return DateFormat.getDateTimeInstance().format(gregorianCalendar.getTime());
    }

    @Override
    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (n == 256) {
            Realms.setScreen(this.field_224580_b);
            return true;
        }
        return super.keyPressed(n, n2, n3);
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        int n3 = this.width() / 2 - 100;
        this.drawCenteredString(this.field_224586_h, this.width() / 2, 17, 0xFFFFFF);
        this.drawString(this.field_224587_i, n3, RealmsConstants.func_225109_a(0), 0xA0A0A0);
        this.drawString(this.field_224591_m, n3, RealmsConstants.func_225109_a(1), 0xFFFFFF);
        if (this.field_224592_n == Subscription.Type.NORMAL) {
            this.drawString(this.field_224588_j, n3, RealmsConstants.func_225109_a(3), 0xA0A0A0);
        } else if (this.field_224592_n == Subscription.Type.RECURRING) {
            this.drawString(this.field_224589_k, n3, RealmsConstants.func_225109_a(3), 0xA0A0A0);
        }
        this.drawString(this.func_224576_a(this.field_224590_l), n3, RealmsConstants.func_225109_a(4), 0xFFFFFF);
        super.render(n, n2, f);
    }

    private String func_224576_a(int n) {
        if (n == -1 && this.field_224581_c.expired) {
            return RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.expired");
        }
        if (n <= 1) {
            return RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.less_than_a_day");
        }
        \u2603 = n / 30;
        \u2603 = n % 30;
        StringBuilder stringBuilder = new StringBuilder();
        if (\u2603 > 0) {
            stringBuilder.append(\u2603).append(" ");
            if (\u2603 == 1) {
                stringBuilder.append(RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.month").toLowerCase(Locale.ROOT));
            } else {
                stringBuilder.append(RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.months").toLowerCase(Locale.ROOT));
            }
        }
        if (\u2603 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(\u2603).append(" ");
            if (\u2603 == 1) {
                stringBuilder.append(RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.day").toLowerCase(Locale.ROOT));
            } else {
                stringBuilder.append(RealmsSubscriptionInfoScreen.getLocalizedString("mco.configure.world.subscription.days").toLowerCase(Locale.ROOT));
            }
        }
        return stringBuilder.toString();
    }
}

