/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.util.UUIDTypeAdapter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.realms.Realms;

public class RealmsUtil {
    private static final YggdrasilAuthenticationService field_225195_b = new YggdrasilAuthenticationService(Realms.getProxy(), UUID.randomUUID().toString());
    private static final MinecraftSessionService field_225196_c = field_225195_b.createMinecraftSessionService();
    public static LoadingCache<String, GameProfile> field_225194_a = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, GameProfile>(){

        public GameProfile load(String string) throws Exception {
            GameProfile gameProfile = field_225196_c.fillProfileProperties(new GameProfile(UUIDTypeAdapter.fromString((String)string), null), false);
            if (gameProfile == null) {
                throw new Exception("Couldn't get profile");
            }
            return gameProfile;
        }

        public /* synthetic */ Object load(Object object) throws Exception {
            return this.load((String)object);
        }
    });

    public static String func_225193_a(String string) throws Exception {
        GameProfile gameProfile = (GameProfile)field_225194_a.get((Object)string);
        return gameProfile.getName();
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> func_225191_b(String string) {
        try {
            GameProfile gameProfile = (GameProfile)field_225194_a.get((Object)string);
            return field_225196_c.getTextures(gameProfile, false);
        }
        catch (Exception exception) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
    }

    public static void func_225190_c(String string) {
        Realms.openUri(string);
    }

    public static String func_225192_a(Long l) {
        if (l < 0L) {
            return "right now";
        }
        long l2 = l / 1000L;
        if (l2 < 60L) {
            return (l2 == 1L ? "1 second" : l2 + " seconds") + " ago";
        }
        if (l2 < 3600L) {
            \u2603 = l2 / 60L;
            return (\u2603 == 1L ? "1 minute" : \u2603 + " minutes") + " ago";
        }
        if (l2 < 86400L) {
            \u2603 = l2 / 3600L;
            return (\u2603 == 1L ? "1 hour" : \u2603 + " hours") + " ago";
        }
        \u2603 = l2 / 86400L;
        return (\u2603 == 1L ? "1 day" : \u2603 + " days") + " ago";
    }
}

