/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class LeavesBlock
extends Block {
    public static final IntegerProperty field_208494_a = BlockStateProperties.field_208514_aa;
    public static final BooleanProperty field_208495_b = BlockStateProperties.field_208515_s;
    protected static boolean field_196478_c;

    public LeavesBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_208494_a, 7)).func_206870_a(field_208495_b, false));
    }

    @Override
    public boolean func_149653_t(BlockState blockState) {
        return blockState.func_177229_b(field_208494_a) == 7 && blockState.func_177229_b(field_208495_b) == false;
    }

    @Override
    public void func_196265_a(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (!blockState.func_177229_b(field_208495_b).booleanValue() && blockState.func_177229_b(field_208494_a) == 7) {
            LeavesBlock.func_220075_c(blockState, world, blockPos);
            world.func_217377_a(blockPos, false);
        }
    }

    @Override
    public void func_196267_b(BlockState blockState, World world, BlockPos blockPos, Random random) {
        world.func_180501_a(blockPos, LeavesBlock.func_208493_b(blockState, world, blockPos), 3);
    }

    @Override
    public int func_200011_d(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return 1;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        int n = LeavesBlock.func_208492_w(blockState2) + 1;
        if (n != 1 || blockState.func_177229_b(field_208494_a) != n) {
            iWorld.func_205220_G_().func_205360_a(blockPos, this, 1);
        }
        return blockState;
    }

    private static BlockState func_208493_b(BlockState blockState2, IWorld iWorld, BlockPos blockPos) {
        BlockState blockState2;
        int n = 7;
        try (BlockPos.PooledMutableBlockPos \u26032 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            for (Direction direction : Direction.values()) {
                \u26032.func_189533_g(blockPos).func_189536_c(direction);
                n = Math.min(n, LeavesBlock.func_208492_w(iWorld.func_180495_p(\u26032)) + 1);
                if (n != 1) continue;
                break;
            }
        }
        return (BlockState)blockState2.func_206870_a(field_208494_a, n);
    }

    private static int func_208492_w(BlockState blockState) {
        if (BlockTags.field_200031_h.func_199685_a_(blockState.func_177230_c())) {
            return 0;
        }
        if (blockState.func_177230_c() instanceof LeavesBlock) {
            return blockState.func_177229_b(field_208494_a);
        }
        return 7;
    }

    @Override
    public void func_180655_c(BlockState blockState, World world, BlockPos blockPos, Random random) {
        if (!world.func_175727_C(blockPos.func_177984_a())) {
            return;
        }
        if (random.nextInt(15) != 1) {
            return;
        }
        BlockPos blockPos2 = blockPos.func_177977_b();
        BlockState \u26032 = world.func_180495_p(blockPos2);
        if (\u26032.func_200132_m() && \u26032.func_224755_d(world, blockPos2, Direction.UP)) {
            return;
        }
        double \u26033 = (float)blockPos.func_177958_n() + random.nextFloat();
        double \u26034 = (double)blockPos.func_177956_o() - 0.05;
        double \u26035 = (float)blockPos.func_177952_p() + random.nextFloat();
        world.func_195594_a(ParticleTypes.field_197618_k, \u26033, \u26034, \u26035, 0.0, 0.0, 0.0);
    }

    public static void func_196475_b(boolean bl) {
        field_196478_c = bl;
    }

    @Override
    public boolean func_200124_e(BlockState blockState) {
        return false;
    }

    @Override
    public BlockRenderLayer func_180664_k() {
        return field_196478_c ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean func_220060_c(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Override
    public boolean func_220067_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, EntityType<?> entityType) {
        return entityType == EntityType.field_200781_U || entityType == EntityType.field_200783_W;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_208494_a, field_208495_b);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return LeavesBlock.func_208493_b((BlockState)this.func_176223_P().func_206870_a(field_208495_b, true), blockItemUseContext.func_195991_k(), blockItemUseContext.func_195995_a());
    }
}

