/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BubbleColumnAmbientSoundHandler;
import net.minecraft.client.audio.ElytraSound;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.RidingMinecartTickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.UnderwaterAmbientSoundHandler;
import net.minecraft.client.audio.UnderwaterAmbientSounds;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.CommandBlockScreen;
import net.minecraft.client.gui.screen.EditBookScreen;
import net.minecraft.client.gui.screen.EditMinecartCommandBlockScreen;
import net.minecraft.client.gui.screen.EditSignScreen;
import net.minecraft.client.gui.screen.EditStructureScreen;
import net.minecraft.client.gui.screen.JigsawScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CRecipeInfoPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.dimension.DimensionType;

public class ClientPlayerEntity
extends AbstractClientPlayerEntity {
    public final ClientPlayNetHandler field_71174_a;
    private final StatisticsManager field_146108_bO;
    private final ClientRecipeBook field_192036_cb;
    private final List<IAmbientSoundHandler> field_204232_cf = Lists.newArrayList();
    private int field_184845_bX = 0;
    private double field_175172_bI;
    private double field_175166_bJ;
    private double field_175167_bK;
    private float field_175164_bL;
    private float field_175165_bM;
    private boolean field_184841_cd;
    private boolean field_175170_bN;
    private boolean field_175171_bO;
    private int field_175168_bP;
    private boolean field_175169_bQ;
    private String field_142022_ce;
    public MovementInput field_71158_b;
    protected final Minecraft field_71159_c;
    protected int field_71156_d;
    public int field_71157_e;
    public float field_71154_f;
    public float field_71155_g;
    public float field_71163_h;
    public float field_71164_i;
    private int field_110320_a;
    private float field_110321_bQ;
    public float field_71086_bY;
    public float field_71080_cy;
    private boolean field_184842_cm;
    private Hand field_184843_cn;
    private boolean field_184844_co;
    private boolean field_189811_cr = true;
    private int field_189812_cs;
    private boolean field_189813_ct;
    private int field_203720_cz;

    public ClientPlayerEntity(Minecraft minecraft, ClientWorld clientWorld, ClientPlayNetHandler clientPlayNetHandler, StatisticsManager statisticsManager, ClientRecipeBook clientRecipeBook) {
        super(clientWorld, clientPlayNetHandler.func_175105_e());
        this.field_71174_a = clientPlayNetHandler;
        this.field_146108_bO = statisticsManager;
        this.field_192036_cb = clientRecipeBook;
        this.field_71159_c = minecraft;
        this.field_71093_bK = DimensionType.field_223227_a_;
        this.field_204232_cf.add(new UnderwaterAmbientSoundHandler(this, minecraft.func_147118_V()));
        this.field_204232_cf.add(new BubbleColumnAmbientSoundHandler(this));
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        return false;
    }

    @Override
    public void func_70691_i(float f) {
    }

    @Override
    public boolean func_184205_a(Entity entity, boolean bl) {
        if (!super.func_184205_a(entity, bl)) {
            return false;
        }
        if (entity instanceof AbstractMinecartEntity) {
            this.field_71159_c.func_147118_V().func_147682_a(new RidingMinecartTickableSound(this, (AbstractMinecartEntity)entity));
        }
        if (entity instanceof BoatEntity) {
            this.field_70126_B = entity.field_70177_z;
            this.field_70177_z = entity.field_70177_z;
            this.func_70034_d(entity.field_70177_z);
        }
        return true;
    }

    @Override
    public void func_184210_p() {
        super.func_184210_p();
        this.field_184844_co = false;
    }

    @Override
    public float func_195050_f(float f) {
        return this.field_70125_A;
    }

    @Override
    public float func_195046_g(float f) {
        if (this.func_184218_aH()) {
            return super.func_195046_g(f);
        }
        return this.field_70177_z;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.func_175667_e(new BlockPos(this.field_70165_t, 0.0, this.field_70161_v))) {
            return;
        }
        super.func_70071_h_();
        if (this.func_184218_aH()) {
            this.field_71174_a.func_147297_a(new CPlayerPacket.RotationPacket(this.field_70177_z, this.field_70125_A, this.field_70122_E));
            this.field_71174_a.func_147297_a(new CInputPacket(this.field_70702_br, this.field_191988_bg, this.field_71158_b.field_78901_c, this.field_71158_b.field_78899_d));
            Entity entity = this.func_184208_bv();
            if (entity != this && entity.func_184186_bw()) {
                this.field_71174_a.func_147297_a(new CMoveVehiclePacket(entity));
            }
        } else {
            this.func_175161_p();
        }
        for (IAmbientSoundHandler iAmbientSoundHandler : this.field_204232_cf) {
            iAmbientSoundHandler.func_204253_a();
        }
    }

    private void func_175161_p() {
        Object object;
        boolean bl;
        boolean bl2 = this.func_70051_ag();
        if (bl2 != this.field_175171_bO) {
            CEntityActionPacket.Action action = bl2 ? CEntityActionPacket.Action.START_SPRINTING : CEntityActionPacket.Action.STOP_SPRINTING;
            this.field_71174_a.func_147297_a(new CEntityActionPacket(this, action));
            this.field_175171_bO = bl2;
        }
        if ((bl = this.func_213838_H()) != this.field_175170_bN) {
            object = bl ? CEntityActionPacket.Action.START_SNEAKING : CEntityActionPacket.Action.STOP_SNEAKING;
            this.field_71174_a.func_147297_a(new CEntityActionPacket(this, (CEntityActionPacket.Action)((Object)object)));
            this.field_175170_bN = bl;
        }
        if (this.func_175160_A()) {
            boolean bl3;
            object = this.func_174813_aQ();
            double \u26032 = this.field_70165_t - this.field_175172_bI;
            double \u26033 = ((AxisAlignedBB)object).field_72338_b - this.field_175166_bJ;
            double \u26034 = this.field_70161_v - this.field_175167_bK;
            double \u26035 = this.field_70177_z - this.field_175164_bL;
            double \u26036 = this.field_70125_A - this.field_175165_bM;
            ++this.field_175168_bP;
            boolean \u26037 = \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034 > 9.0E-4 || this.field_175168_bP >= 20;
            boolean bl4 = bl3 = \u26035 != 0.0 || \u26036 != 0.0;
            if (this.func_184218_aH()) {
                Vec3d vec3d = this.func_213322_ci();
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionRotationPacket(vec3d.field_72450_a, -999.0, vec3d.field_72449_c, this.field_70177_z, this.field_70125_A, this.field_70122_E));
                \u26037 = false;
            } else if (\u26037 && bl3) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionRotationPacket(this.field_70165_t, ((AxisAlignedBB)object).field_72338_b, this.field_70161_v, this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (\u26037) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionPacket(this.field_70165_t, ((AxisAlignedBB)object).field_72338_b, this.field_70161_v, this.field_70122_E));
            } else if (bl3) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.RotationPacket(this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (this.field_184841_cd != this.field_70122_E) {
                this.field_71174_a.func_147297_a(new CPlayerPacket(this.field_70122_E));
            }
            if (\u26037) {
                this.field_175172_bI = this.field_70165_t;
                this.field_175166_bJ = ((AxisAlignedBB)object).field_72338_b;
                this.field_175167_bK = this.field_70161_v;
                this.field_175168_bP = 0;
            }
            if (bl3) {
                this.field_175164_bL = this.field_70177_z;
                this.field_175165_bM = this.field_70125_A;
            }
            this.field_184841_cd = this.field_70122_E;
            this.field_189811_cr = this.field_71159_c.field_71474_y.field_189989_R;
        }
    }

    @Override
    @Nullable
    public ItemEntity func_71040_bB(boolean bl) {
        CPlayerDiggingPacket.Action action = bl ? CPlayerDiggingPacket.Action.DROP_ALL_ITEMS : CPlayerDiggingPacket.Action.DROP_ITEM;
        this.field_71174_a.func_147297_a(new CPlayerDiggingPacket(action, BlockPos.field_177992_a, Direction.DOWN));
        this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, bl && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1);
        return null;
    }

    public void func_71165_d(String string) {
        this.field_71174_a.func_147297_a(new CChatMessagePacket(string));
    }

    @Override
    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.field_71174_a.func_147297_a(new CAnimateHandPacket(hand));
    }

    @Override
    public void func_71004_bE() {
        this.field_71174_a.func_147297_a(new CClientStatusPacket(CClientStatusPacket.State.PERFORM_RESPAWN));
    }

    @Override
    protected void func_70665_d(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return;
        }
        this.func_70606_j(this.func_110143_aJ() - f);
    }

    @Override
    public void func_71053_j() {
        this.field_71174_a.func_147297_a(new CCloseWindowPacket(this.field_71070_bA.field_75152_c));
        this.func_175159_q();
    }

    public void func_175159_q() {
        this.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        super.func_71053_j();
        this.field_71159_c.func_147108_a(null);
    }

    public void func_71150_b(float f) {
        if (this.field_175169_bQ) {
            \u2603 = this.func_110143_aJ() - f;
            if (\u2603 <= 0.0f) {
                this.func_70606_j(f);
                if (\u2603 < 0.0f) {
                    this.field_70172_ad = 10;
                }
            } else {
                this.field_110153_bc = \u2603;
                this.func_70606_j(this.func_110143_aJ());
                this.field_70172_ad = 20;
                this.func_70665_d(DamageSource.field_76377_j, \u2603);
                this.field_70737_aN = this.field_70738_aO = 10;
            }
        } else {
            this.func_70606_j(f);
            this.field_175169_bQ = true;
        }
    }

    @Override
    public void func_71016_p() {
        this.field_71174_a.func_147297_a(new CPlayerAbilitiesPacket(this.field_71075_bZ));
    }

    @Override
    public boolean func_175144_cb() {
        return true;
    }

    protected void func_110318_g() {
        this.field_71174_a.func_147297_a(new CEntityActionPacket(this, CEntityActionPacket.Action.START_RIDING_JUMP, MathHelper.func_76141_d(this.func_110319_bJ() * 100.0f)));
    }

    public void func_175163_u() {
        this.field_71174_a.func_147297_a(new CEntityActionPacket(this, CEntityActionPacket.Action.OPEN_INVENTORY));
    }

    public void func_175158_f(String string) {
        this.field_142022_ce = string;
    }

    public String func_142021_k() {
        return this.field_142022_ce;
    }

    public StatisticsManager func_146107_m() {
        return this.field_146108_bO;
    }

    public ClientRecipeBook func_199507_B() {
        return this.field_192036_cb;
    }

    public void func_193103_a(IRecipe<?> iRecipe) {
        if (this.field_192036_cb.func_194076_e(iRecipe)) {
            this.field_192036_cb.func_194074_f(iRecipe);
            this.field_71174_a.func_147297_a(new CRecipeInfoPacket(iRecipe));
        }
    }

    @Override
    protected int func_184840_I() {
        return this.field_184845_bX;
    }

    public void func_184839_n(int n) {
        this.field_184845_bX = n;
    }

    @Override
    public void func_146105_b(ITextComponent iTextComponent, boolean bl) {
        if (bl) {
            this.field_71159_c.field_71456_v.func_175188_a(iTextComponent, false);
        } else {
            this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(iTextComponent);
        }
    }

    @Override
    protected void func_213282_i(double d, double d2, double d3) {
        BlockPos blockPos = new BlockPos(d, d2, d3);
        if (this.func_205027_h(blockPos)) {
            double d4 = d - (double)blockPos.func_177958_n();
            \u2603 = d3 - (double)blockPos.func_177952_p();
            Direction \u26032 = null;
            \u2603 = 9999.0;
            if (!this.func_205027_h(blockPos.func_177976_e()) && d4 < \u2603) {
                \u2603 = d4;
                \u26032 = Direction.WEST;
            }
            if (!this.func_205027_h(blockPos.func_177974_f()) && 1.0 - d4 < \u2603) {
                \u2603 = 1.0 - d4;
                \u26032 = Direction.EAST;
            }
            if (!this.func_205027_h(blockPos.func_177978_c()) && \u2603 < \u2603) {
                \u2603 = \u2603;
                \u26032 = Direction.NORTH;
            }
            if (!this.func_205027_h(blockPos.func_177968_d()) && 1.0 - \u2603 < \u2603) {
                \u2603 = 1.0 - \u2603;
                \u26032 = Direction.SOUTH;
            }
            if (\u26032 != null) {
                Vec3d vec3d = this.func_213322_ci();
                switch (\u26032) {
                    case WEST: {
                        this.func_213293_j(-0.1, vec3d.field_72448_b, vec3d.field_72449_c);
                        break;
                    }
                    case EAST: {
                        this.func_213293_j(0.1, vec3d.field_72448_b, vec3d.field_72449_c);
                        break;
                    }
                    case NORTH: {
                        this.func_213293_j(vec3d.field_72450_a, vec3d.field_72448_b, -0.1);
                        break;
                    }
                    case SOUTH: {
                        this.func_213293_j(vec3d.field_72450_a, vec3d.field_72448_b, 0.1);
                    }
                }
            }
        }
    }

    private boolean func_205027_h(BlockPos blockPos) {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos(blockPos);
        for (int i = MathHelper.func_76128_c(axisAlignedBB.field_72338_b); i < MathHelper.func_76143_f(axisAlignedBB.field_72337_e); ++i) {
            \u26032.func_185336_p(i);
            if (this.func_207401_g(\u26032)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void func_70031_b(boolean bl) {
        super.func_70031_b(bl);
        this.field_71157_e = 0;
    }

    public void func_71152_a(float f, int n, int n2) {
        this.field_71106_cc = f;
        this.field_71067_cb = n;
        this.field_71068_ca = n2;
    }

    @Override
    public void func_145747_a(ITextComponent iTextComponent) {
        this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(iTextComponent);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by >= 24 && by <= 28) {
            this.func_184839_n(by - 24);
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public void func_184185_a(SoundEvent soundEvent, float f, float f2) {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, this.func_184176_by(), f, f2, false);
    }

    @Override
    public void func_213823_a(SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, soundCategory, f, f2, false);
    }

    @Override
    public boolean func_70613_aW() {
        return true;
    }

    @Override
    public void func_184598_c(Hand hand) {
        ItemStack itemStack = this.func_184586_b(hand);
        if (itemStack.func_190926_b() || this.func_184587_cr()) {
            return;
        }
        super.func_184598_c(hand);
        this.field_184842_cm = true;
        this.field_184843_cn = hand;
    }

    @Override
    public boolean func_184587_cr() {
        return this.field_184842_cm;
    }

    @Override
    public void func_184602_cy() {
        super.func_184602_cy();
        this.field_184842_cm = false;
    }

    @Override
    public Hand func_184600_cs() {
        return this.field_184843_cn;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter2) {
        DataParameter<?> dataParameter2;
        super.func_184206_a(dataParameter2);
        if (field_184621_as.equals(dataParameter2)) {
            boolean bl = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
            Hand hand = \u2603 = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? Hand.OFF_HAND : Hand.MAIN_HAND;
            if (bl && !this.field_184842_cm) {
                this.func_184598_c(\u2603);
            } else if (!bl && this.field_184842_cm) {
                this.func_184602_cy();
            }
        }
        if (field_184240_ax.equals(dataParameter2) && this.func_184613_cA() && !this.field_189813_ct) {
            this.field_71159_c.func_147118_V().func_147682_a(new ElytraSound(this));
        }
    }

    public boolean func_110317_t() {
        Entity entity = this.func_184187_bx();
        return this.func_184218_aH() && entity instanceof IJumpingMount && ((IJumpingMount)((Object)entity)).func_184776_b();
    }

    public float func_110319_bJ() {
        return this.field_110321_bQ;
    }

    @Override
    public void func_175141_a(SignTileEntity signTileEntity) {
        this.field_71159_c.func_147108_a(new EditSignScreen(signTileEntity));
    }

    @Override
    public void func_184809_a(CommandBlockLogic commandBlockLogic) {
        this.field_71159_c.func_147108_a(new EditMinecartCommandBlockScreen(commandBlockLogic));
    }

    @Override
    public void func_184824_a(CommandBlockTileEntity commandBlockTileEntity) {
        this.field_71159_c.func_147108_a(new CommandBlockScreen(commandBlockTileEntity));
    }

    @Override
    public void func_189807_a(StructureBlockTileEntity structureBlockTileEntity) {
        this.field_71159_c.func_147108_a(new EditStructureScreen(structureBlockTileEntity));
    }

    @Override
    public void func_213826_a(JigsawTileEntity jigsawTileEntity) {
        this.field_71159_c.func_147108_a(new JigsawScreen(jigsawTileEntity));
    }

    @Override
    public void func_184814_a(ItemStack itemStack, Hand hand) {
        Item item = itemStack.func_77973_b();
        if (item == Items.field_151099_bA) {
            this.field_71159_c.func_147108_a(new EditBookScreen(this, itemStack, hand));
        }
    }

    @Override
    public void func_71009_b(Entity entity) {
        this.field_71159_c.field_71452_i.func_199282_a(entity, ParticleTypes.field_197614_g);
    }

    @Override
    public void func_71047_c(Entity entity) {
        this.field_71159_c.field_71452_i.func_199282_a(entity, ParticleTypes.field_197622_o);
    }

    @Override
    public boolean func_70093_af() {
        return this.func_213838_H();
    }

    public boolean func_213838_H() {
        return this.field_71158_b != null && this.field_71158_b.field_78899_d;
    }

    @Override
    public boolean func_213287_bg() {
        if (this.field_71075_bZ.field_75100_b || this.func_203007_ba() || !this.func_213298_c(Pose.SNEAKING)) {
            return false;
        }
        return this.func_213838_H() || !this.func_213298_c(Pose.STANDING);
    }

    @Override
    public void func_70626_be() {
        super.func_70626_be();
        if (this.func_175160_A()) {
            this.field_70702_br = this.field_71158_b.field_78902_a;
            this.field_191988_bg = this.field_71158_b.field_192832_b;
            this.field_70703_bu = this.field_71158_b.field_78901_c;
            this.field_71163_h = this.field_71154_f;
            this.field_71164_i = this.field_71155_g;
            this.field_71155_g = (float)((double)this.field_71155_g + (double)(this.field_70125_A - this.field_71155_g) * 0.5);
            this.field_71154_f = (float)((double)this.field_71154_f + (double)(this.field_70177_z - this.field_71154_f) * 0.5);
        }
    }

    protected boolean func_175160_A() {
        return this.field_71159_c.func_175606_aa() == this;
    }

    @Override
    public void func_70636_d() {
        int n;
        boolean bl;
        ++this.field_71157_e;
        if (this.field_71156_d > 0) {
            --this.field_71156_d;
        }
        this.func_213839_ed();
        boolean bl2 = this.field_71158_b.field_78901_c;
        \u2603 = this.field_71158_b.field_78899_d;
        \u2603 = this.func_223110_ee();
        \u2603 = this.func_213287_bg() || this.func_213300_bk();
        this.field_71158_b.func_217607_a(\u2603, this.func_175149_v());
        this.field_71159_c.func_193032_ao().func_193293_a(this.field_71158_b);
        if (this.func_184587_cr() && !this.func_184218_aH()) {
            this.field_71158_b.field_78902_a *= 0.2f;
            this.field_71158_b.field_192832_b *= 0.2f;
            this.field_71156_d = 0;
        }
        \u2603 = false;
        if (this.field_189812_cs > 0) {
            --this.field_189812_cs;
            \u2603 = true;
            this.field_71158_b.field_78901_c = true;
        }
        if (!this.field_70145_X) {
            AxisAlignedBB axisAlignedBB = this.func_174813_aQ();
            this.func_213282_i(this.field_70165_t - (double)this.func_213311_cf() * 0.35, axisAlignedBB.field_72338_b + 0.5, this.field_70161_v + (double)this.func_213311_cf() * 0.35);
            this.func_213282_i(this.field_70165_t - (double)this.func_213311_cf() * 0.35, axisAlignedBB.field_72338_b + 0.5, this.field_70161_v - (double)this.func_213311_cf() * 0.35);
            this.func_213282_i(this.field_70165_t + (double)this.func_213311_cf() * 0.35, axisAlignedBB.field_72338_b + 0.5, this.field_70161_v - (double)this.func_213311_cf() * 0.35);
            this.func_213282_i(this.field_70165_t + (double)this.func_213311_cf() * 0.35, axisAlignedBB.field_72338_b + 0.5, this.field_70161_v + (double)this.func_213311_cf() * 0.35);
        }
        boolean bl3 = bl = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c;
        if (!(!this.field_70122_E && !this.func_204231_K() || \u2603 || \u2603 || !this.func_223110_ee() || this.func_70051_ag() || !bl || this.func_184587_cr() || this.func_70644_a(Effects.field_76440_q))) {
            if (this.field_71156_d > 0 || this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.func_70031_b(true);
            } else {
                this.field_71156_d = 7;
            }
        }
        if (!this.func_70051_ag() && (!this.func_70090_H() || this.func_204231_K()) && this.func_223110_ee() && bl && !this.func_184587_cr() && !this.func_70644_a(Effects.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
        if (this.func_70051_ag()) {
            n = !this.field_71158_b.func_223135_b() || !bl ? 1 : 0;
            boolean bl4 = \u2603 = n != 0 || this.field_70123_F || this.func_70090_H() && !this.func_204231_K();
            if (this.func_203007_ba()) {
                if (!this.field_70122_E && !this.field_71158_b.field_78899_d && n != 0 || !this.func_70090_H()) {
                    this.func_70031_b(false);
                }
            } else if (\u2603) {
                this.func_70031_b(false);
            }
        }
        if (this.field_71075_bZ.field_75101_c) {
            if (this.field_71159_c.field_71442_b.func_178887_k()) {
                if (!this.field_71075_bZ.field_75100_b) {
                    this.field_71075_bZ.field_75100_b = true;
                    this.func_71016_p();
                }
            } else if (!bl2 && this.field_71158_b.field_78901_c && !\u2603) {
                if (this.field_71101_bC == 0) {
                    this.field_71101_bC = 7;
                } else if (!this.func_203007_ba()) {
                    this.field_71075_bZ.field_75100_b = !this.field_71075_bZ.field_75100_b;
                    this.func_71016_p();
                    this.field_71101_bC = 0;
                }
            }
        }
        if (this.field_71158_b.field_78901_c && !bl2 && !this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0 && !this.func_184613_cA() && !this.field_71075_bZ.field_75100_b && (\u2603 = this.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d(\u2603)) {
            this.field_71174_a.func_147297_a(new CEntityActionPacket(this, CEntityActionPacket.Action.START_FALL_FLYING));
        }
        this.field_189813_ct = this.func_184613_cA();
        if (this.func_70090_H() && this.field_71158_b.field_78899_d) {
            this.func_203010_cG();
        }
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            n = this.func_175149_v() ? 10 : 1;
            this.field_203720_cz = MathHelper.func_76125_a(this.field_203720_cz + n, 0, 600);
        } else if (this.field_203720_cz > 0) {
            this.func_208600_a(FluidTags.field_206959_a);
            this.field_203720_cz = MathHelper.func_76125_a(this.field_203720_cz - 10, 0, 600);
        }
        if (this.field_71075_bZ.field_75100_b && this.func_175160_A()) {
            n = 0;
            if (this.field_71158_b.field_78899_d) {
                this.field_71158_b.field_78902_a = (float)((double)this.field_71158_b.field_78902_a / 0.3);
                this.field_71158_b.field_192832_b = (float)((double)this.field_71158_b.field_192832_b / 0.3);
                --n;
            }
            if (this.field_71158_b.field_78901_c) {
                ++n;
            }
            if (n != 0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (float)n * this.field_71075_bZ.func_75093_a() * 3.0f, 0.0));
            }
        }
        if (this.func_110317_t()) {
            IJumpingMount iJumpingMount = (IJumpingMount)((Object)this.func_184187_bx());
            if (this.field_110320_a < 0) {
                ++this.field_110320_a;
                if (this.field_110320_a == 0) {
                    this.field_110321_bQ = 0.0f;
                }
            }
            if (bl2 && !this.field_71158_b.field_78901_c) {
                this.field_110320_a = -10;
                iJumpingMount.func_110206_u(MathHelper.func_76141_d(this.func_110319_bJ() * 100.0f));
                this.func_110318_g();
            } else if (!bl2 && this.field_71158_b.field_78901_c) {
                this.field_110320_a = 0;
                this.field_110321_bQ = 0.0f;
            } else if (bl2) {
                ++this.field_110320_a;
                this.field_110321_bQ = this.field_110320_a < 10 ? (float)this.field_110320_a * 0.1f : 0.8f + 2.0f / (float)(this.field_110320_a - 9) * 0.1f;
            }
        } else {
            this.field_110321_bQ = 0.0f;
        }
        super.func_70636_d();
        if (this.field_70122_E && this.field_71075_bZ.field_75100_b && !this.field_71159_c.field_71442_b.func_178887_k()) {
            this.field_71075_bZ.field_75100_b = false;
            this.func_71016_p();
        }
    }

    private void func_213839_ed() {
        this.field_71080_cy = this.field_71086_bY;
        if (this.field_71087_bX) {
            if (this.field_71159_c.field_71462_r != null && !this.field_71159_c.field_71462_r.isPauseScreen()) {
                if (this.field_71159_c.field_71462_r instanceof ContainerScreen) {
                    this.func_71053_j();
                }
                this.field_71159_c.func_147108_a(null);
            }
            if (this.field_71086_bY == 0.0f) {
                this.field_71159_c.func_147118_V().func_147682_a(SimpleSound.func_184371_a(SoundEvents.field_187814_ei, this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
            }
            this.field_71086_bY += 0.0125f;
            if (this.field_71086_bY >= 1.0f) {
                this.field_71086_bY = 1.0f;
            }
            this.field_71087_bX = false;
        } else if (this.func_70644_a(Effects.field_76431_k) && this.func_70660_b(Effects.field_76431_k).func_76459_b() > 60) {
            this.field_71086_bY += 0.006666667f;
            if (this.field_71086_bY > 1.0f) {
                this.field_71086_bY = 1.0f;
            }
        } else {
            if (this.field_71086_bY > 0.0f) {
                this.field_71086_bY -= 0.05f;
            }
            if (this.field_71086_bY < 0.0f) {
                this.field_71086_bY = 0.0f;
            }
        }
        this.func_184173_H();
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_184844_co = false;
        if (this.func_184187_bx() instanceof BoatEntity) {
            BoatEntity boatEntity = (BoatEntity)this.func_184187_bx();
            boatEntity.func_184442_a(this.field_71158_b.field_187257_e, this.field_71158_b.field_187258_f, this.field_71158_b.field_187255_c, this.field_71158_b.field_187256_d);
            this.field_184844_co |= this.field_71158_b.field_187257_e || this.field_71158_b.field_187258_f || this.field_71158_b.field_187255_c || this.field_71158_b.field_187256_d;
        }
    }

    public boolean func_184838_M() {
        return this.field_184844_co;
    }

    @Override
    @Nullable
    public EffectInstance func_184596_c(@Nullable Effect effect) {
        if (effect == Effects.field_76431_k) {
            this.field_71080_cy = 0.0f;
            this.field_71086_bY = 0.0f;
        }
        return super.func_184596_c(effect);
    }

    @Override
    public void func_213315_a(MoverType moverType, Vec3d vec3d) {
        double d = this.field_70165_t;
        \u2603 = this.field_70161_v;
        super.func_213315_a(moverType, vec3d);
        this.func_189810_i((float)(this.field_70165_t - d), (float)(this.field_70161_v - \u2603));
    }

    public boolean func_189809_N() {
        return this.field_189811_cr;
    }

    protected void func_189810_i(float f, float f2) {
        float \u260323;
        float f3;
        if (!this.func_189809_N()) {
            return;
        }
        if (this.field_189812_cs > 0 || !this.field_70122_E || this.func_70093_af() || this.func_184218_aH()) {
            return;
        }
        Vec2f vec2f = this.field_71158_b.func_190020_b();
        if (vec2f.field_189982_i == 0.0f && vec2f.field_189983_j == 0.0f) {
            return;
        }
        Vec3d \u26032 = new Vec3d(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        Vec3d \u26033 = new Vec3d(this.field_70165_t + (double)f, this.func_174813_aQ().field_72338_b, this.field_70161_v + (double)f2);
        Vec3d \u26034 = new Vec3d(f, 0.0, f2);
        float \u26035 = this.func_70689_ay();
        float \u26036 = (float)\u26034.func_189985_c();
        if (\u26036 <= 0.001f) {
            f3 = \u26035 * vec2f.field_189982_i;
            \u2603 = \u26035 * vec2f.field_189983_j;
            \u2603 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
            \u26034 = new Vec3d(f3 * \u2603 - \u2603 * \u2603, \u26034.field_72448_b, \u2603 * \u2603 + f3 * \u2603);
            \u26036 = (float)\u26034.func_189985_c();
            if (\u26036 <= 0.001f) {
                return;
            }
        }
        f3 = (float)MathHelper.func_181161_i(\u26036);
        Vec3d \u26037 = \u26034.func_186678_a(f3);
        Vec3d \u26038 = this.func_189651_aD();
        \u2603 = (float)(\u26038.field_72450_a * \u26037.field_72450_a + \u26038.field_72449_c * \u26037.field_72449_c);
        if (\u2603 < -0.15f) {
            return;
        }
        ISelectionContext \u26039 = ISelectionContext.func_216374_a(this);
        BlockPos \u260310 = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e, this.field_70161_v);
        BlockState \u260311 = this.field_70170_p.func_180495_p(\u260310);
        if (!\u260311.func_215685_b(this.field_70170_p, \u260310, \u26039).func_197766_b()) {
            return;
        }
        BlockState \u260312 = this.field_70170_p.func_180495_p(\u260310 = \u260310.func_177984_a());
        if (!\u260312.func_215685_b(this.field_70170_p, \u260310, \u26039).func_197766_b()) {
            return;
        }
        \u2603 = 7.0f;
        \u2603 = 1.2f;
        if (this.func_70644_a(Effects.field_76430_j)) {
            \u2603 += (float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.75f;
        }
        \u2603 = Math.max(\u26035 * 7.0f, 1.0f / f3);
        Vec3d \u260313 = \u26032;
        Vec3d \u260314 = \u26033.func_178787_e(\u26037.func_186678_a(\u2603));
        \u2603 = this.func_213311_cf();
        \u2603 = this.func_213302_cg();
        AxisAlignedBB \u260315 = new AxisAlignedBB(\u260313, \u260314.func_72441_c(0.0, \u2603, 0.0)).func_72314_b(\u2603, 0.0, \u2603);
        \u260313 = \u260313.func_72441_c(0.0, 0.51f, 0.0);
        \u260314 = \u260314.func_72441_c(0.0, 0.51f, 0.0);
        Vec3d \u260316 = \u26037.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
        Vec3d \u260317 = \u260316.func_186678_a(\u2603 * 0.5f);
        Vec3d \u260318 = \u260313.func_178788_d(\u260317);
        Vec3d \u260319 = \u260314.func_178788_d(\u260317);
        Vec3d \u260320 = \u260313.func_178787_e(\u260317);
        Vec3d \u260321 = \u260314.func_178787_e(\u260317);
        Iterator \u260322 = this.field_70170_p.func_217352_b(this, \u260315, Collections.emptySet()).flatMap(voxelShape -> voxelShape.func_197756_d().stream()).iterator();
        \u260323 = Float.MIN_VALUE;
        while (\u260322.hasNext()) {
            AxisAlignedBB axisAlignedBB = (AxisAlignedBB)\u260322.next();
            if (!axisAlignedBB.func_189973_a(\u260318, \u260319) && !axisAlignedBB.func_189973_a(\u260320, \u260321)) continue;
            \u260323 = (float)axisAlignedBB.field_72337_e;
            Vec3d \u260324 = axisAlignedBB.func_189972_c();
            BlockPos \u260325 = new BlockPos(\u260324);
            int \u260326 = 1;
            while ((float)\u260326 < \u2603) {
                BlockPos blockPos = \u260325.func_177981_b(\u260326);
                BlockState \u260327 = this.field_70170_p.func_180495_p(blockPos);
                VoxelShape \u260328 = \u260327.func_215685_b(this.field_70170_p, blockPos, \u26039);
                if (!\u260328.func_197766_b() && (double)(\u260323 = (float)\u260328.func_197758_c(Direction.Axis.Y) + (float)blockPos.func_177956_o()) - this.func_174813_aQ().field_72338_b > (double)\u2603) {
                    return;
                }
                if (\u260326 > 1 && !(\u2603 = this.field_70170_p.func_180495_p(\u260310 = \u260310.func_177984_a())).func_215685_b(this.field_70170_p, \u260310, \u26039).func_197766_b()) {
                    return;
                }
                ++\u260326;
            }
            break block0;
        }
        if (\u260323 == Float.MIN_VALUE) {
            return;
        }
        float f4 = (float)((double)\u260323 - this.func_174813_aQ().field_72338_b);
        if (f4 <= 0.5f || f4 > \u2603) {
            return;
        }
        this.field_189812_cs = 1;
    }

    private boolean func_223110_ee() {
        double d = 0.8;
        return this.func_204231_K() ? this.field_71158_b.func_223135_b() : (double)this.field_71158_b.field_192832_b >= 0.8;
    }

    public float func_203719_J() {
        if (!this.func_208600_a(FluidTags.field_206959_a)) {
            return 0.0f;
        }
        float f = 600.0f;
        \u2603 = 100.0f;
        if ((float)this.field_203720_cz >= 600.0f) {
            return 1.0f;
        }
        \u2603 = MathHelper.func_76131_a((float)this.field_203720_cz / 100.0f, 0.0f, 1.0f);
        \u2603 = (float)this.field_203720_cz < 100.0f ? 0.0f : MathHelper.func_76131_a(((float)this.field_203720_cz - 100.0f) / 500.0f, 0.0f, 1.0f);
        return \u2603 * 0.6f + \u2603 * 0.39999998f;
    }

    @Override
    public boolean func_204231_K() {
        return this.field_204230_bP;
    }

    @Override
    protected boolean func_204229_de() {
        boolean bl = this.field_204230_bP;
        \u2603 = super.func_204229_de();
        if (this.func_175149_v()) {
            return this.field_204230_bP;
        }
        if (!bl && \u2603) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_204326_e, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            this.field_71159_c.func_147118_V().func_147682_a(new UnderwaterAmbientSounds.UnderWaterSound(this));
        }
        if (bl && !\u2603) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_204327_f, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.field_204230_bP;
    }
}

