/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class FontRenderer
implements AutoCloseable {
    public final int field_78288_b = 9;
    public final Random field_78289_c = new Random();
    private final TextureManager field_78298_i;
    private final Font field_211127_e;
    private boolean field_78294_m;

    public FontRenderer(TextureManager textureManager, Font font) {
        this.field_78298_i = textureManager;
        this.field_211127_e = font;
    }

    public void func_211568_a(List<IGlyphProvider> list) {
        this.field_211127_e.func_211570_a(list);
    }

    @Override
    public void close() {
        this.field_211127_e.close();
    }

    public int func_175063_a(String string, float f, float f2, int n) {
        GlStateManager.enableAlphaTest();
        return this.func_180455_b(string, f, f2, n, true);
    }

    public int func_211126_b(String string, float f, float f2, int n) {
        GlStateManager.enableAlphaTest();
        return this.func_180455_b(string, f, f2, n, false);
    }

    public String func_147647_b(String string2) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(string2), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicShapingException) {
            String string2;
            return string2;
        }
    }

    private int func_180455_b(String string2, float \u260322, float f, int n2, boolean bl) {
        int n2;
        if (string2 == null) {
            return 0;
        }
        if (this.field_78294_m) {
            String string2 = this.func_147647_b(string2);
        }
        if ((n2 & 0xFC000000) == 0) {
            n2 |= 0xFF000000;
        }
        if (bl) {
            this.func_211843_b(string2, \u260322, f, n2, true);
        }
        float \u260322 = this.func_211843_b(string2, \u260322, f, n2, false);
        return (int)\u260322 + (bl ? 1 : 0);
    }

    private float func_211843_b(String string, float f, float f2, int n, boolean bl) {
        float f3 = bl ? 0.25f : 1.0f;
        \u2603 = (float)(n >> 16 & 0xFF) / 255.0f * f3;
        \u2603 = (float)(n >> 8 & 0xFF) / 255.0f * f3;
        \u2603 = (float)(n & 0xFF) / 255.0f * f3;
        \u260311 = \u2603;
        \u260312 = \u2603;
        \u260313 = \u2603;
        \u2603 = (float)(n >> 24 & 0xFF) / 255.0f;
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        ResourceLocation \u26034 = null;
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        boolean \u26035 = false;
        boolean \u26036 = false;
        boolean \u26037 = false;
        boolean \u26038 = false;
        boolean \u26039 = false;
        ArrayList \u260310 = Lists.newArrayList();
        for (int i = 0; i < string.length(); ++i) {
            float \u260316;
            float \u260313;
            float \u260312;
            float \u260311;
            Object object;
            char c = string.charAt(i);
            if (c == '\u00a7' && i + 1 < string.length()) {
                object = TextFormatting.func_211165_a(string.charAt(i + 1));
                if (object != null) {
                    if (((TextFormatting)((Object)object)).func_211166_f()) {
                        \u26035 = false;
                        \u26036 = false;
                        \u26039 = false;
                        \u26038 = false;
                        \u26037 = false;
                        \u260311 = \u2603;
                        \u260312 = \u2603;
                        \u260313 = \u2603;
                    }
                    if (((TextFormatting)((Object)object)).func_211163_e() != null) {
                        int n2 = ((TextFormatting)((Object)object)).func_211163_e();
                        \u260311 = (float)(n2 >> 16 & 0xFF) / 255.0f * f3;
                        \u260312 = (float)(n2 >> 8 & 0xFF) / 255.0f * f3;
                        \u260313 = (float)(n2 & 0xFF) / 255.0f * f3;
                    } else if (object == TextFormatting.OBFUSCATED) {
                        \u26035 = true;
                    } else if (object == TextFormatting.BOLD) {
                        \u26036 = true;
                    } else if (object == TextFormatting.STRIKETHROUGH) {
                        \u26039 = true;
                    } else if (object == TextFormatting.UNDERLINE) {
                        \u26038 = true;
                    } else if (object == TextFormatting.ITALIC) {
                        \u26037 = true;
                    }
                }
                ++i;
                continue;
            }
            object = this.field_211127_e.func_211184_b(c);
            TexturedGlyph \u260314 = \u26035 && c != ' ' ? this.field_211127_e.func_211188_a((IGlyph)object) : this.field_211127_e.func_211187_a(c);
            ResourceLocation \u260315 = \u260314.func_211233_b();
            if (\u260315 != null) {
                if (\u26034 != \u260315) {
                    \u26032.func_78381_a();
                    this.field_78298_i.func_110577_a(\u260315);
                    \u26033.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    \u26034 = \u260315;
                }
                \u260316 = \u26036 ? object.func_223275_b_() : 0.0f;
                \u2603 = bl ? object.func_223276_c_() : 0.0f;
                this.func_212452_a(\u260314, \u26036, \u26037, \u260316, f + \u2603, f2 + \u2603, \u26033, \u260311, \u260312, \u260313, \u2603);
            }
            \u260316 = object.func_223274_a_(\u26036);
            float f4 = \u2603 = bl ? 1.0f : 0.0f;
            if (\u26039) {
                \u260310.add(new Entry(f + \u2603 - 1.0f, f2 + \u2603 + 4.5f, f + \u2603 + \u260316, f2 + \u2603 + 4.5f - 1.0f, \u260311, \u260312, \u260313, \u2603));
            }
            if (\u26038) {
                \u260310.add(new Entry(f + \u2603 - 1.0f, f2 + \u2603 + 9.0f, f + \u2603 + \u260316, f2 + \u2603 + 9.0f - 1.0f, \u260311, \u260312, \u260313, \u2603));
            }
            f += \u260316;
        }
        \u26032.func_78381_a();
        if (!\u260310.isEmpty()) {
            GlStateManager.disableTexture();
            \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (Entry \u260317 : \u260310) {
                \u260317.func_211168_a(\u26033);
            }
            \u26032.func_78381_a();
            GlStateManager.enableTexture();
        }
        return f;
    }

    private void func_212452_a(TexturedGlyph texturedGlyph, boolean bl, boolean bl2, float f, float f2, float f3, BufferBuilder bufferBuilder, float f4, float f5, float f6, float f7) {
        texturedGlyph.func_211234_a(this.field_78298_i, bl2, f2, f3, bufferBuilder, f4, f5, f6, f7);
        if (bl) {
            texturedGlyph.func_211234_a(this.field_78298_i, bl2, f2 + f, f3, bufferBuilder, f4, f5, f6, f7);
        }
    }

    public int func_78256_a(String string) {
        if (string == null) {
            return 0;
        }
        float f = 0.0f;
        boolean \u26032 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7' && i < string.length() - 1) {
                if ((\u2603 = TextFormatting.func_211165_a(string.charAt(++i))) == TextFormatting.BOLD) {
                    \u26032 = true;
                    continue;
                }
                if (\u2603 == null || !\u2603.func_211166_f()) continue;
                \u26032 = false;
                continue;
            }
            f += this.field_211127_e.func_211184_b(c).func_223274_a_(\u26032);
        }
        return MathHelper.func_76123_f(f);
    }

    public float func_211125_a(char c) {
        if (c == '\u00a7') {
            return 0.0f;
        }
        return this.field_211127_e.func_211184_b(c).func_223274_a_(false);
    }

    public String func_78269_a(String string, int n) {
        return this.func_78262_a(string, n, false);
    }

    public String func_78262_a(String string, int n, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        float \u26032 = 0.0f;
        int \u26033 = bl ? string.length() - 1 : 0;
        int \u26034 = bl ? -1 : 1;
        boolean \u26035 = false;
        boolean \u26036 = false;
        for (int i = \u26033; i >= 0 && i < string.length() && \u26032 < (float)n; i += \u26034) {
            char c = string.charAt(i);
            if (\u26035) {
                \u26035 = false;
                TextFormatting textFormatting = TextFormatting.func_211165_a(c);
                if (textFormatting == TextFormatting.BOLD) {
                    \u26036 = true;
                } else if (textFormatting != null && textFormatting.func_211166_f()) {
                    \u26036 = false;
                }
            } else if (c == '\u00a7') {
                \u26035 = true;
            } else {
                \u26032 += this.func_211125_a(c);
                if (\u26036) {
                    \u26032 += 1.0f;
                }
            }
            if (\u26032 > (float)n) break;
            if (bl) {
                stringBuilder.insert(0, c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private String func_78273_d(String string) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public void func_78279_b(String string2, int n, int n2, int n3, int n4) {
        String string2 = this.func_78273_d(string2);
        this.func_211124_b(string2, n, n2, n3, n4);
    }

    private void func_211124_b(String string, int n, int n2, int n3, int n4) {
        List<String> list = this.func_78271_c(string, n3);
        for (String string22 : list) {
            String string22;
            float f = n;
            if (this.field_78294_m) {
                int n5 = this.func_78256_a(this.func_147647_b(string22));
                f += (float)(n3 - n5);
            }
            this.func_180455_b(string22, f, n2, n4, false);
            n2 += 9;
        }
    }

    public int func_78267_b(String string, int n) {
        return 9 * this.func_78271_c(string, n).size();
    }

    public void func_78275_b(boolean bl) {
        this.field_78294_m = bl;
    }

    public List<String> func_78271_c(String string, int n) {
        return Arrays.asList(this.func_78280_d(string, n).split("\n"));
    }

    public String func_78280_d(String \u260352, int n) {
        String string = "";
        while (!\u260352.isEmpty()) {
            int n2 = this.func_78259_e(\u260352, n);
            if (\u260352.length() <= n2) {
                return string + \u260352;
            }
            String \u26032 = \u260352.substring(0, n2);
            char \u26033 = \u260352.charAt(n2);
            boolean \u26034 = \u26033 == ' ' || \u26033 == '\n';
            String \u260352 = TextFormatting.func_211164_a(\u26032) + \u260352.substring(n2 + (\u26034 ? 1 : 0));
            string = string + \u26032 + "\n";
        }
        return string;
    }

    public int func_78259_e(String string, int n) {
        int n2;
        \u2603 = Math.max(1, n);
        \u2603 = string.length();
        float f = 0.0f;
        int \u26032 = -1;
        boolean \u26033 = false;
        boolean \u26034 = true;
        for (n2 = 0; n2 < \u2603; ++n2) {
            char c = string.charAt(n2);
            switch (c) {
                case '\u00a7': {
                    if (n2 >= \u2603 - 1) break;
                    if ((\u2603 = TextFormatting.func_211165_a(string.charAt(++n2))) == TextFormatting.BOLD) {
                        \u26033 = true;
                        break;
                    }
                    if (\u2603 == null || !\u2603.func_211166_f()) break;
                    \u26033 = false;
                    break;
                }
                case '\n': {
                    --n2;
                    break;
                }
                case ' ': {
                    \u26032 = n2;
                }
                default: {
                    if (f != 0.0f) {
                        \u26034 = false;
                    }
                    f += this.func_211125_a(c);
                    if (!\u26033) break;
                    f += 1.0f;
                }
            }
            if (c == '\n') {
                \u26032 = ++n2;
                break;
            }
            if (!(f > (float)\u2603)) continue;
            if (!\u26034) break;
            ++n2;
            break;
        }
        if (n2 != \u2603 && \u26032 != -1 && \u26032 < n2) {
            return \u26032;
        }
        return n2;
    }

    public int func_216863_a(String string, int n, int n2, boolean bl) {
        int n3 = n2;
        boolean \u26032 = n < 0;
        \u2603 = Math.abs(n);
        for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
            if (\u26032) {
                while (bl && n3 > 0 && (string.charAt(n3 - 1) == ' ' || string.charAt(n3 - 1) == '\n')) {
                    --n3;
                }
                while (n3 > 0 && string.charAt(n3 - 1) != ' ' && string.charAt(n3 - 1) != '\n') {
                    --n3;
                }
                continue;
            }
            \u2603 = string.length();
            \u2603 = string.indexOf(32, n3);
            \u2603 = string.indexOf(10, n3);
            n3 = \u2603 == -1 && \u2603 == -1 ? -1 : (\u2603 != -1 && \u2603 != -1 ? Math.min(\u2603, \u2603) : (\u2603 != -1 ? \u2603 : \u2603));
            if (n3 == -1) {
                n3 = \u2603;
                continue;
            }
            while (bl && n3 < \u2603 && (string.charAt(n3) == ' ' || string.charAt(n3) == '\n')) {
                ++n3;
            }
        }
        return n3;
    }

    public boolean func_78260_a() {
        return this.field_78294_m;
    }

    static class Entry {
        protected final float field_211169_a;
        protected final float field_211170_b;
        protected final float field_211171_c;
        protected final float field_211172_d;
        protected final float field_211173_e;
        protected final float field_211174_f;
        protected final float field_211175_g;
        protected final float field_211176_h;

        private Entry(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            this.field_211169_a = f;
            this.field_211170_b = f2;
            this.field_211171_c = f3;
            this.field_211172_d = f4;
            this.field_211173_e = f5;
            this.field_211174_f = f6;
            this.field_211175_g = f7;
            this.field_211176_h = f8;
        }

        public void func_211168_a(BufferBuilder bufferBuilder) {
            bufferBuilder.func_181662_b(this.field_211169_a, this.field_211170_b, 0.0).func_181666_a(this.field_211173_e, this.field_211174_f, this.field_211175_g, this.field_211176_h).func_181675_d();
            bufferBuilder.func_181662_b(this.field_211171_c, this.field_211170_b, 0.0).func_181666_a(this.field_211173_e, this.field_211174_f, this.field_211175_g, this.field_211176_h).func_181675_d();
            bufferBuilder.func_181662_b(this.field_211171_c, this.field_211172_d, 0.0).func_181666_a(this.field_211173_e, this.field_211174_f, this.field_211175_g, this.field_211176_h).func_181675_d();
            bufferBuilder.func_181662_b(this.field_211169_a, this.field_211172_d, 0.0).func_181666_a(this.field_211173_e, this.field_211174_f, this.field_211175_g, this.field_211176_h).func_181675_d();
        }
    }
}

