/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.fonts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.providers.DefaultGlyphProvider;
import net.minecraft.client.gui.fonts.providers.GlyphProviderTypes;
import net.minecraft.client.gui.fonts.providers.IGlyphProvider;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.EmptyProfiler;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FontResourceManager
implements AutoCloseable {
    private static final Logger field_211509_a = LogManager.getLogger();
    private final Map<ResourceLocation, FontRenderer> field_211510_b = Maps.newHashMap();
    private final Set<IGlyphProvider> field_216888_c = Sets.newHashSet();
    private final TextureManager field_211511_c;
    private boolean field_211826_d;
    private final IFutureReloadListener field_216889_f = new ReloadListener<Map<ResourceLocation, List<IGlyphProvider>>>(){

        @Override
        protected Map<ResourceLocation, List<IGlyphProvider>> func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler2) {
            IProfiler iProfiler2;
            iProfiler2.func_219894_a();
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            HashMap \u26032 = Maps.newHashMap();
            for (ResourceLocation resourceLocation2 : iResourceManager.func_199003_a("font", string -> string.endsWith(".json"))) {
                String string2 = resourceLocation2.func_110623_a();
                ResourceLocation \u26033 = new ResourceLocation(resourceLocation2.func_110624_b(), string2.substring("font/".length(), string2.length() - ".json".length()));
                List \u26034 = \u26032.computeIfAbsent(\u26033, resourceLocation -> Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()}));
                iProfiler2.func_194340_a(\u26033::toString);
                try {
                    for (IResource iResource : iResourceManager.func_199004_b(resourceLocation2)) {
                        iProfiler2.func_194340_a(iResource::func_199026_d);
                        try (Closeable closeable = iResource.func_199027_b();
                             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable, StandardCharsets.UTF_8));){
                            iProfiler2.func_76320_a("reading");
                            JsonArray jsonArray = JSONUtils.func_151214_t(JSONUtils.func_193839_a(gson, bufferedReader, JsonObject.class), "providers");
                            iProfiler2.func_219895_b("parsing");
                            for (int i = jsonArray.size() - 1; i >= 0; --i) {
                                JsonObject jsonObject = JSONUtils.func_151210_l(jsonArray.get(i), "providers[" + i + "]");
                                try {
                                    String string3 = JSONUtils.func_151200_h(jsonObject, "type");
                                    GlyphProviderTypes \u26035 = GlyphProviderTypes.func_211638_a(string3);
                                    if (FontResourceManager.this.field_211826_d && \u26035 != GlyphProviderTypes.LEGACY_UNICODE && \u26033.equals(Minecraft.field_211502_b)) continue;
                                    iProfiler2.func_76320_a(string3);
                                    \u26034.add(\u26035.func_211637_a(jsonObject).func_211246_a(iResourceManager));
                                    iProfiler2.func_76319_b();
                                    continue;
                                }
                                catch (RuntimeException runtimeException) {
                                    field_211509_a.warn("Unable to read definition '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                                }
                            }
                            iProfiler2.func_76319_b();
                        }
                        catch (RuntimeException runtimeException) {
                            field_211509_a.warn("Unable to load font '{}' in fonts.json in resourcepack: '{}': {}", (Object)\u26033, (Object)iResource.func_199026_d(), (Object)runtimeException.getMessage());
                        }
                        iProfiler2.func_76319_b();
                    }
                }
                catch (IOException iOException) {
                    field_211509_a.warn("Unable to load font '{}' in fonts.json: {}", (Object)\u26033, (Object)iOException.getMessage());
                }
                iProfiler2.func_76320_a("caching");
                for (char c = '\u0000'; c < '\uffff'; c = (char)((char)(c + 1))) {
                    if (c == ' ') continue;
                    Iterator iterator = Lists.reverse((List)\u26034).iterator();
                    while (iterator.hasNext() && (closeable = (IGlyphProvider)iterator.next()).func_212248_a(c) == null) {
                    }
                }
                iProfiler2.func_76319_b();
                iProfiler2.func_76319_b();
            }
            iProfiler2.func_219897_b();
            return \u26032;
        }

        @Override
        protected void func_212853_a_(Map<ResourceLocation, List<IGlyphProvider>> map, IResourceManager iResourceManager, IProfiler iProfiler) {
            iProfiler.func_219894_a();
            iProfiler.func_76320_a("reloading");
            Stream.concat(FontResourceManager.this.field_211510_b.keySet().stream(), map.keySet().stream()).distinct().forEach(resourceLocation2 -> {
                List<IGlyphProvider> list = map.getOrDefault(resourceLocation2, Collections.emptyList());
                Collections.reverse(list);
                FontResourceManager.this.field_211510_b.computeIfAbsent(resourceLocation2, resourceLocation -> new FontRenderer(FontResourceManager.this.field_211511_c, new Font(FontResourceManager.this.field_211511_c, (ResourceLocation)resourceLocation))).func_211568_a(list);
            });
            map.values().forEach(FontResourceManager.this.field_216888_c::addAll);
            iProfiler.func_76319_b();
            iProfiler.func_219897_b();
        }

        @Override
        protected /* synthetic */ Object func_212854_a_(IResourceManager iResourceManager, IProfiler iProfiler) {
            return this.func_212854_a_(iResourceManager, iProfiler);
        }
    };

    public FontResourceManager(TextureManager textureManager, boolean bl) {
        this.field_211511_c = textureManager;
        this.field_211826_d = bl;
    }

    @Nullable
    public FontRenderer func_211504_a(ResourceLocation resourceLocation2) {
        return this.field_211510_b.computeIfAbsent(resourceLocation2, resourceLocation -> {
            FontRenderer fontRenderer = new FontRenderer(this.field_211511_c, new Font(this.field_211511_c, (ResourceLocation)resourceLocation));
            fontRenderer.func_211568_a(Lists.newArrayList((Object[])new IGlyphProvider[]{new DefaultGlyphProvider()}));
            return fontRenderer;
        });
    }

    public void func_216883_a(boolean bl, Executor executor, Executor executor2) {
        if (bl == this.field_211826_d) {
            return;
        }
        this.field_211826_d = bl;
        IResourceManager iResourceManager = Minecraft.func_71410_x().func_195551_G();
        IFutureReloadListener.IStage \u26032 = new IFutureReloadListener.IStage(){

            @Override
            public <T> CompletableFuture<T> func_216872_a(T t) {
                return CompletableFuture.completedFuture(t);
            }
        };
        this.field_216889_f.func_215226_a(\u26032, iResourceManager, EmptyProfiler.field_219906_a, EmptyProfiler.field_219906_a, executor, executor2);
    }

    public IFutureReloadListener func_216884_a() {
        return this.field_216889_f;
    }

    @Override
    public void close() {
        this.field_211510_b.values().forEach(FontRenderer::close);
        this.field_216888_c.forEach(IGlyphProvider::close);
    }
}

