/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractCommandBlockScreen
extends Screen {
    protected TextFieldWidget field_195237_a;
    protected TextFieldWidget field_195239_f;
    protected Button field_195240_g;
    protected Button field_195241_h;
    protected Button field_195242_i;
    protected boolean field_195238_s;
    protected final List<String> field_209111_t = Lists.newArrayList();
    protected int field_209112_u;
    protected int field_209113_v;
    protected ParseResults<ISuggestionProvider> field_209114_w;
    protected CompletableFuture<Suggestions> field_209115_x;
    protected SuggestionsList field_209116_y;
    private boolean field_212342_z;

    public AbstractCommandBlockScreen() {
        super(NarratorChatListener.field_216868_a);
    }

    @Override
    public void tick() {
        this.field_195237_a.func_146178_a();
    }

    abstract CommandBlockLogic func_195231_h();

    abstract int func_195236_i();

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_195240_g = this.addButton(new Button(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a("gui.done", new Object[0]), button -> this.func_195234_k()));
        this.field_195241_h = this.addButton(new Button(this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.onClose()));
        this.field_195242_i = this.addButton(new Button(this.width / 2 + 150 - 20, this.func_195236_i(), 20, 20, "O", button -> {
            \u2603.func_175573_a(!(\u2603 = this.func_195231_h()).func_175571_m());
            this.func_195233_j();
        }));
        this.field_195237_a = new TextFieldWidget(this.font, this.width / 2 - 150, 50, 300, 20, I18n.func_135052_a("advMode.command", new Object[0]));
        this.field_195237_a.func_146203_f(32500);
        this.field_195237_a.func_195607_a(this::func_209104_a);
        this.field_195237_a.func_212954_a(this::func_214185_b);
        this.children.add(this.field_195237_a);
        this.field_195239_f = new TextFieldWidget(this.font, this.width / 2 - 150, this.func_195236_i(), 276, 20, I18n.func_135052_a("advMode.previousOutput", new Object[0]));
        this.field_195239_f.func_146203_f(32500);
        this.field_195239_f.func_146184_c(false);
        this.field_195239_f.func_146180_a("-");
        this.children.add(this.field_195239_f);
        this.func_212928_a(this.field_195237_a);
        this.field_195237_a.func_146195_b(true);
        this.func_209106_o();
    }

    @Override
    public void resize(Minecraft minecraft, int n, int n2) {
        String string = this.field_195237_a.func_146179_b();
        this.init(minecraft, n, n2);
        this.func_209102_a(string);
        this.func_209106_o();
    }

    protected void func_195233_j() {
        if (this.func_195231_h().func_175571_m()) {
            this.field_195242_i.setMessage("O");
            this.field_195239_f.func_146180_a(this.func_195231_h().func_145749_h().getString());
        } else {
            this.field_195242_i.setMessage("X");
            this.field_195239_f.func_146180_a("-");
        }
    }

    protected void func_195234_k() {
        CommandBlockLogic commandBlockLogic = this.func_195231_h();
        this.func_195235_a(commandBlockLogic);
        if (!commandBlockLogic.func_175571_m()) {
            commandBlockLogic.func_145750_b(null);
        }
        this.minecraft.func_147108_a(null);
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    protected abstract void func_195235_a(CommandBlockLogic var1);

    @Override
    public void onClose() {
        this.func_195231_h().func_175573_a(this.field_195238_s);
        this.minecraft.func_147108_a(null);
    }

    private void func_214185_b(String string) {
        this.func_209106_o();
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (this.field_209116_y != null && this.field_209116_y.func_209133_b(n, n2, n3)) {
            return true;
        }
        if (this.getFocused() == this.field_195237_a && n == 258) {
            this.func_209109_s();
            return true;
        }
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 257 || n == 335) {
            this.func_195234_k();
            return true;
        }
        if (n == 258 && this.getFocused() == this.field_195237_a) {
            this.func_209109_s();
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        if (this.field_209116_y != null && this.field_209116_y.func_209232_a(MathHelper.func_151237_a(d3, -1.0, 1.0))) {
            return true;
        }
        return super.mouseScrolled(d, d2, d3);
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (this.field_209116_y != null && this.field_209116_y.func_209233_a((int)d, (int)d2, n)) {
            return true;
        }
        return super.mouseClicked(d, d2, n);
    }

    protected void func_209106_o() {
        String string = this.field_195237_a.func_146179_b();
        if (this.field_209114_w != null && !this.field_209114_w.getReader().getString().equals(string)) {
            this.field_209114_w = null;
        }
        if (!this.field_212342_z) {
            this.field_195237_a.func_195612_c(null);
            this.field_209116_y = null;
        }
        this.field_209111_t.clear();
        CommandDispatcher<ISuggestionProvider> \u26032 = this.minecraft.field_71439_g.field_71174_a.func_195515_i();
        StringReader \u26033 = new StringReader(string);
        if (\u26033.canRead() && \u26033.peek() == '/') {
            \u26033.skip();
        }
        int \u26034 = \u26033.getCursor();
        if (this.field_209114_w == null) {
            this.field_209114_w = \u26032.parse(\u26033, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
        }
        if (!((\u2603 = this.field_195237_a.func_146198_h()) < \u26034 || this.field_209116_y != null && this.field_212342_z)) {
            this.field_209115_x = \u26032.getCompletionSuggestions(this.field_209114_w, \u2603);
            this.field_209115_x.thenRun(() -> {
                if (!this.field_209115_x.isDone()) {
                    return;
                }
                this.func_209107_u();
            });
        }
    }

    private void func_209107_u() {
        if (this.field_209115_x.join().isEmpty() && !this.field_209114_w.getExceptions().isEmpty() && this.field_195237_a.func_146198_h() == this.field_195237_a.func_146179_b().length()) {
            int n = 0;
            for (Map.Entry entry : this.field_209114_w.getExceptions().entrySet()) {
                CommandSyntaxException commandSyntaxException = (CommandSyntaxException)entry.getValue();
                if (commandSyntaxException.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                    ++n;
                    continue;
                }
                this.field_209111_t.add(commandSyntaxException.getMessage());
            }
            if (n > 0) {
                this.field_209111_t.add(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create().getMessage());
            }
        }
        this.field_209112_u = 0;
        this.field_209113_v = this.width;
        if (this.field_209111_t.isEmpty()) {
            this.func_209108_a(TextFormatting.GRAY);
        }
        this.field_209116_y = null;
        if (this.minecraft.field_71474_y.field_198018_T) {
            this.func_209109_s();
        }
    }

    private String func_209104_a(String string, int n) {
        if (this.field_209114_w != null) {
            return ChatScreen.func_212336_a(this.field_209114_w, string, n);
        }
        return string;
    }

    private void func_209108_a(TextFormatting textFormatting) {
        CommandContextBuilder commandContextBuilder = this.field_209114_w.getContext();
        SuggestionContext \u26032 = commandContextBuilder.findSuggestionContext(this.field_195237_a.func_146198_h());
        Map \u26033 = this.minecraft.field_71439_g.field_71174_a.func_195515_i().getSmartUsage(\u26032.parent, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
        ArrayList \u26034 = Lists.newArrayList();
        int \u26035 = 0;
        for (Map.Entry entry : \u26033.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            \u26034.add((Object)((Object)textFormatting) + (String)entry.getValue());
            \u26035 = Math.max(\u26035, this.font.func_78256_a((String)entry.getValue()));
        }
        if (!\u26034.isEmpty()) {
            this.field_209111_t.addAll(\u26034);
            this.field_209112_u = MathHelper.func_76125_a(this.field_195237_a.func_195611_j(\u26032.startPos), 0, this.field_195237_a.func_195611_j(0) + this.field_195237_a.func_146200_o() - \u26035);
            this.field_209113_v = \u26035;
        }
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a("advMode.setCommand", new Object[0]), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.font, I18n.func_135052_a("advMode.command", new Object[0]), this.width / 2 - 150, 40, 0xA0A0A0);
        this.field_195237_a.render(n, n2, f);
        int n3 = 75;
        if (!this.field_195239_f.func_146179_b().isEmpty()) {
            this.drawString(this.font, I18n.func_135052_a("advMode.previousOutput", new Object[0]), this.width / 2 - 150, (n3 += 5 * this.font.field_78288_b + 1 + this.func_195236_i() - 135) + 4, 0xA0A0A0);
            this.field_195239_f.render(n, n2, f);
        }
        super.render(n, n2, f);
        if (this.field_209116_y != null) {
            this.field_209116_y.func_209129_a(n, n2);
        } else {
            n3 = 0;
            for (String string : this.field_209111_t) {
                AbstractCommandBlockScreen.fill(this.field_209112_u - 1, 72 + 12 * n3, this.field_209112_u + this.field_209113_v + 1, 84 + 12 * n3, Integer.MIN_VALUE);
                this.font.func_175063_a(string, this.field_209112_u, 74 + 12 * n3, -1);
                ++n3;
            }
        }
    }

    public void func_209109_s() {
        Suggestions suggestions;
        if (this.field_209115_x != null && this.field_209115_x.isDone() && !(suggestions = this.field_209115_x.join()).isEmpty()) {
            int n = 0;
            for (Suggestion suggestion : suggestions.getList()) {
                n = Math.max(n, this.font.func_78256_a(suggestion.getText()));
            }
            int \u26032 = MathHelper.func_76125_a(this.field_195237_a.func_195611_j(suggestions.getRange().getStart()), 0, this.field_195237_a.func_195611_j(0) + this.field_195237_a.func_146200_o() - n);
            this.field_209116_y = new SuggestionsList(\u26032, 72, n, suggestions);
        }
    }

    protected void func_209102_a(String string) {
        this.field_195237_a.func_146180_a(string);
    }

    @Nullable
    private static String func_212339_b(String string, String string2) {
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return null;
    }

    class SuggestionsList {
        private final Rectangle2d field_209135_b;
        private final Suggestions field_209136_c;
        private final String field_212467_d;
        private int field_209138_e;
        private int field_209139_f;
        private Vec2f field_209140_g = Vec2f.field_189974_a;
        private boolean field_209141_h;

        private SuggestionsList(int n, int n2, int n3, Suggestions suggestions) {
            this.field_209135_b = new Rectangle2d(n - 1, n2, n3 + 1, Math.min(suggestions.getList().size(), 7) * 12);
            this.field_209136_c = suggestions;
            this.field_212467_d = AbstractCommandBlockScreen.this.field_195237_a.func_146179_b();
            this.func_209130_b(0);
        }

        public void func_209129_a(int n, int n2) {
            int n3;
            \u2603 = Math.min(this.field_209136_c.getList().size(), 7);
            \u2603 = Integer.MIN_VALUE;
            \u2603 = -5592406;
            boolean bl = this.field_209138_e > 0;
            bl3 = this.field_209136_c.getList().size() > this.field_209138_e + \u2603;
            \u2603 = bl || bl3;
            boolean bl2 = \u2603 = this.field_209140_g.field_189982_i != (float)n || this.field_209140_g.field_189983_j != (float)n2;
            if (\u2603) {
                this.field_209140_g = new Vec2f(n, n2);
            }
            if (\u2603) {
                boolean bl3;
                AbstractGui.fill(this.field_209135_b.func_199318_a(), this.field_209135_b.func_199319_b() - 1, this.field_209135_b.func_199318_a() + this.field_209135_b.func_199316_c(), this.field_209135_b.func_199319_b(), Integer.MIN_VALUE);
                AbstractGui.fill(this.field_209135_b.func_199318_a(), this.field_209135_b.func_199319_b() + this.field_209135_b.func_199317_d(), this.field_209135_b.func_199318_a() + this.field_209135_b.func_199316_c(), this.field_209135_b.func_199319_b() + this.field_209135_b.func_199317_d() + 1, Integer.MIN_VALUE);
                if (bl) {
                    for (n3 = 0; n3 < this.field_209135_b.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.fill(this.field_209135_b.func_199318_a() + n3, this.field_209135_b.func_199319_b() - 1, this.field_209135_b.func_199318_a() + n3 + 1, this.field_209135_b.func_199319_b(), -1);
                    }
                }
                if (bl3) {
                    for (n3 = 0; n3 < this.field_209135_b.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.fill(this.field_209135_b.func_199318_a() + n3, this.field_209135_b.func_199319_b() + this.field_209135_b.func_199317_d(), this.field_209135_b.func_199318_a() + n3 + 1, this.field_209135_b.func_199319_b() + this.field_209135_b.func_199317_d() + 1, -1);
                    }
                }
            }
            n3 = 0;
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                Suggestion suggestion = (Suggestion)this.field_209136_c.getList().get(\u2603 + this.field_209138_e);
                AbstractGui.fill(this.field_209135_b.func_199318_a(), this.field_209135_b.func_199319_b() + 12 * \u2603, this.field_209135_b.func_199318_a() + this.field_209135_b.func_199316_c(), this.field_209135_b.func_199319_b() + 12 * \u2603 + 12, Integer.MIN_VALUE);
                if (n > this.field_209135_b.func_199318_a() && n < this.field_209135_b.func_199318_a() + this.field_209135_b.func_199316_c() && n2 > this.field_209135_b.func_199319_b() + 12 * \u2603 && n2 < this.field_209135_b.func_199319_b() + 12 * \u2603 + 12) {
                    if (\u2603) {
                        this.func_209130_b(\u2603 + this.field_209138_e);
                    }
                    n3 = 1;
                }
                AbstractCommandBlockScreen.this.font.func_175063_a(suggestion.getText(), this.field_209135_b.func_199318_a() + 1, this.field_209135_b.func_199319_b() + 2 + 12 * \u2603, \u2603 + this.field_209138_e == this.field_209139_f ? -256 : -5592406);
            }
            if (n3 != 0 && (\u2603 = ((Suggestion)this.field_209136_c.getList().get(this.field_209139_f)).getTooltip()) != null) {
                AbstractCommandBlockScreen.this.renderTooltip(TextComponentUtils.func_202465_a(\u2603).func_150254_d(), n, n2);
            }
        }

        public boolean func_209233_a(int n, int n2, int n3) {
            if (!this.field_209135_b.func_199315_b(n, n2)) {
                return false;
            }
            \u2603 = (n2 - this.field_209135_b.func_199319_b()) / 12 + this.field_209138_e;
            if (\u2603 >= 0 && \u2603 < this.field_209136_c.getList().size()) {
                this.func_209130_b(\u2603);
                this.func_209131_a();
            }
            return true;
        }

        public boolean func_209232_a(double d) {
            int n = (int)(((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_71417_B.func_198024_e() * (double)((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_195558_d.func_198107_o() / (double)((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_195558_d.func_198105_m());
            if (this.field_209135_b.func_199315_b(n, \u2603 = (int)(((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_71417_B.func_198026_f() * (double)((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_195558_d.func_198087_p() / (double)((AbstractCommandBlockScreen)AbstractCommandBlockScreen.this).minecraft.field_195558_d.func_198083_n()))) {
                this.field_209138_e = MathHelper.func_76125_a((int)((double)this.field_209138_e - d), 0, Math.max(this.field_209136_c.getList().size() - 7, 0));
                return true;
            }
            return false;
        }

        public boolean func_209133_b(int n, int n2, int n3) {
            if (n == 265) {
                this.func_209128_a(-1);
                this.field_209141_h = false;
                return true;
            }
            if (n == 264) {
                this.func_209128_a(1);
                this.field_209141_h = false;
                return true;
            }
            if (n == 258) {
                if (this.field_209141_h) {
                    this.func_209128_a(Screen.hasShiftDown() ? -1 : 1);
                }
                this.func_209131_a();
                return true;
            }
            if (n == 256) {
                this.func_209132_b();
                return true;
            }
            return false;
        }

        public void func_209128_a(int n) {
            this.func_209130_b(this.field_209139_f + n);
            \u2603 = this.field_209138_e;
            \u2603 = this.field_209138_e + 7 - 1;
            if (this.field_209139_f < \u2603) {
                this.field_209138_e = MathHelper.func_76125_a(this.field_209139_f, 0, Math.max(this.field_209136_c.getList().size() - 7, 0));
            } else if (this.field_209139_f > \u2603) {
                this.field_209138_e = MathHelper.func_76125_a(this.field_209139_f - 7, 0, Math.max(this.field_209136_c.getList().size() - 7, 0));
            }
        }

        public void func_209130_b(int n) {
            this.field_209139_f = n;
            if (this.field_209139_f < 0) {
                this.field_209139_f += this.field_209136_c.getList().size();
            }
            if (this.field_209139_f >= this.field_209136_c.getList().size()) {
                this.field_209139_f -= this.field_209136_c.getList().size();
            }
            Suggestion suggestion = (Suggestion)this.field_209136_c.getList().get(this.field_209139_f);
            AbstractCommandBlockScreen.this.field_195237_a.func_195612_c(AbstractCommandBlockScreen.func_212339_b(AbstractCommandBlockScreen.this.field_195237_a.func_146179_b(), suggestion.apply(this.field_212467_d)));
        }

        public void func_209131_a() {
            Suggestion suggestion = (Suggestion)this.field_209136_c.getList().get(this.field_209139_f);
            AbstractCommandBlockScreen.this.field_212342_z = true;
            AbstractCommandBlockScreen.this.func_209102_a(suggestion.apply(this.field_212467_d));
            int \u26032 = suggestion.getRange().getStart() + suggestion.getText().length();
            AbstractCommandBlockScreen.this.field_195237_a.func_212422_f(\u26032);
            AbstractCommandBlockScreen.this.field_195237_a.func_146199_i(\u26032);
            this.func_209130_b(this.field_209139_f);
            AbstractCommandBlockScreen.this.field_212342_z = false;
            this.field_209141_h = true;
        }

        public void func_209132_b() {
            AbstractCommandBlockScreen.this.field_209116_y = null;
        }
    }
}

