/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.SuggestionContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;

public class ChatScreen
extends Screen {
    private static final Pattern field_208608_i = Pattern.compile("(\\s+)");
    private String field_146410_g = "";
    private int field_146416_h = -1;
    protected TextFieldWidget field_146415_a;
    private String field_146409_v = "";
    protected final List<String> field_195136_f = Lists.newArrayList();
    protected int field_195138_g;
    protected int field_195140_h;
    private ParseResults<ISuggestionProvider> field_195135_u;
    private CompletableFuture<Suggestions> field_195137_v;
    private SuggestionsList field_195139_w;
    private boolean field_211139_z;
    private boolean field_212338_z;

    public ChatScreen(String string) {
        super(NarratorChatListener.field_216868_a);
        this.field_146409_v = string;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_146416_h = this.minecraft.field_71456_v.func_146158_b().func_146238_c().size();
        this.field_146415_a = new TextFieldWidget(this.font, 4, this.height - 12, this.width - 4, 12, I18n.func_135052_a("chat.editBox", new Object[0]));
        this.field_146415_a.func_146203_f(256);
        this.field_146415_a.func_146185_a(false);
        this.field_146415_a.func_146180_a(this.field_146409_v);
        this.field_146415_a.func_195607_a(this::func_195130_a);
        this.field_146415_a.func_212954_a(this::func_212997_a);
        this.children.add(this.field_146415_a);
        this.func_195129_h();
        this.func_212928_a(this.field_146415_a);
    }

    @Override
    public void resize(Minecraft minecraft, int n, int n2) {
        String string = this.field_146415_a.func_146179_b();
        this.init(minecraft, n, n2);
        this.func_208604_b(string);
        this.func_195129_h();
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        this.minecraft.field_71456_v.func_146158_b().func_146240_d();
    }

    @Override
    public void tick() {
        this.field_146415_a.func_146178_a();
    }

    private void func_212997_a(String string) {
        \u2603 = this.field_146415_a.func_146179_b();
        this.field_211139_z = !\u2603.equals(this.field_146409_v);
        this.func_195129_h();
    }

    @Override
    public boolean keyPressed(int n4, int n2, int n3) {
        int n4;
        if (this.field_195139_w != null && this.field_195139_w.func_198503_b(n4, n2, n3)) {
            return true;
        }
        if (n4 == 258) {
            this.field_211139_z = true;
            this.func_195131_X_();
        }
        if (super.keyPressed(n4, n2, n3)) {
            return true;
        }
        if (n4 == 256) {
            this.minecraft.func_147108_a(null);
            return true;
        }
        if (n4 == 257 || n4 == 335) {
            String string = this.field_146415_a.func_146179_b().trim();
            if (!string.isEmpty()) {
                this.sendMessage(string);
            }
            this.minecraft.func_147108_a(null);
            return true;
        }
        if (n4 == 265) {
            this.func_146402_a(-1);
            return true;
        }
        if (n4 == 264) {
            this.func_146402_a(1);
            return true;
        }
        if (n4 == 266) {
            this.minecraft.field_71456_v.func_146158_b().func_194813_a(this.minecraft.field_71456_v.func_146158_b().func_146232_i() - 1);
            return true;
        }
        if (n4 == 267) {
            this.minecraft.field_71456_v.func_146158_b().func_194813_a(-this.minecraft.field_71456_v.func_146158_b().func_146232_i() + 1);
            return true;
        }
        return false;
    }

    public void func_195131_X_() {
        if (this.field_195137_v != null && this.field_195137_v.isDone()) {
            int n = 0;
            Suggestions \u26032 = this.field_195137_v.join();
            if (!\u26032.getList().isEmpty()) {
                for (Suggestion suggestion : \u26032.getList()) {
                    n = Math.max(n, this.font.func_78256_a(suggestion.getText()));
                }
                \u2603 = MathHelper.func_76125_a(this.field_146415_a.func_195611_j(\u26032.getRange().getStart()), 0, this.width - n);
                this.field_195139_w = new SuggestionsList(\u2603, this.height - 12, n, \u26032);
            }
        }
    }

    private static int func_208603_a(String string) {
        if (Strings.isNullOrEmpty((String)string)) {
            return 0;
        }
        int n = 0;
        Matcher \u26032 = field_208608_i.matcher(string);
        while (\u26032.find()) {
            n = \u26032.end();
        }
        return n;
    }

    private void func_195129_h() {
        String string = this.field_146415_a.func_146179_b();
        if (this.field_195135_u != null && !this.field_195135_u.getReader().getString().equals(string)) {
            this.field_195135_u = null;
        }
        if (!this.field_212338_z) {
            this.field_146415_a.func_195612_c(null);
            this.field_195139_w = null;
        }
        this.field_195136_f.clear();
        StringReader \u26032 = new StringReader(string);
        if (\u26032.canRead() && \u26032.peek() == '/') {
            \u26032.skip();
            CommandDispatcher<ISuggestionProvider> commandDispatcher = this.minecraft.field_71439_g.field_71174_a.func_195515_i();
            if (this.field_195135_u == null) {
                this.field_195135_u = commandDispatcher.parse(\u26032, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
            }
            if (!((\u2603 = this.field_146415_a.func_146198_h()) < 1 || this.field_195139_w != null && this.field_212338_z)) {
                this.field_195137_v = commandDispatcher.getCompletionSuggestions(this.field_195135_u, \u2603);
                this.field_195137_v.thenRun(() -> {
                    if (!this.field_195137_v.isDone()) {
                        return;
                    }
                    this.func_195133_i();
                });
            }
        } else {
            \u2603 = string;
            int \u26033 = ChatScreen.func_208603_a(\u2603);
            Collection<String> \u26034 = this.minecraft.field_71439_g.field_71174_a.func_195513_b().func_197011_j();
            this.field_195137_v = ISuggestionProvider.func_197005_b(\u26034, new SuggestionsBuilder(\u2603, \u26033));
        }
    }

    private void func_195133_i() {
        if (this.field_195137_v.join().isEmpty() && !this.field_195135_u.getExceptions().isEmpty() && this.field_146415_a.func_146198_h() == this.field_146415_a.func_146179_b().length()) {
            int n = 0;
            for (Map.Entry entry : this.field_195135_u.getExceptions().entrySet()) {
                CommandSyntaxException commandSyntaxException = (CommandSyntaxException)((Object)entry.getValue());
                if (commandSyntaxException.getType() == CommandSyntaxException.BUILT_IN_EXCEPTIONS.literalIncorrect()) {
                    ++n;
                    continue;
                }
                this.field_195136_f.add(commandSyntaxException.getMessage());
            }
            if (n > 0) {
                this.field_195136_f.add(CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().create().getMessage());
            }
        }
        this.field_195138_g = 0;
        this.field_195140_h = this.width;
        if (this.field_195136_f.isEmpty()) {
            this.func_195132_a(TextFormatting.GRAY);
        }
        this.field_195139_w = null;
        if (this.field_211139_z && this.minecraft.field_71474_y.field_198018_T) {
            this.func_195131_X_();
        }
    }

    private String func_195130_a(String string, int n) {
        if (this.field_195135_u != null) {
            return ChatScreen.func_212336_a(this.field_195135_u, string, n);
        }
        return string;
    }

    public static String func_212336_a(ParseResults<ISuggestionProvider> parseResults2, String string2, int n) {
        String string2;
        ParseResults<ISuggestionProvider> parseResults2;
        TextFormatting[] textFormattingArray = new TextFormatting[]{TextFormatting.AQUA, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.LIGHT_PURPLE, TextFormatting.GOLD};
        String \u26032 = TextFormatting.GRAY.toString();
        StringBuilder \u26033 = new StringBuilder(\u26032);
        int \u26034 = 0;
        int \u26035 = -1;
        CommandContextBuilder \u26036 = parseResults2.getContext().getLastChild();
        for (ParsedArgument parsedArgument : \u26036.getArguments().values()) {
            if (++\u26035 >= textFormattingArray.length) {
                \u26035 = 0;
            }
            if ((\u2603 = Math.max(parsedArgument.getRange().getStart() - n, 0)) >= string2.length()) break;
            int n2 = Math.min(parsedArgument.getRange().getEnd() - n, string2.length());
            if (n2 <= 0) continue;
            \u26033.append(string2, \u26034, \u2603);
            \u26033.append((Object)textFormattingArray[\u26035]);
            \u26033.append(string2, \u2603, n2);
            \u26033.append(\u26032);
            \u26034 = n2;
        }
        if (parseResults2.getReader().canRead() && (\u2603 = Math.max(parseResults2.getReader().getCursor() - n, 0)) < string2.length()) {
            int n3 = Math.min(\u2603 + parseResults2.getReader().getRemainingLength(), string2.length());
            \u26033.append(string2, \u26034, \u2603);
            \u26033.append((Object)TextFormatting.RED);
            \u26033.append(string2, \u2603, n3);
            \u26034 = n3;
        }
        \u26033.append(string2, \u26034, string2.length());
        return \u26033.toString();
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        if (d3 > 1.0) {
            d3 = 1.0;
        }
        if (d3 < -1.0) {
            d3 = -1.0;
        }
        if (this.field_195139_w != null && this.field_195139_w.func_198498_a(d3)) {
            return true;
        }
        if (!ChatScreen.hasShiftDown()) {
            d3 *= 7.0;
        }
        this.minecraft.field_71456_v.func_146158_b().func_194813_a(d3);
        return true;
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (this.field_195139_w != null && this.field_195139_w.func_198499_a((int)d, (int)d2, n)) {
            return true;
        }
        if (n == 0 && (\u2603 = this.minecraft.field_71456_v.func_146158_b().func_194817_a(d, d2)) != null && this.handleComponentClicked(\u2603)) {
            return true;
        }
        if (this.field_146415_a.mouseClicked(d, d2, n)) {
            return true;
        }
        return super.mouseClicked(d, d2, n);
    }

    @Override
    protected void insertText(String string, boolean bl) {
        if (bl) {
            this.field_146415_a.func_146180_a(string);
        } else {
            this.field_146415_a.func_146191_b(string);
        }
    }

    public void func_146402_a(int n) {
        \u2603 = this.field_146416_h + n;
        \u2603 = this.minecraft.field_71456_v.func_146158_b().func_146238_c().size();
        if ((\u2603 = MathHelper.func_76125_a(\u2603, 0, \u2603)) == this.field_146416_h) {
            return;
        }
        if (\u2603 == \u2603) {
            this.field_146416_h = \u2603;
            this.field_146415_a.func_146180_a(this.field_146410_g);
            return;
        }
        if (this.field_146416_h == \u2603) {
            this.field_146410_g = this.field_146415_a.func_146179_b();
        }
        this.field_146415_a.func_146180_a(this.minecraft.field_71456_v.func_146158_b().func_146238_c().get(\u2603));
        this.field_195139_w = null;
        this.field_146416_h = \u2603;
        this.field_211139_z = false;
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.setFocused(this.field_146415_a);
        this.field_146415_a.func_146195_b(true);
        ChatScreen.fill(2, this.height - 14, this.width - 2, this.height - 2, this.minecraft.field_71474_y.func_216839_a(Integer.MIN_VALUE));
        this.field_146415_a.render(n3, n2, f);
        if (this.field_195139_w != null) {
            this.field_195139_w.func_198500_a(n3, n2);
        } else {
            int n4 = 0;
            for (String string : this.field_195136_f) {
                ChatScreen.fill(this.field_195138_g - 1, this.height - 14 - 13 - 12 * n4, this.field_195138_g + this.field_195140_h + 1, this.height - 2 - 13 - 12 * n4, -16777216);
                this.font.func_175063_a(string, this.field_195138_g, this.height - 14 - 13 + 2 - 12 * n4, -1);
                ++n4;
            }
        }
        ITextComponent \u26032 = this.minecraft.field_71456_v.func_146158_b().func_194817_a(n3, n2);
        if (\u26032 != null && \u26032.func_150256_b().func_150210_i() != null) {
            this.renderComponentHoverEffect(\u26032, n3, n2);
        }
        super.render(n3, n2, f);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    private void func_195132_a(TextFormatting textFormatting) {
        CommandContextBuilder commandContextBuilder = this.field_195135_u.getContext();
        SuggestionContext \u26032 = commandContextBuilder.findSuggestionContext(this.field_146415_a.func_146198_h());
        Map \u26033 = this.minecraft.field_71439_g.field_71174_a.func_195515_i().getSmartUsage(\u26032.parent, (Object)this.minecraft.field_71439_g.field_71174_a.func_195513_b());
        ArrayList \u26034 = Lists.newArrayList();
        int \u26035 = 0;
        for (Map.Entry entry : \u26033.entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            \u26034.add((Object)((Object)textFormatting) + (String)entry.getValue());
            \u26035 = Math.max(\u26035, this.font.func_78256_a((String)entry.getValue()));
        }
        if (!\u26034.isEmpty()) {
            this.field_195136_f.addAll(\u26034);
            this.field_195138_g = MathHelper.func_76125_a(this.field_146415_a.func_195611_j(\u26032.startPos), 0, this.width - \u26035);
            this.field_195140_h = \u26035;
        }
    }

    @Nullable
    private static String func_208602_b(String string, String string2) {
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return null;
    }

    private void func_208604_b(String string) {
        this.field_146415_a.func_146180_a(string);
    }

    class SuggestionsList {
        private final Rectangle2d field_198505_b;
        private final Suggestions field_198506_c;
        private final String field_212466_d;
        private int field_198507_d;
        private int field_198508_e;
        private Vec2f field_198509_f = Vec2f.field_189974_a;
        private boolean field_199880_h;

        private SuggestionsList(int n, int n2, int n3, Suggestions suggestions) {
            this.field_198505_b = new Rectangle2d(n - 1, n2 - 3 - Math.min(suggestions.getList().size(), 10) * 12, n3 + 1, Math.min(suggestions.getList().size(), 10) * 12);
            this.field_198506_c = suggestions;
            this.field_212466_d = ChatScreen.this.field_146415_a.func_146179_b();
            this.func_199675_a(0);
        }

        public void func_198500_a(int n, int n2) {
            int n3;
            \u2603 = Math.min(this.field_198506_c.getList().size(), 10);
            \u2603 = -5592406;
            boolean bl = this.field_198507_d > 0;
            bl3 = this.field_198506_c.getList().size() > this.field_198507_d + \u2603;
            \u2603 = bl || bl3;
            boolean bl2 = \u2603 = this.field_198509_f.field_189982_i != (float)n || this.field_198509_f.field_189983_j != (float)n2;
            if (\u2603) {
                this.field_198509_f = new Vec2f(n, n2);
            }
            if (\u2603) {
                boolean bl3;
                AbstractGui.fill(this.field_198505_b.func_199318_a(), this.field_198505_b.func_199319_b() - 1, this.field_198505_b.func_199318_a() + this.field_198505_b.func_199316_c(), this.field_198505_b.func_199319_b(), -805306368);
                AbstractGui.fill(this.field_198505_b.func_199318_a(), this.field_198505_b.func_199319_b() + this.field_198505_b.func_199317_d(), this.field_198505_b.func_199318_a() + this.field_198505_b.func_199316_c(), this.field_198505_b.func_199319_b() + this.field_198505_b.func_199317_d() + 1, -805306368);
                if (bl) {
                    for (n3 = 0; n3 < this.field_198505_b.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.fill(this.field_198505_b.func_199318_a() + n3, this.field_198505_b.func_199319_b() - 1, this.field_198505_b.func_199318_a() + n3 + 1, this.field_198505_b.func_199319_b(), -1);
                    }
                }
                if (bl3) {
                    for (n3 = 0; n3 < this.field_198505_b.func_199316_c(); ++n3) {
                        if (n3 % 2 != 0) continue;
                        AbstractGui.fill(this.field_198505_b.func_199318_a() + n3, this.field_198505_b.func_199319_b() + this.field_198505_b.func_199317_d(), this.field_198505_b.func_199318_a() + n3 + 1, this.field_198505_b.func_199319_b() + this.field_198505_b.func_199317_d() + 1, -1);
                    }
                }
            }
            n3 = 0;
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                Suggestion suggestion = (Suggestion)this.field_198506_c.getList().get(\u2603 + this.field_198507_d);
                AbstractGui.fill(this.field_198505_b.func_199318_a(), this.field_198505_b.func_199319_b() + 12 * \u2603, this.field_198505_b.func_199318_a() + this.field_198505_b.func_199316_c(), this.field_198505_b.func_199319_b() + 12 * \u2603 + 12, -805306368);
                if (n > this.field_198505_b.func_199318_a() && n < this.field_198505_b.func_199318_a() + this.field_198505_b.func_199316_c() && n2 > this.field_198505_b.func_199319_b() + 12 * \u2603 && n2 < this.field_198505_b.func_199319_b() + 12 * \u2603 + 12) {
                    if (\u2603) {
                        this.func_199675_a(\u2603 + this.field_198507_d);
                    }
                    n3 = 1;
                }
                ChatScreen.this.font.func_175063_a(suggestion.getText(), this.field_198505_b.func_199318_a() + 1, this.field_198505_b.func_199319_b() + 2 + 12 * \u2603, \u2603 + this.field_198507_d == this.field_198508_e ? -256 : -5592406);
            }
            if (n3 != 0 && (\u2603 = ((Suggestion)this.field_198506_c.getList().get(this.field_198508_e)).getTooltip()) != null) {
                ChatScreen.this.renderTooltip(TextComponentUtils.func_202465_a(\u2603).func_150254_d(), n, n2);
            }
        }

        public boolean func_198499_a(int n, int n2, int n3) {
            if (!this.field_198505_b.func_199315_b(n, n2)) {
                return false;
            }
            \u2603 = (n2 - this.field_198505_b.func_199319_b()) / 12 + this.field_198507_d;
            if (\u2603 >= 0 && \u2603 < this.field_198506_c.getList().size()) {
                this.func_199675_a(\u2603);
                this.func_198501_a();
            }
            return true;
        }

        public boolean func_198498_a(double d) {
            int n = (int)(ChatScreen.this.minecraft.field_71417_B.func_198024_e() * (double)ChatScreen.this.minecraft.field_195558_d.func_198107_o() / (double)ChatScreen.this.minecraft.field_195558_d.func_198105_m());
            if (this.field_198505_b.func_199315_b(n, \u2603 = (int)(ChatScreen.this.minecraft.field_71417_B.func_198026_f() * (double)ChatScreen.this.minecraft.field_195558_d.func_198087_p() / (double)ChatScreen.this.minecraft.field_195558_d.func_198083_n()))) {
                this.field_198507_d = MathHelper.func_76125_a((int)((double)this.field_198507_d - d), 0, Math.max(this.field_198506_c.getList().size() - 10, 0));
                return true;
            }
            return false;
        }

        public boolean func_198503_b(int n, int n2, int n3) {
            if (n == 265) {
                this.func_199879_a(-1);
                this.field_199880_h = false;
                return true;
            }
            if (n == 264) {
                this.func_199879_a(1);
                this.field_199880_h = false;
                return true;
            }
            if (n == 258) {
                if (this.field_199880_h) {
                    this.func_199879_a(Screen.hasShiftDown() ? -1 : 1);
                }
                this.func_198501_a();
                return true;
            }
            if (n == 256) {
                this.func_198502_b();
                return true;
            }
            return false;
        }

        public void func_199879_a(int n) {
            this.func_199675_a(this.field_198508_e + n);
            \u2603 = this.field_198507_d;
            \u2603 = this.field_198507_d + 10 - 1;
            if (this.field_198508_e < \u2603) {
                this.field_198507_d = MathHelper.func_76125_a(this.field_198508_e, 0, Math.max(this.field_198506_c.getList().size() - 10, 0));
            } else if (this.field_198508_e > \u2603) {
                this.field_198507_d = MathHelper.func_76125_a(this.field_198508_e + 1 - 10, 0, Math.max(this.field_198506_c.getList().size() - 10, 0));
            }
        }

        public void func_199675_a(int n) {
            this.field_198508_e = n;
            if (this.field_198508_e < 0) {
                this.field_198508_e += this.field_198506_c.getList().size();
            }
            if (this.field_198508_e >= this.field_198506_c.getList().size()) {
                this.field_198508_e -= this.field_198506_c.getList().size();
            }
            Suggestion suggestion = (Suggestion)this.field_198506_c.getList().get(this.field_198508_e);
            ChatScreen.this.field_146415_a.func_195612_c(ChatScreen.func_208602_b(ChatScreen.this.field_146415_a.func_146179_b(), suggestion.apply(this.field_212466_d)));
        }

        public void func_198501_a() {
            Suggestion suggestion = (Suggestion)this.field_198506_c.getList().get(this.field_198508_e);
            ChatScreen.this.field_212338_z = true;
            ChatScreen.this.func_208604_b(suggestion.apply(this.field_212466_d));
            int \u26032 = suggestion.getRange().getStart() + suggestion.getText().length();
            ChatScreen.this.field_146415_a.func_212422_f(\u26032);
            ChatScreen.this.field_146415_a.func_146199_i(\u26032);
            this.func_199675_a(this.field_198508_e);
            ChatScreen.this.field_212338_z = false;
            this.field_199880_h = true;
        }

        public void func_198502_b() {
            ChatScreen.this.field_195139_w = null;
        }
    }
}

