/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.gson.JsonElement;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Random;
import net.minecraft.client.gui.screen.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.FileUtil;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.lang3.StringUtils;

public class CreateWorldScreen
extends Screen {
    private final Screen field_146332_f;
    private TextFieldWidget field_146333_g;
    private TextFieldWidget field_146335_h;
    private String field_146336_i;
    private String field_146342_r = "survival";
    private String field_175300_s;
    private boolean field_146341_s = true;
    private boolean field_146340_t;
    private boolean field_146339_u;
    private boolean field_146338_v;
    private boolean field_146337_w;
    private boolean field_146345_x;
    private boolean field_146344_y;
    private Button field_195355_B;
    private Button field_146343_z;
    private Button field_146324_A;
    private Button field_146325_B;
    private Button field_146326_C;
    private Button field_146320_D;
    private Button field_146321_E;
    private Button field_146322_F;
    private String field_146323_G;
    private String field_146328_H;
    private String field_146329_I;
    private String field_146330_J;
    private int field_146331_K;
    public CompoundNBT field_146334_a = new CompoundNBT();

    public CreateWorldScreen(Screen screen) {
        super(new TranslationTextComponent("selectWorld.create", new Object[0]));
        this.field_146332_f = screen;
        this.field_146329_I = "";
        this.field_146330_J = I18n.func_135052_a("selectWorld.newWorld", new Object[0]);
    }

    @Override
    public void tick() {
        this.field_146333_g.func_146178_a();
        this.field_146335_h.func_146178_a();
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_146333_g = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a("selectWorld.enterName", new Object[0]));
        this.field_146333_g.func_146180_a(this.field_146330_J);
        this.field_146333_g.func_212954_a(string -> {
            this.field_146330_J = string;
            this.field_195355_B.active = !this.field_146333_g.func_146179_b().isEmpty();
            this.func_146314_g();
        });
        this.children.add(this.field_146333_g);
        this.field_146343_z = this.addButton(new Button(this.width / 2 - 75, 115, 150, 20, I18n.func_135052_a("selectWorld.gameMode", new Object[0]), button -> {
            if ("survival".equals(this.field_146342_r)) {
                if (!this.field_146339_u) {
                    this.field_146340_t = false;
                }
                this.field_146337_w = false;
                this.field_146342_r = "hardcore";
                this.field_146337_w = true;
                this.field_146321_E.active = false;
                this.field_146326_C.active = false;
                this.func_146319_h();
            } else if ("hardcore".equals(this.field_146342_r)) {
                if (!this.field_146339_u) {
                    this.field_146340_t = true;
                }
                this.field_146337_w = false;
                this.field_146342_r = "creative";
                this.func_146319_h();
                this.field_146337_w = false;
                this.field_146321_E.active = true;
                this.field_146326_C.active = true;
            } else {
                if (!this.field_146339_u) {
                    this.field_146340_t = false;
                }
                this.field_146342_r = "survival";
                this.func_146319_h();
                this.field_146321_E.active = true;
                this.field_146326_C.active = true;
                this.field_146337_w = false;
            }
            this.func_146319_h();
        }));
        this.field_146335_h = new TextFieldWidget(this.font, this.width / 2 - 100, 60, 200, 20, I18n.func_135052_a("selectWorld.enterSeed", new Object[0]));
        this.field_146335_h.func_146180_a(this.field_146329_I);
        this.field_146335_h.func_212954_a(string -> {
            this.field_146329_I = this.field_146335_h.func_146179_b();
        });
        this.children.add(this.field_146335_h);
        this.field_146325_B = this.addButton(new Button(this.width / 2 - 155, 100, 150, 20, I18n.func_135052_a("selectWorld.mapFeatures", new Object[0]), button -> {
            this.field_146341_s = !this.field_146341_s;
            this.func_146319_h();
        }));
        this.field_146325_B.visible = false;
        this.field_146320_D = this.addButton(new Button(this.width / 2 + 5, 100, 150, 20, I18n.func_135052_a("selectWorld.mapType", new Object[0]), button -> {
            ++this.field_146331_K;
            if (this.field_146331_K >= WorldType.field_77139_a.length) {
                this.field_146331_K = 0;
            }
            while (!this.func_175299_g()) {
                ++this.field_146331_K;
                if (this.field_146331_K < WorldType.field_77139_a.length) continue;
                this.field_146331_K = 0;
            }
            this.field_146334_a = new CompoundNBT();
            this.func_146319_h();
            this.func_146316_a(this.field_146344_y);
        }));
        this.field_146320_D.visible = false;
        this.field_146322_F = this.addButton(new Button(this.width / 2 + 5, 120, 150, 20, I18n.func_135052_a("selectWorld.customizeType", new Object[0]), button -> {
            if (WorldType.field_77139_a[this.field_146331_K] == WorldType.field_77138_c) {
                this.minecraft.func_147108_a(new CreateFlatWorldScreen(this, this.field_146334_a));
            }
            if (WorldType.field_77139_a[this.field_146331_K] == WorldType.field_205394_h) {
                this.minecraft.func_147108_a(new CreateBuffetWorldScreen(this, this.field_146334_a));
            }
        }));
        this.field_146322_F.visible = false;
        this.field_146321_E = this.addButton(new Button(this.width / 2 - 155, 151, 150, 20, I18n.func_135052_a("selectWorld.allowCommands", new Object[0]), button -> {
            this.field_146339_u = true;
            this.field_146340_t = !this.field_146340_t;
            this.func_146319_h();
        }));
        this.field_146321_E.visible = false;
        this.field_146326_C = this.addButton(new Button(this.width / 2 + 5, 151, 150, 20, I18n.func_135052_a("selectWorld.bonusItems", new Object[0]), button -> {
            this.field_146338_v = !this.field_146338_v;
            this.func_146319_h();
        }));
        this.field_146326_C.visible = false;
        this.field_146324_A = this.addButton(new Button(this.width / 2 - 75, 187, 150, 20, I18n.func_135052_a("selectWorld.moreWorldOptions", new Object[0]), button -> this.func_146315_i()));
        this.field_195355_B = this.addButton(new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a("selectWorld.create", new Object[0]), button -> this.func_195352_j()));
        this.addButton(new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.minecraft.func_147108_a(this.field_146332_f)));
        this.func_146316_a(this.field_146344_y);
        this.func_212928_a(this.field_146333_g);
        this.func_146314_g();
        this.func_146319_h();
    }

    private void func_146314_g() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        if (this.field_146336_i.length() == 0) {
            this.field_146336_i = "World";
        }
        try {
            this.field_146336_i = FileUtil.func_214992_a(this.minecraft.func_71359_d().func_215781_c(), this.field_146336_i, "");
        }
        catch (Exception exception) {
            this.field_146336_i = "World";
            try {
                this.field_146336_i = FileUtil.func_214992_a(this.minecraft.func_71359_d().func_215781_c(), this.field_146336_i, "");
            }
            catch (Exception exception2) {
                throw new RuntimeException("Could not create save folder", exception2);
            }
        }
    }

    private void func_146319_h() {
        this.field_146343_z.setMessage(I18n.func_135052_a("selectWorld.gameMode", new Object[0]) + ": " + I18n.func_135052_a("selectWorld.gameMode." + this.field_146342_r, new Object[0]));
        this.field_146323_G = I18n.func_135052_a("selectWorld.gameMode." + this.field_146342_r + ".line1", new Object[0]);
        this.field_146328_H = I18n.func_135052_a("selectWorld.gameMode." + this.field_146342_r + ".line2", new Object[0]);
        this.field_146325_B.setMessage(I18n.func_135052_a("selectWorld.mapFeatures", new Object[0]) + ' ' + I18n.func_135052_a(this.field_146341_s ? "options.on" : "options.off", new Object[0]));
        this.field_146326_C.setMessage(I18n.func_135052_a("selectWorld.bonusItems", new Object[0]) + ' ' + I18n.func_135052_a(this.field_146338_v && !this.field_146337_w ? "options.on" : "options.off", new Object[0]));
        this.field_146320_D.setMessage(I18n.func_135052_a("selectWorld.mapType", new Object[0]) + ' ' + I18n.func_135052_a(WorldType.field_77139_a[this.field_146331_K].func_77128_b(), new Object[0]));
        this.field_146321_E.setMessage(I18n.func_135052_a("selectWorld.allowCommands", new Object[0]) + ' ' + I18n.func_135052_a(this.field_146340_t && !this.field_146337_w ? "options.on" : "options.off", new Object[0]));
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private void func_195352_j() {
        this.minecraft.func_147108_a(null);
        if (this.field_146345_x) {
            return;
        }
        this.field_146345_x = true;
        long l = new Random().nextLong();
        String \u26032 = this.field_146335_h.func_146179_b();
        if (!StringUtils.isEmpty((CharSequence)\u26032)) {
            try {
                \u2603 = Long.parseLong(\u26032);
                if (\u2603 != 0L) {
                    l = \u2603;
                }
            }
            catch (NumberFormatException numberFormatException) {
                l = \u26032.hashCode();
            }
        }
        WorldSettings \u26033 = new WorldSettings(l, GameType.func_77142_a(this.field_146342_r), this.field_146341_s, this.field_146337_w, WorldType.field_77139_a[this.field_146331_K]);
        \u26033.func_205390_a((JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_146334_a));
        if (this.field_146338_v && !this.field_146337_w) {
            \u26033.func_77159_a();
        }
        if (this.field_146340_t && !this.field_146337_w) {
            \u26033.func_77166_b();
        }
        this.minecraft.func_71371_a(this.field_146336_i, this.field_146333_g.func_146179_b().trim(), \u26033);
    }

    private boolean func_175299_g() {
        WorldType worldType = WorldType.field_77139_a[this.field_146331_K];
        if (worldType == null || !worldType.func_77126_d()) {
            return false;
        }
        if (worldType == WorldType.field_180272_g) {
            return CreateWorldScreen.hasShiftDown();
        }
        return true;
    }

    private void func_146315_i() {
        this.func_146316_a(!this.field_146344_y);
    }

    private void func_146316_a(boolean bl) {
        this.field_146344_y = bl;
        if (WorldType.field_77139_a[this.field_146331_K] == WorldType.field_180272_g) {
            this.field_146343_z.visible = !this.field_146344_y;
            this.field_146343_z.active = false;
            if (this.field_175300_s == null) {
                this.field_175300_s = this.field_146342_r;
            }
            this.field_146342_r = "spectator";
            this.field_146325_B.visible = false;
            this.field_146326_C.visible = false;
            this.field_146320_D.visible = this.field_146344_y;
            this.field_146321_E.visible = false;
            this.field_146322_F.visible = false;
        } else {
            this.field_146343_z.visible = !this.field_146344_y;
            this.field_146343_z.active = true;
            if (this.field_175300_s != null) {
                this.field_146342_r = this.field_175300_s;
                this.field_175300_s = null;
            }
            this.field_146325_B.visible = this.field_146344_y && WorldType.field_77139_a[this.field_146331_K] != WorldType.field_180271_f;
            this.field_146326_C.visible = this.field_146344_y;
            this.field_146320_D.visible = this.field_146344_y;
            this.field_146321_E.visible = this.field_146344_y;
            this.field_146322_F.visible = this.field_146344_y && WorldType.field_77139_a[this.field_146331_K].func_205393_e();
        }
        this.func_146319_h();
        this.field_146335_h.func_146189_e(this.field_146344_y);
        this.field_146333_g.func_146189_e(!this.field_146344_y);
        if (this.field_146344_y) {
            this.field_146324_A.setMessage(I18n.func_135052_a("gui.done", new Object[0]));
        } else {
            this.field_146324_A.setMessage(I18n.func_135052_a("selectWorld.moreWorldOptions", new Object[0]));
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 257 || n == 335) {
            this.func_195352_j();
            return true;
        }
        return false;
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, -1);
        if (this.field_146344_y) {
            this.drawString(this.font, I18n.func_135052_a("selectWorld.enterSeed", new Object[0]), this.width / 2 - 100, 47, -6250336);
            this.drawString(this.font, I18n.func_135052_a("selectWorld.seedInfo", new Object[0]), this.width / 2 - 100, 85, -6250336);
            if (this.field_146325_B.visible) {
                this.drawString(this.font, I18n.func_135052_a("selectWorld.mapFeatures.info", new Object[0]), this.width / 2 - 150, 122, -6250336);
            }
            if (this.field_146321_E.visible) {
                this.drawString(this.font, I18n.func_135052_a("selectWorld.allowCommands.info", new Object[0]), this.width / 2 - 150, 172, -6250336);
            }
            this.field_146335_h.render(n, n2, f);
            if (WorldType.field_77139_a[this.field_146331_K].func_151357_h()) {
                this.font.func_78279_b(I18n.func_135052_a(WorldType.field_77139_a[this.field_146331_K].func_151359_c(), new Object[0]), this.field_146320_D.x + 2, this.field_146320_D.y + 22, this.field_146320_D.getWidth(), 0xA0A0A0);
            }
        } else {
            this.drawString(this.font, I18n.func_135052_a("selectWorld.enterName", new Object[0]), this.width / 2 - 100, 47, -6250336);
            this.drawString(this.font, I18n.func_135052_a("selectWorld.resultFolder", new Object[0]) + " " + this.field_146336_i, this.width / 2 - 100, 85, -6250336);
            this.field_146333_g.render(n, n2, f);
            this.drawCenteredString(this.font, this.field_146323_G, this.width / 2, 137, -6250336);
            this.drawCenteredString(this.font, this.field_146328_H, this.width / 2, 149, -6250336);
        }
        super.render(n, n2, f);
    }

    public void func_146318_a(WorldInfo worldInfo) {
        this.field_146330_J = worldInfo.func_76065_j();
        this.field_146329_I = worldInfo.func_76063_b() + "";
        WorldType worldType = worldInfo.func_76067_t() == WorldType.field_180271_f ? WorldType.field_77137_b : worldInfo.func_76067_t();
        this.field_146331_K = worldType.func_82747_f();
        this.field_146334_a = worldInfo.func_211027_A();
        this.field_146341_s = worldInfo.func_76089_r();
        this.field_146340_t = worldInfo.func_76086_u();
        if (worldInfo.func_76093_s()) {
            this.field_146342_r = "hardcore";
        } else if (worldInfo.func_76077_q().func_77144_e()) {
            this.field_146342_r = "survival";
        } else if (worldInfo.func_76077_q().func_77145_d()) {
            this.field_146342_r = "creative";
        }
    }
}

