/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.ReadBookScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ChangePageButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class EditBookScreen
extends Screen {
    private final PlayerEntity field_214232_a;
    private final ItemStack field_214233_b;
    private boolean field_214234_c;
    private boolean field_214235_d;
    private int field_214236_e;
    private int field_214237_f;
    private final List<String> field_214238_g = Lists.newArrayList();
    private String field_214239_h = "";
    private int field_214240_i;
    private int field_214241_j;
    private long field_214242_k;
    private int field_214243_l = -1;
    private ChangePageButton field_214244_m;
    private ChangePageButton field_214245_n;
    private Button field_214246_o;
    private Button field_214247_p;
    private Button field_214248_q;
    private Button field_214249_r;
    private final Hand field_214250_s;

    public EditBookScreen(PlayerEntity playerEntity, ItemStack itemStack, Hand hand) {
        super(NarratorChatListener.field_216868_a);
        this.field_214232_a = playerEntity;
        this.field_214233_b = itemStack;
        this.field_214250_s = hand;
        CompoundNBT compoundNBT = itemStack.func_77978_p();
        if (compoundNBT != null) {
            ListNBT listNBT = compoundNBT.func_150295_c("pages", 8).func_74737_b();
            for (int i = 0; i < listNBT.size(); ++i) {
                this.field_214238_g.add(listNBT.func_150307_f(i));
            }
        }
        if (this.field_214238_g.isEmpty()) {
            this.field_214238_g.add("");
        }
    }

    private int func_214199_a() {
        return this.field_214238_g.size();
    }

    @Override
    public void tick() {
        super.tick();
        ++this.field_214236_e;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_214247_p = this.addButton(new Button(this.width / 2 - 100, 196, 98, 20, I18n.func_135052_a("book.signButton", new Object[0]), button -> {
            this.field_214235_d = true;
            this.func_214229_d();
        }));
        this.field_214246_o = this.addButton(new Button(this.width / 2 + 2, 196, 98, 20, I18n.func_135052_a("gui.done", new Object[0]), button -> {
            this.minecraft.func_147108_a(null);
            this.func_214198_a(false);
        }));
        this.field_214248_q = this.addButton(new Button(this.width / 2 - 100, 196, 98, 20, I18n.func_135052_a("book.finalizeButton", new Object[0]), button -> {
            if (this.field_214235_d) {
                this.func_214198_a(true);
                this.minecraft.func_147108_a(null);
            }
        }));
        this.field_214249_r = this.addButton(new Button(this.width / 2 + 2, 196, 98, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> {
            if (this.field_214235_d) {
                this.field_214235_d = false;
            }
            this.func_214229_d();
        }));
        int n = (this.width - 192) / 2;
        \u2603 = 2;
        this.field_214244_m = this.addButton(new ChangePageButton(n + 116, 159, true, button -> this.func_214214_c(), true));
        this.field_214245_n = this.addButton(new ChangePageButton(n + 43, 159, false, button -> this.func_214228_b(), true));
        this.func_214229_d();
    }

    private String func_214219_a(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\u00a7' || c == '\u007f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private void func_214228_b() {
        if (this.field_214237_f > 0) {
            --this.field_214237_f;
            this.field_214241_j = this.field_214240_i = 0;
        }
        this.func_214229_d();
    }

    private void func_214214_c() {
        if (this.field_214237_f < this.func_214199_a() - 1) {
            ++this.field_214237_f;
            this.field_214241_j = this.field_214240_i = 0;
        } else {
            this.func_214215_f();
            if (this.field_214237_f < this.func_214199_a() - 1) {
                ++this.field_214237_f;
            }
            this.field_214241_j = this.field_214240_i = 0;
        }
        this.func_214229_d();
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    private void func_214229_d() {
        this.field_214245_n.visible = !this.field_214235_d && this.field_214237_f > 0;
        this.field_214244_m.visible = !this.field_214235_d;
        this.field_214246_o.visible = !this.field_214235_d;
        this.field_214247_p.visible = !this.field_214235_d;
        this.field_214249_r.visible = this.field_214235_d;
        this.field_214248_q.visible = this.field_214235_d;
        this.field_214248_q.active = !this.field_214239_h.trim().isEmpty();
    }

    private void func_214213_e() {
        ListIterator<String> listIterator = this.field_214238_g.listIterator(this.field_214238_g.size());
        while (listIterator.hasPrevious() && listIterator.previous().isEmpty()) {
            listIterator.remove();
        }
    }

    private void func_214198_a(boolean bl) {
        if (!this.field_214234_c) {
            return;
        }
        this.func_214213_e();
        ListNBT listNBT = new ListNBT();
        this.field_214238_g.stream().map(StringNBT::new).forEach(listNBT::add);
        if (!this.field_214238_g.isEmpty()) {
            this.field_214233_b.func_77983_a("pages", listNBT);
        }
        if (bl) {
            this.field_214233_b.func_77983_a("author", new StringNBT(this.field_214232_a.func_146103_bH().getName()));
            this.field_214233_b.func_77983_a("title", new StringNBT(this.field_214239_h.trim()));
        }
        this.minecraft.func_147114_u().func_147297_a(new CEditBookPacket(this.field_214233_b, bl, this.field_214250_s));
    }

    private void func_214215_f() {
        if (this.func_214199_a() >= 100) {
            return;
        }
        this.field_214238_g.add("");
        this.field_214234_c = true;
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (this.field_214235_d) {
            return this.func_214196_c(n, n2, n3);
        }
        return this.func_214230_b(n, n2, n3);
    }

    @Override
    public boolean charTyped(char c, int n) {
        if (super.charTyped(c, n)) {
            return true;
        }
        if (this.field_214235_d) {
            if (this.field_214239_h.length() < 16 && SharedConstants.func_71566_a(c)) {
                this.field_214239_h = this.field_214239_h + Character.toString(c);
                this.func_214229_d();
                this.field_214234_c = true;
                return true;
            }
            return false;
        }
        if (SharedConstants.func_71566_a(c)) {
            this.func_214202_k(Character.toString(c));
            return true;
        }
        return false;
    }

    private boolean func_214230_b(int n, int n2, int n3) {
        String string = this.func_214193_h();
        if (Screen.isSelectAll(n)) {
            this.field_214241_j = 0;
            this.field_214240_i = string.length();
            return true;
        }
        if (Screen.isCopy(n)) {
            this.minecraft.field_195559_v.func_197960_a(this.func_214231_i());
            return true;
        }
        if (Screen.isPaste(n)) {
            this.func_214202_k(this.func_214219_a(TextFormatting.func_110646_a(this.minecraft.field_195559_v.func_197965_a().replaceAll("\\r", ""))));
            this.field_214241_j = this.field_214240_i;
            return true;
        }
        if (Screen.isCut(n)) {
            this.minecraft.field_195559_v.func_197960_a(this.func_214231_i());
            this.func_214192_g();
            return true;
        }
        switch (n) {
            case 259: {
                this.func_214207_b(string);
                return true;
            }
            case 261: {
                this.func_214221_c(string);
                return true;
            }
            case 257: 
            case 335: {
                this.func_214202_k("\n");
                return true;
            }
            case 263: {
                this.func_214200_d(string);
                return true;
            }
            case 262: {
                this.func_214218_e(string);
                return true;
            }
            case 265: {
                this.func_214197_f(string);
                return true;
            }
            case 264: {
                this.func_214209_g(string);
                return true;
            }
            case 266: {
                this.field_214245_n.onPress();
                return true;
            }
            case 267: {
                this.field_214244_m.onPress();
                return true;
            }
            case 268: {
                this.func_214220_h(string);
                return true;
            }
            case 269: {
                this.func_214211_i(string);
                return true;
            }
        }
        return false;
    }

    private void func_214207_b(String string) {
        if (!string.isEmpty()) {
            if (this.field_214241_j != this.field_214240_i) {
                this.func_214192_g();
            } else if (this.field_214240_i > 0) {
                \u2603 = new StringBuilder(string).deleteCharAt(Math.max(0, this.field_214240_i - 1)).toString();
                this.func_214217_j(\u2603);
                this.field_214241_j = this.field_214240_i = Math.max(0, this.field_214240_i - 1);
            }
        }
    }

    private void func_214221_c(String string) {
        if (!string.isEmpty()) {
            if (this.field_214241_j != this.field_214240_i) {
                this.func_214192_g();
            } else if (this.field_214240_i < string.length()) {
                \u2603 = new StringBuilder(string).deleteCharAt(Math.max(0, this.field_214240_i)).toString();
                this.func_214217_j(\u2603);
            }
        }
    }

    private void func_214200_d(String string) {
        int n = this.font.func_78260_a() ? 1 : -1;
        this.field_214240_i = Screen.hasControlDown() ? this.font.func_216863_a(string, n, this.field_214240_i, true) : Math.max(0, this.field_214240_i + n);
        if (!Screen.hasShiftDown()) {
            this.field_214241_j = this.field_214240_i;
        }
    }

    private void func_214218_e(String string) {
        int n = this.font.func_78260_a() ? -1 : 1;
        this.field_214240_i = Screen.hasControlDown() ? this.font.func_216863_a(string, n, this.field_214240_i, true) : Math.min(string.length(), this.field_214240_i + n);
        if (!Screen.hasShiftDown()) {
            this.field_214241_j = this.field_214240_i;
        }
    }

    private void func_214197_f(String string) {
        if (!string.isEmpty()) {
            Point point = this.func_214194_c(string, this.field_214240_i);
            if (point.field_216929_c == 0) {
                this.field_214240_i = 0;
                if (!Screen.hasShiftDown()) {
                    this.field_214241_j = this.field_214240_i;
                }
            } else {
                int n = this.func_214203_a(string, new Point(point.field_216928_b + this.func_214206_a(string, this.field_214240_i) / 3, point.field_216929_c - this.font.field_78288_b));
                if (n >= 0) {
                    this.field_214240_i = n;
                    if (!Screen.hasShiftDown()) {
                        this.field_214241_j = this.field_214240_i;
                    }
                }
            }
        }
    }

    private void func_214209_g(String string) {
        if (!string.isEmpty()) {
            Point point = this.func_214194_c(string, this.field_214240_i);
            int \u26032 = this.font.func_78267_b(string + "" + (Object)((Object)TextFormatting.BLACK) + "_", 114);
            if (point.field_216929_c + this.font.field_78288_b == \u26032) {
                this.field_214240_i = string.length();
                if (!Screen.hasShiftDown()) {
                    this.field_214241_j = this.field_214240_i;
                }
            } else {
                int n = this.func_214203_a(string, new Point(point.field_216928_b + this.func_214206_a(string, this.field_214240_i) / 3, point.field_216929_c + this.font.field_78288_b));
                if (n >= 0) {
                    this.field_214240_i = n;
                    if (!Screen.hasShiftDown()) {
                        this.field_214241_j = this.field_214240_i;
                    }
                }
            }
        }
    }

    private void func_214220_h(String string) {
        this.field_214240_i = this.func_214203_a(string, new Point(0, this.func_214194_c(string, this.field_214240_i).field_216929_c));
        if (!Screen.hasShiftDown()) {
            this.field_214241_j = this.field_214240_i;
        }
    }

    private void func_214211_i(String string) {
        this.field_214240_i = this.func_214203_a(string, new Point(113, this.func_214194_c(string, this.field_214240_i).field_216929_c));
        if (!Screen.hasShiftDown()) {
            this.field_214241_j = this.field_214240_i;
        }
    }

    private void func_214192_g() {
        if (this.field_214241_j == this.field_214240_i) {
            return;
        }
        String string = this.func_214193_h();
        int \u26032 = Math.min(this.field_214240_i, this.field_214241_j);
        int \u26033 = Math.max(this.field_214240_i, this.field_214241_j);
        \u2603 = string.substring(0, \u26032) + string.substring(\u26033);
        this.field_214241_j = this.field_214240_i = \u26032;
        this.func_214217_j(\u2603);
    }

    private int func_214206_a(String string, int n) {
        return (int)this.font.func_211125_a(string.charAt(MathHelper.func_76125_a(n, 0, string.length() - 1)));
    }

    private boolean func_214196_c(int n, int n2, int n3) {
        switch (n) {
            case 259: {
                if (!this.field_214239_h.isEmpty()) {
                    this.field_214239_h = this.field_214239_h.substring(0, this.field_214239_h.length() - 1);
                    this.func_214229_d();
                }
                return true;
            }
            case 257: 
            case 335: {
                if (!this.field_214239_h.isEmpty()) {
                    this.func_214198_a(true);
                    this.minecraft.func_147108_a(null);
                }
                return true;
            }
        }
        return false;
    }

    private String func_214193_h() {
        if (this.field_214237_f >= 0 && this.field_214237_f < this.field_214238_g.size()) {
            return this.field_214238_g.get(this.field_214237_f);
        }
        return "";
    }

    private void func_214217_j(String string) {
        if (this.field_214237_f >= 0 && this.field_214237_f < this.field_214238_g.size()) {
            this.field_214238_g.set(this.field_214237_f, string);
            this.field_214234_c = true;
        }
    }

    private void func_214202_k(String string) {
        if (this.field_214241_j != this.field_214240_i) {
            this.func_214192_g();
        }
        \u2603 = this.func_214193_h();
        this.field_214240_i = MathHelper.func_76125_a(this.field_214240_i, 0, \u2603.length());
        \u2603 = new StringBuilder(\u2603).insert(this.field_214240_i, string).toString();
        int n = this.font.func_78267_b(\u2603 + "" + (Object)((Object)TextFormatting.BLACK) + "_", 114);
        if (n <= 128 && \u2603.length() < 1024) {
            this.func_214217_j(\u2603);
            this.field_214241_j = this.field_214240_i = Math.min(this.func_214193_h().length(), this.field_214240_i + string.length());
        }
    }

    @Override
    public void render(int n3, int n2, float f) {
        int n3;
        this.renderBackground();
        this.setFocused(null);
        GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.minecraft.func_110434_K().func_110577_a(ReadBookScreen.field_214167_b);
        int n4 = (this.width - 192) / 2;
        \u2603 = 2;
        this.blit(n4, 2, 0, 0, 192, 192);
        if (this.field_214235_d) {
            String string = this.field_214239_h;
            string = this.field_214236_e / 6 % 2 == 0 ? string + "" + (Object)((Object)TextFormatting.BLACK) + "_" : string + "" + (Object)((Object)TextFormatting.GRAY) + "_";
            \u2603 = I18n.func_135052_a("book.editTitle", new Object[0]);
            int \u26032 = this.func_214225_l(\u2603);
            this.font.func_211126_b(\u2603, n4 + 36 + (114 - \u26032) / 2, 34.0f, 0);
            int \u26033 = this.func_214225_l(string);
            this.font.func_211126_b(string, n4 + 36 + (114 - \u26033) / 2, 50.0f, 0);
            \u2603 = I18n.func_135052_a("book.byAuthor", this.field_214232_a.func_200200_C_().getString());
            int \u26034 = this.func_214225_l(\u2603);
            this.font.func_211126_b((Object)((Object)TextFormatting.DARK_GRAY) + \u2603, n4 + 36 + (114 - \u26034) / 2, 60.0f, 0);
            \u2603 = I18n.func_135052_a("book.finalizeWarning", new Object[0]);
            this.font.func_78279_b(\u2603, n4 + 36, 82, 114, 0);
        } else {
            \u2603 = I18n.func_135052_a("book.pageIndicator", this.field_214237_f + 1, this.func_214199_a());
            \u2603 = this.func_214193_h();
            int \u26035 = this.func_214225_l(\u2603);
            this.font.func_211126_b(\u2603, n4 - \u26035 + 192 - 44, 18.0f, 0);
            this.font.func_78279_b(\u2603, n4 + 36, 32, 114, 0);
            this.func_214222_m(\u2603);
            if (this.field_214236_e / 6 % 2 == 0) {
                Point point = this.func_214194_c(\u2603, this.field_214240_i);
                if (this.font.func_78260_a()) {
                    this.func_214227_a(point);
                    point.field_216928_b = point.field_216928_b - 4;
                }
                this.func_214224_c(point);
                if (this.field_214240_i < \u2603.length()) {
                    AbstractGui.fill(point.field_216928_b, point.field_216929_c - 1, point.field_216928_b + 1, point.field_216929_c + this.font.field_78288_b, -16777216);
                } else {
                    this.font.func_211126_b("_", point.field_216928_b, point.field_216929_c, 0);
                }
            }
        }
        super.render(n3, n2, f);
    }

    private int func_214225_l(String string) {
        return this.font.func_78256_a(this.font.func_78260_a() ? this.font.func_147647_b(string) : string);
    }

    private int func_214216_b(String string, int n) {
        return this.font.func_78259_e(string, n);
    }

    private String func_214231_i() {
        String string = this.func_214193_h();
        int \u26032 = Math.min(this.field_214240_i, this.field_214241_j);
        int \u26033 = Math.max(this.field_214240_i, this.field_214241_j);
        return string.substring(\u26032, \u26033);
    }

    private void func_214222_m(String string) {
        if (this.field_214241_j == this.field_214240_i) {
            return;
        }
        int n = Math.min(this.field_214240_i, this.field_214241_j);
        \u2603 = Math.max(this.field_214240_i, this.field_214241_j);
        String \u26032 = string.substring(n, \u2603);
        \u2603 = this.font.func_216863_a(string, 1, \u2603, true);
        String \u26033 = string.substring(n, \u2603);
        Point \u26034 = this.func_214194_c(string, n);
        Point \u26035 = new Point(\u26034.field_216928_b, \u26034.field_216929_c + this.font.field_78288_b);
        while (!\u26032.isEmpty()) {
            \u2603 = this.func_214216_b(\u26033, 114 - \u26034.field_216928_b);
            if (\u26032.length() <= \u2603) {
                \u26035.field_216928_b = \u26034.field_216928_b + this.func_214225_l(\u26032);
                this.func_214223_a(\u26034, \u26035);
                break;
            }
            \u2603 = Math.min(\u2603, \u26032.length() - 1);
            String string2 = \u26032.substring(0, \u2603);
            char \u26036 = \u26032.charAt(\u2603);
            boolean \u26037 = \u26036 == ' ' || \u26036 == '\n';
            \u26032 = TextFormatting.func_211164_a(string2) + \u26032.substring(\u2603 + (\u26037 ? 1 : 0));
            \u26033 = TextFormatting.func_211164_a(string2) + \u26033.substring(\u2603 + (\u26037 ? 1 : 0));
            \u26035.field_216928_b = \u26034.field_216928_b + this.func_214225_l(string2 + " ");
            this.func_214223_a(\u26034, \u26035);
            \u26034.field_216928_b = 0;
            \u26034.field_216929_c = \u26034.field_216929_c + this.font.field_78288_b;
            \u26035.field_216929_c = \u26035.field_216929_c + this.font.field_78288_b;
        }
    }

    private void func_214223_a(Point point, Point point2) {
        Point point3;
        point3 = new Point(point.field_216928_b, point.field_216929_c);
        \u2603 = new Point(point2.field_216928_b, point2.field_216929_c);
        if (this.font.func_78260_a()) {
            this.func_214227_a(point3);
            this.func_214227_a(\u2603);
            int n = \u2603.field_216928_b;
            \u2603.field_216928_b = point3.field_216928_b;
            point3.field_216928_b = n;
        }
        this.func_214224_c(point3);
        this.func_214224_c(\u2603);
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        GlStateManager.color4f(0.0f, 0.0f, 255.0f, 255.0f);
        GlStateManager.disableTexture();
        GlStateManager.enableColorLogicOp();
        GlStateManager.logicOp(GlStateManager.LogicOp.OR_REVERSE);
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        \u26033.func_181662_b(point3.field_216928_b, \u2603.field_216929_c, 0.0).func_181675_d();
        \u26033.func_181662_b(\u2603.field_216928_b, \u2603.field_216929_c, 0.0).func_181675_d();
        \u26033.func_181662_b(\u2603.field_216928_b, point3.field_216929_c, 0.0).func_181675_d();
        \u26033.func_181662_b(point3.field_216928_b, point3.field_216929_c, 0.0).func_181675_d();
        \u26032.func_78381_a();
        GlStateManager.disableColorLogicOp();
        GlStateManager.enableTexture();
    }

    private Point func_214194_c(String string, int n) {
        Point point = new Point();
        int \u26032 = 0;
        int \u26033 = 0;
        String \u26034 = string;
        while (!\u26034.isEmpty()) {
            String \u26035;
            int n2 = this.func_214216_b(\u26034, 114);
            if (\u26034.length() <= n2) {
                \u26035 = \u26034.substring(0, Math.min(Math.max(n - \u26033, 0), \u26034.length()));
                point.field_216928_b = point.field_216928_b + this.func_214225_l(\u26035);
                break;
            }
            \u26035 = \u26034.substring(0, n2);
            char \u26036 = \u26034.charAt(n2);
            boolean \u26037 = \u26036 == ' ' || \u26036 == '\n';
            \u26034 = TextFormatting.func_211164_a(\u26035) + \u26034.substring(n2 + (\u26037 ? 1 : 0));
            if ((\u26032 += \u26035.length() + (\u26037 ? 1 : 0)) - 1 >= n) {
                String string2 = \u26035.substring(0, Math.min(Math.max(n - \u26033, 0), \u26035.length()));
                point.field_216928_b = point.field_216928_b + this.func_214225_l(string2);
                break;
            }
            point.field_216929_c = point.field_216929_c + this.font.field_78288_b;
            \u26033 = \u26032;
        }
        return point;
    }

    private void func_214227_a(Point point) {
        if (this.font.func_78260_a()) {
            point.field_216928_b = 114 - point.field_216928_b;
        }
    }

    private void func_214210_b(Point point) {
        point.field_216928_b = point.field_216928_b - (this.width - 192) / 2 - 36;
        point.field_216929_c = point.field_216929_c - 32;
    }

    private void func_214224_c(Point point) {
        point.field_216928_b = point.field_216928_b + (this.width - 192) / 2 + 36;
        point.field_216929_c = point.field_216929_c + 32;
    }

    private int func_214226_d(String string, int n) {
        if (n < 0) {
            return 0;
        }
        float f = 0.0f;
        boolean \u26032 = false;
        String \u26033 = string + " ";
        for (int i = 0; i < \u26033.length(); ++i) {
            char c = \u26033.charAt(i);
            float \u26034 = this.font.func_211125_a(c);
            if (c == '\u00a7' && i < \u26033.length() - 1) {
                if ((c = \u26033.charAt(++i)) == 'l' || c == 'L') {
                    \u26032 = true;
                } else if (c == 'r' || c == 'R') {
                    \u26032 = false;
                }
                \u26034 = 0.0f;
            }
            float \u26035 = f;
            f += \u26034;
            if (\u26032 && \u26034 > 0.0f) {
                f += 1.0f;
            }
            if (!((float)n >= \u26035) || !((float)n < f)) continue;
            return i;
        }
        if ((float)n >= f) {
            return \u26033.length() - 1;
        }
        return -1;
    }

    private int func_214203_a(String string, Point point) {
        int n = 16 * this.font.field_78288_b;
        if (point.field_216929_c > n) {
            return -1;
        }
        \u2603 = Integer.MIN_VALUE;
        \u2603 = this.font.field_78288_b;
        \u2603 = 0;
        String \u26032 = string;
        while (!\u26032.isEmpty() && \u2603 < n) {
            n2 = this.func_214216_b(\u26032, 114);
            if (n2 < \u26032.length()) {
                int n2;
                String string2 = \u26032.substring(0, n2);
                if (point.field_216929_c >= \u2603 && point.field_216929_c < \u2603) {
                    int n3 = this.func_214226_d(string2, point.field_216928_b);
                    return n3 < 0 ? -1 : \u2603 + n3;
                }
                n3 = \u26032.charAt(n2);
                boolean \u26033 = n3 == 32 || n3 == 10;
                \u26032 = TextFormatting.func_211164_a(string2) + \u26032.substring(n2 + (\u26033 ? 1 : 0));
                \u2603 += string2.length() + (\u26033 ? 1 : 0);
            } else if (point.field_216929_c >= \u2603 && point.field_216929_c < \u2603) {
                \u2603 = this.func_214226_d(\u26032, point.field_216928_b);
                return \u2603 < 0 ? -1 : \u2603 + \u2603;
            }
            \u2603 = \u2603;
            \u2603 += this.font.field_78288_b;
        }
        return string.length();
    }

    @Override
    public boolean mouseClicked(double d, double d2, int n) {
        if (n == 0) {
            long l = Util.func_211177_b();
            String \u26032 = this.func_214193_h();
            if (!\u26032.isEmpty()) {
                Point point = new Point((int)d, (int)d2);
                this.func_214210_b(point);
                this.func_214227_a(point);
                int \u26033 = this.func_214203_a(\u26032, point);
                if (\u26033 >= 0) {
                    if (\u26033 == this.field_214243_l && l - this.field_214242_k < 250L) {
                        if (this.field_214241_j == this.field_214240_i) {
                            this.field_214241_j = this.font.func_216863_a(\u26032, -1, \u26033, false);
                            this.field_214240_i = this.font.func_216863_a(\u26032, 1, \u26033, false);
                        } else {
                            this.field_214241_j = 0;
                            this.field_214240_i = this.func_214193_h().length();
                        }
                    } else {
                        this.field_214240_i = \u26033;
                        if (!Screen.hasShiftDown()) {
                            this.field_214241_j = this.field_214240_i;
                        }
                    }
                }
                this.field_214243_l = \u26033;
            }
            this.field_214242_k = l;
        }
        return super.mouseClicked(d, d2, n);
    }

    @Override
    public boolean mouseDragged(double d, double d2, int n, double d3, double d4) {
        if (n == 0 && this.field_214237_f >= 0 && this.field_214237_f < this.field_214238_g.size()) {
            String string = this.field_214238_g.get(this.field_214237_f);
            Point \u26032 = new Point((int)d, (int)d2);
            this.func_214210_b(\u26032);
            this.func_214227_a(\u26032);
            int \u26033 = this.func_214203_a(string, \u26032);
            if (\u26033 >= 0) {
                this.field_214240_i = \u26033;
            }
        }
        return super.mouseDragged(d, d2, n, d3, d4);
    }

    class Point {
        private int field_216928_b;
        private int field_216929_c;

        Point() {
        }

        Point(int n, int n2) {
            this.field_216928_b = n;
            this.field_216929_c = n2;
        }
    }
}

