/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.CreateFlatWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.FlatLayerInfo;

public class FlatPresetsScreen
extends Screen {
    private static final List<LayerItem> field_146431_f = Lists.newArrayList();
    private final CreateFlatWorldScreen field_146432_g;
    private String field_146439_i;
    private String field_146436_r;
    private SlotList field_146435_s;
    private Button field_146434_t;
    private TextFieldWidget field_146433_u;

    public FlatPresetsScreen(CreateFlatWorldScreen createFlatWorldScreen) {
        super(new TranslationTextComponent("createWorld.customize.presets.title", new Object[0]));
        this.field_146432_g = createFlatWorldScreen;
    }

    @Override
    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.field_146439_i = I18n.func_135052_a("createWorld.customize.presets.share", new Object[0]);
        this.field_146436_r = I18n.func_135052_a("createWorld.customize.presets.list", new Object[0]);
        this.field_146433_u = new TextFieldWidget(this.font, 50, 40, this.width - 100, 20, this.field_146439_i);
        this.field_146433_u.func_146203_f(1230);
        this.field_146433_u.func_146180_a(this.field_146432_g.func_210501_h());
        this.children.add(this.field_146433_u);
        this.field_146435_s = new SlotList();
        this.children.add(this.field_146435_s);
        this.field_146434_t = this.addButton(new Button(this.width / 2 - 155, this.height - 28, 150, 20, I18n.func_135052_a("createWorld.customize.presets.select", new Object[0]), button -> {
            this.field_146432_g.func_210502_a(this.field_146433_u.func_146179_b());
            this.minecraft.func_147108_a(this.field_146432_g);
        }));
        this.addButton(new Button(this.width / 2 + 5, this.height - 28, 150, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.minecraft.func_147108_a(this.field_146432_g)));
        this.func_213074_a(this.field_146435_s.getSelected() != null);
    }

    @Override
    public boolean mouseScrolled(double d, double d2, double d3) {
        return this.field_146435_s.mouseScrolled(d, d2, d3);
    }

    @Override
    public void resize(Minecraft minecraft, int n, int n2) {
        String string = this.field_146433_u.func_146179_b();
        this.init(minecraft, n, n2);
        this.field_146433_u.func_146180_a(string);
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    @Override
    public void render(int n, int n2, float f) {
        this.renderBackground();
        this.field_146435_s.render(n, n2, f);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 8, 0xFFFFFF);
        this.drawString(this.font, this.field_146439_i, 50, 30, 0xA0A0A0);
        this.drawString(this.font, this.field_146436_r, 50, 70, 0xA0A0A0);
        this.field_146433_u.render(n, n2, f);
        super.render(n, n2, f);
    }

    @Override
    public void tick() {
        this.field_146433_u.func_146178_a();
        super.tick();
    }

    public void func_213074_a(boolean bl) {
        this.field_146434_t.active = bl || this.field_146433_u.func_146179_b().length() > 1;
    }

    private static void func_199709_a(String string, IItemProvider iItemProvider2, Biome biome, List<String> list, FlatLayerInfo ... flatLayerInfoArray) {
        IItemProvider iItemProvider2;
        FlatGenerationSettings flatGenerationSettings = ChunkGeneratorType.field_205489_f.func_205483_a();
        for (int i = flatLayerInfoArray.length - 1; i >= 0; --i) {
            flatGenerationSettings.func_82650_c().add(flatLayerInfoArray[i]);
        }
        flatGenerationSettings.func_82647_a(biome);
        flatGenerationSettings.func_82645_d();
        for (String string2 : list) {
            flatGenerationSettings.func_82644_b().put(string2, Maps.newHashMap());
        }
        field_146431_f.add(new LayerItem(iItemProvider2.func_199767_j(), string, flatGenerationSettings.toString()));
    }

    static {
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.classic_flat", new Object[0]), Blocks.field_196658_i, Biomes.field_76772_c, Arrays.asList("village"), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(2, Blocks.field_150346_d), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.tunnelers_dream", new Object[0]), Blocks.field_150348_b, Biomes.field_76770_e, Arrays.asList("biome_1", "dungeon", "decoration", "stronghold", "mineshaft"), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(5, Blocks.field_150346_d), new FlatLayerInfo(230, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.water_world", new Object[0]), Items.field_151131_as, Biomes.field_150575_M, Arrays.asList("biome_1", "oceanmonument"), new FlatLayerInfo(90, Blocks.field_150355_j), new FlatLayerInfo(5, Blocks.field_150354_m), new FlatLayerInfo(5, Blocks.field_150346_d), new FlatLayerInfo(5, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.overworld", new Object[0]), Blocks.field_150349_c, Biomes.field_76772_c, Arrays.asList("village", "biome_1", "decoration", "stronghold", "mineshaft", "dungeon", "lake", "lava_lake", "pillager_outpost"), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(59, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.snowy_kingdom", new Object[0]), Blocks.field_150433_aE, Biomes.field_76774_n, Arrays.asList("village", "biome_1"), new FlatLayerInfo(1, Blocks.field_150433_aE), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(59, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.bottomless_pit", new Object[0]), Items.field_151008_G, Biomes.field_76772_c, Arrays.asList("village", "biome_1"), new FlatLayerInfo(1, Blocks.field_196658_i), new FlatLayerInfo(3, Blocks.field_150346_d), new FlatLayerInfo(2, Blocks.field_150347_e));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.desert", new Object[0]), Blocks.field_150354_m, Biomes.field_76769_d, Arrays.asList("village", "biome_1", "decoration", "stronghold", "mineshaft", "dungeon"), new FlatLayerInfo(8, Blocks.field_150354_m), new FlatLayerInfo(52, Blocks.field_150322_A), new FlatLayerInfo(3, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.redstone_ready", new Object[0]), Items.field_151137_ax, Biomes.field_76769_d, Collections.emptyList(), new FlatLayerInfo(52, Blocks.field_150322_A), new FlatLayerInfo(3, Blocks.field_150348_b), new FlatLayerInfo(1, Blocks.field_150357_h));
        FlatPresetsScreen.func_199709_a(I18n.func_135052_a("createWorld.customize.preset.the_void", new Object[0]), Blocks.field_180401_cv, Biomes.field_185440_P, Arrays.asList("decoration"), new FlatLayerInfo(1, Blocks.field_150350_a));
    }

    static class LayerItem {
        public final Item field_148234_a;
        public final String field_148232_b;
        public final String field_148233_c;

        public LayerItem(Item item, String string, String string2) {
            this.field_148234_a = item;
            this.field_148232_b = string;
            this.field_148233_c = string2;
        }
    }

    class SlotList
    extends ExtendedList<PresetEntry> {
        public SlotList() {
            super(FlatPresetsScreen.this.minecraft, FlatPresetsScreen.this.width, FlatPresetsScreen.this.height, 80, FlatPresetsScreen.this.height - 37, 24);
            for (int i = 0; i < field_146431_f.size(); ++i) {
                this.addEntry(new PresetEntry());
            }
        }

        @Override
        public void setSelected(@Nullable PresetEntry presetEntry) {
            super.setSelected(presetEntry);
            if (presetEntry != null) {
                NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", ((LayerItem)field_146431_f.get((int)this.children().indexOf((Object)presetEntry))).field_148232_b).getString());
            }
        }

        @Override
        protected void moveSelection(int n) {
            super.moveSelection(n);
            FlatPresetsScreen.this.func_213074_a(true);
        }

        @Override
        protected boolean isFocused() {
            return FlatPresetsScreen.this.getFocused() == this;
        }

        @Override
        public boolean keyPressed(int n, int n2, int n3) {
            if (super.keyPressed(n, n2, n3)) {
                return true;
            }
            if ((n == 257 || n == 335) && this.getSelected() != null) {
                ((PresetEntry)this.getSelected()).func_214399_a();
            }
            return false;
        }

        @Override
        public /* synthetic */ void setSelected(@Nullable AbstractList.AbstractListEntry abstractListEntry) {
            this.setSelected((PresetEntry)abstractListEntry);
        }

        public class PresetEntry
        extends ExtendedList.AbstractListEntry<PresetEntry> {
            @Override
            public void render(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
                LayerItem layerItem = (LayerItem)field_146431_f.get(n);
                this.func_214402_a(n3, n2, layerItem.field_148234_a);
                FlatPresetsScreen.this.font.func_211126_b(layerItem.field_148232_b, n3 + 18 + 5, n2 + 6, 0xFFFFFF);
            }

            @Override
            public boolean mouseClicked(double d, double d2, int n) {
                if (n == 0) {
                    this.func_214399_a();
                }
                return false;
            }

            private void func_214399_a() {
                SlotList.this.setSelected(this);
                FlatPresetsScreen.this.func_213074_a(true);
                FlatPresetsScreen.this.field_146433_u.func_146180_a(((LayerItem)field_146431_f.get((int)SlotList.this.children().indexOf((Object)this))).field_148233_c);
                FlatPresetsScreen.this.field_146433_u.func_146196_d();
            }

            private void func_214402_a(int n, int n2, Item item) {
                this.func_214400_a(n + 1, n2 + 1);
                GlStateManager.enableRescaleNormal();
                RenderHelper.func_74520_c();
                FlatPresetsScreen.this.itemRenderer.func_175042_a(new ItemStack(item), n + 2, n2 + 2);
                RenderHelper.func_74518_a();
                GlStateManager.disableRescaleNormal();
            }

            private void func_214400_a(int n, int n2) {
                GlStateManager.color4f(1.0f, 1.0f, 1.0f, 1.0f);
                SlotList.this.minecraft.func_110434_K().func_110577_a(AbstractGui.STATS_ICON_LOCATION);
                AbstractGui.blit(n, n2, FlatPresetsScreen.this.blitOffset, 0.0f, 0.0f, 18, 18, 128, 128);
            }
        }
    }
}

