/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.gui.screen.AddServerScreen;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.ConnectingScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.ServerListScreen;
import net.minecraft.client.gui.screen.ServerSelectionList;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.network.LanServerDetector;
import net.minecraft.client.network.LanServerInfo;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MultiplayerScreen
extends Screen {
    private static final Logger field_146802_a = LogManager.getLogger();
    private final ServerPinger field_146797_f = new ServerPinger();
    private final Screen field_146798_g;
    protected ServerSelectionList field_146803_h;
    private ServerList field_146804_i;
    private Button field_146810_r;
    private Button field_146809_s;
    private Button field_146808_t;
    private String field_146812_y;
    private ServerData field_146811_z;
    private LanServerDetector.LanServerList field_146799_A;
    private LanServerDetector.LanServerFindThread field_146800_B;
    private boolean field_146801_C;

    public MultiplayerScreen(Screen screen) {
        super(new TranslationTextComponent("multiplayer.title", new Object[0]));
        this.field_146798_g = screen;
    }

    @Override
    protected void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        if (this.field_146801_C) {
            this.field_146803_h.updateSize(this.width, this.height, 32, this.height - 64);
        } else {
            this.field_146801_C = true;
            this.field_146804_i = new ServerList(this.minecraft);
            this.field_146804_i.func_78853_a();
            this.field_146799_A = new LanServerDetector.LanServerList();
            try {
                this.field_146800_B = new LanServerDetector.LanServerFindThread(this.field_146799_A);
                this.field_146800_B.start();
            }
            catch (Exception exception) {
                field_146802_a.warn("Unable to start LAN server detection: {}", (Object)exception.getMessage());
            }
            this.field_146803_h = new ServerSelectionList(this, this.minecraft, this.width, this.height, 32, this.height - 64, 36);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.children.add(this.field_146803_h);
        this.field_146809_s = this.addButton(new Button(this.width / 2 - 154, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.select", new Object[0]), button -> this.func_146796_h()));
        this.addButton(new Button(this.width / 2 - 50, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.direct", new Object[0]), button -> {
            this.field_146811_z = new ServerData(I18n.func_135052_a("selectServer.defaultName", new Object[0]), "", false);
            this.minecraft.func_147108_a(new ServerListScreen(this::func_214290_d, this.field_146811_z));
        }));
        this.addButton(new Button(this.width / 2 + 4 + 50, this.height - 52, 100, 20, I18n.func_135052_a("selectServer.add", new Object[0]), button -> {
            this.field_146811_z = new ServerData(I18n.func_135052_a("selectServer.defaultName", new Object[0]), "", false);
            this.minecraft.func_147108_a(new AddServerScreen(this::func_214284_c, this.field_146811_z));
        }));
        this.field_146810_r = this.addButton(new Button(this.width / 2 - 154, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.edit", new Object[0]), button -> {
            ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
            if (entry instanceof ServerSelectionList.NormalEntry) {
                ServerData serverData = ((ServerSelectionList.NormalEntry)entry).func_148296_a();
                this.field_146811_z = new ServerData(serverData.field_78847_a, serverData.field_78845_b, false);
                this.field_146811_z.func_152583_a(serverData);
                this.minecraft.func_147108_a(new AddServerScreen(this::func_214292_b, this.field_146811_z));
            }
        }));
        this.field_146808_t = this.addButton(new Button(this.width / 2 - 74, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.delete", new Object[0]), button -> {
            ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
            if (entry instanceof ServerSelectionList.NormalEntry && (\u2603 = ((ServerSelectionList.NormalEntry)entry).func_148296_a().field_78847_a) != null) {
                TranslationTextComponent translationTextComponent = new TranslationTextComponent("selectServer.deleteQuestion", new Object[0]);
                \u2603 = new TranslationTextComponent("selectServer.deleteWarning", \u2603);
                String \u26032 = I18n.func_135052_a("selectServer.deleteButton", new Object[0]);
                String \u26033 = I18n.func_135052_a("gui.cancel", new Object[0]);
                this.minecraft.func_147108_a(new ConfirmScreen(this::func_214285_a, translationTextComponent, \u2603, \u26032, \u26033));
            }
        }));
        this.addButton(new Button(this.width / 2 + 4, this.height - 28, 70, 20, I18n.func_135052_a("selectServer.refresh", new Object[0]), button -> this.func_146792_q()));
        this.addButton(new Button(this.width / 2 + 4 + 76, this.height - 28, 75, 20, I18n.func_135052_a("gui.cancel", new Object[0]), button -> this.minecraft.func_147108_a(this.field_146798_g)));
        this.func_214295_b();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_146799_A.func_77553_a()) {
            List<LanServerInfo> list = this.field_146799_A.func_77554_c();
            this.field_146799_A.func_77552_b();
            this.field_146803_h.func_148194_a(list);
        }
        this.field_146797_f.func_147223_a();
    }

    @Override
    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        if (this.field_146800_B != null) {
            this.field_146800_B.interrupt();
            this.field_146800_B = null;
        }
        this.field_146797_f.func_147226_b();
    }

    private void func_146792_q() {
        this.minecraft.func_147108_a(new MultiplayerScreen(this.field_146798_g));
    }

    private void func_214285_a(boolean bl) {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
        if (bl && entry instanceof ServerSelectionList.NormalEntry) {
            this.field_146804_i.func_217506_a(((ServerSelectionList.NormalEntry)entry).func_148296_a());
            this.field_146804_i.func_78855_b();
            this.field_146803_h.setSelected((ServerSelectionList.Entry)null);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214292_b(boolean bl) {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
        if (bl && entry instanceof ServerSelectionList.NormalEntry) {
            ServerData serverData = ((ServerSelectionList.NormalEntry)entry).func_148296_a();
            serverData.field_78847_a = this.field_146811_z.field_78847_a;
            serverData.field_78845_b = this.field_146811_z.field_78845_b;
            serverData.func_152583_a(this.field_146811_z);
            this.field_146804_i.func_78855_b();
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214284_c(boolean bl) {
        if (bl) {
            this.field_146804_i.func_78849_a(this.field_146811_z);
            this.field_146804_i.func_78855_b();
            this.field_146803_h.setSelected((ServerSelectionList.Entry)null);
            this.field_146803_h.func_148195_a(this.field_146804_i);
        }
        this.minecraft.func_147108_a(this);
    }

    private void func_214290_d(boolean bl) {
        if (bl) {
            this.func_146791_a(this.field_146811_z);
        } else {
            this.minecraft.func_147108_a(this);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2, int n3) {
        if (super.keyPressed(n, n2, n3)) {
            return true;
        }
        if (n == 294) {
            this.func_146792_q();
            return true;
        }
        if (this.field_146803_h.getSelected() != null && (n == 257 || n == 335)) {
            this.func_146796_h();
            return true;
        }
        return false;
    }

    @Override
    public void render(int n, int n2, float f) {
        this.field_146812_y = null;
        this.renderBackground();
        this.field_146803_h.render(n, n2, f);
        this.drawCenteredString(this.font, this.title.func_150254_d(), this.width / 2, 20, 0xFFFFFF);
        super.render(n, n2, f);
        if (this.field_146812_y != null) {
            this.renderTooltip(Lists.newArrayList((Iterable)Splitter.on((String)"\n").split((CharSequence)this.field_146812_y)), n, n2);
        }
    }

    public void func_146796_h() {
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
        if (entry instanceof ServerSelectionList.NormalEntry) {
            this.func_146791_a(((ServerSelectionList.NormalEntry)entry).func_148296_a());
        } else if (entry instanceof ServerSelectionList.LanDetectedEntry) {
            LanServerInfo lanServerInfo = ((ServerSelectionList.LanDetectedEntry)entry).func_189995_a();
            this.func_146791_a(new ServerData(lanServerInfo.func_77487_a(), lanServerInfo.func_77488_b(), true));
        }
    }

    private void func_146791_a(ServerData serverData) {
        this.minecraft.func_147108_a(new ConnectingScreen(this, this.minecraft, serverData));
    }

    public void func_214287_a(ServerSelectionList.Entry entry) {
        this.field_146803_h.setSelected(entry);
        this.func_214295_b();
    }

    protected void func_214295_b() {
        this.field_146809_s.active = false;
        this.field_146810_r.active = false;
        this.field_146808_t.active = false;
        ServerSelectionList.Entry entry = (ServerSelectionList.Entry)this.field_146803_h.getSelected();
        if (entry != null && !(entry instanceof ServerSelectionList.LanScanEntry)) {
            this.field_146809_s.active = true;
            if (entry instanceof ServerSelectionList.NormalEntry) {
                this.field_146810_r.active = true;
                this.field_146808_t.active = true;
            }
        }
    }

    public ServerPinger func_146789_i() {
        return this.field_146797_f;
    }

    public void func_146793_a(String string) {
        this.field_146812_y = string;
    }

    public ServerList func_146795_p() {
        return this.field_146804_i;
    }
}

